#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin

cd $C_DIR

#include files
. ./common.json


if [ -e /etc/sysconfig/network-scripts/ifcfg-br0 ]; then
  ip1=`cat /etc/sysconfig/network-scripts/ifcfg-br0|grep -i IPADDR|awk -F"=" '{print $2}'`
  info_ip1=`arping -I br0 -c 2 $ip1|grep -i "reply from"`
  if [ -z "$info_ip1" ];then
    status_ip1=no
  else
    status_ip1=yes
  fi
fi

if [ -e /etc/sysconfig/network-scripts/ifcfg-br1 ]; then
  ip2=`cat /etc/sysconfig/network-scripts/ifcfg-br1|grep -i IPADDR|awk -F"=" '{print $2}'`
  info_ip2=`arping -I br1 -c 2 $ip2|grep -i "reply from"`
  if [ -z "$info_ip2" ];then
    status_ip2=no
  else
    status_ip2=yes
  fi
fi


if [ -e /etc/sysconfig/network-scripts/ifcfg-wan0 ]; then
  ip_wan=`cat /etc/sysconfig/network-scripts/ifcfg-wan0|grep -i IPADDR|awk -F"=" '{print $2}'`
  if [ -n "$ip_wan" ]; then
    info_wan=`arping -I wan0 -c 2 $ip_wan|grep -i "reply from"`
    if [ -z "$info_wan" ];then
      status_wan=no
    else
      status_wan=yes
    fi
  fi
fi

e_json ip "$status_ip1" ip2 "$status_ip2" wan "$status_wan"




