#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi
if [ -f /etc/sysconfig/network-scripts/ifcfg-bond0 ]; then
  netcardMode="bond"
else
 netcardMode="normal"
fi
if [ "$mode" = "Cluster" ]; then
  e_json deployMode Cluster netcardMode "$netcardMode"
else
su - postgres<<EOF
    psql -d rcd -p $port -c "select vm_net_type from lb_policy_info;" > $tmpf
EOF
  vmNet=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
  if [ "$vmNet" = "BRIDGE" ]; then
    vmType=0
  else
    vmType=1
  fi
su - postgres<<EOF
    psql -d rcd -p $port -c "select para_value from lb_sys_parameter where para_name='SYS_PARA_LOCAL_MODE';" > $tmpf
EOF
  tmType=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`
  if [ "$vmType" = "0" -a "$tmType" = "0" ]; then
    e_json deployMode Normal localMode 0 netcardMode "$netcardMode"
  elif [ "$vmType" = "0" -a "$tmType" = "1" ]; then
    e_json deployMode Normal localMode 1 netcardMode "$netcardMode"
  elif [ "$vmTyp"e = "1" -a "$tmType" = "0" ]; then
    e_json deployMode Normal localMode 2 netcardMode "$netcardMode"
  else
    e_json deployMode Normal localMode 3 netcardMode "$netcardMode"
  fi

fi



