#!/bin/bash
S_NAME=tomcat6
DB_NAME=rcd
C_DIR=$(cd "$(dirname "$0")"; pwd)
RCD_BIN=/usr/rcd/bin
DB_PORT_L=5432
DB_PORT_C=5433

cd $C_DIR

#include files
. ./common.json

tmpf=/tmp/_sqlout.tmp


mode=`$RCD_BIN/fetchServerState.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`
role=`$RCD_BIN/fetchServerRole.sh|grep -i message|awk -F'=' '{print $2}'|awk '{print $1}'`

if [ "$mode" = "Cluster" -a "$role" = "0" ]; then
   port=$DB_PORT_C
else
   port=$DB_PORT_L
fi


su - postgres<<EOF
  psql -d rcd -p $port -c "select count(*) from rcd_class where rcd_classroom_id is null;" > $tmpf
EOF

amount=`cat $tmpf|awk 'NR==3'|awk '{print $1}'`

if [ $amount -gt 0 ]; then
su - postgres<<EOF
   psql -d rcd -p $port -c "update rcd_class set rcd_classroom_id=1 where rcd_classroom_id is null;" > $tmpf
EOF
  e_json needReboot yes
  sh -c "sleep 5 && sudo reboot" &
else
  e_json needReboot no
fi





