local detection = {}

local desc = '粿'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

local bDnsOk = true

--1.1ն˽У԰ģʽַڵַDNS
function detection06_mode1(p)
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":4,"IPs":"'..webip..'"}')		if value == false then return false end
	local ip = value[webip]["ip"]
	local mask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":5,"IPs":"'..webip..'"}')		if value == false then return false end
	local p1 = value[webip]["ip"]
	local p2 = value[webip]["ip2"]
	local netmask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":6,"IPs":"'..webip..'"}')		if value == false then return false end
	local dns = value[webip]["dns"]
	
	local value = GeneralFun.getInfo(0,'{"Request":7,"IPs":"'..webip..'"}')		if value == false then return false end
	local ip1 = value[webip]["ip"]
	local ip2 = value[webip]["ip2"]
	local netmask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":8,"IPs":"'..webip..'"}')		if value == false then return false end
	local gateway = value[webip]["gateway"]
	
	--aַ롢ǷãַͬΣӦ -10֡ʾ1
	if string.len(ip) == 0 or string.len(mask) == 0 or string.len(gateway) == 0 or lua_isSameSubnet(ip,gateway,mask,mask) == false then
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,"δַʹ磬-10")
	else
		lua_addResult(p,1)
	end
	--bַǷڵַǷͬΣͬΣ-10֡ʾ2
	if lua_isSameSubnet(ip,p1,mask,netmask) or lua_isSameSubnet(ip,p2,mask,mask) then
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,"ַַΪͬһΣ-10")
	else
		lua_addResult(p,1)
	end
	--cDNSδûΪ8.8.8.8-5֡ʾ3
	if string.len(dns) == 0 or dns == "8.8.8.8" then
		lua_addResult(p,3)
		lua_addScore(p,-5)
		bDnsOk = false
		lua_addTypeTip(p,3,"DNS󣬽޸ΪӪDNSʹ114.114.114.114-5")
	else
		lua_addResult(p,1)
	end
	
	return true
end

--1.2նˡУ԰ģʽIPءDNS
function detection06_mode2(p)
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":6,"IPs":"'..webip..'"}')		if value == false then return false end
	local dns = value[webip]["dns"]
	
	--a DNSδûΪ8.8.8.8-5֡ʾ3
	if string.len(dns) == 0 or dns == "8.8.8.8" then
		lua_addResult(p,3)
		lua_addScore(p,-5)
		bDnsOk = false
		lua_addTypeTip(p,3,"DNS󣬽޸ΪӪDNSʹ114.114.114.114-5")
	else
		lua_addResult(p,1)
	end	
	return true
end

--1.3նˡ˽ģʽַ
function detection06_mode3(p)
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":4,"IPs":"'..webip..'"}')		if value == false then return false end
	local ip = value[webip]["ip"]
	local mask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":5,"IPs":"'..webip..'"}')		if value == false then return false end
	local p1 = value[webip]["ip"]
	local p2 = value[webip]["ip2"]
	--local netmask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":6,"IPs":"'..webip..'"}')		if value == false then return false end
	local dns = value[webip]["dns"]
	
	local value = GeneralFun.getInfo(0,'{"Request":7,"IPs":"'..webip..'"}')		if value == false then return false end
	local ip1 = value[webip]["ip"]
	local ip2 = value[webip]["ip2"]
	local netmask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":8,"IPs":"'..webip..'"}')		if value == false then return false end
	local gateway = value[webip]["gateway"]	
		
	--aַ롢ǷãַͬΣӦ -10֡ʾ1
	if string.len(ip) == 0 or string.len(mask) == 0 or string.len(gateway) == 0 or lua_isSameSubnet(ip,gateway,mask,mask) == false then
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,"δַʹ磬-10")
	else
		lua_addResult(p,1)
	end
	
	--b ַǷΪ192.168.123.0 / 24ΣӦ  - 10֡ʾ4	
	local value = GeneralFun.getInfo(0,'{"Request":13,"IPs":"'..webip..'"}')		if value == false then return false end
	local b = true
	local boxSize = #value[webip]		
	for i=1,boxSize do
		local ip = value[webip][i]["vmIp"]
		local mask = value[webip][i]["vmMask"]
		if string.find(ip,"192.168.123.") ~= 1 or mask ~= "255.255.255.0" then
			b = false
			break
		end
	end		
	
	if b == false then
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addRepair(p,GeneralFun.getInfoDesc(501),"501")
		lua_addTypeTip(p,3,"粿ģʽ,ַΪ192.168.123.0/24Σ-10")
	else
		lua_addResult(p,1)
	end
	
	if string.len(dns) == 0 or dns == "8.8.8.8" then
		lua_addResult(p,3)
		lua_addScore(p,-5)
		bDnsOk = false
		lua_addTypeTip(p,3,"DNS󣬽޸ΪӪDNSʹ114.114.114.114-5")
	else
		lua_addResult(p,1)
	end	
	
	--c :ַһڡڶIPΪ192.168.123.0/24   - 10
	if string.find(ip,"192.168.123.") == 1 or string.find(p1,"192.168.123.") == 1 or string.find(p2,"192.168.123.") == 1 then
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,"˽ģʽ£192.168.123.0/24ΪڲΣεַӿϣᵼͻȷַ滮-10")
	else
		lua_addResult(p,1)
	end
	return true
end

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	bDnsOk = true
	--1
	local value = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..webip..'"}')		if value == false then return end
	local netcardMode = string.lower(value[webip]["netcardMode"])
	local deployMode = string.lower(value[webip]["deployMode"])
	local bBond = netcardMode == "bond"

	if deployMode == "normal" then
		local mode = value[webip]["localMode"]
		if mode == "1" then 
			local bRunOK = detection06_mode1(p)
			if not bRunOK then
				return
			end
		elseif mode == "0" then
			local bRunOK = detection06_mode2(p)
			if not bRunOK then
				return
			end
		elseif mode == "3" then
			local bRunOK = detection06_mode3(p)
			if not bRunOK then
				return
			end
		else
			-- todo. log unknow mode
		end
	else
		-- todo. log Cluster !!!
	end
	
	if bDnsOk == false then
		lua_addRepair(p,GeneralFun.getInfoDesc(500),"500")
	end
	
	--2
	--2.1RCDlinkΪǧ׻δӣ - 10  ʾ5	
	local value = GeneralFun.getInfo(0,'{"Request":9,"IPs":"'..webip..'"}')		if value == false then return end
	local eth0 = string.lower(value[webip]["eth0"])
	local eth1 = string.lower(value[webip]["eth1"])
	-- state 0-ok 1- 2-ǧ
	local state_eth0 = 0
	local state_eth1 = 0
	if eth0 == "na" then
		state_eth0 = 1
	elseif eth0 == "1000mb/s" then
		state_eth0 = 0
	else
		state_eth0 = 2
	end
	if eth1 == "na" then
		state_eth1 = 1
	elseif eth1 == "1000mb/s" then
		state_eth1 = 0
	else
		state_eth1 = 2
	end
	
	if state_eth0 == 0 and state_eth1 == 0 then
		lua_addResult(p,1)
	else
		-- δ
		local tip1 = ''
		if state_eth0 == 1 then
			tip1 = "1"
		end
		if state_eth1 == 1 then
			if string.len(tip1) ~= 0 then
				tip1 = tip1 .. ""
			end
			tip1 = tip1 .. "2"
		end
		-- һδӣȷ״̬
		if string.len(tip1) ~= 0 then
			lua_addResult(p,3)
			lua_addScore(p,-10)
			lua_addTypeTip(p,3,""..tip1.."δӣȷ״̬-10")
		end		
		
		-- ǧ
		local tip2 = ''
		if state_eth0 == 2 then
			tip2 = "1"			
		end
		if state_eth1 == 2 then
			if string.len(tip2) ~= 0 then
				tip2 = tip2 .. ""
			end
			tip2 = tip2 .. "2"
		end
		-- ڶǧף뽻ǷΪǧЭģʽ
		if string.len(tip2) ~= 0 then
			lua_addResult(p,3)
			lua_addScore(p,-10)
			lua_addTypeTip(p,3,""..tip2.."ǧף뽻ǷΪǧЭģʽ-10")
		end		
	end
		
	--2.2⵽RCDڳIPͻ -10  ʾ6
	local value = GeneralFun.getInfo(0,'{"Request":10,"IPs":"'..webip..'"}')		if value == false then return end
	local ip1 = value[webip]["ip"]
	local ip2 = value[webip]["ip2"]
	local conflict_ip = ''
	if ip1 ~= "no" then
		conflict_ip = "1"
	end
	if not (bBond or ip2 == "no") then
		if string.len(conflict_ip) == 0 then
			conflict_ip = "2"
		else
			conflict_ip = "ڶ"
		end
	end
	
	if string.len(conflict_ip) == 0 then
		lua_addResult(p,1)		
	else
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,""..webip..""..conflict_ip.."ַͻȷַ-10")
	end	
		
	lua_afterDetect(p)
end
 
return detection
