
local detection = {}
 
local desc = 'ͬ'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	
	local value = GeneralFun.getInfo(0,'{"Request":24,"IPs":"'..webip..'"}')		if value == false then return end
	local slaveHost = value[webip]["slaveHost"]
	local needIP = ''
	for i=1,#slaveHost do
		local tmpIP = slaveHost[i]["ip"]		
		local bConnect = lua_getConnectState(tmpIP)
		if bConnect then
			if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
			needIP = needIP .. tmpIP
		end
	end	
	_slaveHost = needIP
	GeneralFun.writeFile("slaveHost:<".._slaveHost..">")
	if string.len(_slaveHost) == 0 then
		lua_addResult(p,1)	
		lua_afterDetect(p)
		return
	end
	local request_ips = _slaveHost..'#'..webip
		
	-- 1ȺRCDγ̾Сܺһ£һ£-5֣ʾ1
	local value = GeneralFun.getInfo(0,'{"Request":28,"IPs":"'..request_ips..'"}')	if value == false then return end
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local baseObj = value[webip]
	local error_info = {}		
	
	for k,v in pairs(baseObj) do			
		for i=1,#ips do
			local tmpIP = ips[i]
			local tmpObj = value[tmpIP]
			if tmpObj ~= nil then
				local tmpSize = tmpObj[k]
				if v ~= tmpSize then
					if error_info[tmpIP] == nil then
						error_info[tmpIP] = '"'..k
					else
						error_info[tmpIP] = error_info[tmpIP] .. '","' .. k
					end
				end
			else
				if error_info[tmpIP] == nil then
					error_info[tmpIP] = '"'..k
				else
					error_info[tmpIP] = error_info[tmpIP] .. '","' .. k
				end
			end
			
		end
	end		
	
	local tip1 = ''
	local tip2 = ''
	for error_ip,error_name in pairs(error_info) do
		if string.len(tip1) == 0 then
			tip1 = 'ӻIP'
		else
			tip1 = tip1 .. "\\"
		end
		tip1 = tip1 .. error_ip
		
		if string.len(tip2) ~= 0 then
			tip2 = tip2 .. ";"
		end
		tip2 = tip2 .. "ӻIP" .. error_ip .. "" .. error_name .. '"'
	end
	
	if string.len(tip1) ~= 0 then
		tip1 = tip1 .. "γ̾δͬͬ(챨)"
		tip2 = tip2 .. "γ̾δͬͬ-5"
		lua_addTypeTip(p,3,tip1,tip2)
		lua_addResult(p,3)
		lua_addScore(p,-5)
	else
		lua_addResult(p,1)	
	end
		
	
	-- 2ȺRCDĿ¼Сһ£һ£-5֣ʾ2
	local value = GeneralFun.getInfo(0,'{"Request":27,"IPs":"'..webip..'"}')	if value == false then return end
	local szShare = string.lower(cjson.encode(value[webip]))
	if string.find(szShare,"yes") ~= nil then
		lua_addResult(p,1)	
	elseif string.find(szShare,"no") ~= nil then
		lua_addTypeTip(p,3,"Ŀ¼δͬҳĿγ̾еͬĿ¼-5")
		lua_addResult(p,3)
		lua_addScore(p,-5)
	else
		GeneralFun.failedDection(3,"27")
		return
	end

	lua_afterDetect(p)
end
 
return detection