local detection = {}

local desc = 'ü'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

	
-- δ֪ҲJЧ
function detection_isBoxVerValid(config,box_ver,box_type,rcd_osver)
	box_type = string.lower(box_type)
	local boxVersion = config["boxVersion"][box_type]
	if boxVersion == nil then return true end
	
	local boxVerId = 0
	local rcdOsVerId = 0
	for i=1,#boxVersion do
		local c_boxVer = boxVersion[i]["ver"]
		local c_osMinVer = boxVersion[i]["osver_min"]
		local c_osManVer = boxVersion[i]["osver_max"]	
		if box_ver == c_boxVer then
			boxVerId = i
		end		
		local r_min = lua_compareVer(rcd_osver,c_osMinVer)
		local r_max = lua_compareVer(rcd_osver,c_osManVer)		
		if r_min ~= 3 and r_max ~= 2 then
			rcdOsVerId = i
		end		
	end
	if rcdOsVerId == 0 or boxVerId == 0 then
		if box_type == "windows" and boxVerId == 0 then
			local box_minVer = lua_compareVer(box_ver,"1.0.8")
			if box_minVer == 3 or box_minVer == 4 then
				return false
			else
				return true
			end
		end
		return true
	end
	return boxVerId == rcdOsVerId
end

function detection43_isSameSubnet()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	--lua_isSameSubnet(teacherIp,wanIP,wanMask,wanMask)
	
	local value = GeneralFun.getInfo(3007)	if value == false then return false end
	local netinfo = value["netinfo"]	
	local value = GeneralFun.getInfo(0,'{"Request":39,"IPs":"'..webip..'"}')	if value == false then return false end
	local classroomInfo = value[webip]
	local bOK = false
	local teaIp = ''
	local teamask = ''
	local crName = ''
	for i=1,#netinfo do
		if bOK then
			break
		end
		local localip = netinfo[i]["ip"]		
		for j=1,#classroomInfo do
			local tmpcrName = classroomInfo[j]["crName"]
			local tmpteaIp = classroomInfo[j]["teaIp"]
			if tmpteaIp == localip and string.len(tmpteaIp) > 0 then				
				local localmask = netinfo[i]["mask"]
				teaIp = localip
				teamask = localmask
				crName = tmpcrName
				bOK = true
				break
			end
		end
	end
	
	if not bOK then
		return
	end

	local value = GeneralFun.getInfo(0,'{"Request":13,"IPs":"'..webip..'"}')	if value == false then return false end
	local tmInfo = {}
	local maxCount = 0
	for i=1,#value[webip] do
		local tmpTeaIp = value[webip][i]["teaIp"]
		local tmMask = value[webip][i]["tmMask"]
		local tmIp = value[webip][i]["tmIp"]
		if string.len(tmIp) ~= 0 and string.len(tmMask) ~= 0 and string.len(tmpTeaIp) ~= 0 and teaIp == tmpTeaIp then		
			local count = 1
			if tmInfo[tmMask] ~= nil then
				count = tmInfo[tmMask]["count"] + 1
			end
			local t = {}
			t["count"] = count
			t["ip"] = tmIp
			t["mask"] = tmMask
			tmInfo[tmMask] = t
			--tmInfo[tmMask]["count"] = count
			--tmInfo[tmMask]["ip"] = tmIp
			--tmInfo[tmMask]["mask"] = tmMask
			if count > maxCount then
				maxCount = count
			end
		end
	end
	local tmIp = ""
	local tmMask = ""
	for k,v in pairs(tmInfo) do      
		if v["count"] == maxCount then
			tmMask = v["mask"]
			tmIp = v["ip"]
		end
	end
	
	if string.len(tmIp) == 0 or string.len(tmMask) == 0 then
		return
	end

	if lua_isSameSubnet(teaIp,tmIp,teamask,tmMask) then
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,"("..crName..")õĽʦIPýն˲ͬһΣȷϸƽIPַ滮-10")
	end

end

function detection43_isIP(ip)
	if ip == '' or ip == nil then
		return false
	end
	local b = string.match(ip,"%d+%.%d+%.%d+%.%d+") == ip
	if not b then
		GeneralFun.writeFile('error ip:' .. ip)
	end
	return b
end

function detection43_contain(ip,startip,endip)
	if not detection43_isIP(ip) or not detection43_isIP(startip) or not detection43_isIP(endip) then
		return false
	end
	local head = '%d+%.%d+%.%d+%.'
	local head1 = string.match(ip,head)
	local end1 = tonumber(string.sub(ip,string.len(head1)+1,string.len(ip)))
	local head2 = string.match(startip,head)
	local end2 = tonumber(string.sub(startip,string.len(head2)+1,string.len(startip)))
	local head3 = string.match(endip,head)
	local end3 = tonumber(string.sub(endip,string.len(head3)+1,string.len(endip)))
	
	if head1 ~= head2 or head1 ~= head3 then
		return false
	end
	
	if end1 < end2 or end1 > end3 then
		return false
	end
	return true
end

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	
	-- ն˹
	if not GeneralFun.getTableValue('detection40_relation') then
		lua_addTypeTip(p,2,"ƿδκնˣȷƿò")
		lua_addResult(p,2)
		lua_afterDetect(p)
		return		
	end
	
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')	if value == false then return end
	local rcd_osver = value[webip]["version"]
	local config = GeneralFun.getConfig()
	local value = GeneralFun.getInfo(0,'{"Request":6,"IPs":"'..webip..'"}')	if value == false then return end
	local rcd_dns = value[webip]["dns"]
	local value39 = GeneralFun.getInfo(0,'{"Request":39,"IPs":"'..webip..'"}')	if value39 == false then return false end
	local value13 = GeneralFun.getInfo(0,'{"Request":13,"IPs":"'..webip..'"}')	if value13 == false then return false end
	local value3007 = GeneralFun.getInfo(3007)	if value3007 == false then return false end
	
	
	-- 3.1.1ҵĽʦIPδã-10֣ʾ1.1 ʦIPδûô󣬲CM-BOXü⣩
	local emptyClassroom = ''
	local classroomInfo = value39[webip]
	for j=1,#classroomInfo do
		local teaIp = classroomInfo[j]["teaIp"]
		local crName = classroomInfo[j]["crName"]
		if string.len(teaIp) == 0 then
			if string.len(emptyClassroom) ~= 0 then
				emptyClassroom = emptyClassroom .. ""
			end
			emptyClassroom = emptyClassroom .. '(' .. crName .. ')'
		end
	end	
	if string.len(emptyClassroom) == 0 then
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,""..emptyClassroom.."δýʦIPȷøýҽʦIP-10")
	end
	
	-- 3.1.2 õĽʦIPնͬΣ-10֣ʾ1.2ʦIPδûô󣬲CM-BOXü⣩
	detection43_isSameSubnet()
	
	
	-- ʦIPδûô󣬲CM-BOXü
	--[[
	豸ѾҪڽʦHALOǱҿԱ֤ȷģĽҺԣΪCMֻɨ赽
	local bTeaSuc = false
	GeneralFun.setTableValue('detection43_tearcher',bTea)
	]]
	
	-- 3.2.1ҵնʼIPͽIPǷãδã-5֣ʾ2.1
	local emptyClassroom = ''
	local classroomInfo = value39[webip]
	for j=1,#classroomInfo do
		local tmStartIp = classroomInfo[j]["tmStartIp"]
		local tmEndIp = classroomInfo[j]["tmEndIp"]
		local crName = classroomInfo[j]["crName"]
		local vmCount = classroomInfo[j]["vmCount"]
		if string.len(tmStartIp) == 0 or string.len(tmEndIp) == 0 then
			if string.len(emptyClassroom) ~= 0 then
				emptyClassroom = emptyClassroom .. ""
			end
			if crName == "ĬϽ" and vmCount == 0 then
				GeneralFun.writeFile("crName == "..crName.."vmCount == 0")
			else
				emptyClassroom = emptyClassroom .. '(' .. crName .. ')'
			end
			
		end
	end	
	if string.len(emptyClassroom) == 0 then
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,""..emptyClassroom.."δնʼIPϽնʼIP-10")
	end
	
	-- 3.2.2õնʼIPýն˵ַ-5֣ʾ2.2	
	-- detection43_contain(ip,startip,endip)
	local errorClassroom = ''
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	for i=1,#classroomInfo do
		local tmStartIp = classroomInfo[i]["tmStartIp"]
		local tmEndIp = classroomInfo[i]["tmEndIp"]
		local crName = classroomInfo[i]["crName"]
		if string.len(tmStartIp) ~= 0 and string.len(tmEndIp) ~= 0 then		
			for j=1,boxSize do
				local tmIp = value13[webip][j]["tmIp"]	
				local box_crName = value13[webip][j]["crName"]	
				if box_crName == crName and string.len(tmIp) ~= 0 then
					if not detection43_contain(tmIp,tmStartIp,tmEndIp) then
						if string.len(errorClassroom) ~= 0 then
							errorClassroom = errorClassroom .. ""
						end
						errorClassroom = errorClassroom .. '(' .. crName .. ')'
						break
					end
				end
			end	
		end		
	end
	if string.len(errorClassroom) == 0 then
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,""..errorClassroom.."õնʼIPΧСڵǰýбնIPΧȷնʼIPã-5")
	end
	
	-- 3.3δIPƼʹþ̬IPȡģʽ -10֣ʾ3.1	
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]			
		for j=1,boxSize do
			local vmIp = value13[webip][j]["vmIp"]
			local box_crName = value13[webip][j]["crName"]
			if box_crName == crName then				
				if string.len(vmIp) == 0 then
					if string.len(errorClassroom) ~= 0 then
						errorClassroom = errorClassroom .. ""
					end
					errorClassroom = errorClassroom .. '(' .. crName .. ')'
					break
				end
			end
		end		
	end
	
	if string.len(errorClassroom) ~= 0 then
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,"" .. errorClassroom .. "еƼʹþ̬IPģʽԷֵַֹͻ-10")
	else
		lua_addResult(p,1)
	end
	
	-- 3.4.1блȡնϢУģʽΪջ߶̬ģʽ-10֣ʾ4.1	
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]			
		for j=1,boxSize do
			local tmNetType = string.lower(value13[webip][j]["tmNetType"])
			local box_crName = value13[webip][j]["crName"]
			if box_crName == crName then				
				if string.len(tmNetType) == 0 or tmNetType == "dhcp" then
					if string.len(errorClassroom) ~= 0 then
						errorClassroom = errorClassroom .. ""
					end
					errorClassroom = errorClassroom .. '(' .. crName .. ')'
					break
				end
			end
		end		
	end
	
	--[[
	if string.len(errorClassroom) ~= 0 then
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,"" .. errorClassroom .. "еնƼʹþ̬IPģʽʹclassmannagerѧײܶն˽һ𣬷-10")
	else
		lua_addResult(p,1)
	end	
	]]
	
	-- 3.4.2блȡնϢУ롢ءDNS Ϊգ-10֣ʾ4.2
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]			
		for j=1,boxSize do
			local box_crName = value13[webip][j]["crName"]
			local tmMask = value13[webip][j]["tmMask"]
			local tmGateway = value13[webip][j]["tmGateway"]
			local tmDns = value13[webip][j]["tmDns"]
			if box_crName == crName then				
				if string.len(tmMask) == 0 or string.len(tmGateway) == 0 or string.len(tmDns) == 0 then
					if string.len(errorClassroom) ~= 0 then
						errorClassroom = errorClassroom .. ""
					end
					errorClassroom = errorClassroom .. '(' .. crName .. ')'
					break
				end
			end
		end		
	end
	
	if string.len(errorClassroom) ~= 0 then
		lua_addResult(p,3)
		lua_addScore(p,-3)
		lua_addTypeTip(p,3,"" .. errorClassroom .. "еնòʹclassmannagerѧײܶն˽һ𣬷-3")
	else
		lua_addResult(p,1)
	end	
	
	
	-- 3.4.3блȡնϢУնDNSһ£-5֣ʾ4.3	
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]			
		for j=1,boxSize do
			local box_crName = value13[webip][j]["crName"]
			local tmDns = value13[webip][j]["tmDns"]
			if box_crName == crName and string.len(tmDns) ~= 0 then				
				if tmDns ~= rcd_dns then
					if string.len(errorClassroom) ~= 0 then
						errorClassroom = errorClassroom .. ""
					end
					errorClassroom = errorClassroom .. '(' .. crName .. ')'
					break
				end
			end
		end		
	end
	
	if string.len(errorClassroom) ~= 0 then
		lua_addResult(p,3)
		lua_addScore(p,-3)
		lua_addTypeTip(p,3,"" .. errorClassroom .. "еնDNSRCDһ£ȷնDNSǷȷ-3")
	else
		lua_addResult(p,1)
	end	
	
	-- 3.5桢ն˳ֵַͻ-10ָʾ5	
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	local errorTable = {}
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]	
		local bAddressConflict = false
		local address = ''
		local addressConflict = ''
		for j=1,boxSize do
			local box_crName = value13[webip][j]["crName"]		
			local vmIp = value13[webip][j]["vmIp"]
			local tmIp = value13[webip][j]["tmIp"]
			if box_crName == crName then				
				if string.len(vmIp) ~= 0 then
					if string.find(address,vmIp.."") == nil then
						address = address .. vmIp .. ""
					else
						bAddressConflict = true
						if string.len(addressConflict) ~= 0 then
							addressConflict = addressConflict .. ""
						end
						addressConflict = addressConflict .. vmIp
					end
				end
				if string.len(tmIp) ~= 0 then
					if string.find(address,tmIp.."") == nil then
						address = address .. tmIp .. ""
					else
						bAddressConflict = true
						if string.len(addressConflict) ~= 0 then
							addressConflict = addressConflict .. ""
						end
						addressConflict = addressConflict .. tmIp
					end
				end	
			end
		end	
		if bAddressConflict then
			if string.len(errorClassroom) ~= 0 then
				errorClassroom = errorClassroom .. ""
			end
			errorClassroom = errorClassroom .. '(' .. crName .. ')'
			errorTable[crName] = addressConflict
		end		
	end
	
	if string.len(errorClassroom) ~= 0 then
		local tip = "" .. errorClassroom .. "նֵַ֮ͻַ滮"
		local conflict = ''
		for k,v in pairs(errorTable) do
			if string.len(conflict) ~= 0 then conflict = conflict .. '' end
			conflict = conflict .. '(' .. k .. ')' .. v
		end
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,tip.."(챨)",tip..'ͻУ'..conflict .. "-10")
	else
		lua_addResult(p,1)
	end		
	
	-- 3.6Ƿж棨ն˹Ʊб 6
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]			
		for j=1,boxSize do
			local box_crName = value13[webip][j]["crName"]
			local tmIp = value13[webip][j]["tmIp"]
			if box_crName == crName then				
				if string.len(tmIp) == 0 then
					if string.len(errorClassroom) ~= 0 then
						errorClassroom = errorClassroom .. ""
					end
					errorClassroom = errorClassroom .. '(' .. crName .. ')'
					break
				end
			end
		end		
	end
	
	if string.len(errorClassroom) ~= 0 then
		lua_addResult(p,3)
		lua_addScore(p,-2)
		lua_addTypeTip(p,3,"" .. errorClassroom .. "еó࣬ɾ棬-2")
	else
		lua_addResult(p,1)
	end	
		
	-- 3.7նϵͳǷ2.0Ӧ汾Ʊб 7	
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	local errorTable = {}
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]		
		local bNeedUpdate = false
		local needUpdateCount = 0
		for j=1,boxSize do
			local box_crName = value13[webip][j]["crName"]
			local box_ver = value13[webip][j]["tmOsVersion"]
			local box_type = string.lower(value13[webip][j]["tmOsType"])
			local ProductModel = string.lower(value13[webip][j]["tmProductModel"])
			if ProductModel == "rain100 v2" then
				box_type = "linux64"
			end
			if box_crName == crName then					
				if not detection_isBoxVerValid(config,box_ver,box_type,rcd_osver) then
					bNeedUpdate = true
					needUpdateCount = needUpdateCount + 1
				end
			end
		end		

		if bNeedUpdate then
			if string.len(errorClassroom) ~= 0 then
				errorClassroom = errorClassroom .. ""
			end
			errorClassroom = errorClassroom .. '(' .. crName .. ')'
			errorTable[crName] = needUpdateCount
			GeneralFun.writeFile("errorClassroom = "..errorClassroom.."needUpdateCount"..needUpdateCount)
		end
	end
	
	if string.len(errorClassroom) ~= 0 then	
		local tip = ''
		for k,v in pairs(errorTable) do      
			tip = tip .. '(' .. k .. ')' .. v .. '̨նˣ'
		end
	
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,tip .. "ϵͳ汾뵱ǰRCDOS汾ףնϵͳ汾-10")
	else
		lua_addResult(p,1)
	end	
	
	-- 3.8նͻ⣨Ʊб 8	
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	local hostNameEmpty = ''
	local hostNameConflictTable = {}
	local hostNameConflictTable_offset = 1
	for i=1,#classroomInfo do
		local bHostNameConflict_vm = false
		local bHostNameConflict_tm = false
		local bHostNameConflict_all = false
		local hostNameConflict_all = ''
		local hostNameConflict_vm = ''
		local hostNameConflict_tm = ''
		local hostName_all = ''
		local hostName_vm = ''
		local hostName_tm = ''
		local k=1
		local bHostNameEmpty_tm = false	
		local crName = classroomInfo[i]["crName"]		
		local vmhostNametab = {}
		local tmhostNametab = {}
		local vm_count = 1
		local tm_count = 1
		for j=1,boxSize do
			local box_crName = value13[webip][j]["crName"]
			if box_crName == crName then					
				local vmHostName = value13[webip][j]["vmHostName"]
				local tmHostName = value13[webip][j]["tmHostName"]				
				
				if string.len(vmHostName) ~= 0 then
					if #vmhostNametab > 0 then 
						local b_exist = GeneralFun.FindSameItem(vmhostNametab,vmHostName) --ͻ
						if b_exist == true then
							bHostNameConflict_vm = true
							if string.len(hostNameConflict_vm) ~= 0 then hostNameConflict_vm = hostNameConflict_vm .. ""	 end
							hostNameConflict_vm = hostNameConflict_vm .. vmHostName
						end
					end
					vmhostNametab[vm_count] = vmHostName
					vm_count = vm_count + 1
				end
			
				if string.len(tmHostName) ~= 0 then
					if string.lower(value13[webip][j]["tmOsType"]) == "windows" then
						if #tmhostNametab > 0 then
							local b_exist = GeneralFun.FindSameItem(tmhostNametab,tmHostName) --ͻ
							if b_exist == true then
								bHostNameConflict_tm = true
								if string.len(hostNameConflict_tm) ~= 0 then hostNameConflict_tm = hostNameConflict_tm .. ""	 end
								hostNameConflict_tm = hostNameConflict_tm .. tmHostName
							end
						end
						tmhostNametab[tm_count] = tmHostName
						tm_count = tm_count + 1
					end
				else
					bHostNameEmpty_tm = true				
				end
				
				if #vmhostNametab > 0 and #tmhostNametab > 0 then  --ͻ
					local confilcstr = GeneralFun.FindTabSameItem(vmhostNametab,tmhostNametab)
					if string.len(confilcstr) ~= 0 then
						bHostNameConflict_all = true
						hostNameConflict_all = confilcstr
					end
				end
			end
		end	
		
		if bHostNameEmpty_tm then
			if string.len(hostNameEmpty) ~= 0 then
				hostNameEmpty = hostNameEmpty .. ""
			end
			hostNameEmpty = hostNameEmpty .. '(' .. crName .. ')'
		end
		-- 

		if	bHostNameConflict_tm or bHostNameConflict_vm or bHostNameConflict_all then
			local briefTip = ''
			local tip = ''
			if bHostNameConflict_all then
				briefTip = "ն֮ͻն֮"	
				tip = briefTip .. "ͻУ"..hostNameConflict_all
				briefTip = briefTip .. "(챨)"					
				
				local tipTable = {}
				tipTable["briefTip"] = briefTip
				tipTable["tip"] = tip
				tipTable["name"] = crName
				hostNameConflictTable_offset = hostNameConflictTable_offset + 1
				hostNameConflictTable[hostNameConflictTable_offset] = tipTable
			end
			
			if bHostNameConflict_tm then
				briefTip = "ն֮ͻն"	
				tip = briefTip .. "ͻУ("..hostNameConflict_tm..")"
				briefTip = briefTip .. "(챨)"
				local tipTable = {}
				tipTable["briefTip"] = briefTip
				tipTable["tip"] = tip
				tipTable["name"] = crName
				hostNameConflictTable_offset = hostNameConflictTable_offset + 1
				hostNameConflictTable[hostNameConflictTable_offset] = tipTable
			end
			
			if bHostNameConflict_vm then
				briefTip = "֮ͻ"	
				tip = briefTip .. "ͻУ("..hostNameConflict_vm..")"
				briefTip = briefTip .. "(챨)"	
				
				local tipTable = {}
				tipTable["briefTip"] = briefTip
				tipTable["tip"] = tip
				tipTable["name"] = crName
				hostNameConflictTable_offset = hostNameConflictTable_offset + 1
				hostNameConflictTable[hostNameConflictTable_offset] = tipTable
			end	
		end
	end
	
	local bconflict = false
	for k,v in pairs(hostNameConflictTable) do      	
		bconflict = true
		lua_addTypeTip(p,3,'(' .. v["name"] .. ')'..v["briefTip"],'(' .. v["name"] .. ')'..v["tip"])		
	end 
	
	if bconflict then
		lua_addResult(p,3)
		lua_addScore(p,-5)
	else
		lua_addResult(p,1)
	end
	--[[
	if string.len(hostNameEmpty) ~= 0 then
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,"" .. hostNameEmpty .. "δնʹclassmannagerն˽һ -10")
	else
		lua_addResult(p,1)
	end		
	]]
	-- 3.9նǷڲͬ
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]			
		for j=1,boxSize do
			local box_crName = value13[webip][j]["crName"]
			if box_crName == crName then	
				local tmIp = value13[webip][j]["tmIp"]
				local tmMask = value13[webip][j]["tmMask"]
				local vmIp = value13[webip][j]["vmIp"]
				local vmMask = value13[webip][j]["vmMask"]
				if string.len(tmIp) > 0 and string.len(tmMask) > 0 and string.len(vmIp) > 0 and string.len(vmMask) > 0 then
					if lua_isSameSubnet(tmIp,vmIp,tmMask,vmMask) then						
						if string.len(errorClassroom) ~= 0 then
							errorClassroom = errorClassroom .. ""
						end
						errorClassroom = errorClassroom .. '(' .. crName .. ')'
						break
					end
				end		
			end
		end		
	end
	
	if string.len(errorClassroom) ~= 0 then
		lua_addResult(p,2)
		lua_addTypeTip(p,2,"" .. errorClassroom .. "նͬһΣв𳡾齫ն")
	else
		lua_addResult(p,1)
	end	
	
	lua_afterDetect(p)
end
 
return detection