
local detection = {}

local desc = 'RCDOS汾'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')
local _slaveHost = ''
function detection16_getSlaveHost()
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')	if value == false then return end
	local rcd_osver = value[webip]["version"]
	local result = lua_compareVer(rcd_osver,"2.1")
	
	local value = GeneralFun.getInfo(0,'{"Request":24,"IPs":"'..webip..'"}')		if value == false then return end
	local slaveHost = value[webip]["slaveHost"]
	local needIP = ''
	
	if result == 3 or result == 4 then --2.0汾
		for i=1,#slaveHost do
			local tmpIP = slaveHost[i]["ip"]		
			local bConnect = lua_getConnectState(tmpIP)
			if not bConnect then
				return false
			end
			if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
			needIP = needIP .. tmpIP
		end
	else -- 2.1汾
		local value = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..webip..'"}')	if value == false then return end
		local localMode = value[webip]["localMode"]
		if localMode == "1" or localMode == "3" then
			for i=1,#slaveHost do
				local tmpIP = slaveHost[i]["wanIp"]		
				local bConnect = lua_getConnectState(tmpIP)
				if not bConnect then
					return false
				end
				if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
				needIP = needIP .. tmpIP
			end
		else
			for i=1,#slaveHost do
				local tmpIP = slaveHost[i]["ip"]		
				local bConnect = lua_getConnectState(tmpIP)
				if not bConnect then
					return false
				end
				if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
				needIP = needIP .. tmpIP
			end
		end
	end
	_slaveHost = needIP
	return true
end

function CM_Tea_Repair(osVersion)
	if osVersion == "2.1.0.24" then
		local b_suc = lua_CmTeaDllRepair()
		if b_suc then 
			GeneralFun.writeFile("CM DLL repair OK")
			lua_SetRepairCode(_slaveHost,"4001")
		end
	end
end

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
		
	local config = GeneralFun.getConfig()
	local ver1 = config["rcdosVersion"]["lowest version"]
	local ver2 = config["rcdosVersion"]['latest version']	
	local externalVer = config["rcdosVersion"]['external version']
	GeneralFun.writeFile('lowest version:'..ver1..'  latest version:'..ver2.." ")
	
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')		if value == false then return end
	local rcdosVer = value[webip]["version"]
	local ret1 = lua_compareVer(rcdosVer,ver1) 
	local ret2 = lua_compareVer(rcdosVer,ver2) 
	
	local versionlist = GeneralFun.getVersionList()
	local webExternalVer = versionlist["RCD-OS-Version"][rcdosVer]
	if webExternalVer == nil then
		webExternalVer = rcdosVer
	end
	
	CM_Tea_Repair(rcdosVer)
	
	if rcdosVer ~= "2.1.0.24" then
		if ret1 == 3 then
			--1Ϊv1.0.9V1.1汾죬ʾ1
			local tip = "汾ͣڽϴգ"..externalVer.."ϰ汾"
			lua_addTypeTip(p,3,tip)
			lua_addScore(p,-100)
			lua_addResult(p,3)
			
			lua_afterDetect(p)
			GeneralFun.StopDetect(2,tip)
			return
		elseif ret2 == 3 or ret2 == 4 then
			--2ΪV2.0.3.25°汾 - 5
			lua_addTypeTip(p,3,"ǰ汾"..webExternalVer..""..externalVer.."ϰ汾-5")
			lua_addScore(p,-5)
			lua_addResult(p,3)
		else
			lua_addResult(p,1)
		end
	end
	detection16_getSlaveHost()
	
	local request_ips = ''
	if string.len(_slaveHost) ~= 0 then
		request_ips = _slaveHost .. '#' ..webip
	else
		request_ips = webip
	end
	-------ģ鰲װ
	local value = GeneralFun.getInfo(0,'{"Request":45,"IPs":"'..request_ips..'"}')		if value == false then return end --webϵͳģ
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local error_ip = ''
	for i=1,#ips do
		local tmpip = ips[i]
		local obj = value[tmpip]
		local installState = obj["isInstallOk"]
		if installState ~= "yes" then
			if string.len(error_ip) > 0 then
				error_ip = error_ip .. ''
			end
			error_ip = error_ip .. tmpip
		end
	end
	
	if string.len(error_ip) > 0 then 
		local tip = "".. error_ip .. " װδʹU̷ʽװ"
		lua_addResult(p,3)
		lua_addScore(p,-100)
		lua_addTypeTip(p,3,tip)
		
		lua_afterDetect(p)
		GeneralFun.StopDetect(2,tip)
	else
		lua_addResult(p,1)
	end
	
	
	
	-----OTAģ2.12.1ϰ汾֧
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')	if value == false then return end
	local rcd_osver = value[webip]["version"]
	local result = lua_compareVer(rcd_osver,"2.1")
	if result == 1 or result == 2 then --2.1汾
		local value = GeneralFun.getInfo(0,'{"Request":46,"IPs":"'..request_ips..'"}')		if value == false then return end --ota
		local ips = GeneralFun.stringSplit(request_ips,"#")
		local needRepairIp = ''
		local needWarnIp = ''
		for i=1,#ips do
			local tmpip = ips[i]
			local obj = value[tmpip]
			if obj["otaPackageFix"] == "-1" then --Ҫ޸
				if needRepairIp ~= '' then needRepairIp = needRepairIp .. "#" end
				needRepairIp = needRepairIp .. tmpip
			elseif obj["otaPackageFix"] == "1" then --޸
				if needWarnIp ~= '' then needWarnIp = needWarnIp .. "#" end
				needWarnIp = needWarnIp .. tmpip
			end
		end
		
		if needRepairIp ~= '' then
			local value = GeneralFun.getAysnInfo(0,'{"Request":47,"IPs":"'..needRepairIp..'"}') if value == false then return end --ota޸
			lua_SetRepairCode(needRepairIp,"47")
			lua_addResult(p,3)
			lua_addScore(p,-100)
			lua_addTypeTip(p,3,"ڻԭնOTAϵͳȴ2ӺͨWEBҳ鿴(->նϵͳ)")
			
			lua_afterDetect(p)
			GeneralFun.StopDetect(2,tip)
		end
		
		if needWarnIp ~= '' then
			lua_addResult(p,3)
			lua_addScore(p,-100)
			lua_addTypeTip(p,3,"ڻԭնOTAϵͳȴ2ӺͨWEBҳ鿴(->նϵͳ)")
			
			lua_afterDetect(p)
			GeneralFun.StopDetect(2,tip)
		end
		
		if needRepairIp == '' and needWarnIp == '' then 
			lua_addResult(p,1)
		end
	end
	
	--CMGUESTǷɾ
	if result == 1 or result == 2 then --2.1汾
		local value = GeneralFun.getInfo(0,'{"Request":61,"IPs":"'..webip..'"}')	if value == false then return end --CMǷɾ
		if value[webip]["cm_missing"] == "true" then
			lua_addResult(p,2)
			lua_addTypeTip(p,2,"Ŀ¼ClassManagerȱʧ")
			lua_addRepair(p,GeneralFun.getInfoDesc(62),"62")
		else
			lua_addResult(p,1)
		end
	
		local value = GeneralFun.getInfo(0,'{"Request":63,"IPs":"'..webip..'"}')	if value == false then return end --GUESTǷɾ
		if value[webip]["gusettool_missing"] == "true" then
			lua_addResult(p,2)
			lua_addTypeTip(p,2,"Ŀ¼Guest-Toolȱʧ")
			lua_addRepair(p,GeneralFun.getInfoDesc(64),"64")
		else
			lua_addResult(p,1)
		end
	end
	lua_afterDetect(p)	
end
 
return detection
