
local detection = {}
 
local desc = 'ɱ'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

function detection23_getRcdSn()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	local value = GeneralFun.getInfo(0,'{"Request":7,"IPs":"'..webip..'"}')		if value == false then return end
	local ip = value[webip]["ip"]
	local ip2 = value[webip]["ip2"]
	
	local value = GeneralFun.getInfo(0,'{"Request":25,"IPs":"'..webip..'"}')		if value == false then return end
	local rcdsn = ""
	local slavercdsn = ""
	local hostSn = value[webip]["hostSn"]	
	for k,v in pairs(hostSn) do
		for tmp_ip,tmp_rcdsn in pairs(v) do
			if tmp_ip == webip or tmp_ip == ip or tmp_ip == ip2 then
				rcdsn = tmp_rcdsn
			else
				if string.len(slavercdsn) ~= 0 then
					slavercdsn = slavercdsn .. "\\"
				end
				slavercdsn = slavercdsn .. tmp_rcdsn
			end		
		end
	end
	
	return string.len(rcdsn)~=0 and rcdsn or "NA"	
end

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	
	local jsonRoot = {}
	
	local value = GeneralFun.getInfo(0,'{"Request":68,"IPs":"'..webip..'"}')		if value == false then return end
	local supportId = value[webip]["supportId"]
	if supportId == "0" then
		jsonRoot["supportID"] = "<td></td>"
	else
		jsonRoot["supportID"] = "<td>֧ID" .. supportId .. "</td>"
	end
	
	jsonRoot["reportName"] = "sigleReport"
	jsonRoot["name"] = detection23_getRcdSn()
	
	local username = ''
	local userId = ''
	local value = GeneralFun.getInfo(3016) if value == false then return end
	if value ~= nil then
		username = value["result"]["username"]
		userId = value["result"]["userId"]
		if string.len(username)==0 then
			jsonRoot["report_username"] = ""
			jsonRoot["userId"] = ""
		else
			jsonRoot["report_username"] = "<p>ύߣ"..username.."</p>" -- ύ
			if string.len(userId) == 0 then
				jsonRoot["userId"] = ""
			else
				if GeneralFun.IsNum(userId) == true and string.len(userId) == 11 then
					jsonRoot["userId"] = "<p>ϵ绰"..userId.."</p>" -- ύϵ绰
				else
					jsonRoot["userId"] = ""
				end
			end
		end
	else
		jsonRoot["report_username"] = ""
		jsonRoot["userId"] = ""
	end
	
	
	local value = GeneralFun.getInfo(0,'{"Request":11,"IPs":"'..webip..'"}')		if value == false then return end
	local name = value[webip]["name"]
	if string.len(name)~=0 then
		jsonRoot["school"] = name
		lua_WriteProfile("FAULTREPORT-MSG","school",name)
	else
		jsonRoot["school"] = "NA"
		lua_WriteProfile("FAULTREPORT-MSG","school","NA")
	end
	local classroom = value[webip]["classroom"]
	jsonRoot["classroom"] = string.len(classroom)~=0 and classroom or "NA"
	
	local value = GeneralFun.getInfo(0,'{"Request":7,"IPs":"'..webip..'"}')		if value == false then return end
	local ip = value[webip]["ip"]
	local ip2 = value[webip]["ip2"]
	
	local value = GeneralFun.getInfo(0,'{"Request":25,"IPs":"'..webip..'"}')		if value == false then return end
	local rcdsn = ""
	local slavercdsn = ""
	local hostSn = value[webip]["hostSn"]	
	for k,v in pairs(hostSn) do
		for tmp_ip,tmp_rcdsn in pairs(v) do
			if tmp_ip == webip or tmp_ip == ip or tmp_ip == ip2 then
				rcdsn = tmp_rcdsn
			else
				if string.len(slavercdsn) ~= 0 then
					slavercdsn = slavercdsn .. "\\"
				end
				slavercdsn = slavercdsn .. tmp_rcdsn
			end		
		end
	end
	
	jsonRoot["rcd_sn"] = string.len(rcdsn)~=0 and rcdsn or "NA"	
	jsonRoot["slave_rcd_sn"] = slavercdsn
			
	local value = GeneralFun.getInfo(0,'{"Request":26,"IPs":"'..webip..'"}')		if value == false then return end
	local baseVersion = value[webip]["baseVersion"]
	jsonRoot["rcd_os_version"] = string.len(baseVersion)~=0 and baseVersion or "NA"
	
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')		if value == false then return end
	local patchVer = value[webip]["version"]
	patchVer = patchVer~=baseVersion and patchVer or ""
	jsonRoot["patch_info"] = patchVer
	
	jsonRoot["exam_score"] = ''..lua_getScore()
	jsonRoot["warn_num"] = ''..lua_getTipCount()
	--ɴϢ	
	local ids = {lua_getNotPassIDs()}
	local RK_ERROR_ITEM = ''
	local itemNum = 1
	for i=1,#ids do
		local tmpID = ids[i]
		local desc = lua_getDescByID(tmpID)
		local tip = lua_getTypeTipByID(tmpID,false,3)
		if string.len(tip) ~= 0 then
			local tips = GeneralFun.stringSplit(tip,"\r\n")
			tip = ''
			for j=1,#tips do
				tip = tip .. "<tr><td>&nbsp;&nbsp;&nbsp;"
				tip = tip .. tips[j]
				tip = tip .. "</td></tr>"
			end
			RK_ERROR_ITEM = RK_ERROR_ITEM .. "<h4>" .. itemNum .. "." .. desc .. "</h4>"
			RK_ERROR_ITEM = RK_ERROR_ITEM .. "<table>" .. tip .. "</table>"
			itemNum = itemNum + 1
		end
	end
	local RK_ERROR = ''
	if string.len(RK_ERROR_ITEM) ~= 0 then
		RK_ERROR = RK_ERROR .. "<div style=\" text-align: left;\" class=\"info_title\"><p>۷</p></div> \
		<div id=\"error_info\" style=\"margin-left: 0px; padding: 5px; text-align: left; text-indent: 20px;\" class=\"info_title\">"
		RK_ERROR = RK_ERROR .. RK_ERROR_ITEM
		RK_ERROR = RK_ERROR .. "</div>"
	end
	jsonRoot["error_item"] = RK_ERROR
	--ɾϢ
	local RK_WARN_ITEM = ''
	local itemNum = 1
	for i=1,#ids do
		local tmpID = ids[i]
		local desc = lua_getDescByID(tmpID)
		local tip = lua_getTypeTipByID(tmpID,false,2)
		if string.len(tip) ~= 0 then
			local tips = GeneralFun.stringSplit(tip,"\r\n")
			tip = ''
			for j=1,#tips do
				tip = tip .. "<tr><td>&nbsp;&nbsp;&nbsp;"
				tip = tip .. tips[j]
				tip = tip .. "</td></tr>"
			end
			RK_WARN_ITEM = RK_WARN_ITEM .. "<h4>" .. itemNum .. "." .. desc .. "</h4>"
			RK_WARN_ITEM = RK_WARN_ITEM .. "<table>" .. tip .. "</table>"
			itemNum = itemNum + 1
		end
	end
	local RK_WARN = ''
	if string.len(RK_WARN_ITEM) ~= 0 then
		 RK_WARN = RK_WARN .. "<div style=\" text-align: left;\" class=\"info_title\"><p></p></div> \
		 <div id=\"warn_info\" style=\"margin-left: 0px; padding: 5px; text-align: left; text-indent: 20px;\" class=\"info_title\">"
		RK_WARN = RK_WARN .. RK_WARN_ITEM
		RK_WARN = RK_WARN .. "</div>"
	end
	jsonRoot["warn_item"] = RK_WARN
	
	--޸Ϣ
	local RK_REPAIR_ITEM = ''
	local itemNum = 1
	local repairNum = lua_GetRepairNum()
	local repairStr = lua_GetRepairInfo()
	GeneralFun.writeFile(repairStr)
	local repairInfo = cjson.decode(repairStr)
	GeneralFun.writeFile(repairInfo["repairOk"])
	if repairInfo["repairOk"] == "false" then
		jsonRoot["repairInfo_item"] = ''
	else
		for k,v in pairs(repairInfo) do
			local tmpIp = k
			local ipInfo = v
			if tmpIp ~= "repairOk" then
				local info = ''
				local tip = "<tr><td style=\"word-break:break-all\">&nbsp;&nbsp;&nbsp;"
				for i=1,#ipInfo do
					if string.len(info) ~= 0 then info = info .. '' end
					info = info .. ipInfo[i] 
				end
				tip = tip .. info
				tip = tip .. "</td></tr>"
				RK_REPAIR_ITEM = RK_REPAIR_ITEM .. "<h4>" .. tmpIp .. "޸" .. "</h4>"
				RK_REPAIR_ITEM = RK_REPAIR_ITEM .. "<table>" .. tip .. "</table>"
				itemNum = itemNum + 1
			end
		end
		RK_REPAIR_ITEM = RK_REPAIR_ITEM .. "<h4>" .. "ܼ޸" .. lua_GetRepairNum() .. "</h4>"
		local RK_REPAIR = ''
		if string.len(RK_REPAIR_ITEM) ~= 0 then
			 RK_REPAIR = RK_REPAIR .. "<div style=\" text-align: left;\" class=\"info_title\"><p>޸</p></div> \
			 <div id=\"warn_info\" style=\"margin-left: 0px; padding: 5px; text-align: left; text-indent: 20px;\" class=\"info_title\">"
			RK_REPAIR = RK_REPAIR .. RK_REPAIR_ITEM
			RK_REPAIR = RK_REPAIR .. "</div>"
		end
		jsonRoot["repairInfo_item"] = RK_REPAIR
	end
	
	--	RCDϢ
	local value = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..webip..'"}')		if value == false then return end
	local netmode = 0
	if string.lower(value[webip]["deployMode"]) == "normal" then
		netmode = tonumber(value[webip]["localMode"])
	else
		netmode = 4
	end	
	
	local modes = {}
	modes[0] = "У԰նУ԰"
	modes[1] = "У԰ն˽"
	modes[2] = "˽նУ԰"
	modes[3] = "˽ն˽"
	modes[4] = "Ⱥ"
	
	jsonRoot["net_mode"] = modes[netmode]
	
	local value = GeneralFun.getInfo(0,'{"Request":4,"IPs":"'..webip..'"}')		if value == false then return end
	
	jsonRoot["rcd_wan_ip"] = value[webip]["ip"]
	
	jsonRoot["wan_mask"] = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":5,"IPs":"'..webip..'"}')		if value == false then return end
	
	jsonRoot["rcd_1st_ip"] = value[webip]["ip"]
	
	local RK_RCD_2ND_IP = value[webip]["ip2"]
	if string.len(RK_RCD_2ND_IP) == 0 then
		RK_RCD_2ND_IP = "ģʽ·ۺģʽ"
	else
		RK_RCD_2ND_IP = "ڶڵַ" .. RK_RCD_2ND_IP
	end
	
	jsonRoot["rcd_2nd_ip"] = RK_RCD_2ND_IP
	
	jsonRoot["rcd_mask"] = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":8,"IPs":"'..webip..'"}')		if value == false then return end
	jsonRoot["rcd_gateway"] = value[webip]["gateway"]
	
	local value = GeneralFun.getInfo(0,'{"Request":6,"IPs":"'..webip..'"}')		if value == false then return end		
	jsonRoot["rcd_dns"] = value[webip]["dns"]
	
	local value = GeneralFun.getInfo(0,'{"Request":17,"IPs":"'..webip..'"}')		if value == false then return end	
	jsonRoot["teacher_ip"] = value[webip]["teacherIp"]
	
	--
	jsonRoot["halo_version"] = lua_getDetectVersion()
	--
	jsonRoot["rule_version"] = lua_getRuleVersion()
		
	local szdate=os.date("%Y.%m.%d %H:%M:%S")
	jsonRoot["report_time"] = szdate
	
	local value = GeneralFun.getInfo(0,'{"Request":13,"IPs":"'..webip..'"}')		if value == false then return end		
	local RK_DESKTOP_INFO = ''
	for i=1,#value[webip] do
		local ProductModel = string.lower(value[webip][i]["tmProductModel"])
		local box_type = value[webip][i]["tmOsType"]
		if ProductModel == "rain100 v2" then
			box_type = "linux(64)"
		end
		RK_DESKTOP_INFO = RK_DESKTOP_INFO .. "<tr>" ..
							"<td>" .. value[webip][i]["vmHostName"] .. "</td>" ..
							"<td>" .. value[webip][i]["vmIp"] .. "</td>" ..
							"<td>" .. value[webip][i]["tmHostName"] .. "</td>" ..
							"<td>" .. value[webip][i]["tmNetType"] .. "</td>" ..
							"<td>" .. value[webip][i]["tmIp"] .. "</td>" ..
							"<td>" .. value[webip][i]["tmMask"] .. "</td>" ..
							"<td>" .. value[webip][i]["tmGateway"] .. "</td>" ..
							"<td>" .. value[webip][i]["tmDns"] .. "</td>" ..
							"<td>" .. box_type .. "</td>" ..
							"<td>" .. value[webip][i]["tmOsVersion"] .. "</td>" ..						
							"</tr>"
	end
	jsonRoot["desktop_info"] = RK_DESKTOP_INFO
	jsonRoot["faultReportInfo"] = ""
	local jsonStr = cjson.encode(jsonRoot)	
	local rpResult = lua_detectReport(jsonStr)
	
	if not rpResult then
		lua_addTypeTip(p,2,"ɱʧܣϵݼ֧")
		lua_addResult(p,2)
	else
		lua_addResult(p,1)
	end
			
	lua_afterDetect(p)	
end
 
return detection
