local detection = {}

local desc = 'ʦ'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

--1⹤Ƿڽʦ
function detection21_isTeacherTM(p)
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":17,"IPs":"'..webip..'"}')	if value == false then return false end
	local teacherIp = value[webip]["teacherIp"]
	
	local value = GeneralFun.getInfo(3007)	if value == false then return false end
	local bEqual = false
	local boxSize = #value["netinfo"]
	for i=1,boxSize do
		local localip = value["netinfo"][i]["ip"]
		if teacherIp == localip then
			bEqual = true
			break
		end
	end
	if not bEqual then
		lua_addResult(p,2)
		lua_addTypeTip(p,2,"ǰ豸ǽʦ޷ؼ")
		lua_afterDetect(p)
		return false
	else
		lua_addResult(p,1)		
		return true
	end
end

-- ҳõĽʦIPǷȷ 5
-- ģʽ0½ʦIP1ͬ ģʽ1½ʦIPַͬΣģʽ3½ʦIP192.168.123.0\24ͬ
function detection21_isTeacherIPError(p)
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":17,"IPs":"'..webip..'"}')	if value == false then return false end
	local teacherIp = value[webip]["teacherIp"]	
	
	local value = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..webip..'"}')	if value == false then return end
	local deployMode = string.lower( value[webip]["deployMode"])
	
	if deployMode == "normal" then
		local localMode = value[webip]["localMode"]
		if localMode == "1" then	-- ģʽ1½ʦIPַͬΣ			
			local value = GeneralFun.getInfo(0,'{"Request":4,"IPs":"'..webip..'"}')		if value == false then return false end
			local wanIP = value[webip]["ip"]
			local wanMask = value[webip]["netmask"]		
			
			if lua_isSameSubnet(teacherIp,wanIP,wanMask,wanMask) then		
				lua_addResult(p,1)		
				return false
			else
				lua_addResult(p,3)
				lua_addScore(p,-5)
				lua_addTypeTip(p,3,"ģʽ½ʦIPַͬΣҳĽ޸ĽʦIPã-5")
				lua_afterDetect(p)
				return true
			end
		elseif localMode == "3" then	-- ģʽ3½ʦIP192.168.123.0\24ͬ
			if lua_isSameSubnet(teacherIp,"192.168.123.0","255.255.255.0","255.255.255.0") then			
				lua_addResult(p,1)	
				return false
			else
				lua_addResult(p,3)
				lua_addScore(p,-5)
				lua_addTypeTip(p,3,"ģʽ½ʦIP192.168.123.0/24IPҳĽ޸ĽʦIPã-5")
				lua_afterDetect(p)
				return true
			end
		elseif localMode == "0" then	-- ģʽ0½ʦIP1ͬ 		
			local value = GeneralFun.getInfo(0,'{"Request":5,"IPs":"'..webip..'"}')		if value == false then return false end
			local ip1 = value[webip]["ip"]
			local netmask = value[webip]["netmask"]		
			
			if lua_isSameSubnet(teacherIp,ip1,netmask,netmask) then
				lua_addResult(p,1)
				return false
			else
				lua_addResult(p,3)
				lua_addScore(p,-5)
				lua_addTypeTip(p,3,"ģʽ½ʦIPͬΣҳĽ޸ĽʦIPã-5")
				lua_afterDetect(p)
				return true
			end
		end
	end	
	
	return false
end
---2.1汾ȥü
--2RCDն˽У԰ģʽʦ˫IPIPַͬΣڶIPΪն˽ͬIPʦIPRCDõĽʦIPһ
--2ʾʦΪ˫IPأΪУ԰أIPַͬΣڶIPΪͬIP
function detection21_mode1(p)
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":17,"IPs":"'..webip..'"}')	if value == false then return false end
	local teacherIp = value[webip]["teacherIp"]
	
	local value = GeneralFun.getInfo(0,'{"Request":5,"IPs":"'..webip..'"}')		if value == false then return false end
	local ip1 = value[webip]["ip"]
	local ip2 = value[webip]["ip2"]
	local netmask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":4,"IPs":"'..webip..'"}')		if value == false then return false end
	local wanIP = value[webip]["ip"]
	local wanGateway = value[webip]["gateway"]
	local wanMask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(3007)		if value == false then return false end
	local boxSize = #value["netinfo"]
	local b1 = string.find(value["netinfo"][1]["gateway"],",") == nil -- 
	if boxSize < 2 then
		local tip = "ʦΪ˫IP"
		if not b1 then 
			tip = tip .. ",أΪУ԰" 
		end
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,tip .. "-5")
		return true
	end
	local b2 = false -- ip
	local b3 = false -- ip
	for i=1,boxSize do		
		if value["netinfo"][i]["ip"] == teacherIp then -- ip
			if lua_isSameSubnet(value["netinfo"][i]["ip"],wanIP,value["netinfo"][i]["mask"],wanMask) then
				b2 = true
			end
		else	-- ip
			if lua_isSameSubnet(value["netinfo"][i]["ip"],ip1,value["netinfo"][i]["mask"],netmask)
				or lua_isSameSubnet(value["netinfo"][i]["ip"],ip2,value["netinfo"][i]["mask"],netmask) then
				b3 = true
			end
			
		end
	end
	local tip = "" 
	if not b1 then
		tip = tip .. "ʦΪأΪУ԰" 
	end
	if not b2 then		
		if string.len(tip) == 0 then  
			tip = "ʦ"
		else
			tip = tip .. ""
		end
		tip = tip .. "ipΪַͬ"
	end
	if not b3 then		
		if string.len(tip) == 0 then  
			tip = "ʦ"
		else
			tip = tip .. ""
		end
		tip = tip .. "ڶIPΪͬIP"
	end
	
	if tip ~= "" then
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,tip .. "-5")
	else
		lua_addResult(p,1)
	end
	
	return true
end

---2.1汾ȥü
-- 3RCDնˡ˽ģʽʦIPΪ192.168.123.0/24ΣΪ192.168.123.1ڶIPͬIPһ£-5֡
-- 3ʾʦΪ˫IPأIPΪ192.168.123.0/24ΣΪ192.168.123.1ڶIPͬIP  
function detection21_mode3(p)
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":17,"IPs":"'..webip..'"}')	if value == false then return false end
	local teacherIp = value[webip]["teacherIp"]
	if string.find(teacherIp,"192.168.123.") == 1 then --and string.find(teacherMask,"255.255.255.0") == 1 then	
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,"RCDĽʦIPΪ192.168.123.0/24IP-5")
		return true
	end 
	
	local value = GeneralFun.getInfo(0,'{"Request":5,"IPs":"'..webip..'"}')		if value == false then return false end
	local ip1 = value[webip]["ip"]
	local ip2 = value[webip]["ip2"]
	local netmask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":4,"IPs":"'..webip..'"}')		if value == false then return false end
	local wanIP = value[webip]["ip"]
	local wanGateway = value[webip]["gateway"]
	local wanMask = value[webip]["netmask"]
	local value = GeneralFun.getInfo(3007)		if value == false then return false end
	local boxSize = #value["netinfo"]
	local b1 = string.find(value["netinfo"][1]["gateway"],",") == nil -- 
	local b2 = true--string.find(value["netinfo"][1]["gateway"],"192.168.123.1") ~= nil -- Ϊ192.168.123.1
	if boxSize < 2 then
		local tip = "ʦΪ˫IP"
		if not b1 then
			tip = tip .. ""
		end
		if not b2 then
			tip = tip .. "Ϊ192.168.123.1"
		end
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,tip .. "-5")
		return true
	end
	local b3 = false -- ip
	local b4 = false -- ip
	for i=1,boxSize do		
		if value["netinfo"][i]["ip"] == teacherIp then -- ip
			if string.find(value["netinfo"][i]["ip"],"192.168.123.") == 1
				and  string.find(value["netinfo"][i]["mask"],"255.255.255.0") == 1 then
				b3 = true
			end
		else	-- ip
			if lua_isSameSubnet(value["netinfo"][i]["ip"],ip1,value["netinfo"][i]["mask"],netmask)
				or lua_isSameSubnet(value["netinfo"][i]["ip"],ip2,value["netinfo"][i]["mask"],netmask) then
				b4 = true
			end			
		end
	end
	local tip = "" 
	if not b1 then
		tip = tip .. "ʦΪ" 
	end
	if not b2 then
		if string.len(tip) == 0 then  
			tip = "ʦ"
		else
			tip = tip .. ""
		end
		tip = tip .. "Ϊ192.168.123.1" 
	end
	
	if not b3 then
		if string.len(tip) ~= 0 then
			tip = tip .. "" 
		else
			tip = "ʦ"
		end
		tip = tip .. "ipΪ192.168.123.0/24IP"
	end
	if not b4 then
		if string.len(tip) ~= 0 then
			tip = tip .. "" 
		else
			tip = "ʦ"
		end
		tip = tip .. "ڶIPΪͬIP"
	end
	
	if tip ~= "" then
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,tip .. "-5")
	else
		lua_addResult(p,1)
	end	
	return true
end

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	
	--1⹤Ƿڽʦ
	if not detection21_isTeacherTM(p) then
		lua_afterDetect(p)
		return
	end
	
	-- ҳõĽʦipǷд
	if detection21_isTeacherIPError(p) then
		lua_afterDetect(p)
		return
	end
	
	--ϵͳ汾2.1ϵĸ
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')	if value == false then return end
	local rcd_osver = value[webip]["version"]
	local result = lua_compareVer(rcd_osver,"2.1")
	if result == 3 or result == 4 then
		local value = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..webip..'"}')	if value == false then return end
		local deployMode = string.lower( value[webip]["deployMode"])
		
		if deployMode == "normal" then
			local localMode = value[webip]["localMode"]
			if localMode == "1" then
				local bRunOK = detection21_mode1(p)
				if not bRunOK then
					return
				end
			elseif localMode == "3" then
				local bRunOK = detection21_mode3(p)
				if not bRunOK then
					return
				end
			end
		end	
	end
	
	
	--4.鹤ڽʦϣԱadmin-toolǷ뵱ǰRCD汾һ£һ£-5֡
	local value = GeneralFun.getInfo(0,'{"Request":30,"IPs":"'..webip..'"}')	if value == false then return end
	local ser_at_ver = value[webip]["version"]
	local value = GeneralFun.getInfo(3008)	if value == false then return end
	local at_ver = value["version"]
	if lua_compareVer(ser_at_ver,at_ver) ~= 1 then
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,"Աߣ-5")
	else
		lua_addResult(p,1)
	end
	
	--ǷΪۺ棬Ϊۺݲ
	local role = lua_GetProfile("USER-MSG","role")
	GeneralFun.writeFile("role== "..role)
	if role == "sale-role" then
		lua_afterDetect(p)
		return
	end
	
	--Ƿ
	local value = GeneralFun.getInfo(3018)		if value == false then return end
	local networksize = #value["result"]
	if networksize > 1 then --1
		lua_addResult(p,2)
		lua_addTypeTip(p,2,"ǰʦڶ")
	else
		lua_addResult(p,1)
	end
	
	--ǷǽCMRǷǽ
	local value = GeneralFun.getInfo(3019)		if value == false then return end
	if value["result"]["firewallState"] == "0" then --ǽر
		lua_addResult(p,1)
	else
		lua_addResult(p,2)
		lua_addTypeTip(p,2,"ʦϵͳǽܣҪƿýѧClassMannagerǽرϵͳǽӰƿýѧʹ")
	end
	
	--Ƿװɱ
	local tabBlackList={} -- 
	tabBlackList[1]={}
	tabBlackList[1]["exename"]="360tray.exe"
	tabBlackList[1]["displayname"]="360ȫʿ"
	
	tabBlackList[2]={}
	tabBlackList[2]["exename"]="BaiduSdTray.exe"
	tabBlackList[2]["displayname"]="ٶɱ"
	
	tabBlackList[3]={}
	tabBlackList[3]["exename"]="msseces.exe"
	tabBlackList[3]["displayname"]="MSE"
	
	tabBlackList[4]={}
	tabBlackList[4]["exename"]="kxetray.exe"
	tabBlackList[4]["displayname"]="ɽ"
	
	tabBlackList[5]={}
	tabBlackList[5]["exename"]="avp.exe"
	tabBlackList[5]["displayname"]="˹"
	
	tabBlackList[6]={}
	tabBlackList[6]["exename"]="avguard.exe"
	tabBlackList[6]["displayname"]="Сɡ"
	
	tabBlackList[7]={}
	tabBlackList[7]["exename"]="ekrn.exe"
	tabBlackList[7]["displayname"]="ESET NOD32"
	
	tabBlackList[8]={}
	tabBlackList[8]["exename"]="QQPCTray.exe"
	tabBlackList[8]["displayname"]="QQԹܼ"
	
	tabBlackList[9]={}
	tabBlackList[9]["exename"]="360sd.exe"
	tabBlackList[9]["displayname"]="360ɱ"
	
	tabBlackList[10]={}
	tabBlackList[10]["exename"]="360rp.exe"
	tabBlackList[10]["displayname"]="360ɱʵʱ"
	
	tabBlackList[11]={}
	tabBlackList[11]["exename"]="360Safe.exe"
	tabBlackList[11]["displayname"]="360ȫģ"
	
	local runningTab={}
	local value = GeneralFun.getInfo(3004)	if value == false then return end
	local var = value["runingPrograms"]
	local runingProgramsTab = GeneralFun.stringSplit(var,",")
	local k=0
	for i=1,#runingProgramsTab do
		local program = runingProgramsTab[i]
		for j=1,#tabBlackList do
			repeat
				local blacklistExename = tabBlackList[j]["exename"]
				if string.find(string.lower(program),string.lower(blacklistExename)) ~= nil then
					k=k+1
					runningTab[k] = {}
					runningTab[k]["DisPlayName"]=tabBlackList[j]["displayname"]
					runningTab[k]["DisPlayIcon"]=program
				else
					break
				end
			until true
		end
	end
	
	if #runningTab ~= 0 then
		lua_addResult(p,2)
		lua_addTypeTip(p,2,"⵽ʦװɱҪƿýѧClassManagerɱԷʹ쳣")
		local i=1
		while runningTab[i] do
			local DisPlayName = runningTab[i]["DisPlayName"]
			GeneralFun.writeFile("DisPlayName== "..DisPlayName.." ==")
			if string.find(DisPlayName,"360") ~= nil then --360ɱرClassManagerʦ˵ĿĿ
				lua_SetClassManagerAutoStart(false)
				break
			end
			i = i+1
		end
	else
		lua_addResult(p,1)
	end
	
	lua_afterDetect(p)
end
 
return detection
