
local detection = {}
 
local desc = 'GUEST-TOOL汾'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

function detection.Detect()
	local webip = lua_getWebIP()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	
	local value = GeneralFun.getInfo(3002)	if value == false then return end
	local gtVer = value["version"]	
	
	local value = GeneralFun.getInfo(3005)	if value == false then return end
	local gtVer_package = value["version"]	
	local value = GeneralFun.getInfo(3010)	if value == false then return end
	local ChromeJsVer = value["version"]
	local value = GeneralFun.getInfo(3011)	if value == false then return end
	local GesutToolJsVer = value["version"]
	local value = GeneralFun.getInfo(3004)	if value == false then return end
	local ProcessLit = value["runingPrograms"]
	local processNameTab = GeneralFun.stringSplit(ProcessLit,",")
	local disk = lua_getDIskPath();
	local value = GeneralFun.getInfo(3025)	if value == false then return end
	local Js360Ver = value["version"]
----------------------------------------------------------------------------------	
	local iResult = 0
	if gtVer == "0.0.0.0" then iResult = 1 end	--δװ
	if iResult == 0 and gtVer_package == "0.0.0.0" then iResult = 2 end --δҵװ
	if iResult == 0 and lua_compareVer(gtVer,gtVer_package) ~= 1 then iResult = 3 end --汾ͬ
	local b_geustOK = true
	local root={}
	root["id"] = 2000
	local data={}
	data[1] = {}
	data[1]["DisPlayName"]="GuestTool"
	data[1]["DisPlayIcon"]="bitmap\\caption\\GuestTool.png"
	if iResult == 0 then
		lua_addResult(p,1)
		data[1]["ToolTip"]="success"
	elseif iResult == 1 then
		lua_addResult(p,3)
		lua_addScore(p,-100)
		data[1]["ToolTip"]="δװGuest Toolװλ" .. disk .. "̸Ŀ¼"
		b_geustOK = false
	elseif iResult == 2 then
		lua_addResult(p,3)
		lua_addScore(p,-100)
		data[1]["ToolTip"]="" .. disk .. "δҵRCC_Guest_ToolװȷǷɾ"
	elseif iResult == 3 then		
		lua_addResult(p,3)
		lua_addScore(p,-50)
		data[1]["ToolTip"]="Guest Tool汾ǰӦ汾"
	end

	--guesttool аװ¼ vdagentvdserviceChromeJs
	if not b_geustOK then
		root["data"]=data;
		local jsonStr = cjson.encode(root);
		lua_fireSignal(jsonStr);
		lua_afterDetect(p)
		return
	end
	
	--vdservice
	local iVdService=0
	for i=1,#processNameTab do
		local processName = string.lower(processNameTab[i])
		if string.find(processName,"vdservice.exe") ~= nil then
			iVdService=1
			break
		end
	end
	
	data[2] = {}
	data[2]["DisPlayName"]="vdservice"
	data[2]["DisPlayIcon"]="bitmap\\caption\\vdservice.png"
	if iVdService == 0 then
		lua_addResult(p,3)
		lua_addScore(p,-40)
		data[2]["ToolTip"]="Guest Tool쳣vdservice°װGuest Tool޷пܾжµľԻϵݼ֧"
	elseif iVdService == 1 then
		lua_addResult(p,1)
		data[2]["ToolTip"]="success"
	end

	--vdagent
	local iVdagent=0
	for i=1,#processNameTab do
		local processName = string.lower(processNameTab[i])
		if string.find(processName,"vdagent.exe") ~= nil then
			iVdagent=1
			break
		end
	end
	
	data[3] = {}
	data[3]["DisPlayName"]="vdagent"
	data[3]["DisPlayIcon"]="bitmap\\caption\\vdagent.png"
	if iVdagent == 0 then
		lua_addResult(p,3)
		lua_addScore(p,-40)
		data[3]["ToolTip"]="Guest Tool쳣vdagent°װGuest Tool޷пܾжµľԻϵݼ֧"
	elseif iVdagent == 1 then
		lua_addResult(p,1)
		data[3]["ToolTip"]="success"
	end
	
	--Chrome
	local b_chromebrowserOK = false
	local b_360browserOK = false
	local value = GeneralFun.getInfo(3012)	if value == false then return end
	local bHaveInstall = value["bHaveInstall"]
	if	bHaveInstall == "1" then
		local InstallProgramsTab = value["installProgram"]
		local i=1
		while InstallProgramsTab[i] do
			local displayname = InstallProgramsTab[i]["displayName"]
			if string.find(displayname,"Google Chrome") ~= nil then
				b_chromebrowserOK = true
			end
			if string.find(displayname,"360ȫ") ~= nil then
				b_360browserOK = true
			end
			i = i+1
		end
	end
	local i=1
	while processNameTab[i] do
		local program = string.lower(processNameTab[i])
		if string.find(program,"chrome.exe") ~= nil then
			b_chromebrowserOK = true
		end
		if string.find(program,"360se.exe") ~= nil then
			b_360browserOK = true
		end
		i = i+1
	end
	
	
	
	--ChromeJs
	if b_chromebrowserOK then
		local iResult = 0
		if ChromeJsVer == "0.0.0.0" then iResult = 1 end 	--δװ
		if iResult == 0 and GesutToolJsVer == "0.0.0.0" then iResult = 2 end --δҵװ
		if iResult == 0 and lua_compareVer(ChromeJsVer,GesutToolJsVer) ~= 1 then iResult = 3 end --汾ͬ
		data[4] = {}
		data[4]["DisPlayName"]="chromeJs"
		data[4]["DisPlayIcon"]="bitmap\\caption\\chromejs.png"
		if iResult == 0 then
			lua_addResult(p,1)
			data[4]["ToolTip"]="success"
		elseif iResult == 1 then		
			lua_addResult(p,3)
			lua_addScore(p,-10)
			data[4]["ToolTip"] = "ƵŻδװֶװChromeƵŻ"
		elseif iResult == 2 then		
			lua_addResult(p,3)
			lua_addScore(p,-10)
			data[4]["ToolTip"] = "Guest Tool쳣δchrome༭,".. disk .."°װGuest Tool޷пܾжµľԻϵݼ֧"
		elseif iResult == 3 then		
			lua_addResult(p,3)
			lua_addScore(p,-10)
			data[4]["ToolTip"] = "ChromeƵŻ"
		end	
	end
	----360Js
	if b_360browserOK then
		local iResult = 0
		if Js360Ver == "0.0.0.0" then iResult = 1 end 	--δװ
		if iResult == 0 and GesutToolJsVer == "0.0.0.0" then iResult = 2 end --δҵװ
		if iResult == 0 and lua_compareVer(Js360Ver,GesutToolJsVer) ~= 1 then iResult = 3 end --汾ͬ
		data[5] = {}
		data[5]["DisPlayName"]="360Js"
		data[5]["DisPlayIcon"]="bitmap\\caption\\chromejs.png"
		if iResult == 0 then
			lua_addResult(p,1)
			data[5]["ToolTip"]="success"
		elseif iResult == 1 then		
			lua_addResult(p,3)
			lua_addScore(p,-10)
			data[5]["ToolTip"] = "ƵŻδװֶװ360ƵŻ"
		elseif iResult == 2 then		
			lua_addResult(p,3)
			lua_addScore(p,-10)
			data[5]["ToolTip"] = "Guest Tool쳣δ360༭".. disk .."°װGuest Tool޷пܾжµľԻϵݼ֧"
		elseif iResult == 3 then		
			lua_addResult(p,3)
			lua_addScore(p,-10)
			data[5]["ToolTip"] = "360ƵŻ"
		end
	end
-------------------------------------------------------------------------------
	root["data"]=data;
	local jsonStr = cjson.encode(root);
	lua_fireSignal(jsonStr);
	lua_afterDetect(p)
end
 
return detection