
local detection = {}
 
local desc = 'RCDѵ𳡾'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')
local _slaveHost = ''

-- ӻǧ
function detection16_checkLink(p,slaveHost)	
	local webip = GeneralFun.getwebip()
	
	local ips = GeneralFun.stringSplit(slaveHost,"#")
	local value9 = GeneralFun.getInfo(0,'{"Request":9,"IPs":"'..slaveHost..'"}')	if value9 == false then return false end
	for i=1,#ips do
		local ip = ips[i]	
		 
		--RCDlinkΪǧ׻δӣ - 10  ʾ5	
		local eth0 = string.lower(value9[ip]["eth0"])
		local eth1 = string.lower(value9[ip]["eth1"])
		-- state 0-ok 1- 2-ǧ
		local state_eth0 = 0
		local state_eth1 = 0
		if eth0 == "na" then
			state_eth0 = 1
		elseif eth0 == "1000mb/s" then
			state_eth0 = 0
		else
			state_eth0 = 2
		end
		if eth1 == "na" then
			state_eth1 = 1
		elseif eth1 == "1000mb/s" then
			state_eth1 = 0
		else
			state_eth1 = 2
		end
		
		if state_eth0 == 0 and state_eth1 == 0 then
			lua_addResult(p,1)
		else
			-- δ
			local tip1 = ''
			if state_eth0 == 1 then
				tip1 = "1"
			end
			if state_eth1 == 1 then
				if string.len(tip1) ~= 0 then
					tip1 = tip1 .. ""
				end
				tip1 = tip1 .. "2"
			end
			-- һδӣȷ״̬
			if string.len(tip1) ~= 0 then
				lua_addResult(p,3)
				lua_addScore(p,-10)
				lua_addTypeTip(p,3,""..ip..tip1.."δӣȷ״̬-10")
			end		
			
			-- ǧ
			local tip2 = ''
			if state_eth0 == 2 then
				tip2 = "1"			
			end
			if state_eth1 == 2 then
				if string.len(tip2) ~= 0 then
					tip2 = tip2 .. ""
				end
				tip2 = tip2 .. "2"
			end
			-- ڶǧף뽻ǷΪǧЭģʽ
			if string.len(tip2) ~= 0 then
				lua_addResult(p,3)
				lua_addScore(p,-10)
				lua_addTypeTip(p,3,""..ip..""..tip2.."ǧף뽻ǷΪǧЭģʽ-10")
			end		
		end
		
	end
	
	return true
end

-- 9. ipͻ
function detection16_checkConflict(p,slaveHost)
	local webip = GeneralFun.getwebip()
	
	local ips = GeneralFun.stringSplit(slaveHost,"#")
	local value3 = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..slaveHost..'"}')	if value3 == false then return false end
	local value10 = GeneralFun.getInfo(0,'{"Request":10,"IPs":"'..slaveHost..'"}')	if value10 == false then return false end
	for i=1,#ips do
		local ip = ips[i]	
		local netcardMode = string.lower(value3[ip]["netcardMode"])
		local bBond = netcardMode == "bond"
		
		--⵽RCDڳIPͻ -10  ʾ6
		local ip1 = value10[ip]["ip"]
		local ip2 = value10[ip]["ip2"]
		local conflict_ip = ''
		if ip1 ~= "no" then
			conflict_ip = "1"
		end
		if not (bBond or ip2 == "no") then
			if string.len(conflict_ip) == 0 then
				conflict_ip = "2"
			else
				conflict_ip = "ڶ"
			end
		end
		
		if string.len(conflict_ip) == 0 then
			lua_addResult(p,1)		
		else
			lua_addResult(p,3)
			lua_addScore(p,-10)
			lua_addTypeTip(p,3,""..ip..""..conflict_ip.."ַͻȷַ-10")
		end			
	end	
	return true
end

-- 8. ÿռ
function detection16_checkSpace(p,slaveHost)
	local webip = GeneralFun.getwebip()
	
	local ips = GeneralFun.stringSplit(slaveHost,"#")
	local value20 = GeneralFun.getInfo(0,'{"Request":20,"IPs":"'..slaveHost..'"}')	if value20 == false then return false end
	local value21 = GeneralFun.getInfo(0,'{"Request":21,"IPs":"'..slaveHost..'"}')	if value21 == false then return false end
	local value22 = GeneralFun.getInfo(0,'{"Request":22,"IPs":"'..slaveHost..'"}')	if value22 == false then return false end
	local value23 = GeneralFun.getInfo(0,'{"Request":23,"IPs":"'..slaveHost..'"}')	if value23 == false then return false end
	local error_20_ip = ''		-- ǷǷ洢ģʽȷɾõĲļ (5)
	local error_21_ip = ''		-- γ̾ռӽޣǷҪݲɾÿγ̾ (3)
	local warning_21_ip = ''	-- γ̾ռӽޣǷҪݲɾÿγ̾ (0)
	local error_22_ip = ''		--Ӳ̿ռӽޣʦĿ¼/ѧĿ¼ɾļ (5)
	local error_23_ip = ''		--Ŀ¼СӽޣɾĿ¼ļ(5)
	for i=1,#ips do
		local ip = ips[i]
		-- ǷǷ洢ģʽȷɾõĲļ.
		local per = ''
		local percent = value20[ip]["percent"]
		local totalSize = value20[ip]["totalSize"]
		if string.len(totalSize) == 0 or string.len(percent) == 0 then
			GeneralFun.failedDection(3,"20")
			return
		else
			per = tonumber(string.sub(percent,0,string.len(percent)-1))
			if per > 95 then
				if string.len(error_20_ip) ~= 0 then
					error_20_ip = error_20_ip .. ""
				end
				error_20_ip = error_20_ip .. ip			
			end
		end
		
		-- γ̾ռӽޣǷҪݲɾÿγ̾ 
		percent = value21[ip]["percent"]
		per = tonumber(string.sub(percent,0,string.len(percent)-1))
		if per > 98 then
			if string.len(error_21_ip) ~= 0 then
				error_21_ip = error_21_ip .. ""
			end
			error_21_ip = error_21_ip .. ip
		elseif per > 90 then
			if string.len(warning_21_ip) ~= 0 then
				warning_21_ip = warning_21_ip .. ""
			end
			warning_21_ip = warning_21_ip .. ip
		end
		--Ӳ̿ռӽޣʦĿ¼/ѧĿ¼ɾļ
		percent = value22[ip]["percent"]
		per = tonumber(string.sub(percent,0,string.len(percent)-1))
		if per > 90 then
			if string.len(error_22_ip) ~= 0 then
				error_22_ip = error_22_ip .. ""
			end
			error_22_ip = error_22_ip .. ip
		end
		--Ŀ¼СӽޣɾĿ¼ļ
		percent = value23[ip]["percent"]
		per = tonumber(string.sub(percent,0,string.len(percent)-1))
		if per > 83 then
			if string.len(error_23_ip) ~= 0 then
				error_23_ip = error_23_ip .. ""
			end
			error_23_ip = error_23_ip .. ip
		end
	end	
	
	if string.len(error_20_ip) == 0 then
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,"CACHEﵽޣǷо洢ģʽȷɾõĴ洢ݡдıIP"..error_20_ip .. "-5")
	end
	
	if string.len(error_21_ip) == 0 then
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-3)
		lua_addTypeTip(p,3,"γ̾ռӽޣǷҪݲɾÿγ̾дıIP"..error_21_ip .. "-3")
	end
	
	if string.len(warning_21_ip) == 0 then
		lua_addResult(p,1)
	else
		lua_addResult(p,2)
		lua_addTypeTip(p,2,"γ̾ռӽޣǷҪݲɾÿγ̾дıIP"..warning_21_ip)
	end
		
	if string.len(error_22_ip) == 0 then
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,"Ӳ̿ռӽޣʦĿ¼/ѧĿ¼ɾļдıIP"..error_22_ip .. "-5")
	end
		
	if string.len(error_23_ip) == 0 then
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-5)
		lua_addTypeTip(p,3,"Ŀ¼СӽޣɾĿ¼ļдıIP"..error_23_ip .. "-5")
	end	
	
	return true
end

function detection16_getSlaveHost()
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')	if value == false then return end
	local rcd_osver = value[webip]["version"]
	local result = lua_compareVer(rcd_osver,"2.1")
	
	local value = GeneralFun.getInfo(0,'{"Request":24,"IPs":"'..webip..'"}')		if value == false then return end
	local slaveHost = value[webip]["slaveHost"]
	local needIP = ''
	
	if result == 3 or result == 4 then --2.0汾
		for i=1,#slaveHost do
			local tmpIP = slaveHost[i]["ip"]		
			local bConnect = lua_getConnectState(tmpIP)
			if not bConnect then
				return false
			end
			if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
			needIP = needIP .. tmpIP
		end
	else -- 2.1汾
		local value = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..webip..'"}')	if value == false then return end
		local localMode = value[webip]["localMode"]
		if localMode == "1" or localMode == "3" then
			for i=1,#slaveHost do
				local tmpIP = slaveHost[i]["wanIp"]		
				local bConnect = lua_getConnectState(tmpIP)
				if not bConnect then
					return false
				end
				if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
				needIP = needIP .. tmpIP
			end
		else
			for i=1,#slaveHost do
				local tmpIP = slaveHost[i]["ip"]		
				local bConnect = lua_getConnectState(tmpIP)
				if not bConnect then
					return false
				end
				if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
				needIP = needIP .. tmpIP
			end
		end
	end
	_slaveHost = needIP
	return true
end

function detection16_checkBios(p,slaveHost)
	local value66 = GeneralFun.getInfo(0,'{"Request":66,"IPs":"'..slaveHost..'"}')	if value == false then return end
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..slaveHost..'"}')	if value == false then return end
	local rcd_osver = value[slaveHost]["version"]
	local mainOsver = string.sub(rcd_osver,0,3)
	local dmidecode_version = value66[slaveHost]["dmidecode_version"]
	if tonumber(value66[slaveHost]["bios_version"]) >= 3.0 and mainOsver == "2.1" and tonumber(dmidecode_version) < 3.0 then
		return true
	else
		return false
	end
end
function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	
	local b_getSalveHost_ok = detection16_getSlaveHost()
	if not b_getSalveHost_ok then 
		lua_addTypeTip(p,3,"޷ӻͨѶȷϴӻ˿IPǷ-10")
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_afterDetect(p)
		return
	end
	
	GeneralFun.writeFile("slaveHost:<".._slaveHost..">")
	
	if string.len(_slaveHost) == 0 then -- ޴ӻƳ
		lua_removeDetection(p)
		--lua_afterDetect(p)
		return
	end
	
	-- ftpĿ¼Ȩ޸Ϊ777
	local value = GeneralFun.getInfo(0,'{"Request":50,"IPs":"'.._slaveHost..'"}')	if value == false then return end
	-- ޸/home/userĿ¼ϵͳ
	local value = GeneralFun.getInfo(0,'{"Request":51,"IPs":"'.._slaveHost..'"}')	if value == false then return end

	--1޷PINGͨӻǶ̨ӻκһڣ - 10 ʾ޷ӻͨѶȷϴӻ˿IPǷ
	--PINGͨӻǷͨ	// ޸ΪȡǷna    9.	RCDǷlinkΪǧ	
	local bRunOK = detection16_checkLink(p,_slaveHost)
	if not bRunOK then
		return
	end
	
	--2дӻȡӻ汾Ϣذ汾Ϣһ£-20 ʾѵ汾һ£ȷ汾
	local request_ips = _slaveHost..'#'..webip
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..request_ips..'"}')	if value == false then return end
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local lastVer = ''
	local bOK = true
	for i=1,#ips do
		local tmpIP = ips[i]
		local tmpObj = value[tmpIP]
		local tmpVer = tmpObj["version"]
		if string.len(lastVer) ~= 0 and lastVer ~= tmpVer then
			bOK = false
			break
		end
		lastVer = tmpVer
	end
	
	if not bOK then
		lua_addTypeTip(p,3,"ѵ汾һ£ȷ汾һ£-20")
		lua_addResult(p,3)
		lua_addScore(p,-20)
	else
		lua_addResult(p,1)		
	end
	
	-- new УرػɫǷȷǰɫΪزŽоͬ
	local value33 = GeneralFun.getInfo(0,'{"Request":33,"IPs":"'..request_ips..'"}')	if value33 == false then return end
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local error_role_ip1 = ''	--	ӦΪصģôip
	local error_role_ip2 = ''	--	ӦΪصģôip
	for i=1,#ips do
		local tmpIP = ips[i]
		local tmpObj = value33[tmpIP]
		local tmpRole = tmpObj["role"]
		if tmpIP == webip then
			if tmpRole ~= "0" then
				-- ǰɫδΪأȷǷô
				error_role_ip1 = tmpIP
			end
		else
			if tmpRole == "0" then
				-- ǰɫδΪأȷǷô
				if string.len(error_role_ip2) > 0 then
					error_role_ip2 = error_role_ip2 .. "\\"
				end
				error_role_ip2 = error_role_ip2 .. tmpIP
			end
		end
	end
	local errorTip = ''
	if string.len(error_role_ip1) > 0 then
		errorTip = 'ǰɫδΪ'
	end
	if string.len(error_role_ip2) > 0 then
		if string.len(errorTip) > 0 then
			errorTip = errorTip .. ""
		end
		errorTip = errorTip .. "ӻIP" .. error_role_ip2 .. 'ɫδΪ""'
	end
	if string.len(errorTip) > 0 then
		errorTip = errorTip .. '"ϵͳ"->""޸ĸ'
		lua_addTypeTip(p,3,errorTip .. "-10")
		lua_addResult(p,3)
		lua_addScore(p,-10)
	else
		lua_addResult(p,1)	
	end
	-- ǰɫδΪأоͬ
	if string.len(error_role_ip1) == 0 then		
		-- 4Уӻγ̾Ŀ¼baseļСǷһ£һ£-10֣ʾδͬÿγ̾
		local value = GeneralFun.getInfo(0,'{"Request":28,"IPs":"'..request_ips..'"}')	if value == false then return end --ȡأؾ
		local ips = GeneralFun.stringSplit(_slaveHost,"#")
		local value48 = GeneralFun.getInfo(0,'{"Request":48,"IPs":"'..webip..'"}')	if value48 == false then return end -- ȡؾ״̬
		
		local Baseobj48 = value48[webip] --õbase
		local base_obj = value[webip] --صbase
		
		local activeBaseobj = {} --ڴõbaseϢ
		for k1,v1 in pairs(base_obj) do
			for k2,v2 in pairs(Baseobj48) do
				if k2 == k1 then
					activeBaseobj[k1] = v1
				end
			end
		end
		
		local error_info = {}
		for k,v in pairs(activeBaseobj) do
			for i=1,#ips do
				local tmpIP = ips[i]
				local tmpObj = value[tmpIP]
				if tmpObj ~= nil then
					local tmpSize = tmpObj[k]
					if v ~= tmpSize then
						if error_info[tmpIP] == nil then
							error_info[tmpIP] = '"'..k
						else
							error_info[tmpIP] = error_info[tmpIP] .. '","' .. k
						end
					end
				else
					if error_info[tmpIP] == nil then
						error_info[tmpIP] = '"'..k
					else
						error_info[tmpIP] = error_info[tmpIP] .. '","' .. k
					end
				end
				
			end
		end		
		
		local tip1 = ''
		local tip2 = ''
		for error_ip,error_name in pairs(error_info) do
			if string.len(tip1) == 0 then
				tip1 = 'ӻIP'
			else
				tip1 = tip1 .. "\\"
			end
			tip1 = tip1 .. error_ip
			
			if string.len(tip2) ~= 0 then
				tip2 = tip2 .. ";"
			end
			tip2 = tip2 .. "ӻIP" .. error_ip .. "" .. error_name .. '"'
		end
		
		if string.len(tip1) ~= 0 then
			tip1 = tip1 .. "γ̾δͬͬ(챨)"
			tip2 = tip2 .. "γ̾δͬͬ-5"
			lua_addTypeTip(p,3,tip1,tip2)
			lua_addResult(p,3)
			lua_addScore(p,-5)
		else
			lua_addResult(p,1)	
		end
	end	
	
	--	5УӻĿ¼.macinfo.iniļСǷһ£һ£ - 10֣ʾͬĿ¼
	local value = GeneralFun.getInfo(0,'{"Request":27,"IPs":"'..webip..'"}')	if value == false then return end
	local szShare = string.lower(cjson.encode(value[webip]))
	if string.find(szShare,"yes") ~= nil then
		lua_addResult(p,1)	
	elseif string.find(szShare,"no") ~= nil then
		lua_addTypeTip(p,3,"Ŀ¼δͬҳĿγ̾еͬĿ¼-5")
		lua_addResult(p,3)
		lua_addScore(p,-5)
	else
		GeneralFun.failedDection(3,"27")
		return
	end
	
	-- 6УӻǷ桢DHCPã - 10֣
	local value1 = GeneralFun.getInfo(0,'{"Request":1,"IPs":"'.._slaveHost..'"}')	if value1 == false then return end
	local value15 = GeneralFun.getInfo(0,'{"Request":15,"IPs":"'.._slaveHost..'"}')	if value15 == false then return end
	local value16 = GeneralFun.getInfo(0,'{"Request":16,"IPs":"'.._slaveHost..'"}')	if value16 == false then return end
	local errorContent = ''
	local errorIP = ''
	local repairIp = ''
	local ips = GeneralFun.stringSplit(_slaveHost,"#")
	local bOK = true
	local bdhcpOK = true
	for i=1,#ips do
		local tmpIP = ips[i]
		-- Ϣ
		if value1[tmpIP]["vmAmount"] ~= "0" then
			bOK = false
			bdhcpOK = false
			if string.find(errorIP.."",tmpIP.."") == nil then
				if string.len(errorIP) ~= 0 then
					errorIP = errorIP .. ""
					repairIp = repairIp .. "#"
				end
				errorIP = errorIP .. tmpIP
				repairIp = repairIp .. tmpIP
			end
			if string.find(errorContent,"Ϣ") == nil then
				if string.len(errorContent) ~= 0 then
					errorContent = errorContent..""
				end
				errorContent = errorContent .. "Ϣ"
			end
		end
		-- DHCP
		if string.lower(value15[tmpIP]["dhcpStatus"]) == "on" then
			bOK = false
			bdhcpOK = false
			if string.find(errorIP.."",tmpIP.."") == nil then
				if string.len(errorIP) ~= 0 then
					errorIP = errorIP .. ""
					repairIp = repairIp .. "#"
				end
				errorIP = errorIP .. tmpIP
				repairIp = repairIp .. tmpIP
			end
			if string.find(errorContent,"DHCP") == nil then
				if string.len(errorContent) ~= 0 then
					errorContent = errorContent..""
				end
				errorContent = errorContent .. "DHCP"				
			end
		end
		-- ַ
		if string.lower(value16[tmpIP]["pxeStatus"]) == "on" then
			bOK = false
			if string.find(errorIP.."",tmpIP.."") == nil then
				if string.len(errorIP) ~= 0 then
					errorIP = errorIP .. ""
					repairIp = repairIp .. "#"
				end
				errorIP = errorIP .. tmpIP
				repairIp = repairIp .. tmpIP
			end
			if string.find(errorContent,"ַ") == nil then
				if string.len(errorContent) ~= 0 then
					errorContent = errorContent..""
				end
				errorContent = errorContent .. "ַ"				
			end
		end
	end
	
	if not bdhcpOK then
		local value33 = GeneralFun.getInfo(0,'{"Request":33,"IPs":"'..repairIp..'"}')	if value33 == false then return end
		local ips = GeneralFun.stringSplit(repairIp,"#")
		local validRepairIp = ''
		for i=1,#ips do
			local tmpIP = ips[i]
			local tmpObj = value33[tmpIP]
			local tmpRole = tmpObj["role"]
			if tmpRole ~= "0" then --
				if string.len(validRepairIp) ~= 0 then
					validRepairIp = validRepairIp .. "#"
				end
				validRepairIp = validRepairIp .. tmpIP
			end
		end
		if string.len(validRepairIp) ~= 0 then
			lua_addRepair(p,GeneralFun.getInfoDesc(506),"506",validRepairIp) --ֻ޸
		end
	end
	
	if not bOK then
		lua_addTypeTip(p,3,""..errorIP.."жãرջɾӻ"..errorContent .. "-5")
		lua_addResult(p,3)
		lua_addScore(p,-5)
	else
		lua_addResult(p,1)	
	end
	
	-- 7ӻͻϢһУ飨ͻͻ𡢽ңһ£òһ£ - 3  ʾȷϿͻϢһ	
	local request_ips = _slaveHost.."#"..webip
	local value = GeneralFun.getInfo(0,'{"Request":11,"IPs":"'..request_ips..'"}')	if value == false then return end
	
	
	
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local lastInfo = ''
	local bOK = true
	for i=1,#ips do
		local tmpIP = ips[i]
		local tmpObj = value[tmpIP]
		local info = tmpObj["name"] .. tmpObj["customer_type"] .. tmpObj["classroom"]
		if string.len(lastInfo)~=0 and lastInfo~=info then
			bOK = false
			break
		end
		lastInfo = info
	end
	
	--[[
	if not bOK then
		lua_addTypeTip(p,3,"ȷϿͻϢһ -10")
		lua_addResult(p,3)
		lua_addScore(p,-10)
	else
		lua_addResult(p,1)	
	end
	]]
	
	
	GeneralFun.writeFile("_slaveHost:".._slaveHost)
	-- 8 ÿռ
	bRunOK = detection16_checkSpace(p,_slaveHost)
	if not bRunOK then
		return
	end
	
	-- 9. ipͻ
	bRunOK = detection16_checkConflict(p,_slaveHost)
	if not bRunOK then
		return
	end
	
	--10.bios 汾
	local b_biosOk = detection16_checkBios(p,_slaveHost)
	if not bRunOK then
		GeneralFun.getAysnInfo(0,'{"Request":67,"IPs":"'.._slaveHost..'"}')
		lua_SetRepairCode(_slaveHost,"67")
		local tip = "޸bios쳣Ժ󡭡"
		lua_addResult(p,3)
		lua_addScore(p,-100)
		lua_addTypeTip(p,3,tip)
		lua_afterDetect(p)
		GeneralFun.StopDetect(2,tip)
		lua_alert(tip)
		return
	else
		lua_addResult(p,1)
	end
	lua_afterDetect(p)	
end
 
return detection