
local detection = {}
 
local desc = 'ϵͳʱ'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

local _slaveHost = ''
function detection16_getSlaveHost()
	local webip = GeneralFun.getwebip()
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')	if value == false then return end
	local rcd_osver = value[webip]["version"]
	local result = lua_compareVer(rcd_osver,"2.1")
	
	local value = GeneralFun.getInfo(0,'{"Request":24,"IPs":"'..webip..'"}')		if value == false then return end
	local slaveHost = value[webip]["slaveHost"]
	local needIP = ''
	
	if result == 3 or result == 4 then --2.0汾
		for i=1,#slaveHost do
			local tmpIP = slaveHost[i]["ip"]		
			local bConnect = lua_getConnectState(tmpIP)
			if not bConnect then
				return false
			end
			if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
			needIP = needIP .. tmpIP
		end
	else -- 2.1汾
		local value = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..webip..'"}')	if value == false then return end
		local localMode = value[webip]["localMode"]
		if localMode == "1" or localMode == "3" then
			for i=1,#slaveHost do
				local tmpIP = slaveHost[i]["wanIp"]		
				local bConnect = lua_getConnectState(tmpIP)
				if not bConnect then
					return false
				end
				if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
				needIP = needIP .. tmpIP
			end
		else
			for i=1,#slaveHost do
				local tmpIP = slaveHost[i]["ip"]		
				local bConnect = lua_getConnectState(tmpIP)
				if not bConnect then
					return false
				end
				if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
				needIP = needIP .. tmpIP
			end
		end
	end
	_slaveHost = needIP
	return true
end

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	 
	local value = GeneralFun.getInfo(0,'{"Request":32,"IPs":"'..webip..'"}')	if value == false then return end
	local bSet = string.lower(value[webip]["rebootSchedule"]) == "yes"	
	
	local value = GeneralFun.getInfo(0,'{"Request":19,"IPs":"'..webip..'"}')	if value == false then return end
	local runTime = value[webip]["runTime"]		
	runTime = string.sub(runTime,1,string.len(runTime)-1)
	local m = tonumber(runTime)

	detection16_getSlaveHost()
	
	local request_ips = ''
	if string.len(_slaveHost) ~= 0 then
		request_ips = _slaveHost .. '#' ..webip
	else
		request_ips = webip
	end
	
	if bSet ~= true and m>24*60 then
		lua_addResult(p,3)
		lua_addScore(p,-3)
		lua_addRepair(p,GeneralFun.getInfoDesc(505),"505",request_ips)
		lua_addTypeTip(p,3,"ʱУҳ->ά->ʱ ʱ񣬷-3")
	else
		lua_addResult(p,1)
	end
	
	lua_afterDetect(p)
end
 
return detection