
local detection = {}
 
local desc = 'CM-BOXü'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	
	local maskTable = {}
	local value = GeneralFun.getInfo(0,'{"Request":13,"IPs":"'..webip..'"}')	if value == false then return end
	local boxSize = #value[webip]
	local macs = ''	
	 
	if boxSize == 0 then
		lua_addTypeTip(p,2,"δ棬")
		lua_addResult(p,2)
		lua_afterDetect(p)
	else
		local bRelation = false		
		for i=1,boxSize do
			local tmIp = value[webip][i]["tmIp"]
			local tmMask = value[webip][i]["tmMask"]
			if string.len(tmIp) ~= 0 and string.len(tmMask) ~= 0 then
				maskTable[tmIp] = tmMask
			end
			if string.len(macs) > 0 then macs = macs .. ',' end
			macs = macs .. value[webip][i]['tmMac']
			if string.len(value[webip][i]['tmIp']) ~= 0 then bRelation = true end
		end			
		
		if not bRelation then 
			lua_addTypeTip(p,2,"ƿδκնˣȷƿò")
			lua_addResult(p,2)
			lua_afterDetect(p)
			return
		end			
	end	
	
	local value = GeneralFun.getInfo(0,'{"Request":4,"IPs":"'..webip..'"}')		if value == false then return end
	local wanIP = value[webip]["ip"]
	
	local value = GeneralFun.getInfo(0,'{"Request":5,"IPs":"'..webip..'"}')	if value == false then return end
	local p1 = value[webip]["ip"]		
	local pos = string.len(p1)
	while(pos > 0)
	do
		local tmpIP = string.sub(p1,pos,pos)	
		if tmpIP == "." then
			break
		end
		pos = pos - 1
	end
	local p1_head = string.sub(p1,1,pos)
	GeneralFun.writeFile("p1_head:"..p1_head)
	
	local p2 = value[webip]["ip2"]
	local netmask = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(3007)	if value == false then return end
	local localips = ''
	local boxSize = #value["netinfo"]
	for i=1,boxSize do
		local localip = value["netinfo"][i]["ip"]
		localips = localips .. "" .. localip
	end
	
	
	local value = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..webip..'"}')	if value == false then return end
	local localMode = value[webip]["localMode"]
	local deployMode = string.lower( value[webip]["deployMode"])
	local value = GeneralFun.getInfo(0,'{"Request":17,"IPs":"'..webip..'"}')	if value == false then return end
	local teacherIp = value[webip]["teacherIp"]
	local value = GeneralFun.getInfo(1001,macs)	if value == false then return end
	local box_count = value["box_count"]		
	
	local bDetection1False = false
	if deployMode == "normal" then
		if localMode == "1" or localMode == "3" then
			if string.find(localips.."",teacherIp.."") == nil then
				bDetection1False = true
			end
		end
	end	
	if box_count == 0 then
		lua_addTypeTip(p,2,"δɨ赽CM_BOXˣȷնǷ񿪻նϵͳ汾ȷ")
		lua_addResult(p,2)
		
		if bDetection1False then	
			lua_addTypeTip(p,3,"粿ģʽҪ칤ڽʦϼ⣬-10")
			lua_addResult(p,3)
			lua_addScore(p,-10)
			lua_afterDetect(p)
			return
		end 
	else
		local bSEqual = true
		local bSEqual_ip = ""
		local bSEqual_warning = false
		local bSEqual_warning_ip = ""
		local bTEqual = true
		local boxSize = #value["box_set"]
		for i=1,boxSize do
			local box_serverIP = value["box_set"][i]['serverIP']
			local box_tearcherIP = value["box_set"][i]['teacherIP']
			local box_ip = value["box_set"][i]["StuIP"]
			local box_mask = maskTable[box_ip]
			if box_mask == nil then
				box_mask = ""
			end
			if box_serverIP ~= p1 then -- and box_serverIP ~= wanIP 
				if box_serverIP ~= wanIP then
					bSEqual = false
					if string.find(bSEqual_ip.."",box_serverIP.."") == nil then
						if string.len(bSEqual_ip)~=0 then
							bSEqual_ip = bSEqual_ip..""
						end
						bSEqual_ip = bSEqual_ip .. box_serverIP
					end
				else
					bSEqual_warning = true
					if string.find(bSEqual_warning_ip.."",box_serverIP.."") == nil then
						if string.len(bSEqual_warning_ip)~=0 then
							bSEqual_warning_ip = bSEqual_warning_ip..""
						end
						bSEqual_warning_ip = bSEqual_warning_ip .. box_serverIP						
					end
				end
			end
			
			GeneralFun.writeFile("box_tearcherIP:"..box_tearcherIP.." p1_head:"..p1_head.." localips:"..localips)
			if string.len(box_mask) > 0 then	
				if box_tearcherIP ~= "0.0.0.0" then
					if not lua_isSameSubnet(box_tearcherIP,p1,box_mask,netmask) then
						bTEqual = false
					end
					if localMode == "0" then
						if box_tearcherIP ~= teacherIp then
							bTEqual = false	
						end
					else					
						if string.find(localips.."",box_tearcherIP.."") == nil then
							bTEqual = false	
						end
					end
				end	
			end				
		end
		
		if not bSEqual then		
			local tmpTip = "CMѧõIPʹclassmannagerͳһն˵ַΪRCDһIP"
			lua_addTypeTip(p,3,tmpTip.."(챨)",tmpTip..";server ip:"..bSEqual_ip .. "-5")
			lua_addResult(p,3)
			lua_addScore(p,-5)
		else
			lua_addResult(p,1)
		end
		
		if bSEqual_warning then
			local tmpTip = "粿ģʽ£նõַΪһIP"
			lua_addTypeTip(p,2,tmpTip.."(챨)",tmpTip..";server ip:"..bSEqual_warning_ip)
			lua_addResult(p,2)
		else
			lua_addResult(p,1)
		end
		
		if bDetection1False then	
			lua_addTypeTip(p,3,"粿ģʽҪ칤ڽʦϼ⣬-10")
			lua_addResult(p,3)
			lua_addScore(p,-10)
			lua_afterDetect(p)
			return
		end
		
		--ϵͳ汾2.1ϵĸ
		local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')	if value == false then return end
		local rcd_osver = value[webip]["version"]
		local result = lua_compareVer(rcd_osver,"2.1")
		if result == 3 or result == 4 then
			if not bTEqual then
				local tip = 'նõĽʦIP󣬽ʦΪ˫IPڶIPһIPͬ'
				if localMode == "0" then
					tip = 'նõĽʦIPΪ' .. teacherIp
				else
					-- ip1ͬεıip
					-- p1 netmask
					
					local value = GeneralFun.getInfo(3007)	if value == false then return end					
					local boxSize = #value["netinfo"]
					for i=1,boxSize do
						local localip = value["netinfo"][i]["ip"]
						if lua_isSameSubnet(localip,p1,value["netinfo"][i]["mask"],netmask) then
							tip = 'նõĽʦIPΪ' .. localip
							break
						end
					end
				end
			
				lua_addTypeTip(p,3,tip .. "-5")
				lua_addResult(p,3)
				lua_addScore(p,-5)
			else
				lua_addResult(p,1)
			end
		end
		
	end
	
	lua_afterDetect(p)
	
end
 
return detection