
local detection = {}

local desc = '״̬'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
		
	local _slaveHost = GeneralFun.oa_get_SlaveHost()
	local request_ips = webip
	if string.len(_slaveHost) ~= 0 then
		request_ips = _slaveHost..'#'..webip
	end
	
	-- 2.1Ⱥ¼ҵ˿״̬ǷΪ״̬δӣ̨ĸ˿δӣ-5֣ʾ1
	local value = GeneralFun.getInfo(0,'{"Request":9,"IPs":"'..request_ips..'"}')	if value == false then return end
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local noConnectTip = ''
	for i=1,#ips do
		local tmpIP = ips[i]
		local eth0 = string.lower(value[tmpIP]["eth0"])
		local eth1 = string.lower(value[tmpIP]["eth1"])
		-- state 0-ok 1-˿1 2-˿2
		local state = 0
		if eth0 == "na" then
			state = 1
		elseif eth1 == "na" then
			state = 2
		end
		
		if state ~= 0 then
			if string.len(noConnectTip) ~= 0 then
				noConnectTip = noConnectTip..""
			end
			noConnectTip = noConnectTip .. "IP:"..tmpIP.."˿"..state.."δ"
		end	
	end
	
	
	if string.len(noConnectTip) ~= 0 then
		lua_addTypeTip(p,3,""..noConnectTip.."ҵʹߣڶӦþۺϣ-2")
		lua_addResult(p,3)
		lua_addScore(p,-2)
	else
		lua_addResult(p,1)	
	end
	
	
	-- 2.4ҵǷǧ״̬зǧ׵˿ڣ̨˿Э̷ǧף-10֣ʾ4	
	local value = GeneralFun.getInfo(0,'{"Request":9,"IPs":"'..request_ips..'"}')	if value == false then return end
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local noConnectTip = ''
	local errorPort = {}
	errorPort[1] = "˿1"
	errorPort[2] = "˿2"
	errorPort[3] = "˿ڶ"
	for i=1,#ips do
		local tmpIP = ips[i]
		local eth0 = string.lower(value[tmpIP]["eth0"])
		local eth1 = string.lower(value[tmpIP]["eth1"])
		-- state 0-ok 1-˿1ǧ 2-˿2ǧ 3-˿ڶΪǧ	
		local state = 0
		if eth0 ~= "na" and eth0 ~= "1000mb/s" then
			state = 1
		end
		if eth1 ~= "na" and eth1 ~= "1000mb/s" then
			if state == 1 then
				state = 3
			else
				state = 2
			end
		end
				
		if state ~= 0 then
			if string.len(noConnectTip) ~= 0 then
				noConnectTip = noConnectTip..""
			end
			noConnectTip = noConnectTip .. "IP:"..tmpIP..errorPort[state].."ЭΪǧ"
		end	
	end
	if string.len(noConnectTip) ~= 0 then
		lua_addTypeTip(p,3,""..noConnectTip..",ȷ뽻˿Э״̬-10")
		lua_addResult(p,3)
		lua_addScore(p,-10)
	else
		lua_addResult(p,1)	
	end
	
	local ips = GeneralFun.stringSplit(request_ips,"#")
	if #ips > 1 then --洢 ̨
		local iptab = ''--IP
		local ipjs = '' -- ڵ㼯
		for i=1,#ips do
			local role = GeneralFun.oa_detection_getRole(ips[i])
			if role == 0 or role == 1 then 
				if string.len(iptab) ~= 0 then iptab = iptab .. "#" end
				iptab = iptab .. ips[i]
			elseif role == 2 then 
				if string.len(ipjs) ~= 0 then ipjs = ipjs .. "#" end
				ipjs = ipjs .. ips[i]
			end
		end
		if string.len(iptab) ~= 0 then
			-- 2.6ڵ洢˿״̬˿ڶδӣ̨ĸ洢˿δӣ-20ʾ
			local value = GeneralFun.getInfo(0,'{"Request":1001,"IPs":"'..iptab..'"}')	if value == false then return end
			local ips = GeneralFun.stringSplit(iptab,"#")
			local noConnectTip = ''
			local errorPort = {}
			errorPort[1] = "˿3"
			errorPort[2] = "˿4"
			errorPort[3] = "˿ڶ"
			
			for i=1,#ips do
				local tmpIP = ips[i]
				local eth2 = string.lower(value[tmpIP]["eth2"])
				local eth3 = string.lower(value[tmpIP]["eth3"])
				-- state 0-ok 1-˿2 2-˿3 3-˿ڶ
				local state = 0
				if eth2 ~= "na" and eth3 == "na" then
					state = 2
				elseif eth2 == "na" and eth3 ~= "na" then
					state = 1
				elseif eth2 == "na" and  eth3 == "na" then
					state = 3
				end
				
				if state == 3 then
					if string.len(noConnectTip) ~= 0 then
						noConnectTip = noConnectTip..""
					end
					noConnectTip = noConnectTip .. "IP:"..tmpIP.."洢"..errorPort[state].."δ"
				end	
			end
			
			if string.len(noConnectTip) ~= 0 then
				lua_addTypeTip(p,3,""..noConnectTip..",ȷǷӣ-20")
				lua_addResult(p,3)
				lua_addScore(p,-20)
			else
				lua_addResult(p,1)	
			end
	
			--2.7洢Ƿ״̬з׵˿ڣ̨˿Э̷ף-10֣ʾ7
			local value = GeneralFun.getInfo(0,'{"Request":1001,"IPs":"'..iptab..'"}')	if value == false then return end
			local ips = GeneralFun.stringSplit(iptab,"#")
			local noConnectTip = ''
			for i=1,#ips do
				local tmpIP = ips[i]
				local eth2 = string.lower(value[tmpIP]["eth2"])
				local eth3 = string.lower(value[tmpIP]["eth3"])
				-- state 0-ok 1-˿1 2-˿2 3-˿ڶΪ	
				local state = 0
				if eth2 ~= "na" and eth2 ~= "10000mb/s" then
					state = 1
				end
				if eth3 ~= "na" and eth3 ~= "10000mb/s" then
					if state == 1 then
						state = 3
					else
						state = 2
					end
				end
						
				if state ~= 0 then
					if string.len(noConnectTip) ~= 0 then
						noConnectTip = noConnectTip..""
					end
					noConnectTip = noConnectTip .. "IP:"..tmpIP.."洢"..errorPort[state].."ЭΪ"
				end	
			end
			if string.len(noConnectTip) ~= 0 then
				lua_addTypeTip(p,3,""..noConnectTip..",ȷ뽻˿Э״̬-10")
				lua_addResult(p,3)
				lua_addScore(p,-10)
			else
				lua_addResult(p,1)	
			end
		end
		
		--2.8ڵ洢Ƿǧ״̬зǧ׵˿ڣ̨˿Э̷ǧף-10֣ʾ8
		if string.len(ipjs) ~= 0 then
			local value = GeneralFun.getInfo(0,'{"Request":1001,"IPs":"'..ipjs..'"}')	if value == false then return end
			local ips = GeneralFun.stringSplit(ipjs,"#")
			local noConnectTip = ''
			for i=1,#ips do
				local tmpIP = ips[i]
				local eth2 = string.lower(value[tmpIP]["eth2"])
				local eth3 = string.lower(value[tmpIP]["eth3"])
				-- state 0-ok 1-˿1ǧ 2-˿2ǧ 3-˿ڶΪǧ	
				local state = 0
				if eth2 ~= "na" and eth2 ~= "1000mb/s" then                              
					state = 1
				end
				if eth3 ~= "na" and eth3 ~= "1000mb/s" then
					if state == 1 then
						state = 3
					else
						state = 2
					end
				end
						
				if state ~= 0 then
					if string.len(noConnectTip) ~= 0 then
						noConnectTip = noConnectTip..""
					end
					noConnectTip = noConnectTip .. "IP:"..tmpIP.."ڵ洢"..errorPort[state].."ЭΪǧ"
				end	
			end
			if string.len(noConnectTip) ~= 0 then
				lua_addTypeTip(p,3,""..noConnectTip..",ȷ뽻˿Э״̬-10")
				lua_addResult(p,3)
				lua_addScore(p,-10)
			else
				lua_addResult(p,1)	
			end
		end
	end
	lua_afterDetect(p)
end
 
return detection