
local detection = {}
 
local desc = 'ɱ'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')
local _teaIp = ''
local _crName = ''

-- ȡǰϢ
function detection54_getCurClassroomInfo()
	_teaIp = ''
	_crName = ''
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	
	local value = GeneralFun.getInfo(3007)	if value == false then return false end
	local netinfo = value["netinfo"]	
	local value = GeneralFun.getInfo(0,'{"Request":39,"IPs":"'..webip..'"}')	if value == false then return false end
	local classroomInfo = value[webip]
	for i=1,#netinfo do
		local localip = netinfo[i]["ip"]		
		for j=1,#classroomInfo do
			local teaIp = classroomInfo[j]["teaIp"]
			local crName = classroomInfo[j]["crName"]
			if teaIp == localip and string.len(teaIp) > 0 then
				_teaIp = teaIp
				_crName = crName
				return
			end
		end
	end
	
	return
end
-- ȡɫ 0- 1- 2-ڵ
function detection54_getRole(ip)
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	
	GeneralFun.writeFile("== "..ip.." ==")
	local value = GeneralFun.getInfo(0,'{"Request":33,"IPs":"'..ip..'"}')	if value == false then return false end
	local role = value[ip]["role"]
	if role == '0' then
		return 0
	end
	local value = GeneralFun.getInfo(0,'{"Request":38,"IPs":"'..ip..'"}')	if value == false then return false end
	if value[ip]["status"] == "on"  then -- ha 
		return 1
	end	
	
	return 2	
end

function detection54_getSn(rcd_ip)
	local value = GeneralFun.getInfo(0,'{"Request":7,"IPs":"'..rcd_ip..'"}')	if value == false then return end
	local ip = value[rcd_ip]["ip"]
	local ip2 = value[rcd_ip]["ip2"]
	
	local value = GeneralFun.getInfo(0,'{"Request":25,"IPs":"'..rcd_ip..'"}')		if value == false then return end
	local rcdsn = ""
	local hostSn = value[rcd_ip]["hostSn"]	
	for k,v in pairs(hostSn) do
		for tmp_ip,tmp_rcdsn in pairs(v) do
			if tmp_ip == rcd_ip or tmp_ip == ip or tmp_ip == ip2 then
				rcdsn = tmp_rcdsn
			end		
		end
	end
	
	return string.len(rcdsn)~=0 and rcdsn or "NA"	
end

function detection54_getRcdType(rcd_ip)
	local value = GeneralFun.getInfo(0,'{"Request":44,"IPs":"'..rcd_ip..'"}')	if value == false then return end
	return value[rcd_ip]["productName"]
end

function detection54_getRcdSn()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	local value = GeneralFun.getInfo(0,'{"Request":7,"IPs":"'..webip..'"}')		if value == false then return end
	local ip = value[webip]["ip"]
	local ip2 = value[webip]["ip2"]
	
	local value = GeneralFun.getInfo(0,'{"Request":25,"IPs":"'..webip..'"}')		if value == false then return end
	local rcdsn = ""
	local slavercdsn = ""
	local hostSn = value[webip]["hostSn"]	
	for k,v in pairs(hostSn) do
		for tmp_ip,tmp_rcdsn in pairs(v) do
			if tmp_ip == webip or tmp_ip == ip or tmp_ip == ip2 then
				rcdsn = tmp_rcdsn
			else
				if string.len(slavercdsn) ~= 0 then
					slavercdsn = slavercdsn .. "\\"
				end
				slavercdsn = slavercdsn .. tmp_rcdsn
			end		
		end
	end
	
	return string.len(rcdsn)~=0 and rcdsn or "NA"	
end

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")
	
	local jsonRoot = {}
	
	local value = GeneralFun.getInfo(0,'{"Request":68,"IPs":"'..webip..'"}')		if value == false then return end
	local supportId = value[webip]["supportId"]
	if supportId == "0" then
		jsonRoot["supportID"] = "<td></td>"
	else
		jsonRoot["supportID"] = "<td>֧ID" .. supportId .. "</td>"
	end
	
	local username = ''
	local userId = ''
	local value = GeneralFun.getInfo(3016) if value == false then return end
	if value ~= nil then
		username = value["result"]["username"]
		userId = value["result"]["userId"]
		if string.len(username)==0 then
			jsonRoot["report_username"] = ""
			jsonRoot["userId"] = ""
		else
			jsonRoot["report_username"] = "<p>ύߣ"..username.."</p>" -- ύ
			if string.len(userId) == 0 then
				jsonRoot["userId"] = ""
			else
				if GeneralFun.IsNum(userId) == true and string.len(userId) == 11 then
					jsonRoot["userId"] = "<p>ϵ绰"..userId.."</p>" -- ύϵ绰
				else
					jsonRoot["userId"] = ""
				end
			end
		end
	else
		jsonRoot["report_username"] = ""
		jsonRoot["userId"] = ""
	end
	
	jsonRoot["reportName"] = "officeCenterReport"
	jsonRoot["name"] = "office_"..detection54_getRcdSn()
	local value = GeneralFun.getInfo(0,'{"Request":11,"IPs":"'..webip..'"}')		if value == false then return end
	local name = value[webip]["name"]
	jsonRoot["school"] = string.len(name)~=0 and name or "NA"
	
	local value = GeneralFun.getInfo(0,'{"Request":5000,"IPs":"'..webip..'"}')		if value == false then return end
	local deployMode = string.lower(value[webip]["deployMode"])
	if deployMode == "2" then 
		jsonRoot["classroom"] = "ư칫-ͨ"
	elseif deployMode == "3" then
		jsonRoot["classroom"] = "ư칫-"
	else
		jsonRoot["classroom"] = "NA"
	end
	
	jsonRoot["rcd_sn"] = detection54_getSn(webip)
	
	local value = GeneralFun.getInfo(0,'{"Request":3,"IPs":"'..webip..'"}')		if value == false then return end
	local deployMode = string.lower(value[webip]["deployMode"])
	GeneralFun.writeFile(deployMode)
	if deployMode == "cluster" then
		jsonRoot["slave_rcd_sn"] = "Ⱥ"
	elseif deployMode == "normal" then
		jsonRoot["slave_rcd_sn"] = "ز"
	end
	
	-- 	
	local speeds = GeneralFun.getTableValue("netSpeedValue")
	local sz_speeds = ""
	if speeds ~= nil then
		for i=1,#speeds do
			local s = speeds[i]			
			if string.len(sz_speeds) ~= 0 then
				sz_speeds = sz_speeds .. ","
			end
			sz_speeds = sz_speeds .. s
		end
	end
	jsonRoot["net_speeds"] = sz_speeds
	
	
	
	
			
	local value = GeneralFun.getInfo(0,'{"Request":26,"IPs":"'..webip..'"}')		if value == false then return end
	local baseVersion = value[webip]["baseVersion"]
	jsonRoot["rcd_os_version"] = string.len(baseVersion)~=0 and baseVersion or "NA"
	
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')		if value == false then return end
	local patchVer = value[webip]["version"]
	patchVer = patchVer~=baseVersion and patchVer or ""
	jsonRoot["patch_info"] = patchVer
	
	jsonRoot["exam_score"] = ''..lua_getScore()
	jsonRoot["warn_num"] = ''..lua_getTipCount()
		
	local ids = {lua_getNotPassIDs()}
	
	local RK_ERROR_ITEM = ''
	for i=1,#ids do
		local tmpID = ids[i]
		local desc = lua_getDescByID(tmpID)
		local tip = lua_getTypeTipByID(tmpID,false,3)
		if string.len(tip) ~= 0 then
			local tips = GeneralFun.stringSplit(tip,"\r\n")
			tip = ''
			for j=1,#tips do
				tip = tip .. "<tr><td>&nbsp;&nbsp;&nbsp;"
				tip = tip .. tips[j]
				tip = tip .. "</td></tr>"
			end
			RK_ERROR_ITEM = RK_ERROR_ITEM .. "<h4>" .. i .. "." .. desc .. "</h4>"
			RK_ERROR_ITEM = RK_ERROR_ITEM .. "<table>" .. tip .. "</table>"
		end
	end
	local RK_ERROR = ''
	if string.len(RK_ERROR_ITEM) ~= 0 then
		RK_ERROR = RK_ERROR .. "<div style=\" text-align: left;\" class=\"info_title\"><p>۷</p></div> \
		<div id=\"error_info\" style=\"margin-left: 0px; padding: 5px; text-align: left; text-indent: 20px;\" class=\"info_title\">"
		RK_ERROR = RK_ERROR .. RK_ERROR_ITEM
		RK_ERROR = RK_ERROR .. "</div>"
	end
	jsonRoot["error_item"] = RK_ERROR
	
	--޸Ϣ
	local RK_REPAIR_ITEM = ''
	local itemNum = 1
	local repairNum = lua_GetRepairNum()
	local repairStr = lua_GetRepairInfo()
	GeneralFun.writeFile(repairStr)
	local repairInfo = cjson.decode(repairStr)
	GeneralFun.writeFile(repairInfo["repairOk"])
	if repairInfo["repairOk"] == "false" then
		jsonRoot["repairInfo_item"] = ''
	else
		for k,v in pairs(repairInfo) do
			local tmpIp = k
			local ipInfo = v
			if tmpIp ~= "repairOk" then
				local info = ''
				local tip = "<tr><td style=\"word-break:break-all\">&nbsp;&nbsp;&nbsp;"
				for i=1,#ipInfo do
					if string.len(info) ~= 0 then info = info .. '' end
					info = info .. ipInfo[i] 
				end
				tip = tip .. info
				tip = tip .. "</td></tr>"
				RK_REPAIR_ITEM = RK_REPAIR_ITEM .. "<h4>" .. tmpIp .. "޸" .. "</h4>"
				RK_REPAIR_ITEM = RK_REPAIR_ITEM .. "<table>" .. tip .. "</table>"
				itemNum = itemNum + 1
			end
		end
		RK_REPAIR_ITEM = RK_REPAIR_ITEM .. "<h4>" .. "ܼ޸" .. lua_GetRepairNum() .. "</h4>"
		local RK_REPAIR = ''
		if string.len(RK_REPAIR_ITEM) ~= 0 then
			 RK_REPAIR = RK_REPAIR .. "<div style=\" text-align: left;\" class=\"info_title\"><p>޸</p></div> \
			 <div id=\"warn_info\" style=\"margin-left: 0px; padding: 5px; text-align: left; text-indent: 20px;\" class=\"info_title\">"
			RK_REPAIR = RK_REPAIR .. RK_REPAIR_ITEM
			RK_REPAIR = RK_REPAIR .. "</div>"
		end
		jsonRoot["repairInfo_item"] = RK_REPAIR
	end
	
	local RK_WARN_ITEM = ''
	for i=1,#ids do
		local tmpID = ids[i]
		local desc = lua_getDescByID(tmpID)
		local tip = lua_getTypeTipByID(tmpID,false,2)
		if string.len(tip) ~= 0 then
			local tips = GeneralFun.stringSplit(tip,"\r\n")
			tip = ''
			for j=1,#tips do
				tip = tip .. "<tr><td>&nbsp;&nbsp;&nbsp;"
				tip = tip .. tips[j]
				tip = tip .. "</td></tr>"
			end
			RK_WARN_ITEM = RK_WARN_ITEM .. "<h4>" .. i .. "." .. desc .. "</h4>"
			RK_WARN_ITEM = RK_WARN_ITEM .. "<table>" .. tip .. "</table>"
		end
	end
	local RK_WARN = ''
	if string.len(RK_WARN_ITEM) ~= 0 then
		 RK_WARN = RK_WARN .. "<div style=\" text-align: left;\" class=\"info_title\"><p></p></div> \
		 <div id=\"warn_info\" style=\"margin-left: 0px; padding: 5px; text-align: left; text-indent: 20px;\" class=\"info_title\">"
		RK_WARN = RK_WARN .. RK_WARN_ITEM
		RK_WARN = RK_WARN .. "</div>"
	end
	jsonRoot["warn_item"] = RK_WARN
		
	--	Ϣ start
	local value = GeneralFun.getInfo(0,'{"Request":38,"IPs":"'..webip..'"}')		if value == false then return end
	local bHA = value[webip]["status"] == "on"  
	local HA_SET=''
	if bHA then
		local virtualIp = value[webip]["virtualIp"]
		local ips = GeneralFun.stringSplit(virtualIp," ")
		HA_SET = HA_SET .. '<tr>'
		for i=1,#ips do
			local ip = ips[i]
			if i == 1 then
				HA_SET = HA_SET .. '<td>ҵIP' .. ip .. '</td>'
			elseif i == 2 then
				HA_SET = HA_SET .. '<td>洢IP' .. ip .. '</td>'
			end
		end
		HA_SET = HA_SET .. '</tr>'
		
		local vipNetmask = value[webip]["vipNetmask"]
		local netmasks = GeneralFun.stringSplit(vipNetmask," ")
		HA_SET = HA_SET .. '<tr>'
		for i=1,#netmasks do
			local netmask = netmasks[i]
			if i == 1 then
				HA_SET = HA_SET .. '<td>ҵ룺' .. netmask .. '</td>'
			elseif i == 2 then
				HA_SET = HA_SET .. '<td>洢룺' .. netmask .. '</td>'
			end
		end
		HA_SET = HA_SET .. '</tr>'
		
		local routerId = value[webip]["routerId"]
		local routerIds = GeneralFun.stringSplit(routerId," ")
		HA_SET = HA_SET .. '<tr>'
		for i=1,#routerIds do
			local Id = routerIds[i]
			if i == 1 then
				HA_SET = HA_SET .. '<td>ҵ·ID' .. Id .. '</td>'
			elseif i == 2 then
				HA_SET = HA_SET .. '<td>洢·ID' .. Id .. '</td>'
			end
		end
		HA_SET = HA_SET .. '</tr>'
	end
	if bHA then
		jsonRoot["ha_set"] = HA_SET
	else
		jsonRoot["ha_set"] = ''
	end
	
	local value = GeneralFun.getInfo(0,'{"Request":5,"IPs":"'..webip..'"}')		if value == false then return end	
	jsonRoot["rcd_1st_ip"] = value[webip]["ip"]		
	jsonRoot["rcd_mask"] = value[webip]["netmask"]
	
	local value = GeneralFun.getInfo(0,'{"Request":8,"IPs":"'..webip..'"}')		if value == false then return end
	jsonRoot["rcd_gateway"] = value[webip]["gateway"]	
	local value = GeneralFun.getInfo(0,'{"Request":6,"IPs":"'..webip..'"}')		if value == false then return end		
	jsonRoot["rcd_dns"] = value[webip]["dns"]
	jsonRoot["rcd_type"] = detection54_getRcdType(webip)


	local slaveHost1 = ''
	local slaveHost2 = ''
	-- ȡӻIP	
	local value = GeneralFun.getInfo(0,'{"Request":1008,"IPs":"'..webip..'"}')		if value == false then return end
	local slaveHost = value[webip]["slaveHost"]
	local needIP = ''
	for i=1,#slaveHost do
		local tmpIP = slaveHost[i]
		local bConnect = lua_getConnectState(tmpIP)
		if bConnect then
			if string.len(needIP) ~= 0 then needIP = needIP .. "#" end
			needIP = needIP .. tmpIP
		end
	end	
	_slaveHost = needIP
	GeneralFun.writeFile("slaveHost:<".._slaveHost..">")
	local ips = GeneralFun.stringSplit(_slaveHost,"#")
	local node = 1
	for i=1,#ips do
		local tmpIP = ips[i]
		if string.len(tmpIP) ~= 0 then			
			-- ȡɫ 0- 1- 2-ڵ
			local role = detection54_getRole(tmpIP)
			local tmpsn = detection54_getSn(tmpIP)
			local rcd_type = detection54_getRcdType(tmpIP)
			if role == 2 then			
				slaveHost2 = slaveHost2 .. "<tr><td>ڵ"..node.." IP"..tmpIP.."</td><td>ͺţ"..rcd_type.."</td><td>SN"..tmpsn.."</td></tr>"
				node = node + 1
			elseif role == 1 then
				slaveHost1 = "<tr><td>IP"..tmpIP.."</td><td>ͺţ"..rcd_type.."</td><td>SN"..tmpsn.."</td></tr>"
			end
		end
	end
	
	jsonRoot["slaveHost1"] = slaveHost1
	jsonRoot["slaveHost2"] = slaveHost2

	
	local value = GeneralFun.getInfo(0,'{"Request":29,"IPs":"'..webip..'"}')	if value == false then return end
	local info = cjson.encode(value)
	local workspaceIp = ' '
	if string.find(info,"workspaceIp") ~= nil then 
		workspaceIp = value[webip]["workspaceIp"]
	end	
	jsonRoot["workspace_Ip"] = workspaceIp
	local value = GeneralFun.getInfo(0,'{"Request":1007,"IPs":"'..webip..'"}')	if value == false then return end
	local licAmount = string.lower(value[webip]["licAmount"])
	jsonRoot["vm_Amount"] = licAmount
	-- Ϣ end
	
	--
	jsonRoot["halo_version"] = lua_getDetectVersion()
	--
	jsonRoot["rule_version"] = lua_getRuleVersion()
		
	local szdate=os.date("%Y.%m.%d %H:%M:%S")
	jsonRoot["report_time"] = szdate
	
	
	local value = GeneralFun.getInfo(0,'{"Request":1006,"IPs":"'..webip..'"}')		if value == false then return end		--ȡϢ
	local groupinfo = GeneralFun.getInfo(0,'{"Request":1005,"IPs":"'..webip..'"}')		if value == false then return end	--ȡϢ
	local RK_DESKTOP_INFO = ''
	local RK_DESKTOP_INFO_TAB={}
	for i=1,#value[webip] do
		local crName=value[webip][i]["crName"]
		RK_DESKTOP_INFO_TAB[i]={}
		RK_DESKTOP_INFO_TAB[i]["crName"]=crName
		RK_DESKTOP_INFO = ''
		for j=1,#groupinfo[webip] do
			local tmp_crname = groupinfo[webip][j]["crName"]
			if tmp_crname == crName then
				RK_DESKTOP_INFO = RK_DESKTOP_INFO .. "<tr>" ..
								"<td>" .. groupinfo[webip][j]["vmHostName"] .. "</td>" ..
								"<td>" .. groupinfo[webip][j]["vmIp"] .. "</td>" ..
								"<td>" .. groupinfo[webip][j]["tmHostName"] .. "</td>" ..
								"<td>" .. groupinfo[webip][j]["tmNetType"] .. "</td>" ..
								"<td>" .. groupinfo[webip][j]["tmIp"] .. "</td>" ..
								"<td>" .. groupinfo[webip][j]["tmMask"] .. "</td>" ..
								"<td>" .. groupinfo[webip][j]["tmGateway"] .. "</td>" ..
								"<td>" .. groupinfo[webip][j]["tmDns"] .. "</td>" ..
								"<td>" .. groupinfo[webip][j]["tmOsType"] .. "</td>" ..
								"<td>" .. groupinfo[webip][j]["tmOsVersion"] .. "</td>" ..						
								"</tr>"
			end
		end
		if string.len(RK_DESKTOP_INFO) ~= 0 then
			RK_DESKTOP_INFO_TAB[i]["deskinfo"]=RK_DESKTOP_INFO
		else
			RK_DESKTOP_INFO_TAB[i]["deskinfo"]=''
		end
		
	end
	
	local RK_CLASSINFO = ''
	for i=1,#RK_DESKTOP_INFO_TAB do
		if string.len(RK_DESKTOP_INFO_TAB[i]["deskinfo"]) ~= 0 then
			RK_CLASSINFO = RK_CLASSINFO.."<div class=\"info_title\">".."<p>"..RK_DESKTOP_INFO_TAB[i]["crName"].."Ϣ</p>".."</div>"
			RK_CLASSINFO = RK_CLASSINFO.."<div style=\"padding: 10px; min-height:300px;\" class=\"info_title\" >"..
										"<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width:100%;\" class=\"info_table\">"..
										"<tr>".."<td colspan=\"2\"></td>".."<td colspan=\"8\">ն</td>".."</tr>"..
										"<tr>".."<td></td>".."<td>IPַ</td>".."<td></td>".."<td>ģʽ</td>".."<td>IPַ</td>".."<td></td>"..
										"<td></td>".."<td>DNS</td>".."<td>ϵͳ</td>".."<td>ϵͳ汾</td>".."</tr>"
			RK_CLASSINFO = RK_CLASSINFO..RK_DESKTOP_INFO_TAB[i]["deskinfo"].."</table>".."</div>"
		end
	end
	--[[
	if string.len(RK_CLASSINFO) ~= 0 then
		jsonRoot["classroom__item"] = RK_CLASSINFO
	else
		jsonRoot["classroom__item"] = ''
	end
	]]
	jsonRoot["classroom__item"] = ''
	jsonRoot["faultReportInfo"] = ""
	local jsonStr = cjson.encode(jsonRoot)	
	local rpResult = lua_detectReport(jsonStr)
	
	if not rpResult then
		lua_addTypeTip(p,2,"ɱʧܣϵݼ֧")
		lua_addResult(p,2)
	else
		lua_addResult(p,1)
	end
			
	lua_afterDetect(p)	
end
 
return detection
