local detection = {}

local desc = 'նü'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

	
-- δ֪ҲJЧ
function detection_isBoxVerValid(config,box_ver,box_type,rcd_osver)
	box_type = string.lower(box_type)
	local boxVersion = config["OfficeBoxVersion"][box_type]
	if boxVersion == nil then return true end
	
	local boxVerId = 0
	local rcdOsVerId = 0
	for i=1,#boxVersion do
		local c_boxVer = boxVersion[i]["ver"]
		local c_osMinVer = boxVersion[i]["osver_min"]
		local c_osManVer = boxVersion[i]["osver_max"]	
		if box_ver == c_boxVer then
			boxVerId = i
		end		
		local r_min = lua_compareVer(rcd_osver,c_osMinVer)
		local r_max = lua_compareVer(rcd_osver,c_osManVer)		
		if r_min ~= 3 and r_max ~= 2 then
			rcdOsVerId = i
		end		
	end
	if rcdOsVerId == 0 or boxVerId == 0 then
		return true
	end
	return boxVerId == rcdOsVerId
end

function detection43_isSameSubnet()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	--lua_isSameSubnet(teacherIp,wanIP,wanMask,wanMask)
	
	local value = GeneralFun.getInfo(3007)	if value == false then return false end
	local netinfo = value["netinfo"]	
	local value = GeneralFun.getInfo(0,'{"Request":1006,"IPs":"'..webip..'"}')	if value == false then return false end
	local classroomInfo = value[webip]
	local bOK = false
	local teaIp = ''
	local teamask = ''
	local crName = ''
	for i=1,#netinfo do
		if bOK then
			break
		end
		local localip = netinfo[i]["ip"]		
		for j=1,#classroomInfo do
			local tmpcrName = classroomInfo[j]["crName"]
			local tmpteaIp = classroomInfo[j]["teaIp"]
			if tmpteaIp == localip and string.len(tmpteaIp) > 0 then				
				local localmask = netinfo[i]["mask"]
				teaIp = localip
				teamask = localmask
				crName = tmpcrName
				bOK = true
				break
			end
		end
	end
	
	if not bOK then
		return
	end

	local value = GeneralFun.getInfo(0,'{"Request":1005,"IPs":"'..webip..'"}')	if value == false then return false end
	local tmInfo = {}
	local maxCount = 0
	for i=1,#value[webip] do
		local tmpTeaIp = value[webip][i]["teaIp"]
		local tmMask = value[webip][i]["tmMask"]
		local tmIp = value[webip][i]["tmIp"]
		if string.len(tmIp) ~= 0 and string.len(tmMask) ~= 0 and string.len(tmpTeaIp) ~= 0 and teaIp == tmpTeaIp then		
			local count = 1
			if tmInfo[tmMask] ~= nil then
				count = tmInfo[tmMask]["count"] + 1
			end
			local t = {}
			t["count"] = count
			t["ip"] = tmIp
			t["mask"] = tmMask
			tmInfo[tmMask] = t
			--tmInfo[tmMask]["count"] = count
			--tmInfo[tmMask]["ip"] = tmIp
			--tmInfo[tmMask]["mask"] = tmMask
			if count > maxCount then
				maxCount = count
			end
		end
	end
	local tmIp = ""
	local tmMask = ""
	for k,v in pairs(tmInfo) do      
		if v["count"] == maxCount then
			tmMask = v["mask"]
			tmIp = v["ip"]
		end
	end
	
	if string.len(tmIp) == 0 or string.len(tmMask) == 0 then
		return
	end

	if lua_isSameSubnet(teaIp,tmIp,teamask,tmMask) then
		lua_addResult(p,1)
	else
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,"("..crName..")õĽʦIPýն˲ͬһΣȷϸƽIPַ滮-10")
	end

end

function detection43_isIP(ip)
	if ip == '' or ip == nil then
		return false
	end
	local b = string.match(ip,"%d+%.%d+%.%d+%.%d+") == ip
	if not b then
		GeneralFun.writeFile('error ip:' .. ip)
	end
	return b
end

function detection43_contain(ip,startip,endip)
	if not detection43_isIP(ip) or not detection43_isIP(startip) or not detection43_isIP(endip) then
		return false
	end
	local head = '%d+%.%d+%.%d+%.'
	local head1 = string.match(ip,head)
	local end1 = tonumber(string.sub(ip,string.len(head1)+1,string.len(ip)))
	local head2 = string.match(startip,head)
	local end2 = tonumber(string.sub(startip,string.len(head2)+1,string.len(startip)))
	local head3 = string.match(endip,head)
	local end3 = tonumber(string.sub(endip,string.len(head3)+1,string.len(endip)))
	
	if head1 ~= head2 or head1 ~= head3 then
		return false
	end
	
	if end1 < end2 or end1 > end3 then
		return false
	end
	return true
end

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")

	
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')	if value == false then return end
	local rcd_osver = value[webip]["version"]
	local config = GeneralFun.getConfig()
	local value = GeneralFun.getInfo(0,'{"Request":6,"IPs":"'..webip..'"}')	if value == false then return end
	local rcd_dns = value[webip]["dns"]
	local value39 = GeneralFun.getInfo(0,'{"Request":1006,"IPs":"'..webip..'"}')	if value39 == false then return false end
	local value13 = GeneralFun.getInfo(0,'{"Request":1005,"IPs":"'..webip..'"}')	if value13 == false then return false end
	local value3007 = GeneralFun.getInfo(3007)	if value3007 == false then return false end
	

	-- 3.2δIPƼʹþ̬IPȡģʽ -10֣ʾ3.1	
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]			
		for j=1,boxSize do
			local vmIp = value13[webip][j]["vmIp"]
			local box_crName = value13[webip][j]["crName"]
			if box_crName == crName then				
				if string.len(vmIp) == 0 then
					if string.len(errorClassroom) ~= 0 then
						errorClassroom = errorClassroom .. ""
					end
					errorClassroom = errorClassroom .. '(' .. crName .. ')'
					break
				end
			end
		end		
	end
	
	if string.len(errorClassroom) ~= 0 then
		lua_addResult(p,2)
		lua_addTypeTip(p,2,"ư칫" .. errorClassroom .. "еƼʹþ̬IPģʽԷֵַֹͻ")
	else
		lua_addResult(p,1)
	end
	
	-- 3.5桢ն˳ֵַͻ-10ָʾ5	
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	local errorTable = {}
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]	
		local bAddressConflict = false
		local address = ''
		local addressConflict = ''
		for j=1,boxSize do
			local box_crName = value13[webip][j]["crName"]		
			local vmIp = value13[webip][j]["vmIp"]
			local tmIp = value13[webip][j]["tmIp"]
			if box_crName == crName then				
				if string.len(vmIp) ~= 0 then
					if string.find(address,vmIp.."") == nil then
						address = address .. vmIp .. ""
					else
						bAddressConflict = true
						if string.len(addressConflict) ~= 0 then
							addressConflict = addressConflict .. ""
						end
						addressConflict = addressConflict .. vmIp
					end
				end
				if string.len(tmIp) ~= 0 then
					if string.find(address,tmIp.."") == nil then
						address = address .. tmIp .. ""
					else
						bAddressConflict = true
						if string.len(addressConflict) ~= 0 then
							addressConflict = addressConflict .. ""
						end
						addressConflict = addressConflict .. tmIp
					end
				end	
			end
		end	
		if bAddressConflict then
			if string.len(errorClassroom) ~= 0 then
				errorClassroom = errorClassroom .. ""
			end
			errorClassroom = errorClassroom .. '(' .. crName .. ')'
			errorTable[crName] = addressConflict
		end		
	end
	
	if string.len(errorClassroom) ~= 0 then
		local tip = "ư칫" .. errorClassroom .. "նֵַ֮ͻַ滮"
		local conflict = ''
		for k,v in pairs(errorTable) do      
			conflict = '(' .. k .. ')' .. '-' .. v .. ';'
		end
		lua_addResult(p,3)
		lua_addScore(p,-10)
		lua_addTypeTip(p,3,tip.."(챨)",tip..'ͻУ'..conflict .. "-10")
	else
		lua_addResult(p,1)
	end		
	
	-- 3.9նǷڲͬ
	local errorClassroom = ''	
	local boxSize = #value13[webip]
	local classroomInfo = value39[webip]
	for i=1,#classroomInfo do
		local crName = classroomInfo[i]["crName"]			
		for j=1,boxSize do
			local box_crName = value13[webip][j]["crName"]
			if box_crName == crName then	
				local tmIp = value13[webip][j]["tmIp"]
				local tmMask = value13[webip][j]["tmMask"]
				local vmIp = value13[webip][j]["vmIp"]
				local vmMask = value13[webip][j]["vmMask"]
				if string.len(tmIp) > 0 and string.len(vmIp) > 0 and string.len(vmMask) > 0 then
					if lua_isSameSubnet(tmIp,vmIp,vmMask,vmMask) then						
						if string.len(errorClassroom) ~= 0 then
							errorClassroom = errorClassroom .. ""
						end
						errorClassroom = errorClassroom .. '(' .. crName .. ')'
						break
					end
				end		
			end
		end		
	end
	
	if string.len(errorClassroom) ~= 0 then
		lua_addResult(p,2)
		lua_addTypeTip(p,2,"ư칫" .. errorClassroom .. "նͬһΣȷ滮Ƿܴڳͻ齫ն")
	else
		lua_addResult(p,1)
	end	
	
	lua_afterDetect(p)
end
 
return detection