
local detection = {}

local desc = '汾'
local cjson = require "cjson"
local GeneralFun = require ('data/rule/detection/GeneralFun')

function detection.Detect()
	local webip = GeneralFun.getwebip()
	local p = GeneralFun.getClassPointer()
	GeneralFun.writeFile("== "..desc.." ==")

	local _slaveHost = GeneralFun.oa_get_SlaveHost()
	local request_ips = webip
	if string.len(_slaveHost) ~= 0 then
		request_ips = _slaveHost..'#'..webip
	end
	
	local config = GeneralFun.getConfig()
	local ver1 = config["OfficeOsVersion"]["lowest version"]
	local ver2 = config["OfficeOsVersion"]['latest version']	
	GeneralFun.writeFile('lowest version:'..ver1..'  latest version:'..ver2.." ")
	
	local bQuit = false
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..webip..'"}')		if value == false then return end
	local rcdosVer = value[webip]["version"]
	local ret1 = lua_compareVer(rcdosVer,ver1) 
	local ret2 = lua_compareVer(rcdosVer,ver2) 
	
	if ret1 == 3 then
		--1.1Ϊver1°汾Ϊ0죬ʾ1
		local tip = "汾ͣڽϴգ"..ver2.."ϰ汾"
		lua_addTypeTip(p,3,tip)
		lua_addScore(p,-100)
		lua_addResult(p,3)
		
		lua_afterDetect(p)
		GeneralFun.StopDetect(2,tip)
		return
	elseif ret2 == 3 or ret2 == 4 then
		--1.2Ϊver2°汾-5֣ʾ2
		lua_addTypeTip(p,3,"ǰ汾"..rcdosVer..""..ver2.."ϰ汾-5")
		lua_addScore(p,-5)
		lua_addResult(p,3)
	else
		lua_addResult(p,1)
	end
	
	--1.3⼯Ⱥ汾Ƿһ£һ£̨һ£-10֣ʾ3	
	local value = GeneralFun.getInfo(0,'{"Request":2,"IPs":"'..request_ips..'"}')	if value == false then return end
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local errorIP = ''
	local bOK = true
	--rcdosVer
	for i=1,#ips do
		local tmpIP = ips[i]
		local tmpObj = value[tmpIP]
		local tmpVer = tmpObj["version"]
		if rcdosVer ~= tmpVer then
			bOK = false
			if string.len(errorIP) ~= 0 then
				errorIP = errorIP .. ""
			end
			errorIP = errorIP .. tmpIP
		end
	end	
	if not bOK then
		lua_addTypeTip(p,3,"IP"..errorIP.."汾һ£Ⱥ汾һ£-10")
		lua_addResult(p,3)
		lua_addScore(p,-10)
	else
		lua_addResult(p,1)		
	end
	
	--ģ鰲װ
	local value = GeneralFun.getInfo(0,'{"Request":45,"IPs":"'..request_ips..'"}')		if value == false then return end --webϵͳģ
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local error_ip = ''
	for i=1,#ips do
		local tmpip = ips[i]
		local obj = value[tmpip]
		local installState = obj["isInstallOk"]
		if installState ~= "yes" then
			if string.len(error_ip) > 0 then
				error_ip = error_ip .. ''
			end
			error_ip = error_ip .. tmpip
		end
	end
	
	if string.len(error_ip) > 0 then 
		local tip = "".. error_ip .. "װδʹU̷ʽװ"
		lua_addResult(p,3)
		lua_addScore(p,-100)
		lua_addTypeTip(p,3,tip)
		
		lua_afterDetect(p)
		GeneralFun.StopDetect(2,tip)
		return
	else
		lua_addResult(p,1)
	end
	
	
	-----OTAģ
	local value = GeneralFun.getInfo(0,'{"Request":46,"IPs":"'..request_ips..'"}')		if value == false then return end --ota
	local ips = GeneralFun.stringSplit(request_ips,"#")
	local needRepairIp = ''
	for i=1,#ips do
		local tmpip = ips[i]
		local obj = value[tmpip]
		if obj["otaPackageFix"] == "-1" then --Ҫ޸
			if needRepairIp ~= '' then needRepairIp = needRepairIp .. "#" end
			needRepairIp = needRepairIp .. tmpip
		end
	end
	
	if needRepairIp ~= '' then
		local value = GeneralFun.getAysnInfo(0,'{"Request":47,"IPs":"'..needRepairIp..'"}') if value == false then return end --ota޸
		lua_SetRepairCode(needRepairIp,"47")
		lua_addResult(p,3)
		lua_addScore(p,-100)
		local tip = "" .. needRepairIp .. "նΪɾʹU̷ʽװ"
		lua_addTypeTip(p,3,tip)
		lua_afterDetect(p)
		GeneralFun.StopDetect(2,tip)
		return
	else
		lua_addResult(p,1)
	end
	
	lua_afterDetect(p)
end
 
return detection