'=================================================================
'===== DEBUGGER FOR FREEBASIC === (C) 2006-2016 Laurent GRAS =====
'=================================================================

#Define fbdebuggerversion "V 2.91"
'#Define fulldbg_prt 'ȡעԻȡϢ
'#Define dbg_prt2 dbg_prt 'ʱfbdebuggerӦעͣԱõ
#Include Once "windows.bi"
#Include Once "win\commctrl.bi"
#Include Once "win\commdlg.bi"
#Include Once "win\wingdi.bi"
#Include Once "win\richedit.bi"
#Include Once "win\tlhelp32.bi"
#Include Once "win\shellapi.bi"
#Include Once "win\psapi.bi" 
#Include Once "file.bi"
'define data 64bit/32bit
#Ifdef __FB_64BIT__ 
   #Define regip rip
   #Define regbp rbp
   #Define regsp rsp
   #Define ver3264 "(64bit) " 
#Else
   #Define regip eip
   #Define regbp ebp
   #Define regsp esp
   #Define ver3264 "(32bit) " 
#EndIf

#Define MAXSRCSIZE 500000 'ԴС
#Define MAX_STAB_SZ 60000 ' stabs string '20/07/2014
' ǻûж
#Ifndef EXCEPTION_DEBUG_EVENT
	#Define EXCEPTION_DEBUG_EVENT  1
	#define CREATE_THREAD_DEBUG_EVENT  2
	#define CREATE_PROCESS_DEBUG_EVENT  3
	#define EXIT_THREAD_DEBUG_EVENT  4
	#define EXIT_PROCESS_DEBUG_EVENT  5
	#define LOAD_DLL_DEBUG_EVENT  6
	#define UNLOAD_DLL_DEBUG_EVENT  7
	#define OUTPUT_DEBUG_STRING_EVENT  8
	#define RIP_EVENT  9
	''' DUPLICATE #define DBG_CONTINUE  &h00010002
	#define DBG_TERMINATE_THREAD           &h40010003
	#define DBG_TERMINATE_PROCESS          &h40010004
	#define DBG_CONTROL_C                  &h40010005
	#define DBG_CONTROL_BREAK              &h40010008
#EndIf
' DBG_EXCEPTION_NOT_HANDLED = &H80010001
#Define EXCEPTION_GUARD_PAGE_VIOLATION      &H80000001
#Define EXCEPTION_NO_MEMORY                 &HC0000017
#Define EXCEPTION_FLOAT_DENORMAL_OPERAND    &HC000008D
#Define EXCEPTION_FLOAT_DIVIDE_BY_ZERO      &HC000008E
#Define EXCEPTION_FLOAT_INEXACT_RESULT      &HC000008F
#Define EXCEPTION_FLOAT_INVALID_OPERATION   &HC0000090
#Define EXCEPTION_FLOAT_OVERFLOW            &HC0000091
#Define EXCEPTION_FLOAT_STACK_CHECK         &HC0000092
#Define EXCEPTION_FLOAT_UNDERFLOW           &HC0000093
#Define EXCEPTION_INTEGER_DIVIDE_BY_ZERO    &HC0000094
#Define EXCEPTION_INTEGER_OVERFLOW          &HC0000095
#Define EXCEPTION_PRIVILEGED_INSTRUCTION    &HC0000096
#Define EXCEPTION_CONTROL_C_EXIT            &HC000013A
 'ַȡlַҪո
#Define fmt(t,l) Left(t,l)+Space(l-Len(t))+"  "
#Define fmt2(t,l) Left(t,l)+Space(l-Len(t))
#Define UM_CHECKSTATECHANGE (WM_USER + 100) 'for checkboxes
#define UM_FOCUSSRC         (WM_USER + 101) 'for focus source
#define RGBA_R( c ) ( c  Shr 16 And 255 )
#define RGBA_G( c ) ( c  Shr  8 And 255 )
#define RGBA_B( c ) ( c         And 255 )

'ʹhtml
#Ifndef HH_DISPLAY_TOPIC 
	#Define HH_DISPLAY_TOPIC 0000
	#Define HH_HELP_CONTEXT  0015
#EndIf
'ڸλʾַ
#Define AFFMAX 40
#Define AFFMAX2 AFFMAX*2
#Define RECUPMAX 1000

#Define TYPESTD 16 ''׼͵ޣֵΪ16 20/08/2015

'ťĻ
Const IDBUTSTEP  = 101
Const IDBUTSTEPP = 102
Const IDBUTSTEPM = 103
Const IDBUTAUTO  = 104
Const IDBUTRUN   = 105
Const IDBUTSTOP  = 106
Const IDBUTMINI  = 107
Const IDBUTFREE  = 108
Const IDBUTTOOL  = 109
Const IDBUTFILE  = 110
Const IDBUTRRUNE = 111
Const IDBUTATTCH = 112
Const IDBUTKILL  = 113
Const IDNOTES    = 114
Const IDLSTEXE   = 115
Const IDFASTRUN  = 116
Const IDEXEMOD   = 117
Const IDBUTSTEPB = 118
Const IDBUTSTEPT = 119

Const IDWATCH1 = 120
Const IDWATCH2 = 121
Const IDWATCH3 = 122
Const IDWATCH4 = 123
Const IDBRKVAR = 124
Const IDCURLIG = 125
Const IDBMKCMB = 126
Const IDDUMP   = 127

Const ENLRSRC   =130
Const ENLRVAR   =131
Const ENLRMEM   =132
Const IDVCLPSE  =133
Const IDVEXPND  =134
Const IDFNDTXUP =135
Const IDFNDTXDW =136
Const IDFNDTXCS =137
Const IDRICHWIN =200
Const IDNOTEWIN =201
Const IDSTATUS  =202
' ID for TAB
Const TAB1=210
Const TAB2=211
Const TVIEW1=220
Const TVIEW2=221
Const TVIEW3=222
Const TVIEW4=223
' ID for dump

' ID ˵Դ
Const IDSETBRK =500
Const IDSETBRT =501
Const IDMNGBRK =502
Const IDCONTHR =503 'Ҳڰť
Const IDFNDTXT =504
Const IDTGLBMK =505
Const IDNXTBMK =506
Const IDPRVBMK =507
Const IDADDNOT =508
Const IDGOTO   =509
Const IDSHWVAR =510
Const IDSETWVAR=511
Const IDACCLINE=512
Const IDFCSSRC =513 
Const IDLINEADR=514
Const IDBRKENB =515
Const IDTHRDAUT=516 'Զִн߳
Const IDLINEASM=517
Const IDPROCASM=518
Const IDREGS   =519 '25/08/2015
Const IDSETBRKC=520 '03/09/2015
Const IDCHGBRKC=521 '03/09/2015
Const IDRSTBRKC=522 '03/09/2015
'ID Ϊ˵var
Const IDVARDMP =530
Const IDVAREDT =531
Const IDVARBRK =532
Const IDSELIDX =533
Const IDSHSTRG =534
Const IDSHWEXP =535
Const IDSETWTCH=536
Const IDSETWTTR=537
Const IDCHGZSTR=538
Const IDCALLINE=539
Const IDLSTVARA=540 'list all proc/variables
Const IDLSTVARS=541 'list only selected and below
Const IDPBCKTRK=542 'backtraking from proc/var
Const IDPCHNING=543 'chaining from proc/var
Const IDSHCHAR =544 'show character in a string at a selected position '03/11/2014 
Const IDCLBVARA=545 'copy to clipboard all procs/vars '28/11/2014
Const IDCLBVARS=546 'copy to clipboard selected var
Const IDPTDUMP =547 'dump deferenced data
Const IDFNDVAR =548 'find proc or var in proc/var

''tracking array 2016/06/02
Const IDTRCKIDX0=1500 ''variable used as index
Const IDTRCKIDX1=1501
Const IDTRCKIDX2=1502
Const IDTRCKIDX3=1503
Const IDTRCKIDX4=1504

Const IDTRCKARR =1510 ''associate var indexes to an array
Const IDTRCKRST =1511 ''reset all

'ID for proc
Const IDRSTPRC =550 'reset proc follow
Const IDSETPRC =551 'set proc follow
Const IDSORTPRC=552 'toggle sort by module name / proc name
Const IDASMPRC =553 'listing of asm code of a proc
'ID for thread
Const IDTHRDCHG=560 'select thread
Const IDLOCPRC =561 'locate proc (also used in menu var and proc)
Const IDTHRDKLL=562 'kill thread
Const IDEXCLINE=563 'show next executed line
Const IDCREATHR=564 'show line creating thread
Const IDTHRDLST=565 'list threads
Const IDSHWPROC=566 'show proc in proc/var
Const IDSHPRSRC=567 'show proc in source
Const IDTBCKTRK=568 'backtracking
Const IDTCHNING=569 'chaining
Const IDTHRDEXP=570 'expand one thread
Const IDTHRDCOL=571 'collapse all threads
Const IDPRCRADR=572 'addr about running proc start,end stack
'ID for tools
Const IDCMDLPRM=580
Const IDDBGHELP=581
Const IDINFOS  =582
Const IDABOUT  =583
Const IDFILEIDE=584
Const IDQCKEDT =585
Const IDCMPNRUN=586
Const IDWINMSG =587
Const IDSHWBDH =588
Const IDCLIPBRD=589
Const IDDELLOG =590
Const IDSHWLOG =591
Const IDSHENUM =592
Const IDCMPINF =593
Const IDJITDBG =594
Const IDTUTO   =595
Const IDLSTDLL =596
Const IDHIDLOG =597
Const IDLSTSHC =598
Const IDFRTIMER=599
'ID for watched var
Const IDWCHVAR =620
Const IDWCHDMP =621
Const IDWCHDEL =622
Const IDSTWTCH1=623
Const IDSTWTCH2=624
Const IDSTWTCH3=625
Const IDSTWTCH4=626
Const IDWCHSTG =627
Const IDWCHSHW =628
Const IDWCHEDT =629
Const IDWCHTTGL=630
Const IDWCHTTGA=631
Const IDWCHDALL=632

' for proc_find / thread
Const KFIRST=1
Const KLAST=2
' when select a var for proc/var or set watched
Const PROCVAR=1
Const WATCHED=2
'for dissassembly
Const KLINE=1
Const KPROC=2
Const KPROG=3
Const KSPROC=3

Union pointeurs
pxxx As Any Ptr
pinteger As Integer Ptr
puinteger As UInteger Ptr
psingle As Single Ptr
pdouble As Double Ptr
plinteger As LongInt Ptr
pulinteger As ULongInt Ptr
pbyte As Byte Ptr
pubyte As UByte Ptr
pshort As Short Ptr
pushort As UShort Ptr
pstring As String Ptr
pzstring As ZString Ptr
pwstring As WString Ptr
End Union
Union valeurs
vinteger As Integer
vuinteger As UInteger
vsingle As Single
vdouble As Double
vlinteger As LongInt
vulinteger As ULongInt
vbyte As Byte
vubyte As UByte
vshort As Short
vushort As UShort
'vstring as string
'vzstring as zstring
'vwstring as wstring
End Union
' DATA STAB
Type udtstab
	stabs As Integer
	code As UShort
	nline As UShort
	ad As UInteger
End Type
Enum 'type udt/redim/dim
	TYUDT
	TYRDM
	TYDIM
End Enum
Enum 'type of running
	RTRUN
	RTSTEP
	RTAUTO
	RTOFF
	RTFRUN
	RTFREE
	RTEND
End Enum
Enum
NODLL
DLL
End Enum

' TO CREATE CLASSNAME / tooltips -------------
Dim Shared fb_szAppName As String
fb_szAppName="DEBUGGER"
Dim Shared fb_hinstance As HINSTANCE
Dim Shared fb_hToolTip As HWND
Dim Shared crc_table(255)  As Integer 'У
Dim Shared flaglog As Byte=0    ' flag for dbg_prt 0 --> no output / 1--> only screen / 2-->only file / 3 --> both
Dim Shared flagtrace As Byte    ' Ϊģʽ : 1 proc / +2 line
Dim Shared flagverbose As Byte  ' ־Ϊϸģʽ
Dim Shared flagmain As Byte     ' һҪ־
Dim Shared flagattach As Byte   ' ӱ־
Dim Shared flagtooltip As Integer =TRUE 'TRUE=activated/FALSE=DESACTIVATED
Dim Shared flagrestart As Integer=-1  '־ʾbasļʵԱ¼Щļ
Dim Shared flagwtch As Integer =0 'flag =0 clean watched / 1 no cleaning in case of restart 
Dim Shared flagfollow As Integer =FALSE 'flag to follow next executed line on focus window
Dim Shared flagkill   As Integer =FALSE 'flag if killing process to avoid freeze in thread_del
Dim Shared flagtuto  As Integer 'flag for tutorial -1=no tuto / 2=let execution then return at value 1 / 1=tutorial so no possible command
Dim Shared As Integer flagmodule,flagunion 'flag for dwarf
Dim Shared As Long dwlastprc,dwlastlnb 'to manage end of proc
Dim Shared compinfo As String   'information about compilation
Dim Shared hattach As HANDLE    'handle to signal attchement done
Dim Shared jitprev As String
Dim Shared fasttimer As Double
'GCC
Dim Shared As Byte    gengcc       ' flag for compiled with gcc
ReDim Shared As String Trans()
Dim   Shared As String stringarray
'END GCC
Dim Shared As Integer autostep=200 'delay for auto step
Enum 'code stop
	CSSTEP=0
	CSCURSOR
	CSBRKTEMPO
	CSBRK
	CSBRKV
	CSBRKM
	CSHALTBU
   CSACCVIOL
   CSNEWTHRD
   CSEXCEP '19/05/2014
End Enum
Dim Shared stopcode As Integer
Dim Shared stoplibel(20) As String*17 =>{"","","ʱж","ж","ϵ","ڴж"_
,"ûж","ʳͻ","߳",""} '19/05/2014
Dim Shared stringadr As Integer
' -------------------------------------------------
Dim Shared pinfo As PROCESS_INFORMATION
Dim Shared windmain As HWND
Dim Shared tviewcur As HWND  'TV1 ou TV2 ou TV3
Dim Shared tviewvar As HWND 'running proc/var
Dim Shared tviewprc As HWND 'all proc
Dim Shared tviewthd As HWND 'all threads
Dim Shared tviewwch As HWND 'watched variables

Dim Shared dbgstatus As HWND
Dim Shared recsav As RECT 'save windmain sizes
'for dump
Dim Shared listview1 As HWND
Dim Shared lvnbcol As Integer
Dim Shared lvtyp As Integer =1

Dim Shared hcurline As HWND 'current line
Dim Shared butstep As HWND
Dim Shared butstepp As HWND
Dim Shared butstept As HWND
Dim Shared butstepb As HWND
Dim Shared butstepm As HWND
Dim Shared butcont As HWND
Dim Shared Butexemod As HWND
Dim Shared butauto As HWND
Dim Shared butrun As HWND
Dim Shared butfastrun As HWND
Dim Shared butstop As HWND
Dim Shared butmini As HWND
Dim Shared butfree As HWND
Dim Shared Buttool As HWND
Dim Shared Butfile As HWND
Dim Shared Butrrune  As HWND
Dim Shared Butlstexe As HWND
Dim Shared Butattch  As HWND
Dim Shared Butkill   As HWND
Dim Shared butenlrsrc  As HWND
Dim Shared butenlrvar  As HWND
Dim Shared butnotes    As HWND
Dim Shared butenlrmem  As HWND
Dim Shared dbgEdit1    As HWND 'for notes
Dim Shared dbgrichedit As HWND 'for rich edit current
''''' dim shared timerid1 as integer 'not used if 2 threads
Dim Shared menuRoot   As HMENU
Dim Shared menuedit   As HMENU 'popup menu with richedit
Dim Shared menuedit2  As HMENU 'popup sub menu with richedit
Dim Shared menuvar    As HMENU 'popup menu var/proc
Dim Shared menuvar2   As HMENU 'popup sub menu var/proc watched 
Dim Shared menuvar3   As HMENU 'popup sub menu var/proc copy to log '28/11/2014
Dim Shared menuvar4   As HMENU 'popup sub menu var/proc copy to clipboard
Dim Shared menuvar5   As HMENU 'popup sub menu for array tracking ''2016/06/15
Dim Shared menutools  As HMENU 'popup menu tools
Dim Shared menuproc   As HMENU 'popup menu proc
Dim Shared menuthread As HMENU 'popup menu thread
Dim Shared menuwatch  As HMENU 'popup menu watch
'dim shared as integer mnubm

'THREAD
Type tthread
 hd  As HANDLE    'handle
 id  As UInteger  'ident
 pe  As Integer   'flag if true indicates proc end 
 sv  As Integer   'sav line
 od  As Integer   'previous line
 nk  As UInteger  'for naked proc, stack and used as flag
 st  As Integer   'to keep starting line
 tv  As HTREEITEM 'to keep handle of thread item
 plt As HTREEITEM 'to keep handle of last proc of thread in proc/var tview 
 ptv As HTREEITEM 'to keep handle of last proc of thread in thread tview 
 exc As Integer   'to indicate execution in case of auto 1=yes, 0=no
End Type
Const THREADMAX=50
Dim Shared thread(THREADMAX) As tthread
Dim Shared threadnb As Integer =-1
Dim Shared threadcur As Integer
Dim Shared threadprv As Integer     'previous thread used when mutexunlock released thread or after thread create
Dim Shared threadsel As Integer     'thread selected by user, used to send a message if not equal current
Dim Shared threadaut As Integer     'number of threads for change when  auto executing
Dim Shared threadcontext As HANDLE
Dim Shared threadhs As HANDLE       'handle thread to resume
Dim Shared dbgprocid As Integer     'pinfo.dwProcessId : debugged process id
Dim Shared dbgthreadID As Integer   'pinfo.dwThreadId : debugged thread id
Dim Shared dbghand As HANDLE  		'debugged proc handle
Dim Shared dbghthread As HANDLE     'debuggee thread handle
Dim Shared dbghfile  As HANDLE   	'debugged file handle
Dim Shared prun As Integer        	'indicateur process running
Dim Shared curlig As Integer  		'current line
Dim Shared curtab As UShort =0 		'associated wih curlig
Dim Shared shwtab As UShort =0 		'tab showed could be different of curtab
' compiler,commandline for compilation and for debug
Dim Shared As String fbcexe,cmdlfbc,ideexe
Dim Shared exename As ZString *300 'debuggee executable
Dim Shared exedate As Double 'serial date
Dim Shared savexe(9) As String 'last 10 exe, 0=more recent
Dim Shared cmdexe(9) As String 'last 10 exe

'SOURCES
Const MAXSRC=200 							   'max 200 sources
Dim Shared dbgsrc As String 			   'current source
Dim Shared dbgmaster As Integer 		   'index master source if include
Dim Shared dbgmain As Integer 		   'index main source proc entry point, to update dbgsrc see load_sources
Dim Shared source(MAXSRC) As String    'source names
Dim Shared srccomp(MAXSRC) As Long     'flag to keep the used compil option (gas=0, gcc=1, gcc+dwarf=2)
Dim Shared sourcenb As Integer  =-1    'number of src
Dim Shared As String compdir           'compil directory (dwarf)
Dim Shared richedit(MAXSRC) As HWND    'one for each tab
Dim Shared clrrichedit As Integer=&hFFFFFF    'background color
Dim Shared clrcurline As Integer=&hFF0000    'current line color, default blue
Dim Shared clrkeyword As Integer=&hFF8040       'keyword color (highlight), default 
Dim Shared clrtmpbrk As Integer=&h04A0FB    'current line color, default orange
Dim Shared clrperbrk As Integer=&hFF 'permanent breakpoint default red (used also when access violation)
Dim Shared As Byte runtype =RTOFF        'running type 07/12/2014

Dim Shared dsptyp As Integer=0         'type of display
Dim Shared dspofs As Integer=4         'type offset current line source : 2->3/ 4->5
Dim Shared dspsize As Integer          'number of lines of the source window
Dim Shared dspwidth As Integer         'max width in characters 
        
Dim Shared breakcpu As Integer =&hCC
Dim Shared As String  dwln '(dwarf) line read
Dim Shared As Integer dwff '(dwarf) freefile
'===== DLL
Type tdll
	As HANDLE   hdl 'handle to close
	As UInteger bse 'base address
	As HTREEITEM tv 'item treeview to delete
	As Integer gblb 'index/number in global var table
	As Integer gbln 
	As Integer  lnb 'index/number in line
	As Integer  lnn 
	As String   fnm 'full name
End Type
Const DLLMAX=300
Dim Shared As tdll dlldata(DLLMAX)
Dim Shared As Integer dllnb 'use index base 1


'===================== proc (sub or function) ============================
Const PROCMAX=20000 'in sources
Enum
 KMODULE=0 'used with IDSORTPRC
 KPROCNM
End Enum

Type tproc
	nm As String   'name
	db As UInteger 'lower address
	fn As UInteger 'upper line address
	ed As UInteger 'upper proc end 18/08/2015
	sr As UShort   'source index
	nu As Long     'line number to quick access
	lastline As Long 'last line of proc (use when dwarf data) ''2016/03/24
	vr As UInteger 'lower index variable upper (next proc) -1
	rv As Integer  'ֵ type
	pt As Long     'counter pointer for ֵ (** -> 2)
	rvadr As Integer 'offset for ֵ adr (for now only dwarf) 19/08/2015
   tv As HTREEITEM 'in tview2
   st As Byte     'state followed = not checked
End Type
Dim Shared proc(PROCMAX) As tproc
Dim Shared procnb As Integer
Dim Shared As UInteger procsv,procad,procin,procsk,proccurad,procregsp,procfn,procbot,proctop,procsort

Const PROCRMAX=50000 'Running proc
Type tprocr
	sk   As UInteger  'stack
	idx  As UInteger  'index for proc
	tv   As HTREEITEM 'index for treeview
	'lst as uinteger 'future array in LIST
	cl   As Integer   'calling line
	thid As Integer   'idx thread
	vr   As Integer   'lower index running variable upper (next proc) -1
End Type
Dim Shared procr(PROCRMAX) As tprocr,procrnb As Integer 'list of running proc
'line ==============================================
Const LINEMAX=100000
Type tline
	ad As UInteger
	nu As Integer
	sv As Byte
	pr As UShort
	hp As Integer
	hn As Integer
End Type
Dim Shared As Integer linenb,rlineold 'numbers of lines, index of previous executed line (rline)
Dim Shared As Integer linenbprev 'used for dll 
Dim Shared rline(LINEMAX) As tline
'DIM ARRAY =========================================
Const ARRMAX=1500
Type tnlu
	lb As UInteger
	ub As UInteger
End Type
Type tarr 'five dimensions max
	dm As UInteger
	nlu(5) As tnlu
End Type
Dim Shared arr(ARRMAX) As tarr,arrnb As Integer
'var =============================
Const VARMAX=20000 'CAUTION 3000 elements taken for globals 
Const VGBLMAX=3000 'max globals
Const KBLOCKIDX=100 'max displayed lines inside index selection
Type tvrb
	nm As String    'name
	typ As Integer  'type
	adr As Integer  'address or offset 
	mem As UByte    'scope 
	arr As tarr Ptr 'pointer to array def
	pt As long      'pointer
End Type
Dim Shared vrbloc      As Integer 'pointer of loc variables or components (init VGBLMAX+1)
Dim Shared vrbgbl      As Integer 'pointer of globals or components
Dim Shared vrbgblprev  As Integer 'for dll, previous value of vrbgbl, initial 1
Dim Shared vrbptr      As Integer Ptr 'equal @vrbloc or @vrbgbl
Dim Shared vrb(VARMAX) As tvrb
Const VRRMAX=100000
Type tvrr
	ad    As UInteger 'address
	tv    As HTREEITEM 'tview handle
	vr    As Integer  'variable if >0 or component if <0
	ini   As UInteger 'dyn array address (structure) or initial address in array
	gofs  As UInteger 'global offset to optimise access
	ix(4) As Integer  '5 index max in case of array
	arrid As integer  'index in array tracking for automatic tracking ''2016/06/02
End Type
Dim Shared vrr(VRRMAX) As tvrr
Dim Shared vrrnb As UInteger
'' tracking an array, displaying value using variables as indexes ''2016/06/02
'' ex array1(i,j) when i or j change the corresponding value of array1 is displayed 
Type ttrckarr
	typ    As UByte     ''type or lenght ???
	memadr As UInteger  ''adress in memory
	iv     As UInteger  ''vrr index used when deleting proc 
	idx    As Integer   ''array variable index in vrr 
	''bname as string
End Type
Const TRCKARRMAX=4 ''2016/07/26
Dim Shared As ttrckarr trckarr(TRCKARRMAX)
'UDT ==============================
Type tudt
	nm As String  'name of udt
	lb As Integer 'lower limit for components
	ub As Integer 'upper
	lg As Integer 'lenght 
	en As Integer 'flag if enum 1 or 0
	index As Integer 'dwarf
	what As Integer 'dwarf udt/pointer/array
	typ As Integer 'dwarf
	dimnb As Long 'dwarf
	bounds(5) As UInteger 'dwarf
End Type
Type tcudt
	nm As String    'name of components or text for enum
	Union
	typ As Integer  'type
	Val As Integer  'value for enum
	End Union
	ofs As UInteger 'offset
	ofb As UInteger 'rest offset bits 
   lg As UInteger  'lenght
	arr As tarr Ptr 'arr ptr
	pt As long
End Type
Const TYPEMAX=80000,CTYPEMAX=100000
'CAUTION : TYPEMAX is the type for bitfield so the real limit is typemax-1
Dim Shared udt(TYPEMAX) As tudt,udtidx As Integer
Dim Shared cudt(CTYPEMAX) As tcudt,cudtnb As Integer,cudtnbsav As Integer
'in case of module or DLL the udt number is initialized each time
Dim Shared As Integer udtcpt,udtmax 'current, max cpt
'dwarf management
Dim Shared As Long udtbeg,cudtbeg,locbeg,vrbbeg,prcbeg
'excluded lines for procs added in dll (DllMain and tmp$x)
Const EXCLDMAX=10
Type texcld
	db As UInteger
	fn As UInteger
End Type
Dim Shared As Long excldnb
Dim Shared As texcld	excldlines(EXCLDMAX)

udt(0).nm="Unknown"
'12/07/2015
#Ifdef __FB_64BIT__ 
   udt(1).nm="long":udt(1).lg=Len(Long)
#Else
   udt(1).nm="Integer":udt(1).lg=Len(Integer)
#EndIf
udt(2).nm="Byte":udt(2).lg=Len(Byte)
udt(3).nm="Ubyte":udt(3).lg=Len(UByte)
udt(4).nm="Zstring":udt(4).lg=Len(Integer)'4 12/07/2015
udt(5).nm="Short":udt(5).lg=Len(Short)
udt(6).nm="Ushort":udt(6).lg=Len(UShort)
udt(7).nm="Void":udt(7).lg=Len(Integer)'4 12/07/2015
udt(7).index=7'dwarf
'12/07/2015
#Ifdef __FB_64BIT__
   udt(8).nm="Ulong":udt(8).lg=Len(ULong)
#Else
   udt(8).nm="Uinteger":udt(8).lg=Len(UInteger)
#EndIf
'12/07/2015
#Ifdef __FB_64BIT__
   udt(9).nm="Integer":udt(9).lg=Len(Integer)
#Else
   udt(9).nm="Longint":udt(9).lg=Len(LongInt)
#EndIf
'12/07/2015
#Ifdef __FB_64BIT__
   udt(10).nm="Uinteger":udt(10).lg=Len(UInteger)
#Else
   udt(10).nm="Ulongint":udt(10).lg=Len(ULongInt)
#EndIf

udt(11).nm="Single":udt(11).lg=Len(Single)
udt(12).nm="Double":udt(12).lg=Len(Double)
udt(13).nm="String":udt(13).lg=Len(String)
udt(14).nm="Fstring":udt(14).lg=Len(Integer)'4 12/07/2015
udt(15).nm="fb_Object":udt(15).lg=Len(UInteger)
udt(16).nm="Boolean": '20/082015 boolean
For i As Integer =0 To TYPESTD:udt(i).what=1:Next '(dwarf) 20/08/2015 boolean
 'BREAK ON LINE
Const BRKMAX=10 'breakpoint index zero for "run to cursor"
Type breakol
	isrc    As UShort   'source index 
	nline   As UInteger 'num line for display
	index   As Integer  'index for rline
	ad      As UInteger 'address
	typ     As Byte	  'type normal=1 /temporary=0, 3 or 4 =disabled
	counter As UInteger 'counter to control the number of times the line should be executed before stopping 02/09/2015
	cntrsav As UInteger 'to reset if needed the initial value of the counter '03/09/2015
End Type
Dim Shared brkol(BRKMAX) As breakol,brknb As Byte
Dim Shared As String brkexe(9,BRKMAX) 'to save breakpoints by session
'break on var
Type tbrkv
	
	typ As Integer   'type of variable
	adr As UInteger  'address
	arr As UInteger  'adr if dyn array
	ivr As Integer   'variable index
	psk As Integer   'stack proc
	Val As valeurs   'value
	vst As String    'value as string
	tst As Byte=1    'type of comparison (1 to 6)
	ttb As Byte      'type of comparison (16 to 0)
	txt As String	  'name and value just for brkv_box
End Type
Dim Shared brkv As tbrkv 
Dim Shared brkv2 As tbrkv 'copie for use inside brkv_box
Dim Shared brkvhnd As HWND   'handle
'BOOKMARK
Type tbmk
	nline As Integer 'bookmark line
	ntab  As Integer 'bookmark tab number, =-1 --> empty
End Type
Const BMKMAX=10
Dim Shared As tbmk    bmk(BMKMAX) 
Dim Shared As HWND    bmkh   'handle combo
Dim Shared As Integer bmkcpt 'bmk counter
'WATCH
Const WTCHMAIN=3
Const WTCHMAX=9
Const WTCHALL=9999999
Type twtch
    hnd As HWND     'handle
    tvl  As HTREEITEM 'tview handle
    adr As UInteger 'memory address
    typ As Integer  'type for var_sh2
    pnt As Integer  'nb pointer
    ivr As Integer  'index vrr
    psk As Integer  'stk procr or -1 (empty)/-2 (memory)/-3 (non-existent local var)/-4 (session)
    lbl As String   'name & type,etc
    arr As UInteger 'ini for dyn arr
    tad As Integer  'additionnal type
    old As String   'keep previous value for tracing
    idx As Integer  'index proc only for local var
    dlt As Integer  'delta on stack only for local var
    vnb As Integer  'number of level
    vnm(10) As String   'name of var or component
    vty(10) As String   'type
    Var     As Integer  'array=1 / no array=0
End Type
Dim Shared wtch(WTCHMAX) As twtch
Dim Shared wtchcpt As Integer 'counter of watched value, used for the menu 
Dim Shared hwtchbx As HWND    'handle
Dim Shared wtchidx As Integer 'index for delete 
Dim Shared wtchexe(9,WTCHMAX) As String 'watched var (no memory for next execution)
Dim Shared wtchnew As Integer 'to keep index after creating new watched
'For findtext
Dim Shared chkcase  As Integer  'flag match case
Dim Shared sfind    As String   'string to find
Dim Shared stext    As String   'string under cursor or selected by user
Dim Shared hfindbx  As HWND     'hwnd find zone
'for save box
Dim Shared savebx   As HWND     'just little yes/cancel box
'for help box
Dim Shared helpbx   As HWND   
Dim Shared helptyp  As Byte     '1=help,2=infos
' or dump
Dim Shared hdumpbx As HWND       'hwnd dump zone
Dim Shared dumplig As Integer =1 'nb lines(1 or xx)
Dim Shared dumpadr As UInteger   'address for dump
Dim Shared dumpdec As Integer =0 'value dump dec=0 or hexa=50
Dim Shared copybeg As Integer   'address beginning/end for copying to clipboard
Dim Shared copyend As Integer
Dim Shared copycol As Integer   'column for copying to clipboard
' input_box
Dim Shared inputval As ZString *25
Dim Shared inputtyp As Byte
'focus box
Dim Shared focusbx   As HWND  
'tutorial box
Dim Shared tutobx   As HWND 
'bitmap buttons
Dim Shared bmb(23) As HBITMAP 
'TAB
Dim Shared  As HWND htab1,htab2
'index box
Const INDEXBOXMAX=9 ''2016/02/07
Dim Shared hindexbx(INDEXBOXMAX) As HWND
Dim Shared autoupd(INDEXBOXMAX) As BOOLEAN
' For size font
Const KSIZE8=8
Const KSIZE10=10
Const KSIZE12=12
'font handle
Dim Shared As HFONT   fonthdl
Dim Shared As HFONT   fontbold
Dim Shared As Integer fontsize=KSIZE8
Dim Shared As String  fontname
fontname="Courier new"
'show/expand
Const SHWEXPMAX=10 'max shwexp boxes
Const VRPMAX=5000  'max elements in each treeview
Type tshwexp
	Dim bx As HWND     'handle pointed value box
	Dim tv As HWND     'corresponding tree view
	Dim nb As Integer  'number of elements tvrp
	Dim dl As Integer  'delta x size of type
	Dim lb As HWND     'handle of the delta label
End Type
Type tvrp
	nm As String    'name
	ty As Integer   'type
	pt As Integer   'is pointer
	ad As UInteger  'address
	tl As HTREEITEM 'line in treeview
	'iv As Integer   'index of variables 
End Type
Dim Shared As Integer shwexpnb 'current number of show/expand box
Dim Shared As tshwexp shwexp(1 To SHWEXPMAX) 'data for show/expand

Dim Shared As tvrp vrp(SHWEXPMAX,VRPMAX)
'VAR FIND
Type tvarfind
	ty As Integer
	pt As Integer
	nm As String    'var name or description when not a variable
	pr As Integer   'index of running var parent (if no parent same as ivr)
	ad As UInteger
	iv As Integer   'index of running var
	tv As HWND      'handle treeview
   tl As HTREEITEM 'handle line
End Type
Dim Shared As tvarfind varfind

'HIGH LIGHTING keywords
Type tmodif
    lg As Integer
    ps As Integer
End Type
Dim Shared As Integer hgltmax
Dim Shared As Integer hgltpt=0
ReDim Shared hgltdata() As tmodif
Dim Shared As Integer hgltflag=FALSE
'shortcuts
Const SHCUTMAX=130 '2016/06/15
Const VSHIFT=&hF00000
Const VALT  =&hF0000
Const VCTRL =&hF000
Type tshcut
	As Integer sccur
	As HMENU   scmenu
	As Integer scidnt
End Type
Dim Shared As tshcut shcut(SHCUTMAX)
Dim Shared As Integer shcutnb 
'Backtracking
Type tbcktrk
	As Integer bcw
	As Integer frw
End Type
Dim Shared As Integer bcktrkpr
Dim Shared As HWND bcktrkbx

'================ DECLARATIONS ========================================================
Declare Function fb_Toolbar (hwnd As HWND,id As Integer,NumBtns As Integer,Text As String,Bstyles As Integer Ptr =0, _
img As Any Ptr =0,imgidx As Integer Ptr =0,bx As Integer =0,by As Integer =0,Style As Integer =0,ExStyle As Integer =0) As HWND
Declare Function fb_edit(text As String,form1 As HWND,id As Integer,x As Integer, _
y As Integer,w As Integer,h As Integer,ByVal s As Integer = 0,ByVal ex As Integer = -1) As HWND
Declare Function fb_editw(text As WString,form1 As HWND,id As Integer,x As Integer, _
y As Integer,w As Integer,h As Integer,ByVal s As Integer = 0,ByVal ex As Integer = -1) As HWND
Declare Function fb_Label(Text As String,hWnd As HWND,id As Integer=0,X As Integer=0,Y As Integer=0, _
W As Integer=0,H As Integer=0,ByVal Style As Integer=0,ByVal Exstyle As Integer=-1) As HWND
Declare Function fb_Form(t As String,x As Integer =0,y As Integer =0,w As Integer =250,h As Integer =150,s As Integer =0,ex As Integer =0) As HWND
Declare Sub fb_show(hwnd As HWND)
Declare Function fb_RichEdit (t As String,h As HWND,i As Integer,x As Integer,y As Integer,w As Integer,h As Integer,s As Integer=0,x As Integer=-1) As HWND
Declare Function fb_Status (text As String,hand As HWND,id As Integer) As HWND
Declare Function WinMain     ( ByVal hInstance As HINSTANCE, _
                                      ByVal hPrevInstance As Integer, _
                                      szCmdLine As String, _
                                      ByVal iCmdShow As Integer ) As Integer
Declare  Function fb_button(a As String,ByVal hwnd As HWND,ByVal i As Integer=0, ByVal x As Integer =0 _
,ByVal y As Integer =0,ByVal w As Integer =0, ByVal h As Integer =0,s As Integer =0,es As Integer =-1) As HWND
Declare Function fb_CreateTooltips(hControl As HWND, Text As String,Title As String, ToolIcon As Integer) As HWND
Declare Function fb_ModStyle(hWnd As HWND, dwAdd As Integer=0, dwRemove As Integer=0, bEx As Integer =0) As Integer
Declare Function fb_UpDown (hWnd As HWND,X As Integer,Y As Integer,W As Integer,H As Integer,Lo As Integer,Hi As Integer,uStart As Integer=0) As HWND
Declare Function fb_message (title As String ,text As String,style As Integer=0) As Integer
Declare Function fb_Treeview(hwnd As HWND,id As Integer,x As Integer,y As Integer,w As Integer,h As Integer,s As Integer =0,ex As Integer =-1) As HWND
Declare Function fb_Group(t As String,H As HWND,i As Integer,x As Integer,y As Integer,w As Integer,h As Integer,s As Integer =0,e As Integer =0) As HWND
Declare Function fb_Checkbox(t As String,H As HWND,i As Integer=0,x As Integer=0,y As Integer=0,w As Integer=0,h As Integer=0,s As Integer =0,e As Integer =0) As HWND
Declare Function fb_radio(t As String,H As HWND,i As Integer=0,x As Integer=0,y As Integer=0,w As Integer=0,h As Integer=0,s As Integer =0,e As Integer =0) As HWND
Declare Function fb_combobox(H As HWND,i As Integer,x As Integer,y As Integer,w As Integer,h As Integer,s As Integer =0,e As Integer =-1) As HWND
Declare Function fb_listbox(H As HWND,i As Integer,x As Integer,y As Integer,w As Integer,h As Integer,s As Integer =0,e As Integer =-1) As HWND
Declare Function fb_datepick(H As HWND,i As Integer,x As Integer,y As Integer,w As Integer,h As Integer,s As Integer =0,e As Integer =-1) As HWND
Declare Function fb_listview(H As HWND,i As Integer,x As Integer,y As Integer,w As Integer,h As Integer,s As Integer =0,e As Integer =-1) As HWND
Declare Function fb_MDialog (DPro As Any Ptr,title As String,hWnd As HWND,X As Integer,Y As Integer,W As Integer,H As Integer,Style As Integer=0,Exstyle As Integer=0) As Integer
Declare Function fb_Dialog (DPro As Any Ptr,title As String,hWnd As HWND,X As Integer,Y As Integer,W As Integer,H As Integer,Style As Integer=0,Exstyle As Integer=0) As HWND
Declare Function fb_Tab (As HWND,As Integer,As Integer,As Integer,As Integer,As Integer,As Integer=0,As Integer=0) As HWND
Declare Sub tab_add(As Integer,As hwnd,As String)
Declare Sub exrichedit(As Integer)
Declare Function wait_debug() As Integer
Declare Sub load_sources(As Integer)
Declare Sub save_source()
Declare Sub log_show()
Declare Sub log_hide()
Declare Function Tree_AddItem(hParent As HTREEITEM,Text As String,hInsAfter As HTREEITEM,hTV As HWND) As HTREEITEM
Declare Sub dbg_return(a As Integer,l As Integer)
Declare Sub menu_set()
Declare Sub ide_launch()
Declare Sub sel_line(l As Integer,c As Integer=0,d As Integer=0,As HWND=dbgrichedit,As Integer=TRUE)
Declare Sub brk_set(t As Integer)
Declare Sub brk_color(As Integer)
Declare Sub brk_apply()
Declare Sub exe_mod()
Declare Sub dump_set(h As HWND)
Declare Sub bmk_tgl()
Declare Sub bmk_goto(As Integer)
Declare Sub notes_add()
Declare Sub start_pgm(p As Any Ptr)
Declare Sub dsp_hide(t As Integer)
Declare Sub but_enable()
Declare Sub menu_enable()
Declare Function brk_manage (ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Sub watch_set()
Declare Sub watch_sh(aff As Integer=WTCHALL)
Declare Sub watch_sel(As Integer)
Declare Sub watch_del(As Integer=WTCHALL)
Declare Sub watch_exch(As Integer)
Declare Function watch_find()As Integer
Declare Sub watch_array()
Declare Function watch_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Sub watch_add(As Integer,As Integer =-1)
Declare Sub watch_trace(As Integer=WTCHALL)
Declare Sub watch_addtr
Declare Sub brkv_set(a As Integer)
Declare Sub proc_expcol(t As Integer)
Declare Sub var_dump(As HWND,ptd As Long =0)
Declare Sub setvpdmp()
Declare Sub dump_sh()
Declare Function wtext() As String
Declare Sub frground()
Declare Function fb_GetFileName(Title As String, Filt As String,Flag As Integer,hWnd As HWND,Flags As Integer,InitialDr As String) As String
Declare Function find_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function input_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function save_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function dump_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function settings_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function brkv_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function help_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function edit_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function index_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function attach_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function shwexp_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function jit_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function focus_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function tuto_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Function bcktrk_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Sub shwexp_det(As Integer,As UInteger,As Integer,As HTREEITEM,As Integer)
Declare Function shwexp_ini(As Integer,As String,As UInteger,As Integer,As Integer) As Integer
Declare Sub shwexp_new(As HWND)
Declare Sub shwexp_del()
Declare Sub shwexp_arrange()
Declare Sub var_tip(As Integer)
Declare Function prep_var(t As String) As String
Declare Function prep_debug(As String) As String
Declare Sub treat_file(f As String)
Declare Sub ini_read()
Declare Sub crc_init()
Declare Function crc_string(txt As String) As Integer
Declare Function crc_file(fname As String) As String
Declare Sub winmsg()
Declare Sub dechexbin()
Declare Sub line_goto()
Declare Sub dump_update(As NMITEMACTIVATE Ptr)'NMLISTVIEW '20/11/2014
Declare Sub dump_sel(lvp As NMITEMACTIVATE Ptr)
Declare Sub show_context()
Declare Sub cutup_udt(As String)
Declare Sub cutup_enum(As String)
Declare Sub cutup_1(As String,As UInteger,As Integer=0)
Declare Sub cutup_2(As String,As Byte)
Declare Function cutup_proc(As String) As String
Declare Function cutup_op (As String) As String
Declare Function cutup_array(As String,As Integer,As Byte) As Integer
Declare Function cutup_scp(As Byte,As UInteger,deltadll As Integer=0) As Integer
Declare Sub cutup_retval(As Integer,As String)
Declare Function Common_exist(As UInteger) As Integer
Declare Sub dbg_prt (As String)
Declare Sub var_iniudt(As UInteger,As UInteger,As HTREEITEM,As UInteger,As UByte)'09/07/2015
Declare Function var_sh2(As Integer,As UInteger, As UByte=0,As String="") As String
Declare Function var_add(As String,As Integer,As Integer)As String
Declare Sub gest_brk(As UInteger)
Declare Sub debug_extract(As UInteger,As String,As Long=NODLL)
Declare Function name_extract(As String) As String
Declare Sub brk_del(As Integer)
Declare Sub proc_new()
Declare Sub proc_watch(As Integer)
Declare Sub proc_end()
Declare Sub globals_load(As Integer=0)
Declare Sub ini_write()
Declare Sub proc_sh()
Declare Sub proc_activ(As HTREEITEM)
Declare Sub proc_flw(As Byte)
Declare Sub thread_check(As HTREEITEM)
Declare Function proc_find(As Integer,As Byte) As Integer
Declare Function proc_verif(As UShort) As Byte
Declare Sub var_ini(As UInteger, As Integer , As Integer)
Declare Sub var_sh()
Declare Sub fastrun()
Declare Sub proc_del(As Integer,As Integer=1)
Declare Sub proc_newfast()
Declare Function proc_retval(As Integer) As String
Declare Function fb_Set_Font (Font As String,Size As Integer,Bold As Integer=0,Italic As Integer=0,Underline As Integer=0,StrikeThru As Integer=0) As HFONT
Declare Function proc_name(ad As UInteger) As String
Declare Sub proc_loc()
Declare Sub proc_update()
Declare Function fb_LoadBMP (F As String,i As Integer=0) As HBITMAP
Declare Sub dsp_size()
Declare Function excep_lib(As Integer) As String
Declare Sub dbg_attach(p As Any Ptr)
Declare Sub string_sh(As HWND)
Declare Sub thread_change(As Integer=-1)
Declare Function enum_find(As Integer,As Integer) As String
Declare Function var_find2(As HWND) As Integer
Declare Sub enum_check(As Integer)
Declare Sub enum_show(As HWND)
Declare Sub font_change(As String="",As Integer=0)
Declare Sub drag_exe(As handle)
Declare Function kill_process(As String) As Integer
Declare Sub dsp_sizecalc()
Declare Sub compinfo_sh()
'Declare Function messageboxw Lib "libuser32" Alias "MessageBoxW" (ByVal As HWND, ByVal As LPCWSTR, ByVal As LPCWSTR, ByVal As UINT) As Integer
'Declare Function setwindowtextw Lib "libuser32" Alias "SetWindowTextW" (ByVal As HWND, ByVal As LPCWSTR) As BOOL
'Declare Function CreateWindowExW Lib "libuser32" Alias "CreateWindowExW" (ByVal As DWORD, _
' ByVal As LPCWSTR, ByVal As LPCWSTR, ByVal As DWORD, ByVal As Integer, ByVal As Integer, _
' ByVal As Integer, ByVal As Integer,  ByVal As HWND, ByVal As HMENU, ByVal As HINSTANCE, ByVal As LPVOID) As HWND
Declare Sub exe_sav(exename As String,cmdline As String) 
Declare Sub dsp_access(shwtab As Integer) 
Declare Sub dsp_noaccess()
Declare Sub help_manage(As Integer=0) 'replace help_start
Declare Function var_search(pproc As Integer,text() As String,vnb As Integer,varr As Integer,As Integer=0) As Integer
Declare Function var_sh1(As Integer) As String
Declare Sub watch_sav()
Declare Sub brk_sav()
Declare Function fb_FontDlg (As HWND) As Integer
Declare Function color_change(As Integer) As Integer 
Declare Sub hglt_lines(As Integer,As Integer)
Declare Sub hglt_data(nline As Integer,src As Integer, datas() As tmodif, cptk As Integer)
Declare Sub translate_gcc(As String)
Declare Sub zstringbyte_exchange()
Declare Sub proc_loccall(typ As Integer=1)
Declare Sub thread_kill()
Declare Sub thread_execline(As Integer,As Integer=0)
Declare Sub line_adr
Declare Sub thread_expcol(As Integer)
Declare Sub thread_text(As Integer=-1)
Declare Sub thread_procloc(As Integer)
Declare Sub procvar_list(As Integer=0)
Declare Sub surround(hdl As HWND,x As Integer=-1,y As Integer=0,w As Integer=0,h As Integer=0)
Declare Sub decode_help(dData As  HELPINFO Pointer)
Declare Sub str_replace(strg As String,srch As String, repl As String)
Declare Function dll_name(FileHandle As HANDLE,t As Integer =1 )As String
Declare Sub shcut_display(As Integer,As HWND,As HWND,As HWND,As HWND)
Declare Function shcut_txt(As Integer,As Integer) As String
Declare Function shcut_check(As Integer,As Integer)As Integer
Declare Function menu_gettxt(As HMENU,As Integer) As String
Declare Sub menu_update(As Integer,As String="")
Declare Function parse_typeope(As long)As String
Declare Function dissassemble(hedit As HWND,scop As Integer)As Integer
Declare Sub bcktrk_proc(prr As Integer,ByRef bcktrk As tbcktrk,typ As Integer,lblcur As HWND,lblprev As HWND,lblnext As HWND,butprev As HWND,butnext As HWND)
Declare Sub bcktrk_close()
Declare Sub bcktrk_launch(pr As Integer,typ As Integer)
Declare Sub bx_closing()
Declare Function dw_extract(As String,As UInteger) As Long 
Declare Sub char_sh(tv As HWND) '03/11/2014
Declare Sub regs_data(thd As handle,reg_values() As String) '25/08/2015
Declare Function procvar_box(ByVal hWnd As HWND,ByVal Msg As UInteger,ByVal wparam As Integer,ByVal lParam As Integer) As Integer
Declare Sub array_tracking(t As short) ''2016/06/15
Declare Sub array_tracking_remove
Declare Function  local_exist As Long
Declare sub dw_lastline_procs(reinit As Long=0)
'========================================
'
If CreateSemaphore(0, 0, 1,"FBdebugger" )<>0 And GetLastError() = ERROR_ALREADY_EXISTS Then
   If fb_message("Starting FBdebugger","An other occurence is already running."+Chr(13)+"Continue ?", _
   MB_YESNO Or MB_ICONQUESTION Or MB_SYSTEMMODAL Or MB_DEFBUTTON1) = IDNO Then End 1
End If

End WinMain( Cast(HINSTANCE,GetModuleHandle( 0 )),0, Command, SW_NORMAL )

'=================================================
private sub fb_win()
	Dim  As Integer l
	Dim As Long pstatus(4)={120,220,470,700,-1} '08/04/2014 520-->470 add 670
	Dim As UInteger tabstop=8
	windmain = fb_Form ( "DEBUG "+ver3264, 0, 0,900, 590)',WS_MINIMIZEBOX or WS_CAPTION Or WS_SYSMENU)
	DragAcceptFiles(windmain, TRUE)
	butstep = fb_button("",windmain, IDBUTSTEP, 8, 0, 30, 26)
	fb_CreateTooltips(butstep, "[S] 𲽵", "FBDEBUGGER",0)
	 fb_ModStyle(butstep,BS_BITMAP) 'add BS_BITMAP
	 'bmb(0)=LoadImage(fb_hinstance,"step.bmp",IMAGE_BITMAP,23,19,LR_LOADFROMFILE) kept for example
	 bmb(0)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1000)))
	 SendMessage(butstep, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(0)))
	 
	 butcont = fb_button("",windmain,IDCONTHR, 40, 0, 30, 26)' >+ 18
	 fb_CreateTooltips(butcont, "[C] е괦", "",0)
	 fb_ModStyle(butcont,BS_BITMAP)
	 bmb(1)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1001)))
	 SendMessage(butcont, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(1)))
	 
	 butstepp = fb_button("",windmain,IDBUTSTEPP, 72, 0, 30, 26)' >+ 18
	 fb_CreateTooltips(butstepp, "[O]  ̻", "",0)
	 fb_ModStyle(butstepp,BS_BITMAP)
	 bmb(2)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1002)))
	 SendMessage(butstepp, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(2)))

	 butstept = fb_button("",windmain,IDBUTSTEPT, 104, 0, 30, 26)
	 fb_CreateTooltips(butstept, "[T] һ ̻", "",0)
	 fb_ModStyle(butstept,BS_BITMAP)
	 bmb(22)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1022)))
	 SendMessage(butstept, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(22)))
	 
	 butstepb = fb_button("",windmain,IDBUTSTEPB, 136, 0, 30, 26)
	 fb_CreateTooltips(butstepb, "[B] е ̻ ײ", "",0)
	 fb_ModStyle(butstepb,BS_BITMAP)
	 bmb(23)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1023)))
	 SendMessage(butstepb, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(23)))

	 butstepm = fb_button("",windmain,IDBUTSTEPM, 168, 0, 30, 26)
	 fb_CreateTooltips(butstepm, "[E] ˳ǰ ̻", "",0)
	 fb_ModStyle(butstepm,BS_BITMAP)
	 bmb(3)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1003)))
	 SendMessage(butstepm, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(3)))
	
	 butauto = fb_button("AUTO", windmain,IDBUTAUTO, 200, 0, 30, 26)
	 fb_CreateTooltips(butauto, "[A] Զ [H] ֹͣ", "",0)
	 fb_ModStyle(butauto,BS_BITMAP)
	 bmb(4)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1004)))
	 SendMessage(butauto, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(4)))
	
	 butrun = fb_button("RUN",windmain, IDBUTRUN, 232, 0, 30, 26)
	 fb_CreateTooltips(butrun, "[R]  [H] ж", "",0)
	 fb_ModStyle(butrun,BS_BITMAP)
	 bmb(5)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1005)))
	 SendMessage(butrun, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(5)))
	
	 butstop = fb_button("HALT",windmain, IDBUTSTOP, 264, 0, 30, 26)
	 fb_CreateTooltips(butstop, "[H] ͣPGM", "",0)
	 fb_ModStyle(butstop,BS_BITMAP)
	 bmb(6)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1006)))
	 SendMessage(butstop, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(6)))
	
	 butmini = fb_button("MINI",windmain, IDBUTMINI,296, 0, 30, 26)
	 fb_CreateTooltips(butmini, "㴰", "",0)
	 fb_ModStyle(butmini,BS_BITMAP)
	 bmb(7)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1007)))
	 SendMessage(butmini, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(7)))
	
	 butfree = fb_button("free",windmain, IDBUTFREE,392, 0, 30, 26)
	 fb_CreateTooltips(butfree, "ͷŵԵĳ", "",0)
	 fb_ModStyle(butfree,BS_BITMAP)
	 bmb(8)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1008)))
	 SendMessage(butfree, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(8)))
	
	 Butkill = fb_button("KILL",windmain, IDBUTKILL,424, 0, 30, 26)
	 fb_CreateTooltips(Butkill, "[K] ɱ  ע⡿", "",0)
	 fb_ModStyle(butkill,BS_BITMAP)
	 bmb(9)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1009)))
	 SendMessage(butkill, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(9)))
	
	 Butrrune = fb_button("EXE>>",windmain, IDBUTRRUNE,466, 0, 30, 26)
	 fb_CreateTooltips(Butrrune, " (exe)", "",0)
	 fb_ModStyle(butrrune,BS_BITMAP)
	 bmb(10)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1010)))
	 SendMessage(butrrune, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(10)))
	 
	 Butlstexe = fb_button("EXE>>",windmain, IDLSTEXE,498, 0, 30, 26)
	 fb_CreateTooltips(Butlstexe, "ʹù 10  exe ļ", "",0)
	 fb_ModStyle(Butlstexe,BS_BITMAP)
	 bmb(11)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1011)))
	 SendMessage(Butlstexe, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(11)))
	 
	 Butattch = fb_button("ATT>>",windmain, IDBUTATTCH,530, 0, 30, 26)
	 fb_CreateTooltips(Butattch, "г", "",0)
	 fb_ModStyle(butattch,BS_BITMAP)
	 bmb(12)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1012)))
	 SendMessage(butattch, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(12)))
	 
	 Butfile = fb_button("FILE",windmain, IDBUTFILE,562, 0, 30, 26)
	 fb_CreateTooltips(Butfile, "ѡ EXE/BAS", "",0)
	 fb_ModStyle(butfile,BS_BITMAP)
	 bmb(13)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1013)))
	 SendMessage(butfile, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(13)))
	
	 butnotes=fb_button("NOTES",windmain, IDNOTES,600,0, 30, 26)
	 fb_CreateTooltips(butnotes,"򿪻رձʼ", "",0)
	 fb_ModStyle(butnotes,BS_BITMAP)
	 bmb(14)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1014)))
	 SendMessage(butnotes, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(14)))
	
	 Buttool = fb_button("TOOLS",windmain, IDBUTTOOL,632, 0, 30, 26)
	 fb_CreateTooltips(Buttool, "һЩõĹ", "",0)
	 fb_ModStyle(buttool,BS_BITMAP)
	 bmb(15)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1015)))
	 SendMessage(buttool, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(15)))
	 
	 Butexemod = fb_button("EXE MOD",windmain, IDEXEMOD,360, 0, 30, 26)
	 fb_CreateTooltips(Butexemod, "[M] ڹ޸ĺִ ע⡿ ", "",0)
	 fb_ModStyle(Butexemod,BS_BITMAP)
	 bmb(16)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1016)))
	 SendMessage(Butexemod, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(16)))
	 
	 Butfastrun = fb_button("Fast Run",windmain, IDFASTRUN,328, 0, 30, 26)
	 fb_CreateTooltips(Butfastrun, "[F] е괦 ע⡿", "",0)
	 fb_ModStyle(Butfastrun,BS_BITMAP)
	 bmb(17)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1017)))
	 SendMessage(Butfastrun, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(17)))

	 butenlrsrc = fb_button("Source",windmain, ENLRSRC,690, 0, 30, 26)
	 fb_CreateTooltips(butenlrsrc,"ŴСԴ", "",0)
	 fb_ModStyle(butenlrsrc,BS_BITMAP)
	 bmb(18)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1018)))
	 SendMessage(butenlrsrc, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(18)))

	 butenlrvar = fb_button("VarProc",windmain, ENLRVAR,720, 0, 30, 26)
	 fb_CreateTooltips(butenlrvar, "Ŵ/С proc/var", "",0)
	 fb_ModStyle(butenlrvar,BS_BITMAP)
	 bmb(19)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1019)))
	 SendMessage(butenlrvar, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(19)))


	 butenlrmem = fb_button("Memory",windmain,ENLRMEM,750,0, 30, 26)
	 fb_CreateTooltips(butenlrmem, "Ŵ/С dump memory", "",0)
	 fb_ModStyle(butenlrmem,BS_BITMAP)
	 bmb(20)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1020)))
	 SendMessage(butenlrmem, BM_SETIMAGE, IMAGE_BITMAP, Cast(LPARAM,bmb(20)))

	 bmb(21)=Loadbitmap(fb_hinstance,Cast(LPSTR,MAKEINTRESOURCE(1021))) 'if notes changes
	 
	' next line just to see it works
	'fb_createtooltips(dbgEdit1, "See your source", "",0)
	
	'TimerID1    = SetTimer (windmain, 1,10,NULL) 'not used if 2 threads
	
	hTab2       = fb_Tab(windmain,TAB2,478,43,315,25)
	
	fonthdl=fb_Set_Font(fontname,fontsize,,TRUE)
	fontbold=fb_Set_Font(fontname,fontsize,FW_SEMIBOLD,TRUE) 'in bold
	tviewvar   = fb_Treeview (windmain,TVIEW1,478,65,315,365) 'procr/var
	SendMessage(tviewvar,WM_SETFONT,Cast(WPARAM,fonthdl),0)
   tviewcur=tviewvar
   tab_add(0,htab2,"Proc/var")
   
   tviewprc   = fb_Treeview (windmain,TVIEW2,478,65,315,365) 'procr
   SendMessage(tviewprc,WM_SETFONT,Cast(WPARAM,fonthdl),0)
   Dim dwStyle As Long =GetWindowLong(tviewprc, GWL_STYLE)
   SetWindowLong(tviewprc,GWL_STYLE,dwStyle Or TVS_CHECKBOXES)
   ShowWindow(tviewprc,SW_HIDE)
   tab_add(1,htab2,"")
   
   tviewthd   = fb_Treeview (windmain,TVIEW3,478,65,315,365) 'thread
   SendMessage(tviewthd,WM_SETFONT,Cast(WPARAM,fonthdl),0)
   dwStyle=GetWindowLong(tviewthd, GWL_STYLE)
   SetWindowLong(tviewthd,GWL_STYLE,dwStyle Or TVS_CHECKBOXES)
   ShowWindow(tviewthd,SW_HIDE)
   tab_add(2,htab2,"߳")
   
   tviewwch   = fb_Treeview (windmain,TVIEW4,478,65,315,365) 'watch
   SendMessage(tviewwch,WM_SETFONT,Cast(WPARAM,fonthdl),0)
   ShowWindow(tviewwch,SW_HIDE)
   tab_add(3,htab2,"ֵ")
   
   hTab1       = fb_Tab(windmain,TAB1,3,43,475,25)
	tab_add(0,htab1,"Դ")
	
	For i As Integer=0 To MAXSRC
	richedit(i) = fb_RichEdit("fb Edit Box",windmain,IDRICHWIN,3,65,475,363)',WS_CHILD or WS_VISIBLE or ES_WANTRETURN or WS_VSCROLL or WS_HSCROLL or ES_MULTILINE or ES_AUTOVSCROLL or ES_AUTOHSCROLL or ES_READONLY)
	SendMessage(richedit(i),WM_SETFONT,Cast(WPARAM,fonthdl),0)
	SendMessage(richedit(i),EM_SETEVENTMASK,0,ENM_KEYEVENTS Or ENM_MOUSEEVENTS)
	sendmessage(richedit(i),EM_SETTABSTOPS,1,Cast(LPARAM,@tabstop))
	sendmessage(richedit(i),EM_SETBKGNDCOLOR,0,clrrichedit)
	ShowWindow(richedit(i),SW_HIDE)
	Next
	dbgrichedit=richedit(0)
	

    
	'used to put margins
'SendMessage( dbgrichedit, EM_SETMARGINS, EC_LEFTMARGIN, 70 )
	ShowWindow(dbgrichedit,SW_SHOW)
	''setWindowText(dbgrichedit,"Source")
	
	hcurline   = fb_Label("ǰУ",windmain,IDCURLIG,3,28,790,16)
	fb_CreateTooltips(hcurline, "뵱ǰ", "",0)
	
	'bookmark handle
	bmkh = fb_combobox(windmain,IDBMKCMB,3,430,790,100)
 
	wtch(0).hnd = fb_Label("쿴 1",windmain,IDWATCH1,3,448,395,16)
	wtch(1).hnd = fb_Label("쿴 2",windmain,IDWATCH2,398,448,395,16)
	wtch(2).hnd = fb_Label("쿴 3",windmain,IDWATCH3,3,464,395,16)
	wtch(3).hnd = fb_Label("쿴 4",windmain,IDWATCH4,398,464,395,16)
	For l=0 To 3
		fb_CreateTooltips(wtch(l).hnd, "ѡ"+Chr(13)+"Ҽ", "",0)
	Next
	 
	 brkvhnd=fb_Label("Break on var",windmain,IDBRKVAR,3,480,790,16)
	 fb_CreateTooltips(brkvhnd, "", "",0)
	
	dbgEdit1   = fb_edit("",windmain,IDNOTEWIN,3,430,790,143,WS_CHILD Or _
	ES_WANTRETURN Or WS_VSCROLL Or WS_HSCROLL Or ES_MULTILINE Or ES_AUTOVSCROLL Or ES_AUTOHSCROLL )
	'or ES_READONLY)
	fb_ModStyle(dbgEdit1,0,WS_EX_NOPARENTNOTIFY,1)
	
	 dbgstatus=fb_Status ("û־",windmain, IDSTATUS)
	 SendMessage(dbgstatus,SB_SETPARTS,5,Cast(LPARAM,@pstatus(0))) '08/04/2014 4-->5
	 listview1=fb_listview(windmain,IDDUMP,3,496,790,37)
	
	 dump_set(listview1)
	 menu_set()
	 but_enable() 'some buttons disabled as no running prgm
	 menu_enable() 'disable some options
	 EnableMenuItem(menutools,IDHIDLOG,MF_GRAYED)
	 'redrawwindow(windmain,0,0,0)

#Ifdef __FB_64BIT__ 
	If Dir(ExePath+"\objdump.exe")="" Then fb_message("FBDEBUGGER 64BIT","Don't forget : objdump.exe must be in the same directory as fbdebugger"_
	+Chr(13)+"it's necessary for extracting debugging data"+Chr(13)+"otherwise no debugging could be possible")
#EndIf
'-------------- pour test toolbar -------------------------------
'dim as string tbText = "||Open|Save||New|Options|About||Exit"
'dim as integer ImIdx(9)={STD_FILEOPEN,STD_PROPERTIES,STD_COPY,STD_FILENEW,STD_HELP,STD_DELETE,IDB_STD_SMALL_COLOR}
'fb_TOOLBAR(windmain,900,6,"-",0,HINST_COMMCTRL,@ImIdx(0))
'fb_TOOLBAR(windmain,900,4,tbText,,,,20,15)

'dim as integer Btnstyles(7)={0,TBSTYLE_CHECK,TBSTYLE_CHECKGROUP,TBSTYLE_CHECKGROUP,TBSTYLE_CHECKGROUP,0}

'dim bm AS HBITMAP
'bm=LoadImage(fb_hinstance,"step_over.bmp",IMAGE_BITMAP,23,19,LR_LOADFROMFILE)
'fb_TOOLBAR(windmain,900,1,"-",@Btnstyles(0),bm)
'DeleteObject(cast(HGDIOBJ,bm)) a rajouter en fin de proc
'----------------- fin test toolbar ---------------------------------
   dsp_size()
   fb_show(windmain)
   ini_read() 'where find FBC.exe
   If Command<>"" Then treat_file("") 'case command line exe see treat_file
End Sub
'=======================================================
'Syntax:
' HWND = fb_TOOLBAR(HWND,ID,NumBtns,Text$="",BtnStyles=0,HBITMAP=0,ImgIndex=0,BtnWidth=0,BtnHeig
'ht=0,Style=0,ExStyle=0)
'
'          HWND     - Parent Handle
'          ID       - Toolbar control ID - each button will be consecutively
'                     numbered following this number.
'          NumBtns  - Number of buttons on the toolbar
'          Text$    - An optional string of names for the buttons
'                     In the format of name1|name2 each separated by a |
'                     Each additional | will place separators (spaces)
'                     between those buttons name1|||name2 will place 2
'                     spaces between names 1 and 2.
'         BtnStyles - Optional array specifying the style of each button.
'         HBITMAP   - Optional handle to a bitmap to be placed on each button.
'         ImgIndex  - An optional array specifying the order the bitmaps are
'                     placed on the buttons. The default will be in the order
'                     the bitmap is supplied in. This also allows use of
'                     windows built in images.
'                     Special note: The last entry in the index when using the
'                     built in images should be the image list.
'                     i.e. IDB_STD_LARGE_COLOR Check the WIn API Help and the
'                     example for the available options. For the HBITMAP enter
'                     HINST_COMMCTRL.
'        BtnWidth   - The width and height of each button. This only has an effect
'        BtnHeight    if no text is being used. In which case the ??? name
'                     determines the button width.
'        Style      - Optional Styles and extended styles for the toolbar.
'        ExStyle
'-------------------------------------------------------------------------------
'Example #1 The minimum needed for a standard button bar with text labels
'-------------------------------------------------------------------------------
'            HWND = FB_TOOLBAR(HWND,ID,4,"OPEN|SAVE|SETUP|QUIT")
'-------------------------------------------------------------------------------
'Example #2 The minimum needed for a standard button bar with text labels and
'           built in windows icons.
'-------------------------------------------------------------------------------
'tbText$ = "||Open|Save||New|Options|About||Exit"

'SET ImIdx[]
'STD_FILEOPEN,STD_FILESAVE,STD_COPY,STD_FILENEW,STD_HELP,STD_DELETE,IDB_STD_SMALL_COLOR
'END SET
'
'            HWND  = fb_TOOLBAR(Form1,ID,6,tbText$,0,HINST_COMMCTRL,ImIdx)

'autre exemple
'   SET Btnstyles[]
'   0,TBSTYLE_CHECK,TBSTYLE_CHECKGROUP,TBSTYLE_CHECKGROUP,TBSTYLE_CHECKGROUP,0
'   END SET
'   RAW tbText$
'   tbText$ = "||Open|Save||New|Options|About||Exit"
'   RAW bm AS HBITMAP
'   bm = fb_LOADBMP("testtool.bmp",0,1)
'   hToolBar  = fb_TOOLBAR(Form1,ID_Toolbar,6,tbText$,Btnstyles,bm)
'======================================================================



'=============================================
private function WndProc ( ByVal hWnd As HWND, _
                   ByVal message As Integer, _
                   ByVal wParam As Integer, _
                   ByVal lParam As Integer ) As Integer
                   WndProc=0
                   
                   Static x As Integer,y As Integer,pnt As Point,hbrsh As HBRUSH
                   
   If flagtuto=1 Then 
   	If message<>WM_DESTROY Then Return DefWindowProc( hWnd, message, wParam, lParam )
   ElseIf flagtuto=2 Then
   	flagtuto=1
   EndIf
                   
    Select Case message
   	Case WM_CREATE

      Case WM_LBUTTONDOWN
            'only if mini screen
            If dsptyp>99 Then
                SetCapture(windmain)
                x = LoWord(lParam)
                y = HiWord(lParam)
            End If
          Case WM_MOUSEMOVE
          If  wParam = MK_LBUTTON And dsptyp>99 Then
           GetCursorPos(@pnt)
           SetWindowPos(windmain, 0, pnt.x - x, pnt.y - y, 0, 0, SWP_NOSIZE Or SWP_NOZORDER)
          End If
          Case WM_LBUTTONUP
          ReleaseCapture()
        Case WM_CONTEXTMENU ' right click
            GetCursorPos(@pnt)
            If wparam=dbgrichedit Then
              TrackPopupMenuEx(menuedit, TPM_LEFTALIGN Or TPM_RIGHTBUTTON, pnt.x, pnt.y, hWnd,ByVal NULL)
              PostMessage(windmain, WM_NULL, 0, 0)
            ElseIf wparam=tviewvar Then
              TrackPopupMenuEx(menuvar, TPM_LEFTALIGN Or TPM_RIGHTBUTTON, pnt.x, pnt.y, hWnd,ByVal NULL)
              PostMessage(windmain, WM_NULL, 0, 0)
            ElseIf wparam=tviewprc Then
              	TrackPopupMenuEx(menuproc, TPM_LEFTALIGN Or TPM_RIGHTBUTTON, pnt.x, pnt.y, hWnd,ByVal NULL)
              	PostMessage(windmain, WM_NULL, 0, 0)
            ElseIf wparam=tviewthd Then
            	TrackPopupMenuEx(menuthread, TPM_LEFTALIGN Or TPM_RIGHTBUTTON, pnt.x, pnt.y, hWnd,ByVal NULL)
            	PostMessage(windmain, WM_NULL, 0, 0)
            ElseIf wparam=tviewwch Then
            	If wtchcpt Then
              		TrackPopupMenuEx(menuwatch, TPM_LEFTALIGN Or TPM_RIGHTBUTTON, pnt.x, pnt.y, hWnd,ByVal NULL)
              		PostMessage(windmain, WM_NULL, 0, 0)
            	Else
            		fb_message("Context menu for watched var list","Watched var list is empty"+Chr(13)+"Nothing to do")
            	End If
            ElseIf wparam=listview1 And prun Then
                If hdumpbx=0 Then
                    fb_Dialog(@dump_box,"Manage dump",windmain,283,25,120,150)
                    PostMessage(windmain, WM_NULL, 0, 0)
                End If
            Else 'Erase watch ?
            	For i As Integer =0 To WTCHMAIN
            		If wparam=wtch(i).hnd Then watch_del(i):Exit For
            	Next
            End If
    	Case WM_KEYDOWN
		   Dim As Integer	sccheck=wparam+(getkeystate(VK_CONTROL) And &h8000)/&h8000*&hF000+(getkeystate(VK_MENU) And &h8000)/&h8000*&hF0000+(getkeystate(VK_SHIFT) And &h8000)/&h8000*&hF00000
		   For i As Integer =0 To shcutnb-1 
		  		If sccheck=shcut(i).sccur Then
					If GetMenuState(shcut(i).scmenu,shcut(i).scidnt,MF_BYCOMMAND)=0 Then
						SendMessage(windmain,WM_COMMAND,makelong(shcut(i).scidnt,BN_CLICKED),0):Return TRUE
					EndIf
		    		Exit For
		  		EndIf
		   Next
    	Case WM_DROPFILES
    		drag_exe(Cast(handle,wParam))
      Case WM_COMMAND
         Select Case LoWord(wparam)
         	Case IDBUTSTEP 'STEP
                        stopcode=0
                        bcktrk_close
                        SetFocus(windmain) 'just to lose focus
                        thread_rsm()
         	Case IDBUTSTEPP 'STEP+ over
                        procin=procsk
                        runtype=RTRUN
                        but_enable()
                        bcktrk_close
                        SetFocus(windmain)
                        thread_rsm()
         	Case IDBUTSTEPM 'STEP- out
                        If (threadcur<>0 andalso proc_find(thread(threadcur).id,KLAST)<>proc_find(thread(threadcur).id,KFIRST)) _
                        OrElse (threadcur=0 AndAlso proc(procr(proc_find(thread(0).id,KLAST)).idx).nm<>"main") Then 'impossible to go out first proc of thread, constructore for shared 22/12/2015
                            procad=procsv
                            runtype=RTRUN
                            but_enable()
                        End If
                        bcktrk_close
                        SetFocus(windmain)
                        thread_rsm()
         	Case IDBUTSTEPB 'STEP at bottom of proc
									If rline(thread(threadcur).sv).ad<>proc(procsv).fn Then 'if current line is end of proc simple step
									  procbot=procsv
									  runtype=RTRUN
									  but_enable()
									EndIf
									bcktrk_close
                        SetFocus(windmain)
                        thread_rsm()
         	Case IDBUTSTEPT 'STEP at top of proc
								If rline(thread(threadcur).sv).ad<>proc(procsv).fn Then 'if current line is end of proc simple step
									  proctop=TRUE
									  runtype=RTRUN
									  but_enable()
								EndIf
								bcktrk_close
                        SetFocus(windmain)
                        thread_rsm()
         	Case IDBUTAUTO,IDTHRDAUT 'simple and multi thread auto
         				   threadaut=0
			         		If LoWord(wparam)=IDTHRDAUT Then
									For i As Integer =0 To threadnb
										If thread(i).exc Then threadaut+=1
									Next
									If threadaut<2 Then fb_message("Automatic execution","Not enough selected thread so normal auto")
								EndIf
			               runtype=RTAUTO
			               but_enable()
			               bcktrk_close
			               SetFocus(windmain)
			               thread_rsm()
            Case IDBUTRUN
			               runtype=RTRUN
			               but_enable()
			               bcktrk_close
			               SetFocus(windmain)
			               fasttimer=Timer
			               thread_rsm()
         	Case IDFASTRUN
         					bcktrk_close
         					but_enable()
         					SetFocus(windmain)
         					fastrun()
            Case IDBUTSTOP
                        If runtype=RTFREE Or runtype=RTFRUN Then
                        	runtype=RTFRUN 'to treat free as fast
                        	For i As Integer = 1 To linenb 'restore every breakpoint
                					WriteProcessMemory(dbghand,Cast(LPVOID,rline(i).ad),@breakcpu,1,0)
                				Next
                        Else
                        	runtype=RTSTEP:procad=0:procin=0:proctop=FALSE:procbot=0
                        EndIf
                        Stopcode=CSHALTBU
                        SetFocus(dbgrichedit)
           Case IDBUTMINI
                        If dsptyp>99 Then 'set full screen
                        	dsptyp-=100
                           DeleteObject(Cast(HGDIOBJ,hbrsh))
                           fb_ModStyle (windmain,WS_MAXIMIZEBOX Or WS_MINIMIZEBOX Or WS_SIZEBOX Or WS_CAPTION Or WS_SYSMENU, 0,FALSE)
                           SetWindowPos(windmain,HWND_NOTOPMOST,recsav.left,recsav.top,recsav.right-recsav.left,recsav.bottom-recsav.top,SWP_NOACTIVATE)' OR SWP_NOSIZE OR SWP_NOMOVE
                        Else 'set mini screen
                        	dsptyp+=100
                        	GetWindowRect(windmain,@recsav)
                           fb_ModStyle (windmain,0,WS_MAXIMIZEBOX Or WS_MINIMIZEBOX Or WS_SIZEBOX Or WS_CAPTION Or WS_SYSMENU, FALSE)
                           hbrsh=createsolidbrush(&h0000FF) 'red background
                           'changed for 64bit
                           'SetClassLong(windmain,GCL_HBRBACKGROUND,Cast(Long,hbrsh))
                           SetClassLongPtr(windmain,GCLP_HBRBACKGROUND,Cast(Long_Ptr,hbrsh))
                           
                           SetWindowPos(windmain,HWND_TOPMOST,50,50,456,45,SWP_NOACTIVATE ) ' OR SWP_NOSIZE OR SWP_NOMOVE
                        End If
                        SetFocus(windmain)
           Case IDBUTTOOL
               GetCursorPos(@pnt)
               If Dir(ExePath+"\dbg_log_file.txt")="" Then 'the file can be deleted by user outside
						EnableMenuItem(menutools,IDSHWLOG,MF_GRAYED)
						EnableMenuItem(menutools,IDDELLOG,MF_GRAYED)
               Else
               	EnableMenuItem(menutools,IDSHWLOG,MF_ENABLED)
						EnableMenuItem(menutools,IDDELLOG,MF_ENABLED)
               End If
               TrackPopupMenuEx(menutools, TPM_LEFTALIGN Or TPM_RIGHTBUTTON, pnt.x, pnt.y, hWnd,ByVal NULL)
               PostMessage(windmain, WM_NULL, 0, 0)
               SetFocus(windmain)
           Case IDBUTFILE
                treat_file("?_NO$FILE_$?") 'hope that nobody uses a such name ;-)
                SetFocus(windmain)
           Case IDRICHWIN  'click sur dbgrichEdit prvoir remettre ligne en cours
                       'tester pour uniquement mouse sur client area
           Case IDNOTEWIN
         		If HiWord(wparam)=EN_CHANGE Then
         			If SendMessage(dbgedit1,EM_GETMODIFY,0,0) Then
         				SendMessage(butnotes,BM_SETIMAGE,IMAGE_BITMAP,Cast(LPARAM,bmb(21)))
         			EndIf
         		EndIf
         		'SetFocus(windmain)
         	Case IDBUTRRUNE  'restart exe
           		Dim As Double dtempo=FileDateTime(exename)
           		If exedate<>0 AndAlso exedate=dtempo Then
           			flagrestart=sourcenb
           		EndIf
           		If wtchcpt Then flagwtch=1 
               treat_file(exename)
         	Case IDLSTEXE 'last 10 EXE(s)   
               GetCursorPos(@pnt)
               Dim exelist As HMENU
               exelist = CreatepopupMenu()
               For i As Byte =0 To 9
               	If savexe(i)<>"" Then AppendMenu(exelist, MF_STRING,1200+i,savexe(i)):If i=0 Then AppendMenu(exelist, MF_SEPARATOR, 0, "")
               Next
               TrackPopupMenuEx(exelist, TPM_LEFTALIGN Or TPM_RIGHTBUTTON, pnt.x, pnt.y, hWnd,ByVal NULL)
               destroymenu(exelist)
               PostMessage(windmain, WM_NULL, 0, 0)
           Case 1200 To 1209   
                exename=savexe(LoWord(wparam)-1200)
                treat_file(exename)
         	Case IDBUTATTCH  'attach running process
                If prun AndAlso kill_process("Trying to attach but debuggee still running")=FALSE Then
                        'nothing to do but better algo
         		Else
         			GetCursorPos(@pnt)
             		fb_MDialog(@attach_box,"Attachment to a running process",windmain,pnt.x-300,pnt.y,100,150)
             	End If 
         	Case IDBUTFREE
                If fb_message("FREE","Release debugged prgm",MB_YESNO Or MB_ICONQUESTION)=IDYES Then
                	For i As Integer = 1 To linenb 'restore old instructions
                		WriteProcessMemory(dbghand,Cast(LPVOID,rline(i).ad),@rLine(i).sv,1,0)
                	Next
                	runtype=RTFREE
                	but_enable()
                	thread_rsm()
                End If
         	Case IDBUTKILL  'kill process
						kill_process("Terminate immediatly no saved data, other option Release")
         	Case IDCMDLPRM   'open settings
                fb_MDialog(@settings_box,"Settings",windmain,50,25,337,196)
            Case IDABOUT '24/08/2015
               If fb_message("FB DEBUGGER "+ver3264,"Debugger for FreeBASIC (only Win32/64)"+Chr(13)+Chr(13)+fbdebuggerversion+" / "+__DATE__+Chr(13)+"(C) L.GRAS  sarg @ aliceadsl . fr"+Chr(13)+Chr(13) _
               +"Select YES for accessing to the dedicated page on the forum"+Chr(13)+"http://www.freebasic.net/forum/viewtopic.php?f=8&t=13935",MB_YESNO)=IDYES Then
               	Shell "start http://www.freebasic.net/forum/viewtopic.php?f=8""&t""=13935" 
               EndIf
         	Case IDCMPINF
               compinfo_sh
            Case IDINFOS
               If helpbx=0 Then helptyp=2:fb_Dialog(@help_box,"PROCESS LIST",windmain,2,2,400,250)
         	Case IDLSTDLL
               If helpbx=0 Then helptyp=7:fb_Dialog(@help_box,"DLLS LIST",windmain,2,2,400,250)
         	Case IDLSTSHC
               If helpbx=0 Then helptyp=8:fb_Dialog(@help_box,"SHORTCUT KEYS LIST",windmain,2,2,400,250)
            Case IDDBGHELP
            	help_manage
            Case IDFILEIDE
                ide_launch()
         	Case IDQCKEDT
         		If prun AndAlso kill_process("If YES debuggee is killed then Quick edit is started")=FALSE Then
                        'nothing to do but better algo
         		Else
               	If dbgsrc="" OrElse Dir(dbgsrc)="" Then
                    fb_message("Quick internal Editor","No file !!!")
               	Else
                    sendmessage(dbgrichedit,EM_SETREADONLY,FALSE,0)
                    dsp_hide(1)
                    fb_Dialog(@save_box,"Quick edit",windmain,283,25,150,25)
                    setfocus(dbgrichedit)
                    sendmessage(dbgrichedit,EM_HIDESELECTION,1,0)
                    sendmessage(dbgrichedit,EM_SETSEL,1,1)
               	End If
               EndIf
         	Case IDCLIPBRD
         		sendmessage(dbgedit1,EM_SETSEL,0,-1)
         		sendmessage(dbgedit1,WM_COPY,0,0)
         		sendmessage(dbgedit1,EM_SETSEL,-1,0)
         	Case IDDELLOG 'delete log file if exists
						Dim savflog As Integer=flaglog       'save see below
						flaglog=flaglog And 1                'change the value but keeps screen output
						dbg_prt(" $$$$___CLOSE ALL___$$$$ ") 'close the file if needed
						Kill (ExePath+"\dbg_log_file.txt")   'delete it
						flaglog=savflog 'restore the value to keep the use of file log
         	Case IDSHWLOG
         			log_show
            Case IDHIDLOG
         			log_hide
         	Case IDSHENUM
                If helpbx=0 Then helptyp=6:fb_Dialog(@help_box,"LIST ENUMS",windmain,2,2,260,250)
         	Case IDCMPNRUN  'recompil bas then run
              	If source(dbgmain)="" Then
              		treat_file("?_NO$FILE_$?")
              	Else
              		treat_file(source(dbgmain))
              	EndIf
            Case IDWINMSG
                winmsg()
            Case IDSHWBDH
                dechexbin()
         	Case IDFRTIMER
                fb_message("Fast run timer","Elapsed Time : "+Str(fasttimer))
         	Case IDJITDBG
         		fb_MDialog(@jit_box,"Set/reset JIT debugger",windmain,283,25,325,60)
         	Case IDTUTO
         		'If tutobx=0 Then fb_Dialog(@tuto_box,"Tutorial",windmain,20,280,325,60)
         		fb_message("Tutorial","Sorry, work in progress !!!")
         	Case IDSETBRK 'set breakpoint
               brk_set(1)
         	Case IDSETBRT 'set tempo brkp
               brk_set(2)
            Case IDSETBRKC 'set brkp with counter  '03/09/2015
               brk_set(3)
         	Case IDCHGBRKC 'change value brkp with counter  '03/09/2015
         	   brk_set(7)
         	Case IDRSTBRKC 'reset brkp with counter  '03/09/2015
         	   brk_set(8)
         	Case IDBRKENB 'enable/disable brkp
               brk_set(4)
           	Case IDMNGBRK
               fb_MDialog(@brk_manage,"Manage breakpoints",windmain,500,8,330,170)
         	Case IDCONTHR 'run to cursor
         		SetFocus(windmain)
               brk_set(9)
         	Case IDEXEMOD 'modify execution from cursor
         		exe_mod()
         	Case IDSHWVAR
         		var_tip(PROCVAR)
         	Case IDSETWVAR
         		var_tip(WATCHED)
           	Case IDFNDTXT
					If hfindbx=0 Then 'findtext not active ?
						stext=wtext() 'selected text or ascii text near cursor
						fb_Dialog(@find_box,"Findtext (Circular)",windmain,283,25,100,25)
					End If
				Case IDACCLINE 
            	'dsp_access(shwtab)
            	dsp_noaccess
         	Case IDFCSSRC
         		If focusbx=0 Then
                	fb_Dialog(@focus_box,"Focus on some lines from source",windmain,2,2,400,260)
         		EndIf   
         	Case IDTGLBMK
               bmk_tgl()
         	Case IDNXTBMK
         		bmk_goto(TRUE) 'move forward
         	Case IDPRVBMK  
               bmk_goto(FALSE)'move backward
         	Case IDCURLIG 'label
                       exrichedit(curtab)
                       sel_line(curlig-1)
         	Case IDBMKCMB 'click on  bookmark area
				   If HiWord(wparam)=CBN_SELCHANGE Then 'move to bmk
				      x=sendmessage(bmkh,CB_GETCURSEL,0,0)
		      		x=sendmessage(bmkh,CB_GETITEMDATA,x,0)
		      		If bmk(x).ntab<>shwtab Then exrichedit(bmk(x).ntab) 'change tab
		            sel_line(bmk(x).nline-1)'select line
				   EndIf
         	Case IDADDNOT 'add notes
               notes_add()
         	Case IDGOTO 'goto line
         			line_goto
         	Case IDLINEADR 'line address (in memory)
         		line_adr
         	Case IDLINEASM 'dissassembly line in source
         		If helpbx=0 Then helptyp=9:fb_Dialog(@help_box,"Dissassembly line",windmain,2,2,400,250)
         	Case IDPROCASM 'dissassembly proc from line in source
         		If helpbx=0 Then helptyp=10:fb_Dialog(@help_box,"Dissassembly proc",windmain,2,2,400,250)
            Case IDREGS 'show processor registers for current thread
               If helpbx=0 Then helptyp=12:fb_Dialog(@help_box,"Show registers",windmain,2,2,400,250) '25/08/2015
           	Case ENLRSRC 'enlarge source
              	dsp_hide(1)
           	Case ENLRVAR 'enlarge proc/var
              	dsp_hide(2)
         	Case IDNOTES 'open or close notes
              	If dsptyp<>0 And dsptyp<>3 Then dsp_hide(dsptyp)'cancel full source or mem or var
              	dsp_hide(3)
           	Case ENLRMEM 'enlarge dump
              	dsp_hide(4)
           	Case IDVCLPSE 'collapse proc/var
		         proc_expcol(TVE_COLLAPSE)
         	Case IDLSTVARA 'list all var in log
               procvar_list()
         	Case IDLSTVARS'list selected var in log
         		procvar_list(1)
         	Case  IDCLBVARA 'clipboard all '28/11/2014
         		procvar_list(2)
         	Case  IDCLBVARS 'clipboard selected var
         		procvar_list(3)
         	Case IDPTDUMP 'dump pointed data
         		var_dump(tviewvar,1)
            Case IDFNDVAR 'find text proc or var in proc/var tree
              	If hfindbx=0 Then 'findtext not active ? also used in source
						fb_Dialog(@procvar_box,"Find any text (sensitive!!)",windmain,140,25,100,25)
					End If
         	Case IDVEXPND 'expand
               proc_expcol(TVE_EXPAND)
            Case IDSELIDX 'select index in proc/var
					fb_Dialog(@index_box,"Index selection",windmain,25,25,500,250) ''2016/02/07
         	Case IDSTWTCH1,IDSTWTCH2,IDSTWTCH3,IDSTWTCH4 'exchange watch 0 to 3
               watch_exch(LoWord(wparam)-IDSTWTCH1) 
         	Case IDWCHDEL'delete watch on cursor from watched
         		watch_del(watch_find())
         	Case IDWCHDALL'delete all watches
   				If fb_message("Delete watched vars","Delete all",MB_YESNO Or MB_ICONQUESTION)=IDYES Then
   					watch_del()
   				EndIf
         	Case IDWCHVAR'show in proc:var window from watched
         		watch_sel(watch_find())
         	Case IDWCHTTGL 'toggle trace
         		watch_trace(watch_find()) 
         	Case IDWCHTTGA 'cancel all traces
         		watch_trace()
         	Case IDWCHDMP'dump for watched
         		var_dump(tviewwch)
         	Case IDWCHSTG'shw string from watched
         		string_sh(tviewwch)
         	Case IDWCHSHW'shw/exp from watched
         		shwexp_new(tviewwch)
         	Case IDWCHEDT'edit from watched
         		If var_find2(tviewwch)<>-1 Then 'not local non-existent
         			fb_MDialog(@edit_box,"Edit var value (Be carefull)",windmain,283,25,350,50)
         		End If
         	Case IDSETWTCH 'set watched first free slot
            	If var_find2(tviewvar)<>-1 Then watch_set()
            Case IDTRCKIDX0 To IDTRCKRST  ''2016/07/26
         		array_tracking(LoWord(wparam))
            Case IDSETWTTR 'set watched + trace
         		watch_addtr
         	Case IDVARDMP  'var dump
              var_dump(tviewvar)
         	Case IDSHSTRG  'show z/w/string
              string_sh(tviewvar)
         	Case IDSHCHAR '03/11/2014
         		char_sh(tviewvar)
         	Case IDCHGZSTR
              zstringbyte_exchange()
         	Case IDVAREDT  'edit var value
              If var_find2(tviewvar)<>-1 Then fb_MDialog(@edit_box,"Edit var value (Be carefull)",windmain,283,25,350,50)
         	Case IDSHWEXP  'show and expand variables
					shwexp_new(tviewvar)
            Case IDVARBRK  'break on var value
              brkv_set(1)  
         	Case IDRSTPRC 'reset all proc
         		proc_flw(1)
         	Case IDSETPRC 'set all proc
           		proc_flw(2)
         	Case IDSORTPRC
         		procsort=1-procsort:proc_sh 'toggle type of sort and update display
         	Case IDASMPRC
         		If helpbx=0 Then helptyp=11:fb_Dialog(@help_box,"Dissassembly proc",windmain,2,2,400,250)
         	Case IDLOCPRC 'locate proc
         		proc_loc()
         	Case IDCALLINE 'ҵ
         	   proc_loccall(1)
         	Case IDPBCKTRK'backtracking from proc/var
            	proc_loccall(2)
         	Case IDPCHNING'chaining from proc/var
            	proc_loccall(3)
         	Case IDSHWPROC 'locate proc in proc/var treeview
         		thread_procloc(1)
         	Case IDSHPRSRC 'locate proc in source
         		thread_procloc(2)
         	Case IDTBCKTRK 'backtracking (from thread)
         		thread_procloc(3)
         	Case IDTCHNING 'chaining (from thread)
         		thread_procloc(4)         		
         	Case IDPRCRADR 'information about running proc
         		thread_procloc(5)
         	Case IDTHRDCHG 'change next executed thread
                thread_change
         	Case IDTHRDKLL 'kill a thread
         		thread_kill
         	Case IDEXCLINE 'show line
         		thread_execline(1)
         	Case IDCREATHR 'show line creating thread
         		thread_execline(2)
         	Case IDTHRDLST
         		If helpbx=0 Then helptyp=1:fb_Dialog(@help_box,"THREADS LIST",windmain,2,2,260,250)
         	Case IDTHRDEXP
         		thread_expcol(TVE_EXPAND)
         	Case IDTHRDCOL	
         		thread_expcol(TVE_COLLAPSE)
         	Case IDFNDTXUP
            	fb_find(0,sfind)
            Case IDFNDTXDW
            	fb_find(1,sfind)
         	Case IDWATCH1,IDWATCH2,IDWATCH3,IDWATCH4
					watch_sel(LoWord(wparam)-IDWATCH1) 'check adr then select watched variable inside proc/var
            Case IDBRKVAR 'update break on var
            	If brkv.adr<>0 Then brkv_set(2)
         End Select
    	Case WM_HELP
    		decode_help(Cast(HELPINFO Ptr,lparam))
    	Case WM_NOTIFY
    		If LoWord(wparam)=IDDUMP Then
        		'Dim lvp2 As NMLISTVIEW Ptr
        		'lvp2=Cast(NMLISTVIEW Ptr,lparam) 'click on one column so can change the value in memory
        		Dim lvp As NMITEMACTIVATE Ptr
        		If dumpadr<>0 And prun Then '23/11/2014
        			lvp=Cast(NMITEMACTIVATE Ptr,lparam)
        			If lvp->hdr.code = LVN_COLUMNCLICK Then
        				dump_sel(lvp)
        			ElseIf lvp->hdr.code=CULng(NM_CLICK) Then  'remove culng when fix done in commctrl.bi
        				dump_update(lvp)
        			EndIf
        		EndIf
        		'If lvp->hdr.code =&hFFFFFF94 And dumpadr<>0 And prun Then dump_update(lvp2)'LVN_COLUMNCLICK
    		ElseIf LoWord(wparam)=TAB1 Then
				Dim pnotify As NMHDR Ptr,wnot As Integer
				pnotify=Cast(NMHDR Ptr,lparam)
				If pnotify->code=TCN_SELCHANGE Then
					wnot=sendmessage(htab1,TCM_GETCURSEL,0,0)
					exrichedit(wnot) 'change tab and richedit
				End If
    		ElseIf LoWord(wparam)=TAB2 Then
    			Dim pnotify As NMHDR Ptr,wnot As Integer
				pnotify=Cast(NMHDR Ptr,lparam)
				If pnotify->code=TCN_SELCHANGE Then
					wnot=sendmessage(htab2,TCM_GETCURSEL,0,0)
					ShowWindow(tviewcur,SW_HIDE)
					Select Case wnot
						Case 0 'proc/var
							tviewcur=tviewvar
							SetFocus(dbgrichedit)
						Case 1 'procrs
							tviewcur=tviewprc
							proc_sh()
							SetFocus(tviewprc)
						Case 2 'threads	
							tviewcur=tviewthd
							SetFocus(dbgrichedit)
						Case 3 'watched var
							tviewcur=tviewwch
							SetFocus(dbgrichedit)
					End Select
               ShowWindow(tviewcur,SW_SHOW)
				End If
    		ElseIf LoWord(wparam)=TVIEW2 Then
                Dim pnotify As NMHDR Ptr =Cast(NMHDR Ptr,lparam)
                Dim As TVHITTESTINFO ht
                If pnotify->code=CULng(NM_CLICK) Then  'remove culng when fix done in commctrl.bi
                    Dim As Integer dwpos = GetMessagePos()
                    ht.pt.x = LoWord(dwpos)
                    ht.pt.y = HiWord(dwpos)
                    MapWindowPoints(HWND_DESKTOP, pnotify->hwndFrom, @ht.pt, 1)
                    sendmessage(tviewprc,TVM_HITTEST,0,Cast(LPARAM,@ht))
                    If(TVHT_ONITEMSTATEICON And ht.flags) Then
                        PostMessage(hWnd, UM_CHECKSTATECHANGE, 2, Cast(LPARAM,ht.hItem)) '2=tviewprc
                    End If
                ElseIf pnotify->code=CULng(NM_DBLCLK) Then 'check double click then show the beginning of the selected proc in source
                	proc_loc
                ElseIf pnotify->code=TVN_KEYDOWN Then 'enter key
                	Dim pnotify2 As TV_KEYDOWN Ptr =Cast(TV_KEYDOWN Ptr,lparam)
                	If pnotify2->wvkey=VK_SHIFT Then
                		proc_loc
                	EndIf
                End If
    		ElseIf LoWord(wparam)=TVIEW3 Then
    				Dim pnotify As NMHDR Ptr =Cast(NMHDR Ptr,lparam)
    				Dim As TVHITTESTINFO ht
                If pnotify->code=CULng(NM_CLICK) Then  'remove culng when fix done in commctrl.bi
                    Dim As Integer dwpos = GetMessagePos()
                    ht.pt.x = LoWord(dwpos)
                    ht.pt.y = HiWord(dwpos)
                    MapWindowPoints(HWND_DESKTOP, pnotify->hwndFrom, @ht.pt, 1)
                    sendmessage(tviewthd,TVM_HITTEST,0,Cast(LPARAM,@ht))
                    If(TVHT_ONITEMSTATEICON And ht.flags) Then
                        PostMessage(hWnd, UM_CHECKSTATECHANGE, 3, Cast(LPARAM,ht.hItem))'3=tviewthd
                    End If
                End If    
    		ElseIf LoWord(wparam)=IDRICHWIN Then
                Dim pmsgfilter As MSGFILTER Ptr =Cast(MSGFILTER Ptr,lparam)
                'Dim idtempo As Integer
                If pmsgfilter->msg=WM_KEYDOWN Then
 						'SendMessage(windmain,WM_KEYDOWN,makelong(idtempo,pmsgfilter->wparam),null)
 						SendMessage(windmain,WM_KEYDOWN,pmsgfilter->wparam,0)
                ElseIf getkeystate(VK_CONTROL) And &h8000 Then
                	If pmsgfilter->msg=WM_LBUTTONUP Then 'display var in proc/var
                		var_tip(PROCVAR)
                	EndIf
                ElseIf getkeystate(VK_LMENU) And &h8000 Then 
                	If pmsgfilter->msg=WM_LBUTTONUP Then
                		var_tip(WATCHED) 'select watched var
                	EndIf
                End If
            End If
    	Case UM_CHECKSTATECHANGE 'user message  not MSWindows
    			If wparam=2 Then
	        		SendMessage(tviewprc,TVM_SELECTITEM,TVGN_CARET,lparam)
            	proc_activ(Cast(HTREEITEM,lparam)) 'handle tree item
    			Else
    				SendMessage(tviewthd,TVM_SELECTITEM,TVGN_CARET,lparam)
            	thread_check(Cast(HTREEITEM,lparam)) 'thread tree item
            End If
        Case WM_SIZE
               Dim cx As Integer, cy As Integer
               cx = LoWord (lParam)
               cy = HiWord (lParam)
               dsp_size()
               dsp_sizecalc()
            'Case WM_SETCURSOR

               'Select Case wParam
               'Case dbgrichedit
                      'fb_message("setcursor",str(wparam))
               'End Select
    	Case WM_CLOSE
    		Dim text  As String
    		Dim ztext As ZString *11 '20/05/2014
    				If prun Then text="CAUTION PROGRAM STILL RUNNING."+Chr(10)+Chr(10)
    				If sendmessage(dbgedit1,WM_GETTEXT,10,Cast(LPARAM,@ztext))>4 Then text+="Don't forget to copy your notes."+Chr(10)+Chr(10) '20/05/2014
                If fb_message("END OF  FBDEBUGGER",text+Chr(10)+"Quit debugger ?",_ 
                MB_YESNO Or MB_ICONWARNING ) = IDYES Then DestroyWindow (windmain)
                Exit Function
    	Case WM_DESTROY
    			'If flaglog Then dbg_prt(" $$$$___CLOSE ALL___$$$$ ")
    			'test to avoid to suppress the watched 
    			If sourcenb<>-1 Then watch_sav:brk_sav 'case exiting without stopping debuggee before
    			ini_write()
            ''''KillTimer (windmain,TimerID1) 'Clean Up Timers 'not used if 2 threads
            sendmessage(fb_hToolTip,WM_DESTROY,0,0)
            destroymenu(menuroot)
            destroymenu(menuvar)
            destroymenu(menuvar2)
            destroymenu(menuvar3)
            destroymenu(menuvar4)
            destroymenu(menuvar5) ''2016/06/15
            destroymenu(menuedit)
            destroymenu(menuedit2)
            destroymenu(menutools)
            destroymenu(menuproc)
            destroymenu(menuthread)
            destroymenu(menuwatch)
				bx_closing 'to close all bx
            For x=0 To 23:DeleteObject(Cast(HGDIOBJ,bmb(x))):Next
            DeleteObject(Cast(HGDIOBJ,fonthdl))
            DeleteObject(Cast(HGDIOBJ,fontbold))
            DragAcceptFiles(hwnd, FALSE)
            help_manage(-1) 'to unload "hhctrl.ocx"
            PostQuitMessage 0            
            Exit Function
    	Case Else
    		WndProc = DefWindowProc( hWnd, message, wParam, lParam ) 
    End Select
  
End Function

'==============================================
private function WinMain ( ByVal hInstance As HINSTANCE, _
                   ByVal hPrevInstance As Integer, _
                   szCmdLine As String, _
                   ByVal iCmdShow As Integer ) As Integer    
     
     Dim wMsg As MSG
     Dim wcls As WNDCLASS     

     Dim hWnd As Unsigned Integer

     
     WinMain = 0
     
     ''
     '' Setup window class
     ''
     fb_hinstance=hinstance
     With wcls
     	.style         = CS_HREDRAW Or CS_VREDRAW
     	.lpfnWndProc   = Cast(WndProc,@WndProc)
     	.cbClsExtra    = 0
     	.cbWndExtra    = 0
     	.hInstance     = hInstance
     	.hIcon         = LoadIcon( hInstance,MAKEINTRESOURCE(1))'LoadIcon( null, byval IDI_APPLICATION )
     	.hCursor       = LoadCursor( NULL, ByVal IDC_ARROW )
     	.hbrBackground = GetStockObject( WHITE_BRUSH )
     	.lpszMenuName  = NULL
     	.lpszClassName = StrPtr( fb_szAppName )
     End With
     
     
     ''
     '' Register the window class     
     ''     
     If ( RegisterClass( @wcls ) = FALSE ) Then
        MessageBox NULL, "޷עᴰ", fb_szAppName, MB_ICONERROR               
        Exit Function
    End If
    ' -----------------------------------------------
   Dim iccex As INITCOMMONCONTROLSEX 
   iccex.dwSize = Len(INITCOMMONCONTROLSEX)
   iccex.dwICC = _
             ICC_LISTVIEW_CLASSES Or ICC_TREEVIEW_CLASSES Or ICC_BAR_CLASSES _
             Or ICC_TAB_CLASSES Or ICC_UPDOWN_CLASS Or ICC_PROGRESS_CLASS _
             Or ICC_USEREX_CLASSES Or ICC_DATE_CLASSES
   InitCommonControlsEx(@iccex)
        
' --------------- call FB_WIN() for initialisation ------------------
   fb_win() 'create window, etc
' --------------------------------------------------------------------------------
    '' Process windows messages
   While ( GetMessage( @wMsg, NULL, 0, 0 ) <> FALSE )    
      Dim hActiveWindow As HWND
      hActiveWindow = GetActiveWindow()
      If (IsWindow(hActiveWindow)=0) Or (IsDialogMessage(hActiveWindow,@wMsg)=0) Then
        TranslateMessage @wMsg
        DispatchMessage  @wMsg
    End If
    Wend

    WinMain = wMsg.wParam
End Function
