#Include once "crt.bi"
#inclib "LZMA"



#define SZ_OK 0

#define SZ_ERROR_DATA 1
#define SZ_ERROR_MEM 2
#define SZ_ERROR_CRC 3
#define SZ_ERROR_UNSUPPORTED 4
#define SZ_ERROR_PARAM 5
#define SZ_ERROR_INPUT_EOF 6
#define SZ_ERROR_OUTPUT_EOF 7
#define SZ_ERROR_READ 8
#define SZ_ERROR_WRITE 9
#define SZ_ERROR_PROGRESS 10
#define SZ_ERROR_FAIL 11
#define SZ_ERROR_THREAD 12

#define SZ_ERROR_ARCHIVE 16
#define SZ_ERROR_NO_ARCHIVE 17



#define LZMA_PROPS_SIZE 5

extern "C"

/'
RAM Ҫ LZMA:
  ѹ:   (dictSize * 11.5 + 6 MB) + state_size
  ڼѹ: dictSize + state_size
    state_size = (4 + (1.5 << (lc + lp))) KB
    by default (lc=3, lp=0), state_size = 16 KB.

LZMA  (5 bytes) format
    Offset Size  
      0     1    lc, lp and pb in encoded form.
      1     4    dictSize (little endian).
'/

/'
LzmaCompress
------------

outPropsSize -
     In:  ָoutPropsСָ; *outPropsSize = LZMA_PROPS_SIZE = 5.
     Out: ָoutPropsдԴСָ; *outPropsSize = LZMA_PROPS_SIZE = 5.

  LZMA ʹκβĬֵ, if it is
  -1  for any from: level, loc, lp, pb, fb, numThreads
   0  for dictSize
  
level - compression level: 0 <= level <= 9;

  level dictSize algo  fb
    0:    16 KB   0    32
    1:    64 KB   0    32
    2:   256 KB   0    32
    3:     1 MB   0    32
    4:     4 MB   0    32
    5:    16 MB   1    32
    6:    32 MB   1    32
    7+:   64 MB   1    64
 
  The default value for "level" is 5.

  algo = 0 means fast method
  algo = 1 means normal method

dictSize - ֵСֽΪλ ֵΪ
        128 MB = (1 << 27) bytes for 32-bit version
          1 GB = (1 << 30) bytes for 64-bit version
     ĬֵΪ 16 MB = (1 << 24) bytes.
     It's recommended to use the dictionary that is larger than 4 KB and
     that can be calculated as (1 << N) or (3 << N) sizes.

lc - λǰֵĸλ).
     It can be in the range from 0 to 8. The default value is 3.
     Sometimes lc=4 gives the gain for big files.

lp - λֵǰλõĵλ
     It can be in the range from 0 to 4. The default value is 0.
     The lp switch is intended for periodical data when the period is equal to 2^lp.
     For example, for 32-bit (4 bytes) periodical data you can use lp=2. Often it's
     better to set lc=0, if you change lp switch.

pb - λǰλõĵλ
     It can be in the range from 0 to 4. The default value is 2.
     The pb switch is intended for periodical data when the period is equal 2^pb.

fb - ִСֽ
     It can be in the range from 5 to 273. The default value is 32.
     Usually, a big number gives a little bit better compression ratio and
     slower compression process.

numThreads - The number of thereads. 1 or 2. The default value is 2.
     Fast mode (algo = 0) can use only 1 thread.

Out:
  destLen  - processed output size
Returns:
  SZ_OK               - OK
  SZ_ERROR_MEM        - ڴ
  SZ_ERROR_PARAM      - ȷ
  SZ_ERROR_OUTPUT_EOF - 
  SZ_ERROR_THREAD     - ̹߳еĴ󣨽Mt汾
'/



/'
	dest					Ŀڴ
	destLen				ĿڴС[ѹ]
	src				ѹڴ
	srcLen				ѹݴС
	outProps			ָ뻺
	outPropsSize	ָ뻺С[̶Ϊ:LZMA_PROPS_SIZE]
	level					ѹ[0-9,ԽѹԽ,ĬΪ5]
	dictSize			ֵС
	numThreads		߳
'/
declare function LzmaCompress(ByVal dest as ubyte ptr,ByRef destLen as size_t,ByVal src as const ubyte ptr,ByVal srcLen as size_t,ByVal outProps as ubyte ptr,_
								ByRef outPropsSize as size_t, _           ' outPropsSize must be = 5 
                byval level as integer = -1,_             ' 0 <= level <= 9, default = 5 
                byval dictSize as uinteger = 0, _         ' default = (1 << 24) 
                byval lc as integer = -1, _               ' 0 <= lc <= 8, default = 3 
                byval lp as integer = -1, _               ' 0 <= lp <= 4, default = 0 
                byval pb as integer = -1, _               ' 0 <= pb <= 4, default = 2  
                byval fb as integer = -1, _               ' 5 <= fb <= 273, default = 32 
                byval numThreads as integer = -1  _       ' 1 or 2, default = 2
                ) as integer


/'
LzmaUncompress
--------------
In:
  dest     - output data
  destLen  - output data size
  src      - input data
  srcLen   - input data size
Out:
  destLen  - С
  srcLen   - С
Returns:
  SZ_OK                - OK
  SZ_ERROR_DATA        - ݴ
  SZ_ERROR_MEM         - ڴ
  SZ_ERROR_UNSUPPORTED - ֵ֧
  SZ_ERROR_INPUT_EOF   - 뻺srcҪֽ
'/

declare function LzmaUncompress(ByVal dest as ubyte Ptr,ByRef destLen as size_t,ByVal src as const ubyte ptr,ByRef srcLen as size_t,ByVal props as const ubyte ptr,ByVal propsSize as size_t) as integer

end Extern



Type Lzma_FileHdr Field = 1
	FileSize As UInteger	'ѹļС
	CompLevel As Byte													' ѹ
	LzmaProp(0 To LZMA_PROPS_SIZE-1) As Byte	' Props
End Type





