﻿'FreeBASIC绑定为cl343_beta
'
'?基于C头文件：
'???cryptlib是根据双重许可证分发的，允许根据GPL兼容许可证进行免费，开源的使用，并根据标准商业许可使用封闭源代码。 GPL兼容许可证（a.k.a. the Sleepycat许可证）如下。有关此许可证的更多详细信息，请参阅cryptlib主页。
'
'?????版权所有1992-2013 Peter Gutmann版权所有。
'
'?????允许使用源代码和二进制形式进行重新分发和使用，只要符合以下条件，即可使用或不进行修改：
'
'?????1.重新分发源代码必须保留上述版权声明，本条件列表和以下免责声明。
'
'?????二进制再分发必须复制上述版权声明，
'????????此列表中的条件和以下免责声明与文档和/或其他材料一起提供。
'
'?????3.任何形式的再分发都必须附有关于如何获取cryptlib软件的完整源代码以及任何使用cryptlib软件的随附软件的信息。源代码必须包含在分发中，或者可用于不超过分发成本，并且必须在合理条件下自由再分发。对于可执行文件，完整的源代码是指其包含或使用的所有模块的源代码。它不包括通常伴随运行可执行文件的操作系统的主要组件的模块或文件的源代码。请注意，将软件与用户脱钩，例如通过在SaaS配置中运行，不会免除您的这些要求。
'
'?????本软件“按原样”提供，任何明示或暗示的保证，包括但不限于适销性，适用于特定用途或非侵权的默示保证，均不承担任何责任。在任何情况下，作者不得对任何直接，间接，偶然，特殊，惩戒性或后果性的损害（包括但不限于采购替代商品或服务;使用，数据或利润的损失或业务中断）负责）无论是否因使用本软件而导致任何责任原因和任何责任理由（无论合约，严格责任或侵权行为（包括疏忽或其他情况）），均已被告知此类损害的可能性。
'
'???如果您无法遵守上述许可证，则适用以下替代使用条件：
'
'?????任何大规模商业使用cryptlib都需要许可证。 “大规模商业用途”是指任何创收目的，例如用于公司内部用途，或在应用或产品中使用cryptlib，
'?????总收入超过5000美元。这允许cryptlib用于免费软件和共享软件应用程序，用于评估和研究目的，以及无收入的非创收或个人使用。此外，作者保留在特殊情况下（例如对公众有一般利益的情况下）免费授予商业许可证的权利，如果您认为您有资格，请联系作者了解详情。
'
'?翻译成FreeBASIC：
'???版权所有2015 FreeBASIC开发团队

#pragma once

#inclib "cl"

#ifdef __FB_WIN32__
	#include once "windows.bi"

	extern "Windows"
#else
	extern "C"
#endif

#define _CRYPTLIB_DEFINED
const CRYPTLIB_VERSION = 3430

type CRYPT_ALGO_TYPE as long
enum
	CRYPT_ALGO_NONE
	CRYPT_ALGO_DES
	CRYPT_ALGO_3DES
	CRYPT_ALGO_IDEA
	CRYPT_ALGO_CAST
	CRYPT_ALGO_RC2
	CRYPT_ALGO_RC4
	CRYPT_ALGO_RC5
	CRYPT_ALGO_AES
	CRYPT_ALGO_BLOWFISH
	CRYPT_ALGO_DH = 100
	CRYPT_ALGO_RSA
	CRYPT_ALGO_DSA
	CRYPT_ALGO_ELGAMAL
	CRYPT_ALGO_RESERVED1
	CRYPT_ALGO_ECDSA
	CRYPT_ALGO_ECDH
	CRYPT_ALGO_RESERVED2 = 200
	CRYPT_ALGO_RESERVED3
	CRYPT_ALGO_MD5
	CRYPT_ALGO_SHA1
	CRYPT_ALGO_RIPEMD160
	CRYPT_ALGO_SHA2
	CRYPT_ALGO_SHA256 = CRYPT_ALGO_SHA2
	CRYPT_ALGO_SHAng
	CRYPT_ALGO_HMAC_MD5 = 300
	CRYPT_ALGO_HMAC_SHA1
	CRYPT_ALGO_HMAC_RIPEMD160
	CRYPT_ALGO_HMAC_SHA2
	CRYPT_ALGO_HMAC_SHAng
	CRYPT_ALGO_LAST
	CRYPT_ALGO_FIRST_CONVENTIONAL = 1
	CRYPT_ALGO_LAST_CONVENTIONAL = 99
	CRYPT_ALGO_FIRST_PKC = 100
	CRYPT_ALGO_LAST_PKC = 199
	CRYPT_ALGO_FIRST_HASH = 200
	CRYPT_ALGO_LAST_HASH = 299
	CRYPT_ALGO_FIRST_MAC = 300
	CRYPT_ALGO_LAST_MAC = 399
end enum

type CRYPT_MODE_TYPE as long
enum
	CRYPT_MODE_NONE
	CRYPT_MODE_ECB
	CRYPT_MODE_CBC
	CRYPT_MODE_CFB
	CRYPT_MODE_OFB
	CRYPT_MODE_GCM
	CRYPT_MODE_LAST
end enum

type CRYPT_KEYSET_TYPE as long
enum
	CRYPT_KEYSET_NONE
	CRYPT_KEYSET_FILE
	CRYPT_KEYSET_HTTP
	CRYPT_KEYSET_LDAP
	CRYPT_KEYSET_ODBC
	CRYPT_KEYSET_DATABASE
	CRYPT_KEYSET_ODBC_STORE
	CRYPT_KEYSET_DATABASE_STORE
	CRYPT_KEYSET_LAST
end enum

type CRYPT_DEVICE_TYPE as long
enum
	CRYPT_DEVICE_NONE
	CRYPT_DEVICE_FORTEZZA
	CRYPT_DEVICE_PKCS11
	CRYPT_DEVICE_CRYPTOAPI
	CRYPT_DEVICE_HARDWARE
	CRYPT_DEVICE_LAST
end enum

type CRYPT_CERTTYPE_TYPE as long
enum
	CRYPT_CERTTYPE_NONE
	CRYPT_CERTTYPE_CERTIFICATE
	CRYPT_CERTTYPE_ATTRIBUTE_CERT
	CRYPT_CERTTYPE_CERTCHAIN
	CRYPT_CERTTYPE_CERTREQUEST
	CRYPT_CERTTYPE_REQUEST_CERT
	CRYPT_CERTTYPE_REQUEST_REVOCATION
	CRYPT_CERTTYPE_CRL
	CRYPT_CERTTYPE_CMS_ATTRIBUTES
	CRYPT_CERTTYPE_RTCS_REQUEST
	CRYPT_CERTTYPE_RTCS_RESPONSE
	CRYPT_CERTTYPE_OCSP_REQUEST
	CRYPT_CERTTYPE_OCSP_RESPONSE
	CRYPT_CERTTYPE_PKIUSER
	CRYPT_CERTTYPE_LAST
end enum

type CRYPT_FORMAT_TYPE as long
enum
	CRYPT_FORMAT_NONE
	CRYPT_FORMAT_AUTO
	CRYPT_FORMAT_CRYPTLIB
	CRYPT_FORMAT_CMS
	CRYPT_FORMAT_PKCS7 = CRYPT_FORMAT_CMS
	CRYPT_FORMAT_SMIME
	CRYPT_FORMAT_PGP
	CRYPT_FORMAT_LAST
end enum

type CRYPT_SESSION_TYPE as long
enum
	CRYPT_SESSION_NONE
	CRYPT_SESSION_SSH
	CRYPT_SESSION_SSH_SERVER
	CRYPT_SESSION_SSL
	CRYPT_SESSION_SSL_SERVER
	CRYPT_SESSION_RTCS
	CRYPT_SESSION_RTCS_SERVER
	CRYPT_SESSION_OCSP
	CRYPT_SESSION_OCSP_SERVER
	CRYPT_SESSION_TSP
	CRYPT_SESSION_TSP_SERVER
	CRYPT_SESSION_CMP
	CRYPT_SESSION_CMP_SERVER
	CRYPT_SESSION_SCEP
	CRYPT_SESSION_SCEP_SERVER
	CRYPT_SESSION_CERTSTORE_SERVER
	CRYPT_SESSION_LAST
end enum

type CRYPT_USER_TYPE as long
enum
	CRYPT_USER_NONE
	CRYPT_USER_NORMAL
	CRYPT_USER_SO
	CRYPT_USER_CA
	CRYPT_USER_LAST
end enum

type CRYPT_ATTRIBUTE_TYPE as long
enum
	CRYPT_ATTRIBUTE_NONE
	CRYPT_PROPERTY_FIRST
	CRYPT_PROPERTY_HIGHSECURITY
	CRYPT_PROPERTY_OWNER
	CRYPT_PROPERTY_FORWARDCOUNT
	CRYPT_PROPERTY_LOCKED
	CRYPT_PROPERTY_USAGECOUNT
	CRYPT_PROPERTY_NONEXPORTABLE
	CRYPT_PROPERTY_LAST
	CRYPT_GENERIC_FIRST
	CRYPT_ATTRIBUTE_ERRORTYPE
	CRYPT_ATTRIBUTE_ERRORLOCUS
	CRYPT_ATTRIBUTE_ERRORMESSAGE
	CRYPT_ATTRIBUTE_CURRENT_GROUP
	CRYPT_ATTRIBUTE_CURRENT
	CRYPT_ATTRIBUTE_CURRENT_INSTANCE
	CRYPT_ATTRIBUTE_BUFFERSIZE
	CRYPT_GENERIC_LAST
	CRYPT_OPTION_FIRST = 100
	CRYPT_OPTION_INFO_DESCRIPTION
	CRYPT_OPTION_INFO_COPYRIGHT
	CRYPT_OPTION_INFO_MAJORVERSION
	CRYPT_OPTION_INFO_MINORVERSION
	CRYPT_OPTION_INFO_STEPPING
	CRYPT_OPTION_ENCR_ALGO
	CRYPT_OPTION_ENCR_HASH
	CRYPT_OPTION_ENCR_MAC
	CRYPT_OPTION_PKC_ALGO
	CRYPT_OPTION_PKC_KEYSIZE
	CRYPT_OPTION_SIG_ALGO
	CRYPT_OPTION_SIG_KEYSIZE
	CRYPT_OPTION_KEYING_ALGO
	CRYPT_OPTION_KEYING_ITERATIONS
	CRYPT_OPTION_CERT_SIGNUNRECOGNISEDATTRIBUTES
	CRYPT_OPTION_CERT_VALIDITY
	CRYPT_OPTION_CERT_UPDATEINTERVAL
	CRYPT_OPTION_CERT_COMPLIANCELEVEL
	CRYPT_OPTION_CERT_REQUIREPOLICY
	CRYPT_OPTION_CMS_DEFAULTATTRIBUTES
	CRYPT_OPTION_SMIME_DEFAULTATTRIBUTES = CRYPT_OPTION_CMS_DEFAULTATTRIBUTES
	CRYPT_OPTION_KEYS_LDAP_OBJECTCLASS
	CRYPT_OPTION_KEYS_LDAP_OBJECTTYPE
	CRYPT_OPTION_KEYS_LDAP_FILTER
	CRYPT_OPTION_KEYS_LDAP_CACERTNAME
	CRYPT_OPTION_KEYS_LDAP_CERTNAME
	CRYPT_OPTION_KEYS_LDAP_CRLNAME
	CRYPT_OPTION_KEYS_LDAP_EMAILNAME
	CRYPT_OPTION_DEVICE_PKCS11_DVR01
	CRYPT_OPTION_DEVICE_PKCS11_DVR02
	CRYPT_OPTION_DEVICE_PKCS11_DVR03
	CRYPT_OPTION_DEVICE_PKCS11_DVR04
	CRYPT_OPTION_DEVICE_PKCS11_DVR05
	CRYPT_OPTION_DEVICE_PKCS11_HARDWAREONLY
	CRYPT_OPTION_NET_SOCKS_SERVER
	CRYPT_OPTION_NET_SOCKS_USERNAME
	CRYPT_OPTION_NET_HTTP_PROXY
	CRYPT_OPTION_NET_CONNECTTIMEOUT
	CRYPT_OPTION_NET_READTIMEOUT
	CRYPT_OPTION_NET_WRITETIMEOUT
	CRYPT_OPTION_MISC_ASYNCINIT
	CRYPT_OPTION_MISC_SIDECHANNELPROTECTION
	CRYPT_OPTION_CONFIGCHANGED
	CRYPT_OPTION_SELFTESTOK
	CRYPT_OPTION_LAST
	CRYPT_CTXINFO_FIRST = 1000
	CRYPT_CTXINFO_ALGO
	CRYPT_CTXINFO_MODE
	CRYPT_CTXINFO_NAME_ALGO
	CRYPT_CTXINFO_NAME_MODE
	CRYPT_CTXINFO_KEYSIZE
	CRYPT_CTXINFO_BLOCKSIZE
	CRYPT_CTXINFO_IVSIZE
	CRYPT_CTXINFO_KEYING_ALGO
	CRYPT_CTXINFO_KEYING_ITERATIONS
	CRYPT_CTXINFO_KEYING_SALT
	CRYPT_CTXINFO_KEYING_VALUE
	CRYPT_CTXINFO_KEY
	CRYPT_CTXINFO_KEY_COMPONENTS
	CRYPT_CTXINFO_IV
	CRYPT_CTXINFO_HASHVALUE
	CRYPT_CTXINFO_LABEL
	CRYPT_CTXINFO_PERSISTENT
	CRYPT_CTXINFO_LAST
	CRYPT_CERTINFO_FIRST = 2000
	CRYPT_CERTINFO_SELFSIGNED
	CRYPT_CERTINFO_IMMUTABLE
	CRYPT_CERTINFO_XYZZY
	CRYPT_CERTINFO_CERTTYPE
	CRYPT_CERTINFO_FINGERPRINT_MD5
	CRYPT_CERTINFO_FINGERPRINT_SHA1
	CRYPT_CERTINFO_FINGERPRINT_SHA2
	CRYPT_CERTINFO_FINGERPRINT_SHAng
	CRYPT_CERTINFO_CURRENT_CERTIFICATE
	CRYPT_CERTINFO_TRUSTED_USAGE
	CRYPT_CERTINFO_TRUSTED_IMPLICIT
	CRYPT_CERTINFO_SIGNATURELEVEL
	CRYPT_CERTINFO_VERSION
	CRYPT_CERTINFO_SERIALNUMBER
	CRYPT_CERTINFO_SUBJECTPUBLICKEYINFO
	CRYPT_CERTINFO_CERTIFICATE
	CRYPT_CERTINFO_USERCERTIFICATE = CRYPT_CERTINFO_CERTIFICATE
	CRYPT_CERTINFO_CACERTIFICATE
	CRYPT_CERTINFO_ISSUERNAME
	CRYPT_CERTINFO_VALIDFROM
	CRYPT_CERTINFO_VALIDTO
	CRYPT_CERTINFO_SUBJECTNAME
	CRYPT_CERTINFO_ISSUERUNIQUEID
	CRYPT_CERTINFO_SUBJECTUNIQUEID
	CRYPT_CERTINFO_CERTREQUEST
	CRYPT_CERTINFO_THISUPDATE
	CRYPT_CERTINFO_NEXTUPDATE
	CRYPT_CERTINFO_REVOCATIONDATE
	CRYPT_CERTINFO_REVOCATIONSTATUS
	CRYPT_CERTINFO_CERTSTATUS
	CRYPT_CERTINFO_DN
	CRYPT_CERTINFO_PKIUSER_ID
	CRYPT_CERTINFO_PKIUSER_ISSUEPASSWORD
	CRYPT_CERTINFO_PKIUSER_REVPASSWORD
	CRYPT_CERTINFO_PKIUSER_RA
	CRYPT_CERTINFO_COUNTRYNAME = CRYPT_CERTINFO_FIRST + 100
	CRYPT_CERTINFO_STATEORPROVINCENAME
	CRYPT_CERTINFO_LOCALITYNAME
	CRYPT_CERTINFO_ORGANIZATIONNAME
	CRYPT_CERTINFO_ORGANISATIONNAME = CRYPT_CERTINFO_ORGANIZATIONNAME
	CRYPT_CERTINFO_ORGANIZATIONALUNITNAME
	CRYPT_CERTINFO_ORGANISATIONALUNITNAME = CRYPT_CERTINFO_ORGANIZATIONALUNITNAME
	CRYPT_CERTINFO_COMMONNAME
	CRYPT_CERTINFO_OTHERNAME_TYPEID
	CRYPT_CERTINFO_OTHERNAME_VALUE
	CRYPT_CERTINFO_RFC822NAME
	CRYPT_CERTINFO_EMAIL = CRYPT_CERTINFO_RFC822NAME
	CRYPT_CERTINFO_DNSNAME
	CRYPT_CERTINFO_DIRECTORYNAME
	CRYPT_CERTINFO_EDIPARTYNAME_NAMEASSIGNER
	CRYPT_CERTINFO_EDIPARTYNAME_PARTYNAME
	CRYPT_CERTINFO_UNIFORMRESOURCEIDENTIFIER
	CRYPT_CERTINFO_URL = CRYPT_CERTINFO_UNIFORMRESOURCEIDENTIFIER
	CRYPT_CERTINFO_IPADDRESS
	CRYPT_CERTINFO_REGISTEREDID
	CRYPT_CERTINFO_CHALLENGEPASSWORD = CRYPT_CERTINFO_FIRST + 200
	CRYPT_CERTINFO_CRLEXTREASON
	CRYPT_CERTINFO_KEYFEATURES
	CRYPT_CERTINFO_AUTHORITYINFOACCESS
	CRYPT_CERTINFO_AUTHORITYINFO_RTCS
	CRYPT_CERTINFO_AUTHORITYINFO_OCSP
	CRYPT_CERTINFO_AUTHORITYINFO_CAISSUERS
	CRYPT_CERTINFO_AUTHORITYINFO_CERTSTORE
	CRYPT_CERTINFO_AUTHORITYINFO_CRLS
	CRYPT_CERTINFO_BIOMETRICINFO
	CRYPT_CERTINFO_BIOMETRICINFO_TYPE
	CRYPT_CERTINFO_BIOMETRICINFO_HASHALGO
	CRYPT_CERTINFO_BIOMETRICINFO_HASH
	CRYPT_CERTINFO_BIOMETRICINFO_URL
	CRYPT_CERTINFO_QCSTATEMENT
	CRYPT_CERTINFO_QCSTATEMENT_SEMANTICS
	CRYPT_CERTINFO_QCSTATEMENT_REGISTRATIONAUTHORITY
	CRYPT_CERTINFO_IPADDRESSBLOCKS
	CRYPT_CERTINFO_IPADDRESSBLOCKS_ADDRESSFAMILY
	CRYPT_CERTINFO_IPADDRESSBLOCKS_PREFIX
	CRYPT_CERTINFO_IPADDRESSBLOCKS_MIN
	CRYPT_CERTINFO_IPADDRESSBLOCKS_MAX
	CRYPT_CERTINFO_AUTONOMOUSSYSIDS
	CRYPT_CERTINFO_AUTONOMOUSSYSIDS_ASNUM_ID
	CRYPT_CERTINFO_AUTONOMOUSSYSIDS_ASNUM_MIN
	CRYPT_CERTINFO_AUTONOMOUSSYSIDS_ASNUM_MAX
	CRYPT_CERTINFO_OCSP_NONCE
	CRYPT_CERTINFO_OCSP_RESPONSE
	CRYPT_CERTINFO_OCSP_RESPONSE_OCSP
	CRYPT_CERTINFO_OCSP_NOCHECK
	CRYPT_CERTINFO_OCSP_ARCHIVECUTOFF
	CRYPT_CERTINFO_SUBJECTINFOACCESS
	CRYPT_CERTINFO_SUBJECTINFO_TIMESTAMPING
	CRYPT_CERTINFO_SUBJECTINFO_CAREPOSITORY
	CRYPT_CERTINFO_SUBJECTINFO_SIGNEDOBJECTREPOSITORY
	CRYPT_CERTINFO_SUBJECTINFO_RPKIMANIFEST
	CRYPT_CERTINFO_SUBJECTINFO_SIGNEDOBJECT
	CRYPT_CERTINFO_SIGG_DATEOFCERTGEN
	CRYPT_CERTINFO_SIGG_PROCURATION
	CRYPT_CERTINFO_SIGG_PROCURE_COUNTRY
	CRYPT_CERTINFO_SIGG_PROCURE_TYPEOFSUBSTITUTION
	CRYPT_CERTINFO_SIGG_PROCURE_SIGNINGFOR
	CRYPT_CERTINFO_SIGG_ADMISSIONS
	CRYPT_CERTINFO_SIGG_ADMISSIONS_AUTHORITY
	CRYPT_CERTINFO_SIGG_ADMISSIONS_NAMINGAUTHID
	CRYPT_CERTINFO_SIGG_ADMISSIONS_NAMINGAUTHURL
	CRYPT_CERTINFO_SIGG_ADMISSIONS_NAMINGAUTHTEXT
	CRYPT_CERTINFO_SIGG_ADMISSIONS_PROFESSIONITEM
	CRYPT_CERTINFO_SIGG_ADMISSIONS_PROFESSIONOID
	CRYPT_CERTINFO_SIGG_ADMISSIONS_REGISTRATIONNUMBER
	CRYPT_CERTINFO_SIGG_MONETARYLIMIT
	CRYPT_CERTINFO_SIGG_MONETARY_CURRENCY
	CRYPT_CERTINFO_SIGG_MONETARY_AMOUNT
	CRYPT_CERTINFO_SIGG_MONETARY_EXPONENT
	CRYPT_CERTINFO_SIGG_DECLARATIONOFMAJORITY
	CRYPT_CERTINFO_SIGG_DECLARATIONOFMAJORITY_COUNTRY
	CRYPT_CERTINFO_SIGG_RESTRICTION
	CRYPT_CERTINFO_SIGG_CERTHASH
	CRYPT_CERTINFO_SIGG_ADDITIONALINFORMATION
	CRYPT_CERTINFO_STRONGEXTRANET
	CRYPT_CERTINFO_STRONGEXTRANET_ZONE
	CRYPT_CERTINFO_STRONGEXTRANET_ID
	CRYPT_CERTINFO_SUBJECTDIRECTORYATTRIBUTES
	CRYPT_CERTINFO_SUBJECTDIR_TYPE
	CRYPT_CERTINFO_SUBJECTDIR_VALUES
	CRYPT_CERTINFO_SUBJECTKEYIDENTIFIER
	CRYPT_CERTINFO_KEYUSAGE
	CRYPT_CERTINFO_PRIVATEKEYUSAGEPERIOD
	CRYPT_CERTINFO_PRIVATEKEY_NOTBEFORE
	CRYPT_CERTINFO_PRIVATEKEY_NOTAFTER
	CRYPT_CERTINFO_SUBJECTALTNAME
	CRYPT_CERTINFO_ISSUERALTNAME
	CRYPT_CERTINFO_BASICCONSTRAINTS
	CRYPT_CERTINFO_CA
	CRYPT_CERTINFO_AUTHORITY = CRYPT_CERTINFO_CA
	CRYPT_CERTINFO_PATHLENCONSTRAINT
	CRYPT_CERTINFO_CRLNUMBER
	CRYPT_CERTINFO_CRLREASON
	CRYPT_CERTINFO_HOLDINSTRUCTIONCODE
	CRYPT_CERTINFO_INVALIDITYDATE
	CRYPT_CERTINFO_DELTACRLINDICATOR
	CRYPT_CERTINFO_ISSUINGDISTRIBUTIONPOINT
	CRYPT_CERTINFO_ISSUINGDIST_FULLNAME
	CRYPT_CERTINFO_ISSUINGDIST_USERCERTSONLY
	CRYPT_CERTINFO_ISSUINGDIST_CACERTSONLY
	CRYPT_CERTINFO_ISSUINGDIST_SOMEREASONSONLY
	CRYPT_CERTINFO_ISSUINGDIST_INDIRECTCRL
	CRYPT_CERTINFO_CERTIFICATEISSUER
	CRYPT_CERTINFO_NAMECONSTRAINTS
	CRYPT_CERTINFO_PERMITTEDSUBTREES
	CRYPT_CERTINFO_EXCLUDEDSUBTREES
	CRYPT_CERTINFO_CRLDISTRIBUTIONPOINT
	CRYPT_CERTINFO_CRLDIST_FULLNAME
	CRYPT_CERTINFO_CRLDIST_REASONS
	CRYPT_CERTINFO_CRLDIST_CRLISSUER
	CRYPT_CERTINFO_CERTIFICATEPOLICIES
	CRYPT_CERTINFO_CERTPOLICYID
	CRYPT_CERTINFO_CERTPOLICY_CPSURI
	CRYPT_CERTINFO_CERTPOLICY_ORGANIZATION
	CRYPT_CERTINFO_CERTPOLICY_NOTICENUMBERS
	CRYPT_CERTINFO_CERTPOLICY_EXPLICITTEXT
	CRYPT_CERTINFO_POLICYMAPPINGS
	CRYPT_CERTINFO_ISSUERDOMAINPOLICY
	CRYPT_CERTINFO_SUBJECTDOMAINPOLICY
	CRYPT_CERTINFO_AUTHORITYKEYIDENTIFIER
	CRYPT_CERTINFO_AUTHORITY_KEYIDENTIFIER
	CRYPT_CERTINFO_AUTHORITY_CERTISSUER
	CRYPT_CERTINFO_AUTHORITY_CERTSERIALNUMBER
	CRYPT_CERTINFO_POLICYCONSTRAINTS
	CRYPT_CERTINFO_REQUIREEXPLICITPOLICY
	CRYPT_CERTINFO_INHIBITPOLICYMAPPING
	CRYPT_CERTINFO_EXTKEYUSAGE
	CRYPT_CERTINFO_EXTKEY_MS_INDIVIDUALCODESIGNING
	CRYPT_CERTINFO_EXTKEY_MS_COMMERCIALCODESIGNING
	CRYPT_CERTINFO_EXTKEY_MS_CERTTRUSTLISTSIGNING
	CRYPT_CERTINFO_EXTKEY_MS_TIMESTAMPSIGNING
	CRYPT_CERTINFO_EXTKEY_MS_SERVERGATEDCRYPTO
	CRYPT_CERTINFO_EXTKEY_MS_ENCRYPTEDFILESYSTEM
	CRYPT_CERTINFO_EXTKEY_SERVERAUTH
	CRYPT_CERTINFO_EXTKEY_CLIENTAUTH
	CRYPT_CERTINFO_EXTKEY_CODESIGNING
	CRYPT_CERTINFO_EXTKEY_EMAILPROTECTION
	CRYPT_CERTINFO_EXTKEY_IPSECENDSYSTEM
	CRYPT_CERTINFO_EXTKEY_IPSECTUNNEL
	CRYPT_CERTINFO_EXTKEY_IPSECUSER
	CRYPT_CERTINFO_EXTKEY_TIMESTAMPING
	CRYPT_CERTINFO_EXTKEY_OCSPSIGNING
	CRYPT_CERTINFO_EXTKEY_DIRECTORYSERVICE
	CRYPT_CERTINFO_EXTKEY_ANYKEYUSAGE
	CRYPT_CERTINFO_EXTKEY_NS_SERVERGATEDCRYPTO
	CRYPT_CERTINFO_EXTKEY_VS_SERVERGATEDCRYPTO_CA
	CRYPT_CERTINFO_CRLSTREAMIDENTIFIER
	CRYPT_CERTINFO_FRESHESTCRL
	CRYPT_CERTINFO_FRESHESTCRL_FULLNAME
	CRYPT_CERTINFO_FRESHESTCRL_REASONS
	CRYPT_CERTINFO_FRESHESTCRL_CRLISSUER
	CRYPT_CERTINFO_ORDEREDLIST
	CRYPT_CERTINFO_BASEUPDATETIME
	CRYPT_CERTINFO_DELTAINFO
	CRYPT_CERTINFO_DELTAINFO_LOCATION
	CRYPT_CERTINFO_DELTAINFO_NEXTDELTA
	CRYPT_CERTINFO_INHIBITANYPOLICY
	CRYPT_CERTINFO_TOBEREVOKED
	CRYPT_CERTINFO_TOBEREVOKED_CERTISSUER
	CRYPT_CERTINFO_TOBEREVOKED_REASONCODE
	CRYPT_CERTINFO_TOBEREVOKED_REVOCATIONTIME
	CRYPT_CERTINFO_TOBEREVOKED_CERTSERIALNUMBER
	CRYPT_CERTINFO_REVOKEDGROUPS
	CRYPT_CERTINFO_REVOKEDGROUPS_CERTISSUER
	CRYPT_CERTINFO_REVOKEDGROUPS_REASONCODE
	CRYPT_CERTINFO_REVOKEDGROUPS_INVALIDITYDATE
	CRYPT_CERTINFO_REVOKEDGROUPS_STARTINGNUMBER
	CRYPT_CERTINFO_REVOKEDGROUPS_ENDINGNUMBER
	CRYPT_CERTINFO_EXPIREDCERTSONCRL
	CRYPT_CERTINFO_AAISSUINGDISTRIBUTIONPOINT
	CRYPT_CERTINFO_AAISSUINGDIST_FULLNAME
	CRYPT_CERTINFO_AAISSUINGDIST_SOMEREASONSONLY
	CRYPT_CERTINFO_AAISSUINGDIST_INDIRECTCRL
	CRYPT_CERTINFO_AAISSUINGDIST_USERATTRCERTS
	CRYPT_CERTINFO_AAISSUINGDIST_AACERTS
	CRYPT_CERTINFO_AAISSUINGDIST_SOACERTS
	CRYPT_CERTINFO_NS_CERTTYPE
	CRYPT_CERTINFO_NS_BASEURL
	CRYPT_CERTINFO_NS_REVOCATIONURL
	CRYPT_CERTINFO_NS_CAREVOCATIONURL
	CRYPT_CERTINFO_NS_CERTRENEWALURL
	CRYPT_CERTINFO_NS_CAPOLICYURL
	CRYPT_CERTINFO_NS_SSLSERVERNAME
	CRYPT_CERTINFO_NS_COMMENT
	CRYPT_CERTINFO_SET_HASHEDROOTKEY
	CRYPT_CERTINFO_SET_ROOTKEYTHUMBPRINT
	CRYPT_CERTINFO_SET_CERTIFICATETYPE
	CRYPT_CERTINFO_SET_MERCHANTDATA
	CRYPT_CERTINFO_SET_MERID
	CRYPT_CERTINFO_SET_MERACQUIRERBIN
	CRYPT_CERTINFO_SET_MERCHANTLANGUAGE
	CRYPT_CERTINFO_SET_MERCHANTNAME
	CRYPT_CERTINFO_SET_MERCHANTCITY
	CRYPT_CERTINFO_SET_MERCHANTSTATEPROVINCE
	CRYPT_CERTINFO_SET_MERCHANTPOSTALCODE
	CRYPT_CERTINFO_SET_MERCHANTCOUNTRYNAME
	CRYPT_CERTINFO_SET_MERCOUNTRY
	CRYPT_CERTINFO_SET_MERAUTHFLAG
	CRYPT_CERTINFO_SET_CERTCARDREQUIRED
	CRYPT_CERTINFO_SET_TUNNELING
	CRYPT_CERTINFO_SET_TUNNELLING = CRYPT_CERTINFO_SET_TUNNELING
	CRYPT_CERTINFO_SET_TUNNELINGFLAG
	CRYPT_CERTINFO_SET_TUNNELLINGFLAG = CRYPT_CERTINFO_SET_TUNNELINGFLAG
	CRYPT_CERTINFO_SET_TUNNELINGALGID
	CRYPT_CERTINFO_SET_TUNNELLINGALGID = CRYPT_CERTINFO_SET_TUNNELINGALGID
	CRYPT_CERTINFO_CMS_CONTENTTYPE = CRYPT_CERTINFO_FIRST + 500
	CRYPT_CERTINFO_CMS_MESSAGEDIGEST
	CRYPT_CERTINFO_CMS_SIGNINGTIME
	CRYPT_CERTINFO_CMS_COUNTERSIGNATURE
	CRYPT_CERTINFO_CMS_SIGNINGDESCRIPTION
	CRYPT_CERTINFO_CMS_SMIMECAPABILITIES
	CRYPT_CERTINFO_CMS_SMIMECAP_3DES
	CRYPT_CERTINFO_CMS_SMIMECAP_AES
	CRYPT_CERTINFO_CMS_SMIMECAP_CAST128
	CRYPT_CERTINFO_CMS_SMIMECAP_IDEA
	CRYPT_CERTINFO_CMS_SMIMECAP_RC2
	CRYPT_CERTINFO_CMS_SMIMECAP_RC5
	CRYPT_CERTINFO_CMS_SMIMECAP_SKIPJACK
	CRYPT_CERTINFO_CMS_SMIMECAP_DES
	CRYPT_CERTINFO_CMS_SMIMECAP_SHAng
	CRYPT_CERTINFO_CMS_SMIMECAP_SHA2
	CRYPT_CERTINFO_CMS_SMIMECAP_SHA1
	CRYPT_CERTINFO_CMS_SMIMECAP_HMAC_SHAng
	CRYPT_CERTINFO_CMS_SMIMECAP_HMAC_SHA2
	CRYPT_CERTINFO_CMS_SMIMECAP_HMAC_SHA1
	CRYPT_CERTINFO_CMS_SMIMECAP_AUTHENC256
	CRYPT_CERTINFO_CMS_SMIMECAP_AUTHENC128
	CRYPT_CERTINFO_CMS_SMIMECAP_RSA_SHAng
	CRYPT_CERTINFO_CMS_SMIMECAP_RSA_SHA2
	CRYPT_CERTINFO_CMS_SMIMECAP_RSA_SHA1
	CRYPT_CERTINFO_CMS_SMIMECAP_DSA_SHA1
	CRYPT_CERTINFO_CMS_SMIMECAP_ECDSA_SHAng
	CRYPT_CERTINFO_CMS_SMIMECAP_ECDSA_SHA2
	CRYPT_CERTINFO_CMS_SMIMECAP_ECDSA_SHA1
	CRYPT_CERTINFO_CMS_SMIMECAP_PREFERSIGNEDDATA
	CRYPT_CERTINFO_CMS_SMIMECAP_CANNOTDECRYPTANY
	CRYPT_CERTINFO_CMS_SMIMECAP_PREFERBINARYINSIDE
	CRYPT_CERTINFO_CMS_RECEIPTREQUEST
	CRYPT_CERTINFO_CMS_RECEIPT_CONTENTIDENTIFIER
	CRYPT_CERTINFO_CMS_RECEIPT_FROM
	CRYPT_CERTINFO_CMS_RECEIPT_TO
	CRYPT_CERTINFO_CMS_SECURITYLABEL
	CRYPT_CERTINFO_CMS_SECLABEL_POLICY
	CRYPT_CERTINFO_CMS_SECLABEL_CLASSIFICATION
	CRYPT_CERTINFO_CMS_SECLABEL_PRIVACYMARK
	CRYPT_CERTINFO_CMS_SECLABEL_CATTYPE
	CRYPT_CERTINFO_CMS_SECLABEL_CATVALUE
	CRYPT_CERTINFO_CMS_MLEXPANSIONHISTORY
	CRYPT_CERTINFO_CMS_MLEXP_ENTITYIDENTIFIER
	CRYPT_CERTINFO_CMS_MLEXP_TIME
	CRYPT_CERTINFO_CMS_MLEXP_NONE
	CRYPT_CERTINFO_CMS_MLEXP_INSTEADOF
	CRYPT_CERTINFO_CMS_MLEXP_INADDITIONTO
	CRYPT_CERTINFO_CMS_CONTENTHINTS
	CRYPT_CERTINFO_CMS_CONTENTHINT_DESCRIPTION
	CRYPT_CERTINFO_CMS_CONTENTHINT_TYPE
	CRYPT_CERTINFO_CMS_EQUIVALENTLABEL
	CRYPT_CERTINFO_CMS_EQVLABEL_POLICY
	CRYPT_CERTINFO_CMS_EQVLABEL_CLASSIFICATION
	CRYPT_CERTINFO_CMS_EQVLABEL_PRIVACYMARK
	CRYPT_CERTINFO_CMS_EQVLABEL_CATTYPE
	CRYPT_CERTINFO_CMS_EQVLABEL_CATVALUE
	CRYPT_CERTINFO_CMS_SIGNINGCERTIFICATE
	CRYPT_CERTINFO_CMS_SIGNINGCERT_ESSCERTID
	CRYPT_CERTINFO_CMS_SIGNINGCERT_POLICIES
	CRYPT_CERTINFO_CMS_SIGNINGCERTIFICATEV2
	CRYPT_CERTINFO_CMS_SIGNINGCERTV2_ESSCERTIDV2
	CRYPT_CERTINFO_CMS_SIGNINGCERTV2_POLICIES
	CRYPT_CERTINFO_CMS_SIGNATUREPOLICYID
	CRYPT_CERTINFO_CMS_SIGPOLICYID
	CRYPT_CERTINFO_CMS_SIGPOLICYHASH
	CRYPT_CERTINFO_CMS_SIGPOLICY_CPSURI
	CRYPT_CERTINFO_CMS_SIGPOLICY_ORGANIZATION
	CRYPT_CERTINFO_CMS_SIGPOLICY_NOTICENUMBERS
	CRYPT_CERTINFO_CMS_SIGPOLICY_EXPLICITTEXT
	CRYPT_CERTINFO_CMS_SIGTYPEIDENTIFIER
	CRYPT_CERTINFO_CMS_SIGTYPEID_ORIGINATORSIG
	CRYPT_CERTINFO_CMS_SIGTYPEID_DOMAINSIG
	CRYPT_CERTINFO_CMS_SIGTYPEID_ADDITIONALATTRIBUTES
	CRYPT_CERTINFO_CMS_SIGTYPEID_REVIEWSIG
	CRYPT_CERTINFO_CMS_NONCE
	CRYPT_CERTINFO_SCEP_MESSAGETYPE
	CRYPT_CERTINFO_SCEP_PKISTATUS
	CRYPT_CERTINFO_SCEP_FAILINFO
	CRYPT_CERTINFO_SCEP_SENDERNONCE
	CRYPT_CERTINFO_SCEP_RECIPIENTNONCE
	CRYPT_CERTINFO_SCEP_TRANSACTIONID
	CRYPT_CERTINFO_CMS_SPCAGENCYINFO
	CRYPT_CERTINFO_CMS_SPCAGENCYURL
	CRYPT_CERTINFO_CMS_SPCSTATEMENTTYPE
	CRYPT_CERTINFO_CMS_SPCSTMT_INDIVIDUALCODESIGNING
	CRYPT_CERTINFO_CMS_SPCSTMT_COMMERCIALCODESIGNING
	CRYPT_CERTINFO_CMS_SPCOPUSINFO
	CRYPT_CERTINFO_CMS_SPCOPUSINFO_NAME
	CRYPT_CERTINFO_CMS_SPCOPUSINFO_URL
	CRYPT_CERTINFO_LAST
	CRYPT_KEYINFO_FIRST = 3000
	CRYPT_KEYINFO_QUERY
	CRYPT_KEYINFO_QUERY_REQUESTS
	CRYPT_KEYINFO_LAST
	CRYPT_DEVINFO_FIRST = 4000
	CRYPT_DEVINFO_INITIALISE
	CRYPT_DEVINFO_INITIALIZE = CRYPT_DEVINFO_INITIALISE
	CRYPT_DEVINFO_AUTHENT_USER
	CRYPT_DEVINFO_AUTHENT_SUPERVISOR
	CRYPT_DEVINFO_SET_AUTHENT_USER
	CRYPT_DEVINFO_SET_AUTHENT_SUPERVISOR
	CRYPT_DEVINFO_ZEROISE
	CRYPT_DEVINFO_ZEROIZE = CRYPT_DEVINFO_ZEROISE
	CRYPT_DEVINFO_LOGGEDIN
	CRYPT_DEVINFO_LABEL
	CRYPT_DEVINFO_LAST
	CRYPT_ENVINFO_FIRST = 5000
	CRYPT_ENVINFO_DATASIZE
	CRYPT_ENVINFO_COMPRESSION
	CRYPT_ENVINFO_CONTENTTYPE
	CRYPT_ENVINFO_DETACHEDSIGNATURE
	CRYPT_ENVINFO_SIGNATURE_RESULT
	CRYPT_ENVINFO_INTEGRITY
	CRYPT_ENVINFO_PASSWORD
	CRYPT_ENVINFO_KEY
	CRYPT_ENVINFO_SIGNATURE
	CRYPT_ENVINFO_SIGNATURE_EXTRADATA
	CRYPT_ENVINFO_RECIPIENT
	CRYPT_ENVINFO_PUBLICKEY
	CRYPT_ENVINFO_PRIVATEKEY
	CRYPT_ENVINFO_PRIVATEKEY_LABEL
	CRYPT_ENVINFO_ORIGINATOR
	CRYPT_ENVINFO_SESSIONKEY
	CRYPT_ENVINFO_HASH
	CRYPT_ENVINFO_TIMESTAMP
	CRYPT_ENVINFO_KEYSET_SIGCHECK
	CRYPT_ENVINFO_KEYSET_ENCRYPT
	CRYPT_ENVINFO_KEYSET_DECRYPT
	CRYPT_ENVINFO_LAST
	CRYPT_SESSINFO_FIRST = 6000
	CRYPT_SESSINFO_ACTIVE
	CRYPT_SESSINFO_CONNECTIONACTIVE
	CRYPT_SESSINFO_USERNAME
	CRYPT_SESSINFO_PASSWORD
	CRYPT_SESSINFO_PRIVATEKEY
	CRYPT_SESSINFO_KEYSET
	CRYPT_SESSINFO_AUTHRESPONSE
	CRYPT_SESSINFO_SERVER_NAME
	CRYPT_SESSINFO_SERVER_PORT
	CRYPT_SESSINFO_SERVER_FINGERPRINT_SHA1
	CRYPT_SESSINFO_CLIENT_NAME
	CRYPT_SESSINFO_CLIENT_PORT
	CRYPT_SESSINFO_SESSION
	CRYPT_SESSINFO_NETWORKSOCKET
	CRYPT_SESSINFO_VERSION
	CRYPT_SESSINFO_REQUEST
	CRYPT_SESSINFO_RESPONSE
	CRYPT_SESSINFO_CACERTIFICATE
	CRYPT_SESSINFO_CMP_REQUESTTYPE
	CRYPT_SESSINFO_CMP_PRIVKEYSET
	CRYPT_SESSINFO_SSH_CHANNEL
	CRYPT_SESSINFO_SSH_CHANNEL_TYPE
	CRYPT_SESSINFO_SSH_CHANNEL_ARG1
	CRYPT_SESSINFO_SSH_CHANNEL_ARG2
	CRYPT_SESSINFO_SSH_CHANNEL_ACTIVE
	CRYPT_SESSINFO_SSL_OPTIONS
	CRYPT_SESSINFO_TSP_MSGIMPRINT
	CRYPT_SESSINFO_LAST
	CRYPT_USERINFO_FIRST = 7000
	CRYPT_USERINFO_PASSWORD
	CRYPT_USERINFO_CAKEY_CERTSIGN
	CRYPT_USERINFO_CAKEY_CRLSIGN
	CRYPT_USERINFO_CAKEY_RTCSSIGN
	CRYPT_USERINFO_CAKEY_OCSPSIGN
	CRYPT_USERINFO_LAST
	CRYPT_ATTRIBUTE_LAST = CRYPT_USERINFO_LAST
end enum

const CRYPT_KEYUSAGE_NONE = &h000
const CRYPT_KEYUSAGE_DIGITALSIGNATURE = &h001
const CRYPT_KEYUSAGE_NONREPUDIATION = &h002
const CRYPT_KEYUSAGE_KEYENCIPHERMENT = &h004
const CRYPT_KEYUSAGE_DATAENCIPHERMENT = &h008
const CRYPT_KEYUSAGE_KEYAGREEMENT = &h010
const CRYPT_KEYUSAGE_KEYCERTSIGN = &h020
const CRYPT_KEYUSAGE_CRLSIGN = &h040
const CRYPT_KEYUSAGE_ENCIPHERONLY = &h080
const CRYPT_KEYUSAGE_DECIPHERONLY = &h100
const CRYPT_KEYUSAGE_LAST = &h200

enum
	CRYPT_CRLREASON_UNSPECIFIED
	CRYPT_CRLREASON_KEYCOMPROMISE
	CRYPT_CRLREASON_CACOMPROMISE
	CRYPT_CRLREASON_AFFILIATIONCHANGED
	CRYPT_CRLREASON_SUPERSEDED
	CRYPT_CRLREASON_CESSATIONOFOPERATION
	CRYPT_CRLREASON_CERTIFICATEHOLD
	CRYPT_CRLREASON_REMOVEFROMCRL = 8
	CRYPT_CRLREASON_PRIVILEGEWITHDRAWN
	CRYPT_CRLREASON_AACOMPROMISE
	CRYPT_CRLREASON_LAST
	CRYPT_CRLREASON_NEVERVALID = 20
	CRYPT_CRLEXTREASON_LAST
end enum

const CRYPT_CRLREASONFLAG_UNUSED = &h001
const CRYPT_CRLREASONFLAG_KEYCOMPROMISE = &h002
const CRYPT_CRLREASONFLAG_CACOMPROMISE = &h004
const CRYPT_CRLREASONFLAG_AFFILIATIONCHANGED = &h008
const CRYPT_CRLREASONFLAG_SUPERSEDED = &h010
const CRYPT_CRLREASONFLAG_CESSATIONOFOPERATION = &h020
const CRYPT_CRLREASONFLAG_CERTIFICATEHOLD = &h040
const CRYPT_CRLREASONFLAG_LAST = &h080

enum
	CRYPT_HOLDINSTRUCTION_NONE
	CRYPT_HOLDINSTRUCTION_CALLISSUER
	CRYPT_HOLDINSTRUCTION_REJECT
	CRYPT_HOLDINSTRUCTION_PICKUPTOKEN
	CRYPT_HOLDINSTRUCTION_LAST
end enum

enum
	CRYPT_COMPLIANCELEVEL_OBLIVIOUS
	CRYPT_COMPLIANCELEVEL_REDUCED
	CRYPT_COMPLIANCELEVEL_STANDARD
	CRYPT_COMPLIANCELEVEL_PKIX_PARTIAL
	CRYPT_COMPLIANCELEVEL_PKIX_FULL
	CRYPT_COMPLIANCELEVEL_LAST
end enum

const CRYPT_NS_CERTTYPE_SSLCLIENT = &h001
const CRYPT_NS_CERTTYPE_SSLSERVER = &h002
const CRYPT_NS_CERTTYPE_SMIME = &h004
const CRYPT_NS_CERTTYPE_OBJECTSIGNING = &h008
const CRYPT_NS_CERTTYPE_RESERVED = &h010
const CRYPT_NS_CERTTYPE_SSLCA = &h020
const CRYPT_NS_CERTTYPE_SMIMECA = &h040
const CRYPT_NS_CERTTYPE_OBJECTSIGNINGCA = &h080
const CRYPT_NS_CERTTYPE_LAST = &h100
const CRYPT_SET_CERTTYPE_CARD = &h001
const CRYPT_SET_CERTTYPE_MER = &h002
const CRYPT_SET_CERTTYPE_PGWY = &h004
const CRYPT_SET_CERTTYPE_CCA = &h008
const CRYPT_SET_CERTTYPE_MCA = &h010
const CRYPT_SET_CERTTYPE_PCA = &h020
const CRYPT_SET_CERTTYPE_GCA = &h040
const CRYPT_SET_CERTTYPE_BCA = &h080
const CRYPT_SET_CERTTYPE_RCA = &h100
const CRYPT_SET_CERTTYPE_ACQ = &h200
const CRYPT_SET_CERTTYPE_LAST = &h400

type CRYPT_CONTENT_TYPE as long
enum
	CRYPT_CONTENT_NONE
	CRYPT_CONTENT_DATA
	CRYPT_CONTENT_SIGNEDDATA
	CRYPT_CONTENT_ENVELOPEDDATA
	CRYPT_CONTENT_SIGNEDANDENVELOPEDDATA
	CRYPT_CONTENT_DIGESTEDDATA
	CRYPT_CONTENT_ENCRYPTEDDATA
	CRYPT_CONTENT_COMPRESSEDDATA
	CRYPT_CONTENT_AUTHDATA
	CRYPT_CONTENT_AUTHENVDATA
	CRYPT_CONTENT_TSTINFO
	CRYPT_CONTENT_SPCINDIRECTDATACONTEXT
	CRYPT_CONTENT_RTCSREQUEST
	CRYPT_CONTENT_RTCSRESPONSE
	CRYPT_CONTENT_RTCSRESPONSE_EXT
	CRYPT_CONTENT_MRTD
	CRYPT_CONTENT_LAST
end enum

enum
	CRYPT_CLASSIFICATION_UNMARKED
	CRYPT_CLASSIFICATION_UNCLASSIFIED
	CRYPT_CLASSIFICATION_RESTRICTED
	CRYPT_CLASSIFICATION_CONFIDENTIAL
	CRYPT_CLASSIFICATION_SECRET
	CRYPT_CLASSIFICATION_TOP_SECRET
	CRYPT_CLASSIFICATION_LAST = 255
end enum

enum
	CRYPT_CERTSTATUS_VALID
	CRYPT_CERTSTATUS_NOTVALID
	CRYPT_CERTSTATUS_NONAUTHORITATIVE
	CRYPT_CERTSTATUS_UNKNOWN
end enum

enum
	CRYPT_OCSPSTATUS_NOTREVOKED
	CRYPT_OCSPSTATUS_REVOKED
	CRYPT_OCSPSTATUS_UNKNOWN
end enum

type CRYPT_SIGNATURELEVEL_TYPE as long
enum
	CRYPT_SIGNATURELEVEL_NONE
	CRYPT_SIGNATURELEVEL_SIGNERCERT
	CRYPT_SIGNATURELEVEL_ALL
	CRYPT_SIGNATURELEVEL_LAST
end enum

type CRYPT_INTEGRITY_TYPE as long
enum
	CRYPT_INTEGRITY_NONE
	CRYPT_INTEGRITY_MACONLY
	CRYPT_INTEGRITY_FULL
end enum

type CRYPT_CERTFORMAT_TYPE as long
enum
	CRYPT_CERTFORMAT_NONE
	CRYPT_CERTFORMAT_CERTIFICATE
	CRYPT_CERTFORMAT_CERTCHAIN
	CRYPT_CERTFORMAT_TEXT_CERTIFICATE
	CRYPT_CERTFORMAT_TEXT_CERTCHAIN
	CRYPT_CERTFORMAT_XML_CERTIFICATE
	CRYPT_CERTFORMAT_XML_CERTCHAIN
	CRYPT_CERTFORMAT_LAST
end enum

type CRYPT_REQUESTTYPE_TYPE as long
enum
	CRYPT_REQUESTTYPE_NONE
	CRYPT_REQUESTTYPE_INITIALISATION
	CRYPT_REQUESTTYPE_INITIALIZATION = CRYPT_REQUESTTYPE_INITIALISATION
	CRYPT_REQUESTTYPE_CERTIFICATE
	CRYPT_REQUESTTYPE_KEYUPDATE
	CRYPT_REQUESTTYPE_REVOCATION
	CRYPT_REQUESTTYPE_PKIBOOT
	CRYPT_REQUESTTYPE_LAST
end enum

type CRYPT_KEYID_TYPE as long
enum
	CRYPT_KEYID_NONE
	CRYPT_KEYID_NAME
	CRYPT_KEYID_URI
	CRYPT_KEYID_EMAIL = CRYPT_KEYID_URI
	CRYPT_KEYID_LAST
end enum

type CRYPT_OBJECT_TYPE as long
enum
	CRYPT_OBJECT_NONE
	CRYPT_OBJECT_ENCRYPTED_KEY
	CRYPT_OBJECT_PKCENCRYPTED_KEY
	CRYPT_OBJECT_KEYAGREEMENT
	CRYPT_OBJECT_SIGNATURE
	CRYPT_OBJECT_LAST
end enum

type CRYPT_ERRTYPE_TYPE as long
enum
	CRYPT_ERRTYPE_NONE
	CRYPT_ERRTYPE_ATTR_SIZE
	CRYPT_ERRTYPE_ATTR_VALUE
	CRYPT_ERRTYPE_ATTR_ABSENT
	CRYPT_ERRTYPE_ATTR_PRESENT
	CRYPT_ERRTYPE_CONSTRAINT
	CRYPT_ERRTYPE_ISSUERCONSTRAINT
	CRYPT_ERRTYPE_LAST
end enum

type CRYPT_CERTACTION_TYPE as long
enum
	CRYPT_CERTACTION_NONE
	CRYPT_CERTACTION_CREATE
	CRYPT_CERTACTION_CONNECT
	CRYPT_CERTACTION_DISCONNECT
	CRYPT_CERTACTION_ERROR
	CRYPT_CERTACTION_ADDUSER
	CRYPT_CERTACTION_DELETEUSER
	CRYPT_CERTACTION_REQUEST_CERT
	CRYPT_CERTACTION_REQUEST_RENEWAL
	CRYPT_CERTACTION_REQUEST_REVOCATION
	CRYPT_CERTACTION_CERT_CREATION
	CRYPT_CERTACTION_CERT_CREATION_COMPLETE
	CRYPT_CERTACTION_CERT_CREATION_DROP
	CRYPT_CERTACTION_CERT_CREATION_REVERSE
	CRYPT_CERTACTION_RESTART_CLEANUP
	CRYPT_CERTACTION_RESTART_REVOKE_CERT
	CRYPT_CERTACTION_ISSUE_CERT
	CRYPT_CERTACTION_ISSUE_CRL
	CRYPT_CERTACTION_REVOKE_CERT
	CRYPT_CERTACTION_EXPIRE_CERT
	CRYPT_CERTACTION_CLEANUP
	CRYPT_CERTACTION_LAST
end enum

const CRYPT_SSLOPTION_NONE = &h00
const CRYPT_SSLOPTION_MINVER_SSLV3 = &h00
const CRYPT_SSLOPTION_MINVER_TLS10 = &h01
const CRYPT_SSLOPTION_MINVER_TLS11 = &h02
const CRYPT_SSLOPTION_MINVER_TLS12 = &h03
const CRYPT_SSLOPTION_SUITEB_128 = &h04
const CRYPT_SSLOPTION_SUITEB_256 = &h08
const CRYPT_SSLOPTION_DISABLE_NAMEVERIFY = &h10
const CRYPT_SSLOPTION_DISABLE_CERTVERIFY = &h20
const CRYPT_MAX_KEYSIZE = 256
const CRYPT_MAX_IVSIZE = 32
const CRYPT_MAX_PKCSIZE = 512
const CRYPT_MAX_PKCSIZE_ECC = 72
const CRYPT_MAX_HASHSIZE = 64
const CRYPT_MAX_TEXTSIZE = 64
const CRYPT_USE_DEFAULT = -100
const CRYPT_UNUSED = -101
const CRYPT_CURSOR_FIRST = -200
const CRYPT_CURSOR_PREVIOUS = -201
const CRYPT_CURSOR_NEXT = -202
const CRYPT_CURSOR_LAST = -203
const CRYPT_RANDOM_FASTPOLL = -300
const CRYPT_RANDOM_SLOWPOLL = -301
const CRYPT_KEYTYPE_PRIVATE = 0
const CRYPT_KEYTYPE_PUBLIC = 1

type CRYPT_KEYOPT_TYPE as long
enum
	CRYPT_KEYOPT_NONE
	CRYPT_KEYOPT_READONLY
	CRYPT_KEYOPT_CREATE
	CRYPT_KEYOPT_LAST
end enum

type CRYPT_CERTIFICATE as long
type CRYPT_CONTEXT as long
type CRYPT_DEVICE as long
type CRYPT_ENVELOPE as long
type CRYPT_KEYSET as long
type CRYPT_SESSION as long
type CRYPT_USER as long
type CRYPT_HANDLE as long

type CRYPT_QUERY_INFO
	algoName as zstring * 64
	blockSize as long
	minKeySize as long
	keySize as long
	maxKeySize as long
end type

type CRYPT_OBJECT_INFO
	objectType as CRYPT_OBJECT_TYPE
	cryptAlgo as CRYPT_ALGO_TYPE
	cryptMode as CRYPT_MODE_TYPE
	hashAlgo as CRYPT_ALGO_TYPE
	salt(0 to 63) as ubyte
	saltSize as long
end type

type CRYPT_PKCINFO_RSA
	isPublicKey as long
	n(0 to 511) as ubyte
	nLen as long
	e(0 to 511) as ubyte
	eLen as long
	d(0 to 511) as ubyte
	dLen as long
	p(0 to 511) as ubyte
	pLen as long
	q(0 to 511) as ubyte
	qLen as long
	u(0 to 511) as ubyte
	uLen as long
	e1(0 to 511) as ubyte
	e1Len as long
	e2(0 to 511) as ubyte
	e2Len as long
end type

type CRYPT_PKCINFO_DLP
	isPublicKey as long
	p(0 to 511) as ubyte
	pLen as long
	q(0 to 511) as ubyte
	qLen as long
	g(0 to 511) as ubyte
	gLen as long
	y(0 to 511) as ubyte
	yLen as long
	x(0 to 511) as ubyte
	xLen as long
end type

type CRYPT_ECCCURVE_TYPE as long
enum
	CRYPT_ECCCURVE_NONE
	CRYPT_ECCCURVE_P192
	CRYPT_ECCCURVE_P224
	CRYPT_ECCCURVE_P256
	CRYPT_ECCCURVE_P384
	CRYPT_ECCCURVE_P521
	CRYPT_ECCCURVE_BRAINPOOL_P256
	CRYPT_ECCCURVE_BRAINPOOL_P384
	CRYPT_ECCCURVE_BRAINPOOL_P512
	CRYPT_ECCCURVE_LAST
end enum

type CRYPT_PKCINFO_ECC
	isPublicKey as long
	curveType as CRYPT_ECCCURVE_TYPE
	p(0 to 71) as ubyte
	pLen as long
	a(0 to 71) as ubyte
	aLen as long
	b(0 to 71) as ubyte
	bLen as long
	gx(0 to 71) as ubyte
	gxLen as long
	gy(0 to 71) as ubyte
	gyLen as long
	n(0 to 71) as ubyte
	nLen as long
	h(0 to 71) as ubyte
	hLen as long
	qx(0 to 71) as ubyte
	qxLen as long
	qy(0 to 71) as ubyte
	qyLen as long
	d(0 to 71) as ubyte
	dLen as long
end type

#macro cryptInitComponents(componentInfo, componentKeyType)
	scope
		memset((componentInfo), 0, sizeof(*componentInfo))
		(componentInfo)->isPublicKey = iif((componentKeyType), 1, 0)
	end scope
#endmacro
#define cryptDestroyComponents(componentInfo) memset((componentInfo), 0, sizeof(*componentInfo))
#macro cryptSetComponent(destination, source, length)
	scope
		memcpy((destination), (source), ((length) + 7) shr 3)
		destination##Len = length
	end scope
#endmacro
const CRYPT_OK = 0
const CRYPT_ERROR_PARAM1 = -1
const CRYPT_ERROR_PARAM2 = -2
const CRYPT_ERROR_PARAM3 = -3
const CRYPT_ERROR_PARAM4 = -4
const CRYPT_ERROR_PARAM5 = -5
const CRYPT_ERROR_PARAM6 = -6
const CRYPT_ERROR_PARAM7 = -7
const CRYPT_ERROR_MEMORY = -10
const CRYPT_ERROR_NOTINITED = -11
const CRYPT_ERROR_INITED = -12
const CRYPT_ERROR_NOSECURE = -13
const CRYPT_ERROR_RANDOM = -14
const CRYPT_ERROR_FAILED = -15
const CRYPT_ERROR_INTERNAL = -16
const CRYPT_ERROR_NOTAVAIL = -20
const CRYPT_ERROR_PERMISSION = -21
const CRYPT_ERROR_WRONGKEY = -22
const CRYPT_ERROR_INCOMPLETE = -23
const CRYPT_ERROR_COMPLETE = -24
const CRYPT_ERROR_TIMEOUT = -25
const CRYPT_ERROR_INVALID = -26
const CRYPT_ERROR_SIGNALLED = -27
const CRYPT_ERROR_OVERFLOW = -30
const CRYPT_ERROR_UNDERFLOW = -31
const CRYPT_ERROR_BADDATA = -32
const CRYPT_ERROR_SIGNATURE = -33
const CRYPT_ERROR_OPEN = -40
const CRYPT_ERROR_READ = -41
const CRYPT_ERROR_WRITE = -42
const CRYPT_ERROR_NOTFOUND = -43
const CRYPT_ERROR_DUPLICATE = -44
const CRYPT_ENVELOPE_RESOURCE = -50
#define cryptStatusError(status) ((status) < CRYPT_OK)
#define cryptStatusOK(status) ((status) = CRYPT_OK)

declare function cryptInit() as long
declare function cryptEnd() as long
declare function cryptQueryCapability(byval cryptAlgo as const CRYPT_ALGO_TYPE, byval cryptQueryInfo as CRYPT_QUERY_INFO ptr) as long
declare function cryptCreateContext(byval cryptContext as CRYPT_CONTEXT ptr, byval cryptUser as const CRYPT_USER, byval cryptAlgo as const CRYPT_ALGO_TYPE) as long
declare function cryptDestroyContext(byval cryptContext as const CRYPT_CONTEXT) as long
declare function cryptDestroyObject(byval cryptObject as const CRYPT_HANDLE) as long
declare function cryptGenerateKey(byval cryptContext as const CRYPT_CONTEXT) as long
declare function cryptEncrypt(byval cryptContext as const CRYPT_CONTEXT, byval buffer as any ptr, byval length as const long) as long
declare function cryptDecrypt(byval cryptContext as const CRYPT_CONTEXT, byval buffer as any ptr, byval length as const long) as long
declare function cryptSetAttribute(byval cryptHandle as const CRYPT_HANDLE, byval attributeType as const CRYPT_ATTRIBUTE_TYPE, byval value as const long) as long
declare function cryptSetAttributeString(byval cryptHandle as const CRYPT_HANDLE, byval attributeType as const CRYPT_ATTRIBUTE_TYPE, byval value as const any ptr, byval valueLength as const long) as long
declare function cryptGetAttribute(byval cryptHandle as const CRYPT_HANDLE, byval attributeType as const CRYPT_ATTRIBUTE_TYPE, byval value as long ptr) as long
declare function cryptGetAttributeString(byval cryptHandle as const CRYPT_HANDLE, byval attributeType as const CRYPT_ATTRIBUTE_TYPE, byval value as any ptr, byval valueLength as long ptr) as long
declare function cryptDeleteAttribute(byval cryptHandle as const CRYPT_HANDLE, byval attributeType as const CRYPT_ATTRIBUTE_TYPE) as long
declare function cryptAddRandom(byval randomData as const any ptr, byval randomDataLength as const long) as long
declare function cryptQueryObject(byval objectData as const any ptr, byval objectDataLength as const long, byval cryptObjectInfo as CRYPT_OBJECT_INFO ptr) as long
declare function cryptExportKey(byval encryptedKey as any ptr, byval encryptedKeyMaxLength as const long, byval encryptedKeyLength as long ptr, byval exportKey as const CRYPT_HANDLE, byval sessionKeyContext as const CRYPT_CONTEXT) as long
declare function cryptExportKeyEx(byval encryptedKey as any ptr, byval encryptedKeyMaxLength as const long, byval encryptedKeyLength as long ptr, byval formatType as const CRYPT_FORMAT_TYPE, byval exportKey as const CRYPT_HANDLE, byval sessionKeyContext as const CRYPT_CONTEXT) as long
declare function cryptImportKey(byval encryptedKey as const any ptr, byval encryptedKeyLength as const long, byval importKey as const CRYPT_CONTEXT, byval sessionKeyContext as const CRYPT_CONTEXT) as long
declare function cryptImportKeyEx(byval encryptedKey as const any ptr, byval encryptedKeyLength as const long, byval importKey as const CRYPT_CONTEXT, byval sessionKeyContext as const CRYPT_CONTEXT, byval returnedContext as CRYPT_CONTEXT ptr) as long
declare function cryptCreateSignature(byval signature as any ptr, byval signatureMaxLength as const long, byval signatureLength as long ptr, byval signContext as const CRYPT_CONTEXT, byval hashContext as const CRYPT_CONTEXT) as long
declare function cryptCreateSignatureEx(byval signature as any ptr, byval signatureMaxLength as const long, byval signatureLength as long ptr, byval formatType as const CRYPT_FORMAT_TYPE, byval signContext as const CRYPT_CONTEXT, byval hashContext as const CRYPT_CONTEXT, byval extraData as const CRYPT_CERTIFICATE) as long
declare function cryptCheckSignature(byval signature as const any ptr, byval signatureLength as const long, byval sigCheckKey as const CRYPT_HANDLE, byval hashContext as const CRYPT_CONTEXT) as long
declare function cryptCheckSignatureEx(byval signature as const any ptr, byval signatureLength as const long, byval sigCheckKey as const CRYPT_HANDLE, byval hashContext as const CRYPT_CONTEXT, byval extraData as CRYPT_HANDLE ptr) as long
declare function cryptKeysetOpen(byval keyset as CRYPT_KEYSET ptr, byval cryptUser as const CRYPT_USER, byval keysetType as const CRYPT_KEYSET_TYPE, byval name as const zstring ptr, byval options as const CRYPT_KEYOPT_TYPE) as long
declare function cryptKeysetClose(byval keyset as const CRYPT_KEYSET) as long
declare function cryptGetPublicKey(byval keyset as const CRYPT_KEYSET, byval cryptContext as CRYPT_CONTEXT ptr, byval keyIDtype as const CRYPT_KEYID_TYPE, byval keyID as const zstring ptr) as long
declare function cryptGetPrivateKey(byval keyset as const CRYPT_KEYSET, byval cryptContext as CRYPT_CONTEXT ptr, byval keyIDtype as const CRYPT_KEYID_TYPE, byval keyID as const zstring ptr, byval password as const zstring ptr) as long
declare function cryptGetKey(byval keyset as const CRYPT_KEYSET, byval cryptContext as CRYPT_CONTEXT ptr, byval keyIDtype as const CRYPT_KEYID_TYPE, byval keyID as const zstring ptr, byval password as const zstring ptr) as long
declare function cryptAddPublicKey(byval keyset as const CRYPT_KEYSET, byval certificate as const CRYPT_CERTIFICATE) as long
declare function cryptAddPrivateKey(byval keyset as const CRYPT_KEYSET, byval cryptKey as const CRYPT_HANDLE, byval password as const zstring ptr) as long
declare function cryptDeleteKey(byval keyset as const CRYPT_KEYSET, byval keyIDtype as const CRYPT_KEYID_TYPE, byval keyID as const zstring ptr) as long
declare function cryptCreateCert(byval certificate as CRYPT_CERTIFICATE ptr, byval cryptUser as const CRYPT_USER, byval certType as const CRYPT_CERTTYPE_TYPE) as long
declare function cryptDestroyCert(byval certificate as const CRYPT_CERTIFICATE) as long
declare function cryptGetCertExtension(byval certificate as const CRYPT_CERTIFICATE, byval oid as const zstring ptr, byval criticalFlag as long ptr, byval extension as any ptr, byval extensionMaxLength as const long, byval extensionLength as long ptr) as long
declare function cryptAddCertExtension(byval certificate as const CRYPT_CERTIFICATE, byval oid as const zstring ptr, byval criticalFlag as const long, byval extension as const any ptr, byval extensionLength as const long) as long
declare function cryptDeleteCertExtension(byval certificate as const CRYPT_CERTIFICATE, byval oid as const zstring ptr) as long
declare function cryptSignCert(byval certificate as const CRYPT_CERTIFICATE, byval signContext as const CRYPT_CONTEXT) as long
declare function cryptCheckCert(byval certificate as const CRYPT_CERTIFICATE, byval sigCheckKey as const CRYPT_HANDLE) as long
declare function cryptImportCert(byval certObject as const any ptr, byval certObjectLength as const long, byval cryptUser as const CRYPT_USER, byval certificate as CRYPT_CERTIFICATE ptr) as long
declare function cryptExportCert(byval certObject as any ptr, byval certObjectMaxLength as const long, byval certObjectLength as long ptr, byval certFormatType as const CRYPT_CERTFORMAT_TYPE, byval certificate as const CRYPT_CERTIFICATE) as long
declare function cryptCAAddItem(byval keyset as const CRYPT_KEYSET, byval certificate as const CRYPT_CERTIFICATE) as long
declare function cryptCAGetItem(byval keyset as const CRYPT_KEYSET, byval certificate as CRYPT_CERTIFICATE ptr, byval certType as const CRYPT_CERTTYPE_TYPE, byval keyIDtype as const CRYPT_KEYID_TYPE, byval keyID as const zstring ptr) as long
declare function cryptCADeleteItem(byval keyset as const CRYPT_KEYSET, byval certType as const CRYPT_CERTTYPE_TYPE, byval keyIDtype as const CRYPT_KEYID_TYPE, byval keyID as const zstring ptr) as long
declare function cryptCACertManagement(byval certificate as CRYPT_CERTIFICATE ptr, byval action as const CRYPT_CERTACTION_TYPE, byval keyset as const CRYPT_KEYSET, byval caKey as const CRYPT_CONTEXT, byval certRequest as const CRYPT_CERTIFICATE) as long
declare function cryptCreateEnvelope(byval envelope as CRYPT_ENVELOPE ptr, byval cryptUser as const CRYPT_USER, byval formatType as const CRYPT_FORMAT_TYPE) as long
declare function cryptDestroyEnvelope(byval envelope as const CRYPT_ENVELOPE) as long
declare function cryptCreateSession(byval session as CRYPT_SESSION ptr, byval cryptUser as const CRYPT_USER, byval formatType as const CRYPT_SESSION_TYPE) as long
declare function cryptDestroySession(byval session as const CRYPT_SESSION) as long
declare function cryptPushData(byval envelope as const CRYPT_HANDLE, byval buffer as const any ptr, byval length as const long, byval bytesCopied as long ptr) as long
declare function cryptFlushData(byval envelope as const CRYPT_HANDLE) as long
declare function cryptPopData(byval envelope as const CRYPT_HANDLE, byval buffer as any ptr, byval length as const long, byval bytesCopied as long ptr) as long
declare function cryptDeviceOpen(byval device as CRYPT_DEVICE ptr, byval cryptUser as const CRYPT_USER, byval deviceType as const CRYPT_DEVICE_TYPE, byval name as const zstring ptr) as long
declare function cryptDeviceClose(byval device as const CRYPT_DEVICE) as long
declare function cryptDeviceQueryCapability(byval device as const CRYPT_DEVICE, byval cryptAlgo as const CRYPT_ALGO_TYPE, byval cryptQueryInfo as CRYPT_QUERY_INFO ptr) as long
declare function cryptDeviceCreateContext(byval device as const CRYPT_DEVICE, byval cryptContext as CRYPT_CONTEXT ptr, byval cryptAlgo as const CRYPT_ALGO_TYPE) as long
declare function cryptLogin(byval user as CRYPT_USER ptr, byval name as const zstring ptr, byval password as const zstring ptr) as long
declare function cryptLogout(byval user as const CRYPT_USER) as long

#ifdef __FB_WIN32__
	declare function cryptUIGenerateKey(byval cryptDevice as const CRYPT_DEVICE, byval cryptContext as CRYPT_CONTEXT ptr, byval cryptCert as const CRYPT_CERTIFICATE, byval password as zstring ptr, byval hWnd as const HWND) as long
	declare function cryptUIDisplayCert(byval cryptCert as const CRYPT_CERTIFICATE, byval hWnd as const HWND) as long
#endif

end extern
