'' 程序重载:
''

'' 至少一个必须标记为加载
declare sub foo overload ( byval bar as integer )
declare sub foo          ( byval bar as uinteger )
declare sub foo          ( byval bar as single )
declare sub foo          ( byval bar as double )
declare sub foo          ( byval bar as longint )

dim intvar as integer
dim uintvar as uinteger
dim fltvar as single
dim dblvar as double
dim lngvar as longint

foo( intvar )
foo( uintvar )
foo( fltvar )
foo( dblvar )
foo( lngvar )

foo( cdbl( intvar ) )
foo( intvar + dblvar )

private sub foo( byval bar as integer )
	print "foo(integer) called"
end sub

private sub foo( byval bar as uinteger )
	print "foo(uinteger) called"
end sub

private sub foo( byval bar as single )
	print "foo(single) called"
end sub

private sub foo( byval bar as double )
	print "foo(double) called"
end sub

private sub foo( byval bar as longint )
	print "foo(longint) called"
end sub

''
'' 用户定义类型的运算符重载：
''
'' - 所有二进制运算符都可以重载，除了关系运算符
''
'' - Self-operators （OP =）分别处理可以获得更好的性能， 
''
'' - 大多数的一元运算符可以被重载，包括铸造、地址（@）,
''   指针解引用操作符（*）和UDT成员指针引用（->）
''
'' - 赋值运算符也可以重载（operator Let)
''

type MyInteger
	i as integer
	declare constructor( as integer )
	declare operator cast( ) as string
end type

constructor MyInteger( i as integer )
	this.i = i
end constructor

operator MyInteger.cast( ) as string
	return str( this.i )
end operator

operator + ( byref l as MyInteger, byref r as MyInteger ) as MyInteger
	return MyInteger( l.i + r.i )
end operator

dim as MyInteger x = MyInteger( 3 ), y = MyInteger( 4 )
print x + y

sleep
