''
 ' 这个例子展示了如何可以模拟得到一个类方法指针
 ' 直到支持的编译器的正确执行
 '
 ' 当这个被支持时，你只需要移除这里介绍的静态包装函数，来保持兼容性。
 '/

type MyFavoriteType
	declare function myFavoriteMethod(byval number as integer) as integer
	declare static function myFavoriteMethod(byref this as MyFavoriteType, byval number as integer) as integer

	dim as integer myFavoriteNumber = 420
end type

function MyFavoriteType.myFavoriteMethod(byval number as integer) as integer
	return myFavoriteNumber + number
end function

function MyFavoriteType.myFavoriteMethod(byref this as MyFavoriteType, byval number as integer) as integer
	return this.myFavoriteMethod(number)
end function

dim methodPointer as function(byref as MyFavoriteType, byval as integer) as integer
methodPointer = ProcPtr(MyFavoriteType.myFavoriteMethod)

dim as MyFavoriteType obj

print methodPointer(obj, 69) '' prints 489
