''
'' 固定大小的数组:
''
	dim a(0 to 9) as integer '' 10 elements
	dim b(9) as integer      '' 10 elements (default lower bound is 0)
	dim c(5 to 6) as integer '' 2 elements

	print lbound(a), ubound(a)
	print lbound(b), ubound(b)
	print lbound(c), ubound(c)

''
'' 动态数组（高达2 GB的大小）:
''
	dim d() as integer '' 空数组

	redim d(1 to 10)   '' 为数组分配内存
	redim preserve d(1 to 20) '' 在保持内容的同时调整数组大小

	print lbound(d), ubound(d)

	erase d            '' 释放数组内存

''
'' 多维度（高达8支持）：
''
	dim matrix(0 to 3, 0 to 3, 0 to 3, 0 to 3) as integer
	print matrix(0, 0, 0, 0)

''
'' 阵列的领域：
'' （注：动态数组现在不允许在UDTs，只有固定大小的）
''
	type MyType
		foo(0 to 9) as integer
	end type

	dim x as MyType
	print lbound(x.foo), ubound(x.foo)

''
'' 传递数组到程序：
''
	sub fillWithSomeData( array() as integer )
		for i as integer = lbound(array) to ubound(array)
			array(i) = i
		next
	end sub

	sub printArrayData( array() as integer )
		for i as integer = lbound(array) to ubound(array)
			print array(i);" ";
		next
		print
	end sub

	fillWithSomeData( a() )
	fillWithSomeData( c() )

	printArrayData( a() )
	printArrayData( c() )
