'[NAME] FF_MakeFontEX
'[AUTHORNAME] 
'[EMAIL] 
'[WEBSITE] 
'[VERSION] 
'[ISFAVORITE] No
'[EXPAND] No
'[ISPROTOTYPE] No
'[KEYWORDS] 
'font
'[/KEYWORDS]
'[DESCRIPTION] 
'   һ岢ľ
'
'   ʹʱɾ DeleteObject(hFont)
'
'[/DESCRIPTION]
'[CODESTART]
' ========================================================================================
' Jose RocaĴ뷵ظ߼߶ȵĵС
' ========================================================================================
Function FF_AfxGetFontPointSize( ByVal nHeight As Long ) As Long
   Dim hDC As hDC
   hDC = CreateDC("DISPLAY", ByVal Null, ByVal Null, ByVal Null)
   If hDC = Null Then Exit Function
   Dim cyPixelsPerInch As Long
   cyPixelsPerInch = GetDeviceCaps(hDC, LOGPIXELSY)
   DeleteDC hDC
   Dim nPointSize As Long
   nPointSize = MulDiv(nHeight, 72, cyPixelsPerInch)
   If nPointSize < 0 Then nPointSize = -nPointSize
   Function = nPointSize
End Function


Function FF_GetFontInfo( ByRef sCurValue  As String, _
                         ByRef sFontName  As String, _
                         ByRef nPointSize As Long, _
                         ByRef nWeight    As Long, _
                         ByRef nItalic    As Long, _
                         ByRef nUnderline As Long, _
                         ByRef nStrikeOut As Long, _
                         ByRef nFontStyle As Long _
                         ) As Long
                         
  ' FireFly͵ַ һǴͳlogfontַڶǼ򻯵PB汾 
  ' FireFlyת򻯰汾Ҫlogfont汾ʵԡ

  '㴫ַжŵ
  Dim nCount As Integer
  Dim i      As Integer 
  
  For i = 0 To Len(sCurValue) - 1
     If sCurValue[i] = 44 Then nCount = nCount + 1
  Next
  
  If nCount > 10 Then
     ' Ǿʽlogfontṹ
     ' "Tahoma,-11,0,0,0,400,0,0,0,0,3,2,1,34"        ' 400 = normal, 700 = bold
     sFontName  = FF_Parse(sCurValue, ",", 1)
     nPointSize = FF_AfxGetFontPointSize(Val(FF_Parse(sCurValue, ",", 2)))
     nWeight    = Val(FF_Parse(sCurValue, ",", 6))
     nItalic    = Val(FF_Parse(sCurValue, ",", 7)) 
     nUnderline = Val(FF_Parse(sCurValue, ",", 8))
     nStrikeOut = Val(FF_Parse(sCurValue, ",", 9)) 
     If nWeight = FW_BOLD Then nFontStyle = nFontStyle + 1   ' normal/bold
     If nItalic           Then nFontStyle = nFontStyle + 2   ' italic
     If nUnderline        Then nFontStyle = nFontStyle + 4   ' underline
     If nStrikeOut        Then nFontStyle = nFontStyle + 8   ' strikeout
  Else
     ' This is the new style (3 parts)
     sFontName  = FF_Parse(sCurValue, ",", 1)
     nPointSize = Val(FF_Parse(sCurValue, ",", 2))
     nFontStyle = Val(FF_Parse(sCurValue, ",", 3))
     nWeight = FW_NORMAL
     If (nFontStyle And 1) Then nWeight    = FW_BOLD 
     If (nFontStyle And 2) Then nItalic    = True
     If (nFontStyle And 4) Then nUnderline = True
     If (nFontStyle And 8) Then nStrikeOut = True
  End If

  Function = 0
     
End Function


Function FF_EnumCharSet( _
                       elf            As ENUMLOGFONT,   _
                       ntm            As NEWTEXTMETRIC, _
                       ByVal FontType As Long, _
                       CharSet        As Long  _
                       ) As Long
                       
    CharSet = elf.elfLogFont.lfCharSet 
    Function = True
End Function


Function FF_MakeFontEX( sFont            As String, _
                        ByVal PointSize  As Long,   _
                        ByVal fBold      As Long,   _ 
                        ByVal fItalic    As Long,   _
                        ByVal fUnderline As Long,   _
                        ByVal StrikeThru As Long    _
                        ) As HFONT

    Dim tlf      As LOGFONT
    Dim hDC      As hDC
    Dim CharSet  As Integer
    Dim m_DPI    As Integer
    
    ' dpiʶ
    If Len(sFont) = 0 Then Exit Function

    hDC = GetDC(0)

    EnumFontFamilies hDC, ByVal StrPtr(sFont), Cast(FONTENUMPROC,@FF_EnumCharSet), ByVal Cast(lParam, VarPtr(CharSet))
    
    m_DPI = GetDeviceCaps(hDC, LOGPIXELSX)
    PointSize = (PointSize * m_DPI) \ GetDeviceCaps(hDC, LOGPIXELSY)

    tlf.lfHeight         = -MulDiv(PointSize, GetDeviceCaps(hDC, LOGPIXELSY), 72)   ' ߼߶
    tlf.lfWidth          =  0                                                       ' ƽַ
    tlf.lfEscapement     =  0                                                       ' escapement
    tlf.lfOrientation    =  0                                                       ' orientation angles
    tlf.lfWeight         =  fBold                                                   ' font weight
    tlf.lfItalic         =  fItalic                                                 ' italic(TRUE/FALSE)
    tlf.lfUnderline      =  fUnderline                                              ' underline(TRUE/FALSE)
    tlf.lfStrikeOut      =  StrikeThru                                              ' strikeout(TRUE/FALSE)
    tlf.lfCharSet        =  Charset                                                 ' character set
    tlf.lfOutPrecision   =  OUT_TT_PRECIS                                           ' output precision
    tlf.lfClipPrecision  =  CLIP_DEFAULT_PRECIS                                     ' clipping precision
    tlf.lfQuality        =  DEFAULT_QUALITY                                         ' output quality
    tlf.lfPitchAndFamily =  FF_DONTCARE                                             ' pitch and family
    tlf.lfFaceName       =  sFont                                                   ' typeface name

    ReleaseDC 0, hDC

    Function = CreateFontIndirect(@tlf)

End Function               



Function FF_MakeFontEx_Internal( sFont As String ) As HFONT

   Dim hFont      As HFONT
   Dim sFontName  As String
   Dim nPointSize As Long
   Dim nWeight    As Long
   Dim nItalic    As Long
   Dim nUnderline As Long
   Dim nStrikeOut As Long 
   Dim nFontStyle As Long 
      
   FF_GetFontInfo sFont, sFontName, nPointSize, nWeight, nItalic, nUnderline, nStrikeOut, nFontStyle 
'   hFont = FF_MakeFontEX( sFontName, nPointSize, nWeight, nItalic, nUnderline, nStrikeOut )
#ifdef FF_NOSCALE
   hFont = AfxCreateFont ( sFontName, nPointSize,96, nWeight, nItalic, nUnderline, nStrikeOut )    
#else  
   hFont = AfxCreateFont ( sFontName, nPointSize,-1, nWeight, nItalic, nUnderline, nStrikeOut )    
#endif                 
   Function = hFont
   
End Function

