'[NAME] FF_StrInsert
'[AUTHORNAME] 
'[EMAIL] 
'[WEBSITE] 
'[VERSION] 
'[ISFAVORITE] No
'[EXPAND] No
'[ISPROTOTYPE] No
'[KEYWORDS] 
'
'[/KEYWORDS]
'[DESCRIPTION] 
'
'
'''
'''  FF_STRINSERT
'''  һַʽеָλòһַ
'''
'''  Returns a string consisting of MainString with the string InsertString inserted 
'''  at nPosition. If nPosition is greater than the length of MainString or <= zero then 
'''  InsertString is appended to MainString. The first character in the string is position 1, etc.
'''
'  Function FF_StrInsert( ByRef sMainString   as String, _
'                         ByRef sInsertString as String, _
'                         ByRef nPosition     as Integer _
'                         ) as String
'
'
'[/DESCRIPTION]
'[CODESTART]


''
''  FF_STRINSERT
''  Insert a string at a specified position within another string expression.
''
''  Returns a string consisting of MainString with the string InsertString inserted 
''  at nPosition. If nPosition is greater than the length of MainString or <= zero then 
''  InsertString is appended to MainString. The first character in the string is position 1, etc.
''
Function FF_StrInsert( ByRef sMainString   As String, _
                       ByRef sInsertString As String, _
                       ByRef nPosition     As Integer _
                       ) As String

   Dim nLenMain   As Integer = Len(sMainString)
   Dim nLenInsert As Integer = Len(sInsertString)
   
   ' Try to avoid string concatentation as much as possible for speed consideration.
   ' Therefore, create the full buffer and insert by moving memory into the string.
   Dim s As String = Space(nLenMain + nLenInsert)
   
   ' If nPosition is greater than length of MainString or is <=0 then adjust so it appends.
   If nPosition > nLenMain Then nPosition = nLenMain + 1
   If nPosition <= 0 Then nPosition = nLenMain + 1
   
   MemMove( Strptr(s), Strptr(sMainString), nPosition - 1 )
   MemMove( Strptr(s)+nPosition-1, Strptr(sInsertString), nLenInsert )
   MemMove( Strptr(s)+nPosition+nLenInsert-1, Strptr(sMainString)+nPosition-1, nLenInsert )
   
   Function = s

End Function

