'[NAME] FF_RemainAny
'[AUTHORNAME] 
'[EMAIL] 
'[WEBSITE] 
'[VERSION] 
'[ISFAVORITE] No
'[EXPAND] No
'[ISPROTOTYPE] No
'[KEYWORDS] 
'
'[/KEYWORDS]
'[DESCRIPTION] 
'
'
'  FF_REMAINANY
'  ַĵһƥַַһ֡ Compliment function to FF_EXTRACT.
'
'  MainString is searched for the string specified in MatchPattern. If found, 
'  all characters after MatchPattern are returned. 
'  MatchPattern specifies a list of single characters to be searched for 
'  individually, a match on any one of which will cause the extract operation 
'  to be performed after that character.
'  If MatchPattern is not present in MainString (or is null) then a 
'  zero-length empty string is returned.
'  This function is case-sensitive. 
'
'  Function FF_RemainAny( ByRef nStart        as Integer, _
'                         ByRef sMainString   as String, _
'                         ByRef sMatchPattern as String _
'                         ) as String
'
'
'
'[/DESCRIPTION]
'[CODESTART]

''
''  FF_REMAINANY
''  Return the portion of a string following the first occurrence of 
''  a character or group of characters. Compliment function to FF_EXTRACT.
''
''  MainString is searched for the string specified in MatchPattern. If found, 
''  all characters after MatchPattern are returned. 
''  MatchPattern specifies a list of single characters to be searched for 
''  individually, a match on any one of which will cause the extract operation 
''  to be performed after that character.
''  If MatchPattern is not present in MainString (or is null) then a 
''  zero-length empty string is returned.
''  This function is case-sensitive. 
''
Function FF_RemainAny( ByRef nStart        as Integer, _
                       ByRef sMainString   as String, _
                       ByRef sMatchPattern as String _
                       ) as String

    Dim nLenMain  as Integer = Len(sMainString)
    Dim nLenMatch as Integer = Len(sMatchPattern)
    
    Dim y as Integer
    Dim i as Integer
    
    If (nStart = 0) Or (nStart > nLenMain) Then Return ""
    If nStart < 0 Then nStart = nLenMain + nStart + 1
    
    ' Make nStart zero based because of pointer indexing
    nStart = nStart - 1
    
    ' Use string pointer indexing for speed
    For i = nStart To nLenMain - 1
       For y = 0 To nLenMatch - 1
          If sMainString[i] = sMatchPattern[y] Then
             Return Mid(sMainString, i+2)
          End If   
       Next
    Next
    
    Function = ""
End Function

