'[NAME] FF_Pathname
'[AUTHORNAME] 
'[EMAIL] 
'[WEBSITE] 
'[VERSION] 
'[ISFAVORITE] No
'[EXPAND] No
'[ISPROTOTYPE] No
'[KEYWORDS] 
'
'[/KEYWORDS]
'[DESCRIPTION] 
'  FF_PATHNAME
'  ·/ļȡ
'
'  ˺һı·/ļıƣƵһ֡ùϸַ֮һ

'  
'  ѡ֮һָĲ֣
'  FULL
'        ·ļƣ sFilespec  
'  PATH
'        ·/ļ·֡ıķбܣ\ðţ
'  NAME
'        ·ļƵƲ֡ұߵһб (\) ð :֮һ . βı
'  EXTN
'        ص·/ļչ֡һ . ַӵҲı
'  NAMEX
'        صƺEXTNֵܺ͡
' 
'  Function FF_Pathname( ByRef sOption   as String, _
'                        ByRef sFilespec as String _
'                        ) as String
'[/DESCRIPTION]
'[CODESTART]
''
''  FF_PATHNAME
''  Parse a path/file name to extract component parts
''
''  This function evaluates a text path/file text name, and returns a requested 
''  part of the name. The functionality is strictly one of string parsing alone. 
''  
''  sOption one of the following words which is used to specify the requested part:
''  FULL
''        Returns the full path/file name, just as given in the sFilespec parameter. 
''  PATH
''        Returns the path portion of the path/file Name. That is the text up to and 
''        including the last backslash (\) or colon (:).
''  NAME
''        Return the name portion of the path/file Name. That is the text To the right 
''        of the last backslash (\) or colon (:), ending just before the last period (.).
''  EXTN
''        Returns the extension portion of the path/file name. That is the last 
''        period (.) in the string plus the text to the right of it.
''  NAMEX
''        Returns the name and the EXTN parts combined.
'' 
Function FF_Pathname( ByRef sOption   as String, _
                      ByRef sFilespec as String _
                      ) as String

    Dim nLen as Integer = Len(sFilespec)
    Dim s    as String  = sFilespec
    Dim st   as String  = ""
    Dim i    as Integer = 0
    
    If nLen = 0 Then Return sFilespec
    
    Select Case UCase(Trim(sOption))
       Case "FULL" 
          Return s
       
       Case "PATH"
          i = InStrRev(s, Any ":\/")
          If i Then 
             Return Left(s, i)
          Else
             Return ""
          End If
             
       Case "NAME"
          ' Get the full filename
          i = InStrRev(s, Any ":/\")
          st = IIf( i, Mid(s, i + 1), s )
          ' Get the name portion
          i = InStrRev(st, ".")
          st = IIf( i, Left(st, i - 1), st )
          Return st
       
       Case "EXTN"
          ' Get the full filename
          i = InStrRev(s, Any ":/\")
          st = IIf( i, Mid(s, i + 1), s )
          ' Get the extension
          i = InStrRev(st, ".")
          st = IIf( i, Mid(st, i), "" )
          Return st
       
       Case "NAMEX"
          i = InStrRev(s, Any ":/\")
          If i Then Return Mid(s, i + 1)
             
    End Select
    
    Return s
    
End Function


