'[NAME] FF_ParseCountAny
'[AUTHORNAME] 
'[EMAIL] 
'[WEBSITE] 
'[VERSION] 
'[ISFAVORITE] No
'[EXPAND] No
'[ISPROTOTYPE] No
'[KEYWORDS] 
'
'[/KEYWORDS]
'[DESCRIPTION] 
'
'
'  FF_PARSECOUNTANY
'  ַʽطֶָε
'
'  If MainString is empty (a null string) or contains no delimiter character(s), the string 
'  is considered to contain exactly one sub-field. In this case, FF_PARSECOUNTANY returns the value 1.
'  Delimiter contains a set of characters (one or more), any of which may act as a delimiter character.
'  Delimiters are case-sensitive,
'
'  Function FF_ParseCountAny( ByRef sMainString as String, _
'                             ByRef sDelimiter  as String _
'                             ) as Integer
'
'
'
'
'[/DESCRIPTION]
'[CODESTART]
''
''  FF_PARSECOUNTANY
''  Return the count of delimited fields from a string expression.
''
''  If MainString is empty (a null string) or contains no delimiter character(s), the string 
''  is considered to contain exactly one sub-field. In this case, FF_PARSECOUNTANY returns the value 1.
''  Delimiter contains a set of characters (one or more), any of which may act as a delimiter character.
''  Delimiters are case-sensitive,
''
Function FF_ParseCountAny( ByRef sMainString as String, _
                           ByRef sDelimiter  as String _
                           ) as Integer
                   
    Dim count as Integer = 1
    Dim i     as Integer = 1
   
    Do
        i = InStr(i, sMainString, Any sDelimiter)
        If i > 0 Then count += 1: i += 1 
    Loop Until i = 0
   
    Return count
   
End Function
