'[NAME] FF_ParseCount
'[AUTHORNAME] 
'[EMAIL] 
'[WEBSITE] 
'[VERSION] 
'[ISFAVORITE] No
'[EXPAND] No
'[ISPROTOTYPE] No
'[KEYWORDS] 
'
'[/KEYWORDS]
'[DESCRIPTION] 
'  FF_PARSECOUNT
'  ַʽطֶָε
'
'  If MainString is empty (a null string) or contains no delimiter character(s), the string 
'  is considered to contain exactly one sub-field. In this case, FF_PARSECOUNT returns the value 1.
'  Delimiter contains a string (one or more characters) that must be fully matched.
'  Delimiters are case-sensitive,
'
'  Function FF_ParseCount( ByRef sMainString as String, _
'                          ByRef sDelimiter  as String _
'                          ) as Integer
'
'
'
'[/DESCRIPTION]
'[CODESTART]
 
''
''  FF_PARSECOUNT
''  Return the count of delimited fields from a string expression.
''
''  If MainString is empty (a null string) or contains no delimiter character(s), the string 
''  is considered to contain exactly one sub-field. In this case, FF_PARSECOUNT returns the value 1.
''  Delimiter contains a string (one or more characters) that must be fully matched.
''  Delimiters are case-sensitive,
''
Function FF_ParseCount( ByRef sMainString as String, _
                        ByRef sDelimiter  as String _
                        ) as Integer
                   
    Dim count as Integer = 1
    Dim i     as Integer = 1
   
    Do
        i = InStr(i, sMainString, sDelimiter)
        If i > 0 Then count += 1: i += Len(sDelimiter)
    Loop Until i = 0
   
    Return count
   
End Function


