'[NAME] FF_Join
'[AUTHORNAME] 
'[EMAIL] 
'[WEBSITE] 
'[VERSION] 
'[ISFAVORITE] No
'[EXPAND] No
'[ISPROTOTYPE] No
'[KEYWORDS] 
'
'[/KEYWORDS]
'[DESCRIPTION] 
'
'''
'''  FF_JOIN
'''  һеַÿһָָ
'''
'''  If the delimiter is a null (zero-length) string then no separators are inserted 
'''  between the string sections. If the delimiter expression is the 3-byte value 
'''  of "," which may be expressed in your source code as the string literal ""","""
'''  or as Chr(34,44,34) then a leading and trailing double-quote is added to each 
'''  string section. This ensures that the returned string contains standard 
'''  comma-delimited quoted fields that can be easily parsed.
'''
'''  Function FF_Join( sArray() as String, _
'''                    ByRef sDelimiter as String _
'''                    ) as String        
'
'
'[/DESCRIPTION]
'[CODESTART]


''
''  FF_JOIN
''  Return a string consisting of all of the strings in an array, each 
''  separated by a delimiter.
''
''  If the delimiter is a null (zero-length) string then no separators are inserted 
''  between the string sections. If the delimiter expression is the 3-byte value 
''  of "," which may be expressed in your source code as the string literal ""","""
''  or as Chr(34,44,34) then a leading and trailing double-quote is added to each 
''  string section. This ensures that the returned string contains standard 
''  comma-delimited quoted fields that can be easily parsed.
''        

Function FF_Join( sArray() As String, _
                  ByRef sDelimiter As String _
                  ) As String

   Dim s    As String  = ""     
   Dim lb   As Integer = LBound(sArray)
   Dim ub   As Integer = Ubound(sArray)
   Dim nLen As Integer = 0 
   Dim i    As Integer = 0
   Dim nPos As Integer = 0
   
   ' Determine the total size of the resulting string
   For i = lb To ub
      nLen = nLen + Len(sArray(i))
   Next
   
   ' Add room for the delimiters
   nLen = nLen + ( (ub-lb) * Len(sDelimiter) )
   If nLen = 0 Then Return ""
   
   ' Build the buffer to hold the resulting string
   s = Space(nLen)
   
   ' Copy the strings into the buffer
   Dim nLenMatch As Integer = Len(sDelimiter)
   nPos = 0
   For i = lb To ub
      nLen = Len(sArray(i))
      MemMove( Strptr(s)+nPos, Strptr(sArray(i)), nLen )
      nPos = nPos + nLen
      If i <> ub Then   ' add a delimiter 
         MemMove( Strptr(s)+nPos, Strptr(sDelimiter), nLenMatch )
         nPos = nPos + nLenMatch
      End If   
   Next

   ' If the special delimiter of DQ & COMMA & DQ was used then we
   ' also need to wrap the start and end of the string in DQ
   If sDelimiter = Chr(34,44,34) Then
      s = Chr(34) & s & Chr(34)
   End If
      
   Return s
    
End Function
