'[NAME] FF_ExtractAny
'[AUTHORNAME] 
'[EMAIL] 
'[WEBSITE] 
'[VERSION] 
'[ISFAVORITE] No
'[EXPAND] No
'[ISPROTOTYPE] No
'[KEYWORDS] 
'
'[/KEYWORDS]
'[DESCRIPTION] 
'
'
'  FF_EXTRACTANY
'  ַȡַһضַ
'
'  Returns a substring of MainString starting with its first character (or the 
'  character specified by nStart) and up to (but not including) the first 
'  occurrence of MatchPattern. 
'  MatchPattern specifies a list of single characters to be searched for 
'  individually, a match on any one of which will cause the extract operation 
'  to be performed up to that character.
'  If MatchPattern is not present in MainString (or is null) then all 
'  of MainString is returned.
'  This function is case-sensitive. 
'
'  Function FF_ExtractAny( ByRef nStart        as Integer, _
'                          ByRef sMainString   as String, _
'                          ByRef sMatchPattern as String _
'                          ) as String
'
'
'
'
'[/DESCRIPTION]
'[CODESTART]


''
''  FF_EXTRACTANY
''  Extract characters from a string up to a specific character.
''
''  Returns a substring of MainString starting with its first character (or the 
''  character specified by nStart) and up to (but not including) the first 
''  occurrence of MatchPattern. 
''  MatchPattern specifies a list of single characters to be searched for 
''  individually, a match on any one of which will cause the extract operation 
''  to be performed up to that character.
''  If MatchPattern is not present in MainString (or is null) then all 
''  of MainString is returned.
''  This function is case-sensitive. 
''
Function FF_ExtractAny( ByRef nStart        as Integer, _
                        ByRef sMainString   as String, _
                        ByRef sMatchPattern as String _
                        ) as String

    Dim nLenMain  as Integer = Len(sMainString)
    Dim nLenMatch as Integer = Len(sMatchPattern)
    
    Dim y as Integer
    Dim i as Integer
    
    If (nStart = 0) Or (nStart > nLenMain) Then Return ""
    If nStart < 0 Then nStart = nLenMain + nStart + 1
    
    ' Make nStart zero based because of pointer indexing
    nStart = nStart - 1
    
    ' Use string pointer indexing for speed
    For i = nStart To nLenMain - 1
       For y = 0 To nLenMatch - 1
          If sMainString[i] = sMatchPattern[y] Then  
             ' Convert nStart back to one based
             nStart = nStart + 1
             Return Mid(sMainString, nStart, i-nStart+1)
          End If   
       Next
    Next
    
    Function = ""
End Function

