'[NAME] FF_Extract
'[AUTHORNAME] 
'[EMAIL] 
'[WEBSITE] 
'[VERSION] 
'[ISFAVORITE] No
'[EXPAND] No
'[ISPROTOTYPE] No
'[KEYWORDS] 
'
'[/KEYWORDS]
'[DESCRIPTION] 
'  FF_EXTRACT
'  ַȡַһַһַ
'  Compliment function to FF_REMAIN.
'
'  Returns a substring of MainString starting with its first character (or the 
'  character specified by nStart) and up to (but not including) the first 
'  occurrence of MatchPattern. 
'  If MatchPattern is not present in MainString (or is null) then all 
'  of MainString is returned from the nStart position.
'  This function is case-sensitive. 
'
'  Function FF_Extract( ByRef nStart        as Integer, _
'                       ByRef sMainString   as String, _
'                       ByRef sMatchPattern as String _
'                       ) as String
'
'
'
'
'[/DESCRIPTION]
'[CODESTART]
''
''  FF_EXTRACT
''  Extract characters from a string up to a character or group of characters.
''  Compliment function to FF_REMAIN.
''
''  Returns a substring of MainString starting with its first character (or the 
''  character specified by nStart) and up to (but not including) the first 
''  occurrence of MatchPattern. 
''  If MatchPattern is not present in MainString (or is null) then all 
''  of MainString is returned from the nStart position.
''  This function is case-sensitive. 
''
Function FF_Extract( ByRef nStart        as Integer, _
                     ByRef sMainString   as String, _
                     ByRef sMatchPattern as String _
                     ) as String

    Dim nLenMain as Integer = Len(sMainString)             
    Dim i as Integer
    
    If (nStart = 0) Or (nStart > nLenMain) Then Return ""
    If nStart < 0 Then nStart = nLenMain + nStart + 1
    
    i = InStr(nStart, sMainString, sMatchPattern)
    If i Then
       Function = Mid(sMainString, nStart, i-nStart )
    Else
       Function = Mid(sMainString, nStart)
    End If
End Function


