/*
 * Decompiled with CFR 0.152.
 */
package org.jf.smali;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;
import org.jf.smali.smaliFlexLexer;
import org.jf.smali.smaliParser;
import org.jf.smali.smaliTreeWalker;
import org.jf.util.ConsoleUtil;
import org.jf.util.SmaliHelpFormatter;

public class main {
    public static final String VERSION;
    private static final Options basicOptions;
    private static final Options debugOptions;
    private static final Options options;

    static {
        basicOptions = new Options();
        debugOptions = new Options();
        options = new Options();
        main.buildOptions();
        InputStream templateStream = main.class.getClassLoader().getResourceAsStream("smali.properties");
        if (templateStream != null) {
            Properties properties = new Properties();
            String version = "(unknown)";
            try {
                properties.load(templateStream);
                version = properties.getProperty("application.version");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            VERSION = version;
        } else {
            VERSION = "[unknown version]";
        }
    }

    private main() {
    }

    public static void main(String[] args) {
        CommandLine commandLine;
        Locale locale = new Locale("en", "US");
        Locale.setDefault(locale);
        PosixParser parser = new PosixParser();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (ParseException ex) {
            main.usage();
            return;
        }
        int jobs = -1;
        boolean allowOdex = false;
        boolean verboseErrors = false;
        boolean printTokens = false;
        int apiLevel = 15;
        String outputDexFile = "out.dex";
        String[] remainingArgs = commandLine.getArgs();
        Option[] options = commandLine.getOptions();
        int i = 0;
        while (i < options.length) {
            Option option = options[i];
            String opt = option.getOpt();
            switch (opt.charAt(0)) {
                case 'v': {
                    main.version();
                    return;
                }
                case '?': {
                    while (++i < options.length) {
                        if (options[i].getOpt().charAt(0) != '?') continue;
                        main.usage(true);
                        return;
                    }
                    main.usage(false);
                    return;
                }
                case 'o': {
                    outputDexFile = commandLine.getOptionValue("o");
                    break;
                }
                case 'x': {
                    allowOdex = true;
                    break;
                }
                case 'a': {
                    apiLevel = Integer.parseInt(commandLine.getOptionValue("a"));
                    break;
                }
                case 'j': {
                    jobs = Integer.parseInt(commandLine.getOptionValue("j"));
                    break;
                }
                case 'V': {
                    verboseErrors = true;
                    break;
                }
                case 'T': {
                    printTokens = true;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ++i;
        }
        if (remainingArgs.length == 0) {
            main.usage();
            return;
        }
        try {
            LinkedHashSet<File> filesToProcess = new LinkedHashSet<File>();
            String[] stringArray = remainingArgs;
            int n = remainingArgs.length;
            int opt = 0;
            while (opt < n) {
                String arg = stringArray[opt];
                File argFile = new File(arg);
                if (!argFile.exists()) {
                    throw new RuntimeException("Cannot find file or directory \"" + arg + "\"");
                }
                if (argFile.isDirectory()) {
                    main.getSmaliFilesInDir(argFile, filesToProcess);
                } else if (argFile.isFile()) {
                    filesToProcess.add(argFile);
                }
                ++opt;
            }
            if (jobs <= 0 && (jobs = Runtime.getRuntime().availableProcessors()) > 6) {
                jobs = 6;
            }
            boolean errors = false;
            final DexBuilder dexBuilder = DexBuilder.makeDexBuilder((int)apiLevel);
            ExecutorService executor = Executors.newFixedThreadPool(jobs);
            ArrayList tasks = Lists.newArrayList();
            final boolean finalVerboseErrors = verboseErrors;
            final boolean finalPrintTokens = printTokens;
            final boolean finalAllowOdex = allowOdex;
            final int finalApiLevel = apiLevel;
            for (final File file : filesToProcess) {
                tasks.add(executor.submit(new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return main.assembleSmaliFile(file, dexBuilder, finalVerboseErrors, finalPrintTokens, finalAllowOdex, finalApiLevel);
                    }
                }));
            }
            block21: for (Future task : tasks) {
                while (true) {
                    try {
                        if (((Boolean)task.get()).booleanValue()) continue block21;
                        errors = true;
                        continue block21;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            executor.shutdown();
            if (errors) {
                System.exit(1);
            }
            dexBuilder.writeTo((DexDataStore)new FileDataStore(new File(outputDexFile)));
        }
        catch (RuntimeException ex) {
            System.err.println("\nUNEXPECTED TOP-LEVEL EXCEPTION:");
            ex.printStackTrace();
            System.exit(2);
        }
        catch (Throwable ex) {
            System.err.println("\nUNEXPECTED TOP-LEVEL ERROR:");
            ex.printStackTrace();
            System.exit(3);
        }
    }

    private static void getSmaliFilesInDir(@Nonnull File dir, @Nonnull Set<File> smaliFiles) {
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    main.getSmaliFilesInDir(file, smaliFiles);
                } else if (file.getName().endsWith(".smali")) {
                    smaliFiles.add(file);
                }
                ++n2;
            }
        }
    }

    private static boolean assembleSmaliFile(File smaliFile, DexBuilder dexBuilder, boolean verboseErrors, boolean printTokens, boolean allowOdex, int apiLevel) throws Exception {
        FileInputStream fis = new FileInputStream(smaliFile.getAbsolutePath());
        InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
        smaliFlexLexer lexer = new smaliFlexLexer(reader);
        lexer.setSourceFile(smaliFile);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        if (printTokens) {
            tokens.getTokens();
            int i = 0;
            while (i < tokens.size()) {
                Token token = tokens.get(i);
                if (token.getChannel() != 99) {
                    System.out.println(String.valueOf(smaliParser.tokenNames[token.getType()]) + ": " + token.getText());
                }
                ++i;
            }
        }
        smaliParser parser = new smaliParser((TokenStream)tokens);
        parser.setVerboseErrors(verboseErrors);
        parser.setAllowOdex(allowOdex);
        parser.setApiLevel(apiLevel);
        smaliParser.smali_file_return result = parser.smali_file();
        if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
            return false;
        }
        CommonTree t = result.getTree();
        CommonTreeNodeStream treeStream = new CommonTreeNodeStream((Object)t);
        treeStream.setTokenStream((TokenStream)tokens);
        smaliTreeWalker dexGen = new smaliTreeWalker((TreeNodeStream)treeStream);
        dexGen.setVerboseErrors(verboseErrors);
        dexGen.setDexBuilder(dexBuilder);
        dexGen.smali_file();
        return dexGen.getNumberOfSyntaxErrors() == 0;
    }

    private static void usage(boolean printDebugOptions) {
        SmaliHelpFormatter formatter = new SmaliHelpFormatter();
        int consoleWidth = ConsoleUtil.getConsoleWidth();
        if (consoleWidth <= 0) {
            consoleWidth = 80;
        }
        formatter.setWidth(consoleWidth);
        formatter.printHelp("java -jar smali.jar [options] [--] [<smali-file>|folder]*", "assembles a set of smali files into a dex file", basicOptions, (Options)(printDebugOptions ? debugOptions : null));
    }

    private static void usage() {
        main.usage(false);
    }

    private static void version() {
        System.out.println("smali " + VERSION + " (http://smali.googlecode.com)");
        System.out.println("Copyright (C) 2010 Ben Gruver (JesusFreke@JesusFreke.com)");
        System.out.println("BSD license (http://www.opensource.org/licenses/bsd-license.php)");
        System.exit(0);
    }

    private static void buildOptions() {
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"prints the version then exits");
        Option versionOption = OptionBuilder.create((String)"v");
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"prints the help message then exits. Specify twice for debug options");
        Option helpOption = OptionBuilder.create((String)"?");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.withDescription((String)"the name of the dex file that will be written. The default is out.dex");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FILE");
        Option outputOption = OptionBuilder.create((String)"o");
        OptionBuilder.withLongOpt((String)"allow-odex-instructions");
        OptionBuilder.withDescription((String)"allow odex instructions to be compiled into the dex file. Only a few instructions are supported - the ones that can exist in a dead code path and not cause dalvik to reject the class");
        Option allowOdexOption = OptionBuilder.create((String)"x");
        OptionBuilder.withLongOpt((String)"api-level");
        OptionBuilder.withDescription((String)"The numeric api-level of the file to generate, e.g. 14 for ICS. If not specified, it defaults to 15 (ICS).");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"API_LEVEL");
        Option apiLevelOption = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"jobs");
        OptionBuilder.withDescription((String)"The number of threads to use. Defaults to the number of cores available, up to a maximum of 6");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"NUM_THREADS");
        Option jobsOption = OptionBuilder.create((String)"j");
        OptionBuilder.withLongOpt((String)"verbose-errors");
        OptionBuilder.withDescription((String)"Generate verbose error messages");
        Option verboseErrorsOption = OptionBuilder.create((String)"V");
        OptionBuilder.withLongOpt((String)"print-tokens");
        OptionBuilder.withDescription((String)"Print the name and text of each token");
        Option printTokensOption = OptionBuilder.create((String)"T");
        basicOptions.addOption(versionOption);
        basicOptions.addOption(helpOption);
        basicOptions.addOption(outputOption);
        basicOptions.addOption(allowOdexOption);
        basicOptions.addOption(apiLevelOption);
        basicOptions.addOption(jobsOption);
        debugOptions.addOption(verboseErrorsOption);
        debugOptions.addOption(printTokensOption);
        for (Object option : basicOptions.getOptions()) {
            options.addOption((Option)option);
        }
        for (Object option : debugOptions.getOptions()) {
            options.addOption((Option)option);
        }
    }
}

