/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.reader.io;

import com.googlecode.dex2jar.reader.io.DataInputDataIn;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.xmlgraphics.image.codec.util.MemoryCacheSeekableStream;

public class InputStreamDataIn
extends DataInputDataIn
implements Closeable {
    public static InputStreamDataIn open(InputStream in) {
        return new InputStreamDataIn(in, true);
    }

    public static InputStreamDataIn openApk(File file) {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("No valid apk", e);
        }
        return InputStreamDataIn.openApk(in);
    }

    public static InputStreamDataIn openApk(InputStream in) {
        try {
            ZipInputStream zis = new ZipInputStream(in);
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals("classes.dex")) {
                    return new InputStreamDataIn(zis, true);
                }
                entry = zis.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Not valid apk", e);
        }
        throw new RuntimeException("No valid apk");
    }

    public InputStreamDataIn(InputStream stream, boolean isLE) {
        super((DataInput)new MemoryCacheSeekableStream(stream), isLE);
    }

    @Override
    public void close() throws IOException {
        ((MemoryCacheSeekableStream)this.in).close();
    }

    @Override
    public int getCurrentPosition() {
        return (int)((MemoryCacheSeekableStream)this.in).getFilePointer();
    }

    @Override
    public void move(int absOffset) {
        try {
            ((MemoryCacheSeekableStream)this.in).seek((long)absOffset);
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

