/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.util;

import java.util.Arrays;

public class mxSpline1D {
    protected double[] len;
    protected double[] pos1D;
    protected double[] a;
    protected double[] b;
    protected double[] c;
    protected double[] d;
    private int storageIndex = 0;

    public mxSpline1D(double[] dArray, double[] dArray2) {
        this.setValues(dArray, dArray2);
    }

    public void setValues(double[] dArray, double[] dArray2) {
        this.len = dArray;
        this.pos1D = dArray2;
        if (this.len.length > 1) {
            this.calculateCoefficients();
        }
    }

    public double getValue(double d) {
        if (this.len.length == 0) {
            return Double.NaN;
        }
        if (this.len.length == 1) {
            if (this.len[0] == d) {
                return this.pos1D[0];
            }
            return Double.NaN;
        }
        int n = Arrays.binarySearch(this.len, d);
        if (n > 0) {
            return this.pos1D[n];
        }
        if ((n = -(n + 1) - 1) < 0) {
            return this.pos1D[0];
        }
        return this.a[n] + this.b[n] * (d - this.len[n]) + this.c[n] * Math.pow(d - this.len[n], 2.0) + this.d[n] * Math.pow(d - this.len[n], 3.0);
    }

    public double getFastValue(double d) {
        if (this.storageIndex <= -1 || this.storageIndex >= this.len.length - 1 || !(d > this.len[this.storageIndex]) || !(d < this.len[this.storageIndex + 1])) {
            int n = Arrays.binarySearch(this.len, d);
            if (n > 0) {
                return this.pos1D[n];
            }
            this.storageIndex = n = -(n + 1) - 1;
        }
        if (this.storageIndex < 0) {
            return this.pos1D[0];
        }
        double d2 = d - this.len[this.storageIndex];
        return this.a[this.storageIndex] + this.b[this.storageIndex] * d2 + this.c[this.storageIndex] * (d2 * d2) + this.d[this.storageIndex] * (d2 * d2 * d2);
    }

    public double getDx(double d) {
        if (this.len.length == 0 || this.len.length == 1) {
            return 0.0;
        }
        int n = Arrays.binarySearch(this.len, d);
        if (n < 0) {
            n = -(n + 1) - 1;
        }
        return this.b[n] + 2.0 * this.c[n] * (d - this.len[n]) + 3.0 * this.d[n] * Math.pow(d - this.len[n], 2.0);
    }

    private void calculateCoefficients() {
        int n;
        int n2 = this.pos1D.length;
        this.a = new double[n2];
        this.b = new double[n2];
        this.c = new double[n2];
        this.d = new double[n2];
        if (n2 == 2) {
            this.a[0] = this.pos1D[0];
            this.b[0] = this.pos1D[1] - this.pos1D[0];
            return;
        }
        double[] dArray = new double[n2 - 1];
        for (int i = 0; i < n2 - 1; ++i) {
            this.a[i] = this.pos1D[i];
            dArray[i] = this.len[i + 1] - this.len[i];
            if (dArray[i] != 0.0) continue;
            dArray[i] = 0.01;
        }
        this.a[n2 - 1] = this.pos1D[n2 - 1];
        double[][] dArray2 = new double[n2 - 2][n2 - 2];
        double[] dArray3 = new double[n2 - 2];
        for (n = 0; n < n2 - 2; ++n) {
            dArray3[n] = 3.0 * ((this.pos1D[n + 2] - this.pos1D[n + 1]) / dArray[n + 1] - (this.pos1D[n + 1] - this.pos1D[n]) / dArray[n]);
            dArray2[n][n] = 2.0 * (dArray[n] + dArray[n + 1]);
            if (n > 0) {
                dArray2[n][n - 1] = dArray[n];
            }
            if (n >= n2 - 3) continue;
            dArray2[n][n + 1] = dArray[n + 1];
        }
        this.solve(dArray2, dArray3);
        for (n = 0; n < n2 - 2; ++n) {
            this.c[n + 1] = dArray3[n];
            this.b[n] = (this.a[n + 1] - this.a[n]) / dArray[n] - (2.0 * this.c[n] + this.c[n + 1]) / 3.0 * dArray[n];
            this.d[n] = (this.c[n + 1] - this.c[n]) / (3.0 * dArray[n]);
        }
        this.b[n2 - 2] = (this.a[n2 - 1] - this.a[n2 - 2]) / dArray[n2 - 2] - (2.0 * this.c[n2 - 2] + this.c[n2 - 1]) / 3.0 * dArray[n2 - 2];
        this.d[n2 - 2] = (this.c[n2 - 1] - this.c[n2 - 2]) / (3.0 * dArray[n2 - 2]);
    }

    public void solve(double[][] dArray, double[] dArray2) {
        int n;
        int n2 = dArray2.length;
        for (n = 1; n < n2; ++n) {
            dArray[n][n - 1] = dArray[n][n - 1] / dArray[n - 1][n - 1];
            dArray[n][n] = dArray[n][n] - dArray[n - 1][n] * dArray[n][n - 1];
            dArray2[n] = dArray2[n] - dArray[n][n - 1] * dArray2[n - 1];
        }
        dArray2[n2 - 1] = dArray2[n2 - 1] / dArray[n2 - 1][n2 - 1];
        for (n = dArray2.length - 2; n >= 0; --n) {
            dArray2[n] = (dArray2[n] - dArray[n][n + 1] * dArray2[n + 1]) / dArray[n][n];
        }
    }
}

