/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.mod.SmaliMod;
import brut.androlib.res.util.ExtFile;
import brut.androlib.src.DebugInjector;
import brut.directory.DirectoryException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.antlr.runtime.RecognitionException;
import org.apache.commons.io.IOUtils;
import org.jf.dexlib2.writer.builder.DexBuilder;
import org.jf.dexlib2.writer.io.DexDataStore;
import org.jf.dexlib2.writer.io.FileDataStore;

public class SmaliBuilder {
    private final ExtFile mSmaliDir;
    private final File mDexFile;
    private final HashMap<String, Boolean> mFlags;
    private static final Logger LOGGER = Logger.getLogger(SmaliBuilder.class.getName());

    public static void build(ExtFile smaliDir, File dexFile, HashMap<String, Boolean> flags) throws AndrolibException {
        new SmaliBuilder(smaliDir, dexFile, flags).build();
    }

    private SmaliBuilder(ExtFile smaliDir, File dexFile, HashMap<String, Boolean> flags) {
        this.mSmaliDir = smaliDir;
        this.mDexFile = dexFile;
        this.mFlags = flags;
    }

    private void build() throws AndrolibException {
        try {
            DexBuilder dexBuilder = DexBuilder.makeDexBuilder();
            for (String fileName : this.mSmaliDir.getDirectory().getFiles(true)) {
                this.buildFile(fileName, dexBuilder);
            }
            dexBuilder.writeTo((DexDataStore)new FileDataStore(new File(this.mDexFile.getAbsolutePath())));
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException(ex);
        }
    }

    private void buildFile(String fileName, DexBuilder dexBuilder) throws AndrolibException, IOException {
        File inFile = new File(this.mSmaliDir, fileName);
        FileInputStream inStream = new FileInputStream(inFile);
        if (fileName.endsWith(".smali")) {
            try {
                if (!SmaliMod.assembleSmaliFile(inFile, dexBuilder, false, false)) {
                    throw new AndrolibException("Could not smali file: " + fileName);
                }
            }
            catch (IOException | RecognitionException ex) {
                throw new AndrolibException(ex);
            }
            return;
        }
        if (!fileName.endsWith(".java")) {
            LOGGER.warning("Unknown file type, ignoring: " + inFile);
            return;
        }
        StringBuilder out = new StringBuilder();
        List lines = IOUtils.readLines((InputStream)inStream);
        if (!this.mFlags.get("debug").booleanValue()) {
            String[] linesArray = lines.toArray(new String[0]);
            int i = 1;
            while (i < linesArray.length - 1) {
                out.append(linesArray[i].split("//", 2)[1]).append('\n');
                ++i;
            }
        } else {
            lines.remove(lines.size() - 1);
            ListIterator<String> it = lines.listIterator(1);
            out.append(".source \"").append(inFile.getName()).append("\"\n");
            while (it.hasNext()) {
                String line = ((String)it.next()).split("//", 2)[1].trim();
                if (line.isEmpty() || line.charAt(0) == '#' || line.startsWith(".source")) continue;
                if (line.startsWith(".method ")) {
                    it.previous();
                    DebugInjector.inject(it, out);
                    continue;
                }
                out.append(line).append('\n');
            }
        }
        try {
            if (!SmaliMod.assembleSmaliFile(out.toString(), dexBuilder, false, false, inFile)) {
                throw new AndrolibException("Could not smali file: " + fileName);
            }
        }
        catch (IOException | RecognitionException ex) {
            throw new AndrolibException(ex);
        }
    }
}

