/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.src;

import brut.androlib.AndrolibException;
import brut.androlib.src.TypeName;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebugInjector {
    private boolean areParamsInjected;
    private int currParam;
    private int lastParam;
    private final ListIterator<String> mIt;
    private final StringBuilder mOut;
    private boolean mFirstInstruction = true;
    private final Set<String> mInitializedRegisters = new HashSet<String>();
    private static final Pattern REGISTER_INFO_PATTERN = Pattern.compile("((?:p|v)\\d+)=\\(([^,)]+)([^)]*)\\);");

    public static void inject(ListIterator<String> it, StringBuilder out) throws AndrolibException {
        new DebugInjector(it, out).inject();
    }

    private DebugInjector(ListIterator<String> it, StringBuilder out) {
        this.mIt = it;
        this.mOut = out;
    }

    private void inject() throws AndrolibException {
        String definition = this.nextAndAppend();
        if (definition.contains(" abstract ") || definition.contains(" native ")) {
            this.nextAndAppend();
            return;
        }
        this.parseParamsNumber(definition);
        boolean end = false;
        while (!end) {
            end = this.step();
        }
    }

    private void parseParamsNumber(String definition) throws AndrolibException {
        int pos = definition.indexOf(40);
        if (pos == -1) {
            throw new AndrolibException();
        }
        int pos2 = definition.indexOf(41, pos);
        if (pos2 == -1) {
            throw new AndrolibException();
        }
        String params = definition.substring(pos + 1, pos2);
        this.currParam = definition.contains(" static ") ? 0 : 1;
        this.lastParam = TypeName.listFromInternalName(params).size() + this.currParam - 1;
    }

    private void injectRemainingParams() {
        this.areParamsInjected = true;
        while (this.currParam <= this.lastParam) {
            ++this.currParam;
        }
    }

    private boolean step() {
        String line = this.next();
        if (line.isEmpty()) {
            return false;
        }
        switch (line.charAt(0)) {
            case '#': {
                return this.processComment(line);
            }
            case ':': {
                this.append(line);
                return false;
            }
            case '.': {
                return this.processDirective(line);
            }
        }
        if (!this.areParamsInjected) {
            this.injectRemainingParams();
        }
        return this.processInstruction(line);
    }

    private boolean processComment(String line) {
        if (this.mFirstInstruction) {
            return false;
        }
        Matcher m = REGISTER_INFO_PATTERN.matcher(line);
        block35: while (m.find()) {
            String localName = m.group(1);
            String localType = null;
            switch (m.group(2)) {
                case "UninitThis": 
                case "Null": 
                case "Reference": 
                case "UninitRef": 
                case "REFERENCE": {
                    localType = "Ljava/lang/Object;";
                    break;
                }
                case "Boolean": {
                    localType = "Z";
                    break;
                }
                case "Integer": 
                case "One": 
                case "Unknown": {
                    localType = "I";
                    break;
                }
                case "Uninit": 
                case "Conflicted": {
                    if (!this.mInitializedRegisters.remove(localName)) continue block35;
                    this.mOut.append(".end local ").append(localName).append('\n');
                    continue block35;
                }
                case "Short": 
                case "PosShort": {
                    localType = "S";
                    break;
                }
                case "Byte": 
                case "PosByte": {
                    localType = "B";
                    break;
                }
                case "Char": {
                    localType = "C";
                    break;
                }
                case "Float": {
                    localType = "F";
                    break;
                }
                case "LongHi": 
                case "LongLo": {
                    localType = "J";
                    break;
                }
                case "DoubleHi": 
                case "DoubleLo": {
                    localType = "D";
                    break;
                }
                default: {
                    System.err.println(line);
                    System.err.println(m.group(2));
                    System.err.println(m.group(3));
                    assert (false);
                    break;
                }
            }
            this.mInitializedRegisters.add(localName);
            this.mOut.append(".local ").append(localName).append(", ").append('\"').append(localName).append('\"').append(':').append(localType).append('\n');
        }
        return false;
    }

    private boolean processDirective(String line) {
        String line2 = line.substring(1);
        if (line2.startsWith("line ") || line2.startsWith("local ") || line2.startsWith("end local ")) {
            return false;
        }
        if (line2.equals("prologue")) {
            if (!this.areParamsInjected) {
                this.injectRemainingParams();
            }
            return false;
        }
        if (line2.equals("param")) {
            this.mOut.append(".param \"p").append(this.currParam++).append("\"\n");
            return false;
        }
        if (line2.startsWith("param")) {
            this.mOut.append(line).append("\n");
            ++this.currParam;
            return false;
        }
        this.append(line);
        if (line2.equals("end method")) {
            return true;
        }
        if (line2.startsWith("annotation ") || line2.equals("sparse-switch") || line2.startsWith("packed-switch ") || line2.startsWith("array-data ")) {
            while (!(line2 = this.nextAndAppend()).startsWith(".end ")) {
            }
        }
        return false;
    }

    private boolean processInstruction(String line) {
        if (this.mFirstInstruction) {
            this.mOut.append(".prologue\n");
            this.mFirstInstruction = false;
        }
        this.mOut.append(".line ").append(this.mIt.nextIndex()).append('\n').append(line).append('\n');
        return false;
    }

    private String next() {
        return this.mIt.next().split("//", 2)[1].trim();
    }

    private String nextAndAppend() {
        String line = this.next();
        this.append(line);
        return line;
    }

    private void append(String append) {
        this.mOut.append(append).append('\n');
    }
}

