/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.xml;

import brut.util.Duo;
import java.util.ArrayList;
import java.util.List;

public final class ResXmlEncoders {
    public static String escapeXmlChars(String str) {
        return str.replace("&", "&amp;").replace("<", "&lt;");
    }

    public static String encodeAsResXmlAttr(String str) {
        if (str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder out = new StringBuilder(str.length() + 10);
        switch (chars[0]) {
            case '#': 
            case '?': 
            case '@': {
                out.append('\\');
            }
        }
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                char c = cArray[n2];
                switch (c) {
                    case '\\': {
                        out.append('\\');
                        break;
                    }
                    case '\"': {
                        out.append("&quot;");
                        break block10;
                    }
                    case '\n': {
                        out.append("\\n");
                        break block10;
                    }
                    default: {
                        if (ResXmlEncoders.isPrintableChar(c)) break;
                        out.append(String.format("\\u%04x", c));
                        break block10;
                    }
                }
                out.append(c);
            }
            ++n2;
        }
        return out.toString();
    }

    public static String encodeAsXmlValue(String str) {
        if (str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder out = new StringBuilder(str.length() + 10);
        switch (chars[0]) {
            case '#': 
            case '?': 
            case '@': {
                out.append('\\');
            }
        }
        boolean isInStyleTag = false;
        int startPos = 0;
        boolean enclose = false;
        boolean wasSpace = true;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                char c;
                block15: {
                    block16: {
                        block14: {
                            c = cArray[n2];
                            if (!isInStyleTag) break block14;
                            if (c == '>') {
                                isInStyleTag = false;
                                startPos = out.length() + 1;
                                enclose = false;
                            }
                            break block15;
                        }
                        if (c != ' ') break block16;
                        if (wasSpace) {
                            enclose = true;
                        }
                        wasSpace = true;
                        break block15;
                    }
                    wasSpace = false;
                    switch (c) {
                        case '\\': {
                            out.append('\\');
                            break;
                        }
                        case '\n': 
                        case '\'': {
                            enclose = true;
                            break;
                        }
                        case '\"': {
                            out.append('\\');
                            break;
                        }
                        case '<': {
                            isInStyleTag = true;
                            if (!enclose) break;
                            out.insert(startPos, '\"').append('\"');
                            break;
                        }
                        default: {
                            if (ResXmlEncoders.isPrintableChar(c)) break;
                            out.append(String.format("\\u%04x", c));
                            break block17;
                        }
                    }
                }
                out.append(c);
            }
            ++n2;
        }
        if (enclose || wasSpace) {
            out.insert(startPos, '\"').append('\"');
        }
        return out.toString();
    }

    public static boolean hasMultipleNonPositionalSubstitutions(String str) {
        Duo<List<Integer>, List<Integer>> tuple = ResXmlEncoders.findSubstitutions(str, 2);
        return !((List)tuple.m1).isEmpty() && ((List)tuple.m1).size() + ((List)tuple.m2).size() > 1;
    }

    public static String enumerateNonPositionalSubstitutionsIfRequired(String str) {
        Duo<List<Integer>, List<Integer>> tuple = ResXmlEncoders.findSubstitutions(str, 2);
        if (((List)tuple.m1).isEmpty() || ((List)tuple.m1).size() + ((List)tuple.m2).size() < 2) {
            return str;
        }
        List subs = (List)tuple.m1;
        StringBuilder out = new StringBuilder();
        int pos = 0;
        int count = 0;
        for (Integer sub : subs) {
            sub = sub + 1;
            out.append(str.substring(pos, sub)).append(++count).append('$');
            pos = sub;
        }
        out.append(str.substring(pos));
        return out.toString();
    }

    private static Duo<List<Integer>, List<Integer>> findSubstitutions(String str, int nonPosMax) {
        int pos;
        if (nonPosMax == -1) {
            nonPosMax = Integer.MAX_VALUE;
        }
        int pos2 = 0;
        int length = str.length();
        ArrayList<Integer> nonPositional = new ArrayList<Integer>();
        ArrayList<Integer> positional = new ArrayList<Integer>();
        while ((pos = str.indexOf(37, pos2)) != -1) {
            char c;
            pos2 = pos + 1;
            if (pos2 == length) {
                nonPositional.add(pos);
                break;
            }
            if ((c = str.charAt(pos2++)) == '%') continue;
            if (c >= '0' && c <= '9' && pos2 < length) {
                while ((c = str.charAt(pos2++)) >= '0' && c <= '9' && pos2 < length) {
                }
                if (c == '$') {
                    positional.add(pos);
                    continue;
                }
            }
            nonPositional.add(pos);
            if (nonPositional.size() >= nonPosMax) break;
        }
        return new Duo(nonPositional, positional);
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

