/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.err.CantFind9PatchChunk;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBoolValue;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.XmlPullStreamDecoder;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResFileDecoder {
    private final ResStreamDecoderContainer mDecoders;
    private static final Logger LOGGER = Logger.getLogger(ResFileDecoder.class.getName());

    public ResFileDecoder(ResStreamDecoderContainer decoders) {
        this.mDecoders = decoders;
    }

    public void decode(ResResource res, Directory inDir, Directory outDir) throws AndrolibException {
        String outFileName;
        ResFileValue fileValue = (ResFileValue)res.getValue();
        String inFileName = fileValue.getStrippedPath();
        String outResName = res.getFilePath();
        String typeName = res.getResSpec().getType().getName();
        String ext = null;
        int extPos = inFileName.lastIndexOf(".");
        if (extPos == -1) {
            outFileName = outResName;
        } else {
            ext = inFileName.substring(extPos);
            outFileName = String.valueOf(outResName) + ext;
        }
        try {
            if (typeName.equals("raw")) {
                this.decode(inDir, inFileName, outDir, outFileName, "raw");
                return;
            }
            if (typeName.equals("drawable") || typeName.equals("mipmap")) {
                if (inFileName.toLowerCase().endsWith(".9.png")) {
                    outFileName = String.valueOf(outResName) + ".9" + ext;
                    if (inFileName.toLowerCase().endsWith(".r.9.png")) {
                        outFileName = String.valueOf(outResName) + ".r.9" + ext;
                    }
                    try {
                        this.decode(inDir, inFileName, outDir, outFileName, "9patch");
                        return;
                    }
                    catch (CantFind9PatchChunk ex) {
                        LOGGER.log(Level.WARNING, String.format("Cant find 9patch chunk in file: \"%s\". Renaming it to *.png.", inFileName), (Throwable)((Object)ex));
                        outDir.removeFile(outFileName);
                        outFileName = String.valueOf(outResName) + ext;
                    }
                }
                if (!".xml".equals(ext)) {
                    this.decode(inDir, inFileName, outDir, outFileName, "raw");
                    return;
                }
            }
            this.decode(inDir, inFileName, outDir, outFileName, "xml");
        }
        catch (AndrolibException ex) {
            LOGGER.log(Level.SEVERE, String.format("Could not decode file, replacing by FALSE value: %s", inFileName, outFileName), (Throwable)((Object)ex));
            res.replace(new ResBoolValue(false, null));
        }
    }

    public void decode(Directory inDir, String inFileName, Directory outDir, String outFileName, String decoder) throws AndrolibException {
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = inDir.getFileInput(inFileName);
                out = outDir.getFileOutput(outFileName);
                this.mDecoders.decode(in, out, decoder);
            }
            catch (DirectoryException ex) {
                throw new AndrolibException(ex);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
    }

    public void decodeManifest(Directory inDir, String inFileName, Directory outDir, String outFileName) throws AndrolibException {
        InputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = inDir.getFileInput(inFileName);
                out = outDir.getFileOutput(outFileName);
                ((XmlPullStreamDecoder)this.mDecoders.getDecoder("xml")).decodeManifest(in, out);
            }
            catch (DirectoryException ex) {
                throw new AndrolibException(ex);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException ex) {
                throw new AndrolibException(ex);
            }
        }
    }
}

