/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.AndrolibException;
import brut.androlib.err.CantFind9PatchChunk;
import brut.androlib.res.decoder.ResStreamDecoder;
import brut.util.ExtDataInput;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import org.apache.commons.io.IOUtils;

public class Res9patchStreamDecoder
implements ResStreamDecoder {
    private static final int NP_CHUNK_TYPE = 1852855395;
    private static final int NP_COLOR = -16777216;

    @Override
    public void decode(InputStream in, OutputStream out) throws AndrolibException {
        try {
            byte[] data = IOUtils.toByteArray((InputStream)in);
            BufferedImage im = ImageIO.read(new ByteArrayInputStream(data));
            int w = im.getWidth();
            int h = im.getHeight();
            ImageTypeSpecifier its = ImageTypeSpecifier.createFromRenderedImage(im);
            BufferedImage im2 = its.createBufferedImage(w + 2, h + 2);
            im2.getRaster().setRect(1, 1, im.getRaster());
            NinePatch np = this.getNinePatch(data);
            this.drawHLine(im2, h + 1, np.padLeft + 1, w - np.padRight);
            this.drawVLine(im2, w + 1, np.padTop + 1, h - np.padBottom);
            int[] xDivs = np.xDivs;
            int i = 0;
            while (i < xDivs.length) {
                this.drawHLine(im2, 0, xDivs[i] + 1, xDivs[i + 1]);
                i += 2;
            }
            int[] yDivs = np.yDivs;
            int i2 = 0;
            while (i2 < yDivs.length) {
                this.drawVLine(im2, 0, yDivs[i2] + 1, yDivs[i2 + 1]);
                i2 += 2;
            }
            ImageIO.write((RenderedImage)im2, "png", out);
        }
        catch (IOException ex) {
            throw new AndrolibException(ex);
        }
        catch (NullPointerException ex) {
            throw new AndrolibException(ex);
        }
    }

    private NinePatch getNinePatch(byte[] data) throws AndrolibException, IOException {
        ExtDataInput di = new ExtDataInput((InputStream)new ByteArrayInputStream(data));
        this.find9patchChunk((DataInput)di);
        return NinePatch.decode(di);
    }

    private void find9patchChunk(DataInput di) throws AndrolibException, IOException {
        di.skipBytes(8);
        while (true) {
            int size;
            try {
                size = di.readInt();
            }
            catch (IOException ex) {
                throw new CantFind9PatchChunk("Cant find nine patch chunk", ex);
            }
            if (di.readInt() == 1852855395) {
                return;
            }
            di.skipBytes(size + 4);
        }
    }

    private void drawHLine(BufferedImage im, int y, int x1, int x2) {
        int x = x1;
        while (x <= x2) {
            im.setRGB(x, y, -16777216);
            ++x;
        }
    }

    private void drawVLine(BufferedImage im, int x, int y1, int y2) {
        int y = y1;
        while (y <= y2) {
            im.setRGB(x, y, -16777216);
            ++y;
        }
    }

    private static class NinePatch {
        public final int padLeft;
        public final int padRight;
        public final int padTop;
        public final int padBottom;
        public final int[] xDivs;
        public final int[] yDivs;

        public NinePatch(int padLeft, int padRight, int padTop, int padBottom, int[] xDivs, int[] yDivs) {
            this.padLeft = padLeft;
            this.padRight = padRight;
            this.padTop = padTop;
            this.padBottom = padBottom;
            this.xDivs = xDivs;
            this.yDivs = yDivs;
        }

        public static NinePatch decode(ExtDataInput di) throws IOException {
            di.skipBytes(1);
            byte numXDivs = di.readByte();
            byte numYDivs = di.readByte();
            di.skipBytes(1);
            di.skipBytes(8);
            int padLeft = di.readInt();
            int padRight = di.readInt();
            int padTop = di.readInt();
            int padBottom = di.readInt();
            di.skipBytes(4);
            int[] xDivs = di.readIntArray((int)numXDivs);
            int[] yDivs = di.readIntArray((int)numYDivs);
            return new NinePatch(padLeft, padRight, padTop, padBottom, xDivs, yDivs);
        }
    }
}

