/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.value.ResArrayValue;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResBoolValue;
import brut.androlib.res.data.value.ResColorValue;
import brut.androlib.res.data.value.ResDimenValue;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResFloatValue;
import brut.androlib.res.data.value.ResFractionValue;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResPluralsValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResStyleValue;
import brut.androlib.res.data.value.ResValue;
import brut.util.Duo;

public class ResValueFactory {
    private final ResPackage mPackage;

    public ResValueFactory(ResPackage pakage_) {
        this.mPackage = pakage_;
    }

    public ResScalarValue factory(int type, int value, String rawValue) throws AndrolibException {
        switch (type) {
            case 1: {
                return this.newReference(value, rawValue);
            }
            case 2: {
                return this.newReference(value, rawValue, true);
            }
            case 3: {
                return new ResStringValue(rawValue);
            }
            case 4: {
                return new ResFloatValue(Float.intBitsToFloat(value), rawValue);
            }
            case 5: {
                return new ResDimenValue(value, rawValue);
            }
            case 6: {
                return new ResFractionValue(value, rawValue);
            }
            case 18: {
                return new ResBoolValue(value != 0, rawValue);
            }
        }
        if (type >= 28 && type <= 31) {
            return new ResColorValue(value, rawValue);
        }
        if (type >= 16 && type <= 31) {
            return new ResIntValue(value, rawValue, type);
        }
        throw new AndrolibException("Invalid value type: " + type);
    }

    public ResValue factory(String value) {
        if (value.startsWith("res/")) {
            return new ResFileValue(value);
        }
        return new ResStringValue(value);
    }

    public ResBagValue bagFactory(int parent, Duo<Integer, ResScalarValue>[] items) throws AndrolibException {
        ResReferenceValue parentVal = this.newReference(parent, null);
        if (items.length == 0) {
            return new ResBagValue(parentVal);
        }
        int key = (Integer)items[0].m1;
        if (key == 0x1000000) {
            return ResAttr.factory(parentVal, items, this, this.mPackage);
        }
        if (key == 0x2000000) {
            return new ResArrayValue(parentVal, items);
        }
        if (key >= 0x1000004 && key <= 0x1000009) {
            return new ResPluralsValue(parentVal, items);
        }
        return new ResStyleValue(parentVal, items, this);
    }

    public ResReferenceValue newReference(int resID, String rawValue) {
        return this.newReference(resID, rawValue, false);
    }

    public ResReferenceValue newReference(int resID, String rawValue, boolean theme) {
        return new ResReferenceValue(this.mPackage, resID, rawValue, theme);
    }
}

