/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.util.Duo;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public class ResArrayValue
extends ResBagValue
implements ResValuesXmlSerializable {
    private String mRawItems;
    private final ResScalarValue[] mItems;
    public static final int BAG_KEY_ARRAY_START = 0x2000000;

    ResArrayValue(ResReferenceValue parent, Duo<Integer, ResScalarValue>[] items) {
        super(parent);
        this.mItems = new ResScalarValue[items.length];
        int i = 0;
        while (i < items.length) {
            this.mItems[i] = (ResScalarValue)items[i].m2;
            ++i;
        }
    }

    public ResArrayValue(ResReferenceValue parent, ResScalarValue[] items) {
        super(parent);
        this.mItems = items;
    }

    @Override
    public void serializeToResValuesXml(XmlSerializer serializer, ResResource res) throws IOException, AndrolibException {
        String type = this.getType();
        type = String.valueOf(type == null ? "" : String.valueOf(type) + "-") + "array";
        if ("reference-array".equals(type)) {
            type = "string-array";
        }
        serializer.startTag(null, type);
        serializer.attribute(null, "name", res.getResSpec().getName());
        int i = 0;
        while (i < this.mItems.length) {
            serializer.startTag(null, "item");
            serializer.text(this.mItems[i].encodeAsResXmlNonEscapedItemValue());
            serializer.endTag(null, "item");
            ++i;
        }
        serializer.endTag(null, type);
    }

    public String getType() throws AndrolibException {
        if (this.mItems.length == 0) {
            return null;
        }
        String type = this.mItems[0].getType();
        int i = 1;
        while (i < this.mItems.length) {
            if (this.mItems[i].encodeAsResXmlItemValue().startsWith("@string")) {
                return "string";
            }
            if (this.mItems[i].encodeAsResXmlItemValue().startsWith("@drawable")) {
                return null;
            }
            if (!"string".equals(type) && !"integer".equals(type)) {
                return null;
            }
            if (!type.equals(this.mItems[i].getType())) {
                return null;
            }
            ++i;
        }
        return type;
    }
}

