/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.AndrolibException;
import brut.androlib.err.UndefinedResObject;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResTable;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class ResSmaliUpdater {
    private static final String RES_ID_FORMAT_FIELD = ".field %s:I = 0x%08x";
    private static final String RES_ID_FORMAT_CONST = "    const %s, 0x%08x";
    private static final Pattern RES_ID_PATTERN = Pattern.compile("^(?:\\.field (.+?):I =|    const(?:|/(?:|high)16) ([pv]\\d+?),) 0x(7[a-f]0[1-9a-f](?:|[0-9a-f]{4}))$");
    private static final String RES_NAME_FORMAT = "# APKTOOL/RES_NAME: %s";
    private static final Pattern RES_NAME_PATTERN = Pattern.compile("^# APKTOOL/RES_NAME: ([a-zA-Z0-9.]+):([a-z]+)/([a-zA-Z0-9._]+)$");
    private static final Pattern R_FILE_PATTERN = Pattern.compile(".*R\\$[a-z]+\\.smali$");
    private static final Logger LOGGER = Logger.getLogger(ResSmaliUpdater.class.getName());

    public void tagResIDs(ResTable resTable, File smaliDir) throws AndrolibException {
        FileDirectory dir = null;
        try {
            dir = new FileDirectory(smaliDir);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException("Could not tag res IDs", ex);
        }
        for (String fileName : dir.getFiles(true)) {
            try {
                this.tagResIdsForFile(resTable, (Directory)dir, fileName);
            }
            catch (IOException ex) {
                throw new AndrolibException("Could not tag resIDs for file: " + fileName, ex);
            }
            catch (DirectoryException ex) {
                throw new AndrolibException("Could not tag resIDs for file: " + fileName, ex);
            }
            catch (AndrolibException ex) {
                throw new AndrolibException("Could not tag resIDs for file: " + fileName, (Throwable)((Object)ex));
            }
        }
    }

    public void updateResIDs(ResTable resTable, File smaliDir) throws AndrolibException {
        try {
            FileDirectory dir = new FileDirectory(smaliDir);
            for (String fileName : dir.getFiles(true)) {
                Iterator it = IOUtils.readLines((InputStream)dir.getFileInput(fileName)).iterator();
                PrintWriter out = new PrintWriter(dir.getFileOutput(fileName));
                while (it.hasNext()) {
                    String line = (String)it.next();
                    out.println(line);
                    Matcher m1 = RES_NAME_PATTERN.matcher(line);
                    if (!m1.matches()) continue;
                    Matcher m2 = RES_ID_PATTERN.matcher((CharSequence)it.next());
                    if (!m2.matches()) {
                        throw new AndrolibException();
                    }
                    int resID = resTable.getPackage((String)m1.group((int)1)).getType((String)m1.group((int)2)).getResSpec((String)m1.group((int)3)).getId().id;
                    if (m2.group(1) != null) {
                        out.println(String.format(RES_ID_FORMAT_FIELD, m2.group(1), resID));
                        continue;
                    }
                    out.println(String.format(RES_ID_FORMAT_CONST, m2.group(2), resID));
                }
                out.close();
            }
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not tag res IDs for: " + smaliDir.getAbsolutePath(), ex);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException("Could not tag res IDs for: " + smaliDir.getAbsolutePath(), ex);
        }
    }

    private void tagResIdsForFile(ResTable resTable, Directory dir, String fileName) throws IOException, DirectoryException, AndrolibException {
        Iterator it = IOUtils.readLines((InputStream)dir.getFileInput(fileName)).iterator();
        PrintWriter out = new PrintWriter(dir.getFileOutput(fileName));
        while (it.hasNext()) {
            String line;
            block5: {
                int resID;
                line = (String)it.next();
                if (RES_NAME_PATTERN.matcher(line).matches()) {
                    out.println(line);
                    out.println((String)it.next());
                    continue;
                }
                Matcher m = RES_ID_PATTERN.matcher(line);
                if (m.matches() && (resID = this.parseResID(m.group(3))) != -1) {
                    try {
                        ResResSpec spec = resTable.getResSpec(resID);
                        out.println(String.format(RES_NAME_FORMAT, spec.getFullName()));
                    }
                    catch (UndefinedResObject ex) {
                        if (R_FILE_PATTERN.matcher(fileName).matches()) break block5;
                        LOGGER.warning(String.format("Undefined resource spec in %s: 0x%08x", fileName, resID));
                    }
                }
            }
            out.println(line);
        }
        out.close();
    }

    private int parseResID(String resIDHex) {
        if (resIDHex.endsWith("ff")) {
            return -1;
        }
        int resID = Integer.valueOf(resIDHex, 16);
        if (resIDHex.length() == 4) {
            resID <<= 16;
        }
        return resID;
    }
}

