/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib;

import brut.androlib.Androlib;
import brut.androlib.AndrolibException;
import brut.androlib.err.InFileNotFoundException;
import brut.androlib.err.OutDirExistsException;
import brut.androlib.res.AndrolibResources;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.util.ExtFile;
import brut.common.BrutException;
import brut.directory.DirectoryException;
import brut.directory.ZipExtFile;
import brut.util.OS;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class ApkDecoder {
    public static final short DECODE_SOURCES_NONE = 0;
    public static final short DECODE_SOURCES_SMALI = 1;
    public static final short DECODE_SOURCES_JAVA = 2;
    public static final short DECODE_RESOURCES_NONE = 256;
    public static final short DECODE_RESOURCES_FULL = 257;
    private final Androlib mAndrolib;
    private static final Logger LOGGER = Logger.getLogger(Androlib.class.getName());
    private ExtFile mApkFile;
    private File mOutDir;
    private ResTable mResTable;
    private short mDecodeSources = 1;
    private short mDecodeResources = (short)257;
    private boolean mDebug = false;
    private String mDebugLinePrefix = "a=0;// ";
    private boolean mForceDelete = false;
    private String mFrameTag;
    private boolean mKeepBrokenResources = false;
    private String mFrameworkDir = null;
    private int mApi = 15;
    private boolean mBakDeb = true;
    private boolean mCompressResources = false;
    private boolean mAnalysisMode = false;

    public ApkDecoder() {
        this(new Androlib());
    }

    public ApkDecoder(Androlib androlib) {
        this.mAndrolib = androlib;
    }

    public ApkDecoder(File apkFile) {
        this(apkFile, new Androlib());
    }

    public ApkDecoder(File apkFile, Androlib androlib) {
        this.mAndrolib = androlib;
        this.setApkFile(apkFile);
    }

    public void setApkFile(File apkFile) {
        this.mApkFile = new ExtFile(apkFile);
        this.mResTable = null;
    }

    public void setOutDir(File outDir) throws AndrolibException {
        this.mOutDir = outDir;
    }

    public void setApi(int api) {
        this.mApi = api;
    }

    public void decode() throws AndrolibException, IOException {
        File outDir = this.getOutDir();
        if (!this.mForceDelete && outDir.exists()) {
            throw new OutDirExistsException();
        }
        if (!this.mApkFile.isFile() || !this.mApkFile.canRead()) {
            throw new InFileNotFoundException();
        }
        try {
            OS.rmdir((File)outDir);
        }
        catch (BrutException ex) {
            throw new AndrolibException(ex);
        }
        outDir.mkdirs();
        LOGGER.info("Using Apktool " + Androlib.getVersion() + " on " + this.mApkFile.getName());
        if (this.hasResources()) {
            Map<String, String> sdkInfo = this.mAndrolib.getResTable(this.mApkFile).getSdkInfo();
            if (sdkInfo.get("targetSdkVersion") != null) {
                this.mApi = Integer.parseInt(sdkInfo.get("targetSdkVersion"));
            }
            this.setAnalysisMode(this.mAnalysisMode, true);
            ZipExtFile zef = new ZipExtFile(this.mApkFile.getAbsolutePath());
            ZipArchiveEntry ze = zef.getEntry("resources.arsc");
            if (ze != null) {
                int compression = ze.getMethod();
                this.mCompressResources = compression != 0 && compression == 8;
            }
            zef.close();
            switch (this.mDecodeResources) {
                case 256: {
                    this.mAndrolib.decodeResourcesRaw(this.mApkFile, outDir);
                    break;
                }
                case 257: {
                    this.mAndrolib.decodeResourcesFull(this.mApkFile, outDir, this.getResTable());
                }
            }
        } else if (this.hasManifest()) {
            switch (this.mDecodeResources) {
                case 256: {
                    this.mAndrolib.decodeManifestRaw(this.mApkFile, outDir);
                    break;
                }
                case 257: {
                    this.mAndrolib.decodeManifestFull(this.mApkFile, outDir, this.getResTable());
                }
            }
        }
        if (this.hasSources()) {
            switch (this.mDecodeSources) {
                case 0: {
                    this.mAndrolib.decodeSourcesRaw(this.mApkFile, outDir, this.mDebug);
                    break;
                }
                case 1: {
                    this.mAndrolib.decodeSourcesSmali(this.mApkFile, outDir, this.mDebug, this.mDebugLinePrefix, this.mBakDeb, this.mApi);
                    break;
                }
                case 2: {
                    this.mAndrolib.decodeSourcesJava(this.mApkFile, outDir, this.mDebug);
                }
            }
        }
        this.mAndrolib.decodeRawFiles(this.mApkFile, outDir);
        this.mAndrolib.decodeUnknownFiles(this.mApkFile, outDir, this.mResTable);
        this.mAndrolib.writeOriginalFiles(this.mApkFile, outDir);
        this.writeMetaFile();
    }

    public void setDecodeSources(short mode) throws AndrolibException {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new AndrolibException("Invalid decode sources mode: " + mode);
        }
        this.mDecodeSources = mode;
    }

    public void setDecodeResources(short mode) throws AndrolibException {
        if (mode != 256 && mode != 257) {
            throw new AndrolibException("Invalid decode resources mode");
        }
        this.mDecodeResources = mode;
    }

    public void setDebugMode(boolean debug) {
        this.mDebug = debug;
    }

    public void setAnalysisMode(boolean mode, boolean pass) throws AndrolibException {
        this.mAnalysisMode = mode;
        if (pass) {
            if (this.mResTable == null) {
                this.mResTable = this.getResTable();
            }
            this.mResTable.setAnalysisMode(mode);
        }
    }

    public void setDebugLinePrefix(String debugLinePrefix) {
        this.mDebugLinePrefix = debugLinePrefix;
    }

    public void setBaksmaliDebugMode(boolean bakdeb) {
        this.mBakDeb = bakdeb;
    }

    public void setForceDelete(boolean forceDelete) {
        this.mForceDelete = forceDelete;
    }

    public void setFrameworkTag(String tag) throws AndrolibException {
        this.mFrameTag = tag;
        if (this.mResTable != null) {
            this.getResTable().setFrameTag(tag);
        }
    }

    public void setKeepBrokenResources(boolean keepBrokenResources) {
        this.mKeepBrokenResources = keepBrokenResources;
    }

    public void setFrameworkDir(String dir) {
        this.mFrameworkDir = dir;
    }

    public ResTable getResTable() throws AndrolibException {
        if (this.mResTable == null) {
            boolean hasResources = this.hasResources();
            boolean hasManifest = this.hasManifest();
            if (!hasManifest && !hasResources) {
                throw new AndrolibException("Apk doesn't contain either AndroidManifest.xml file or resources.arsc file");
            }
            AndrolibResources.sKeepBroken = this.mKeepBrokenResources;
            AndrolibResources.sFrameworkFolder = this.mFrameworkDir;
            this.mResTable = this.mAndrolib.getResTable(this.mApkFile, hasResources);
            this.mResTable.setFrameTag(this.mFrameTag);
        }
        return this.mResTable;
    }

    public boolean hasSources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("classes.dex");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasManifest() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("AndroidManifest.xml");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    public boolean hasResources() throws AndrolibException {
        try {
            return this.mApkFile.getDirectory().containsFile("resources.arsc");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
    }

    private File getOutDir() throws AndrolibException {
        if (this.mOutDir == null) {
            throw new AndrolibException("Out dir not set");
        }
        return this.mOutDir;
    }

    private void writeMetaFile() throws AndrolibException {
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
        meta.put("version", Androlib.getVersion());
        meta.put("apkFileName", this.mApkFile.getName());
        if (this.mDecodeResources != 256 && (this.hasManifest() || this.hasResources())) {
            meta.put("isFrameworkApk", this.mAndrolib.isFrameworkApk(this.getResTable()));
            this.putUsesFramework(meta);
            this.putSdkInfo(meta);
            this.putPackageInfo(meta);
            this.putVersionInfo(meta);
            this.putCompressionInfo(meta);
            this.putUnknownInfo(meta);
        }
        this.mAndrolib.writeMetaFile(this.mOutDir, meta);
    }

    private void putUsesFramework(Map<String, Object> meta) throws AndrolibException {
        Set<ResPackage> pkgs = this.getResTable().listFramePackages();
        if (pkgs.isEmpty()) {
            return;
        }
        Object[] ids = new Integer[pkgs.size()];
        int i = 0;
        for (ResPackage pkg : pkgs) {
            ids[i++] = pkg.getId();
        }
        Arrays.sort(ids);
        LinkedHashMap<String, Object> uses = new LinkedHashMap<String, Object>();
        uses.put("ids", ids);
        if (this.mFrameTag != null) {
            uses.put("tag", this.mFrameTag);
        }
        meta.put("usesFramework", uses);
    }

    private void putSdkInfo(Map<String, Object> meta) throws AndrolibException {
        Map<String, String> info = this.getResTable().getSdkInfo();
        if (info.size() > 0) {
            meta.put("sdkInfo", info);
        }
    }

    private void putPackageInfo(Map<String, Object> meta) throws AndrolibException {
        Map<String, String> info = this.getResTable().getPackageInfo();
        if (info.size() > 0) {
            meta.put("packageInfo", info);
        }
    }

    private void putVersionInfo(Map<String, Object> meta) throws AndrolibException {
        Map<String, String> info = this.getResTable().getVersionInfo();
        if (info.size() > 0) {
            meta.put("versionInfo", info);
        }
    }

    private void putUnknownInfo(Map<String, Object> meta) throws AndrolibException {
        Map<String, String> info = this.getResTable().getUnknownFiles();
        if (info.size() > 0) {
            meta.put("unknownFiles", info);
        }
    }

    private void putCompressionInfo(Map<String, Object> meta) throws AndrolibException {
        meta.put("compressionType", this.getCompressionType());
    }

    private boolean getCompressionType() {
        return this.mCompressResources;
    }
}

