/*
 * Decompiled with CFR 0.152.
 */
package com.sv.smali.Item;

import com.sv.smali.Item.ItemInstructionMethod;
import com.sv.smali.Item.ItemLabelMethod;
import com.sv.smali.MethodDefine;
import com.sv.view.SmaliTextWriter;
import org.jf.baksmali.baksmaliOptions;
import org.jf.dexlib2.Opcode;
import org.jf.dexlib2.iface.instruction.OffsetInstruction;

public class ItemOffsetInstructionFormatMethod
extends ItemInstructionMethod {
    protected ItemLabelMethod label;

    public ItemOffsetInstructionFormatMethod(baksmaliOptions baksmaliOptions2, MethodDefine methodDefine, int n2, OffsetInstruction offsetInstruction) {
        super(methodDefine, n2, offsetInstruction);
        this.label = new ItemLabelMethod(baksmaliOptions2, n2 + offsetInstruction.getCodeOffset(), this.getLabelPrefix());
        this.label = methodDefine.getLabelCache().internLabel(this.label);
    }

    @Override
    protected void writeTargetLabel(SmaliTextWriter smaliTextWriter) {
        this.label.writeTo(smaliTextWriter);
    }

    public ItemLabelMethod getLabel() {
        return this.label;
    }

    private String getLabelPrefix() {
        Opcode opcode = ((OffsetInstruction)this.instruction).getOpcode();
        switch (opcode.format) {
            case Format10t: 
            case Format20t: 
            case Format30t: {
                return "goto_";
            }
            case Format21t: 
            case Format22t: {
                return "cond_";
            }
            case Format31t: {
                if (opcode == Opcode.FILL_ARRAY_DATA) {
                    return "array_";
                }
                if (opcode == Opcode.PACKED_SWITCH) {
                    return "pswitch_data_";
                }
                return "sswitch_data_";
            }
        }
        assert (false);
        return null;
    }
}

