/*
 * Decompiled with CFR 0.152.
 */
package com.sv.smali.Item;

import com.sv.smali.Item.ItemInstructionMethod;
import com.sv.smali.MethodDefine;
import com.sv.view.SmaliTextWriter;
import java.util.List;
import org.jf.baksmali.Renderers.LongRenderer;
import org.jf.baksmali.bakconfig;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;

public class ItemArrayDataMethod
extends ItemInstructionMethod {
    public ItemArrayDataMethod(MethodDefine methodDefine, int n2, ArrayPayload arrayPayload) {
        super(methodDefine, n2, arrayPayload);
    }

    @Override
    public boolean writeTo(SmaliTextWriter smaliTextWriter) {
        int n2 = ((ArrayPayload)this.instruction).getElementWidth();
        smaliTextWriter.write(".array-data ");
        smaliTextWriter.printIntAsDec(((ArrayPayload)this.instruction).getElementWidth(), SmaliTextWriter.CLRINT);
        smaliTextWriter.write(10);
        smaliTextWriter.indent(4);
        List<Number> list = ((ArrayPayload)this.instruction).getArrayElements();
        String string = "";
        switch (n2) {
            case 1: {
                string = "t";
                break;
            }
            case 2: {
                string = "s";
            }
        }
        for (Number number : list) {
            LongRenderer.writeSignedIntOrLongTo(smaliTextWriter, number.longValue());
            smaliTextWriter.write(string);
            if (bakconfig.OptSmaliArrayChar) {
                smaliTextWriter.write("\t\t");
                smaliTextWriter.write((char)number.longValue());
            }
            smaliTextWriter.write("\n");
        }
        smaliTextWriter.deindent(4);
        smaliTextWriter.write(".end array-data");
        smaliTextWriter.write("\n");
        return true;
    }
}

