/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.v3;

import com.googlecode.dex2jar.Annotation;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.asm.LdcOptimizeAdapter;
import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.ts.ArrayNullPointerTransformer;
import com.googlecode.dex2jar.ir.ts.CleanLabel;
import com.googlecode.dex2jar.ir.ts.EndRemover;
import com.googlecode.dex2jar.ir.ts.ExceptionHandlerCurrectTransformer;
import com.googlecode.dex2jar.ir.ts.ExceptionHandlerTrim;
import com.googlecode.dex2jar.ir.ts.FixVar;
import com.googlecode.dex2jar.ir.ts.LocalRemove;
import com.googlecode.dex2jar.ir.ts.LocalSplit;
import com.googlecode.dex2jar.ir.ts.LocalType;
import com.googlecode.dex2jar.ir.ts.TopologicalSort;
import com.googlecode.dex2jar.ir.ts.Transformer;
import com.googlecode.dex2jar.ir.ts.ZeroTransformer;
import com.googlecode.dex2jar.v3.Dex2AsmAnnotationAdapter;
import com.googlecode.dex2jar.v3.DexExceptionHandler;
import com.googlecode.dex2jar.v3.IrMethod2AsmMethod;
import com.googlecode.dex2jar.v3.V3AnnAdapter;
import com.googlecode.dex2jar.v3.V3CodeAdapter;
import com.googlecode.dex2jar.visitors.DexAnnotationAble;
import com.googlecode.dex2jar.visitors.DexAnnotationVisitor;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.TraceMethodVisitor;

public class V3MethodAdapter
implements DexMethodVisitor,
Opcodes {
    protected static Transformer topologicalSort = new TopologicalSort();
    private static final Logger log = Logger.getLogger(V3MethodAdapter.class.getName());
    protected static Transformer[] tses = new Transformer[]{new EndRemover(), new ExceptionHandlerCurrectTransformer(), new ZeroTransformer(), new ArrayNullPointerTransformer(), new FixVar(), new CleanLabel(), new LocalSplit(), new LocalRemove(), new LocalType(), new ExceptionHandlerTrim()};
    protected int accessFlags;
    protected DexExceptionHandler exceptionHandler;
    protected IrMethod irMethod;
    protected final Method method;
    protected final MethodNode methodNode = new MethodNode();
    protected Annotation signatureAnnotation;
    protected Annotation throwsAnnotation;
    protected int config;

    static {
        log.log(Level.CONFIG, "InsnList.check=false");
        InsnList.check = false;
    }

    protected static void indexLabelStmt4Debug(StmtList list) {
        int labelIndex = 0;
        for (Stmt stmt : list) {
            if (stmt.st != Stmt.ST.LABEL) continue;
            ((LabelStmt)stmt).displayName = "L" + labelIndex++;
        }
    }

    public V3MethodAdapter(int accessFlags, Method method, DexExceptionHandler exceptionHandler) {
        this(accessFlags, method, exceptionHandler, 0);
    }

    public V3MethodAdapter(int accessFlags, Method method, DexExceptionHandler exceptionHandler, int config) {
        this.method = method;
        int cleanFlag = -196609;
        this.accessFlags = accessFlags & 0xFFFCFFFF;
        this.exceptionHandler = exceptionHandler;
        this.config = config;
        this.methodNode.desc = method.getDesc();
    }

    protected void build() {
        Annotation values;
        ArrayList<String> exceptions = new ArrayList<String>();
        String signature = null;
        if (this.throwsAnnotation != null) {
            for (Annotation.Item item : this.throwsAnnotation.items) {
                if (!item.name.equals("value")) continue;
                values = (Annotation)item.value;
                for (Annotation.Item i : values.items) {
                    exceptions.add(((Type)i.value).getInternalName());
                }
            }
        }
        if (this.signatureAnnotation != null) {
            for (Annotation.Item item : this.signatureAnnotation.items) {
                if (!item.name.equals("value")) continue;
                values = (Annotation)item.value;
                StringBuilder sb = new StringBuilder();
                for (Annotation.Item i : values.items) {
                    sb.append(i.value.toString());
                }
                signature = sb.toString();
            }
        }
        MethodNode methodNode = this.methodNode;
        methodNode.access = this.accessFlags;
        methodNode.name = this.method.getName();
        methodNode.desc = this.method.getDesc();
        methodNode.signature = signature;
        methodNode.exceptions = exceptions;
        methodNode.tryCatchBlocks = new ArrayList();
        methodNode.localVariables = new ArrayList();
    }

    protected void debug_dump(MethodNode methodNode) {
        TraceMethodVisitor tmv = new TraceMethodVisitor();
        methodNode.instructions.accept((MethodVisitor)tmv);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Object o : tmv.text) {
            sb.append(i++).append(o);
        }
        System.out.println(sb);
    }

    public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
        if (name.equals("Ldalvik/annotation/Signature;")) {
            this.signatureAnnotation = new Annotation(name, visible);
            return new V3AnnAdapter(this.signatureAnnotation);
        }
        if (name.equals("Ldalvik/annotation/Throws;")) {
            this.throwsAnnotation = new Annotation(name, visible);
            return new V3AnnAdapter(this.throwsAnnotation);
        }
        AnnotationVisitor av = this.methodNode.visitAnnotation(name, visible);
        if (av != null) {
            return new Dex2AsmAnnotationAdapter(av);
        }
        return null;
    }

    public DexCodeVisitor visitCode() {
        IrMethod irMethod = new IrMethod();
        irMethod.access = this.accessFlags;
        irMethod.args = Type.getArgumentTypes((String)this.method.getDesc());
        irMethod.ret = Type.getType((String)this.method.getReturnType());
        irMethod.owner = Type.getType((String)this.method.getOwner());
        irMethod.name = this.method.getName();
        this.irMethod = irMethod;
        return new V3CodeAdapter(this.accessFlags, irMethod);
    }

    public void visitEnd() {
        this.build();
        IrMethod irMethod = this.irMethod;
        if (irMethod != null) {
            try {
                if (irMethod.stmts.getSize() > 1) {
                    Transformer[] transformerArray = tses;
                    int n = tses.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Transformer ts = transformerArray[n2];
                        ts.transform(irMethod);
                        ++n2;
                    }
                    if ((this.config & 2) != 0) {
                        topologicalSort.transform(irMethod);
                    }
                }
                if ((this.config & 4) != 0) {
                    V3MethodAdapter.indexLabelStmt4Debug(irMethod.stmts);
                    System.out.println(irMethod);
                }
                new IrMethod2AsmMethod(this.config).convert(irMethod, (MethodVisitor)new LdcOptimizeAdapter((MethodVisitor)this.methodNode));
            }
            catch (Exception e) {
                if (this.exceptionHandler == null) {
                    throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                }
                this.exceptionHandler.handleMethodTranslateException(this.method, irMethod, this.methodNode, e);
            }
        }
    }

    public DexAnnotationAble visitParameterAnnotation(final int index) {
        return new DexAnnotationAble(){

            public DexAnnotationVisitor visitAnnotation(String name, boolean visible) {
                AnnotationVisitor av = V3MethodAdapter.this.methodNode.visitParameterAnnotation(index, name, visible);
                if (av != null) {
                    return new Dex2AsmAnnotationAdapter(av);
                }
                return null;
            }
        };
    }
}

