/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.jf.dexlib2.writer.io.DexDataStore;

public class MemoryDataStore
implements DexDataStore {
    private byte[] buf;

    public MemoryDataStore() {
        this(0x100000);
    }

    public MemoryDataStore(int initialCapacity) {
        this.buf = new byte[initialCapacity];
    }

    public byte[] getData() {
        return this.buf;
    }

    @Override
    @Nonnull
    public OutputStream outputAt(int offset) {
        return new OutputStream(offset){
            private int position;
            {
                this.position = n;
            }

            @Override
            public void write(int b) throws IOException {
                MemoryDataStore.this.growBufferIfNeeded(this.position);
                ((MemoryDataStore)MemoryDataStore.this).buf[this.position++] = (byte)b;
            }

            @Override
            public void write(byte[] b) throws IOException {
                MemoryDataStore.this.growBufferIfNeeded(this.position + b.length);
                System.arraycopy(b, 0, MemoryDataStore.this.buf, this.position, b.length);
                this.position += b.length;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                MemoryDataStore.this.growBufferIfNeeded(this.position + len);
                System.arraycopy(b, off, MemoryDataStore.this.buf, this.position, len);
                this.position += len;
            }
        };
    }

    private void growBufferIfNeeded(int index) {
        if (index < this.buf.length) {
            return;
        }
        this.buf = Arrays.copyOf(this.buf, (int)((double)(index + 1) * 1.2));
    }

    @Override
    @Nonnull
    public InputStream readAt(int offset) {
        return new InputStream(offset){
            private int position;
            {
                this.position = n;
            }

            @Override
            public int read() throws IOException {
                if (this.position >= MemoryDataStore.this.buf.length) {
                    return -1;
                }
                return MemoryDataStore.this.buf[this.position++];
            }

            @Override
            public int read(byte[] b) throws IOException {
                int readLength = Math.min(b.length, MemoryDataStore.this.buf.length - this.position);
                if (readLength <= 0) {
                    if (this.position >= MemoryDataStore.this.buf.length) {
                        return -1;
                    }
                    return 0;
                }
                System.arraycopy(MemoryDataStore.this.buf, this.position, b, 0, readLength);
                this.position += readLength;
                return readLength;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int readLength = Math.min(len, MemoryDataStore.this.buf.length - this.position);
                if (readLength <= 0) {
                    if (this.position >= MemoryDataStore.this.buf.length) {
                        return -1;
                    }
                    return 0;
                }
                System.arraycopy(MemoryDataStore.this.buf, this.position, b, 0, readLength);
                this.position += readLength;
                return readLength;
            }

            @Override
            public long skip(long n) throws IOException {
                int skipLength = (int)Math.min(n, (long)(MemoryDataStore.this.buf.length - this.position));
                this.position += skipLength;
                return skipLength;
            }

            @Override
            public int available() throws IOException {
                return MemoryDataStore.this.buf.length - this.position;
            }
        };
    }

    @Override
    public void close() throws IOException {
    }
}

