/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.instruction.SwitchElement;
import org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import org.jf.dexlib2.iface.instruction.formats.Instruction10t;
import org.jf.dexlib2.iface.instruction.formats.Instruction10x;
import org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import org.jf.dexlib2.iface.instruction.formats.Instruction11x;
import org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import org.jf.dexlib2.iface.instruction.formats.Instruction20t;
import org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import org.jf.dexlib2.iface.instruction.formats.Instruction21s;
import org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22b;
import org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import org.jf.dexlib2.iface.instruction.formats.Instruction22x;
import org.jf.dexlib2.iface.instruction.formats.Instruction23x;
import org.jf.dexlib2.iface.instruction.formats.Instruction30t;
import org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import org.jf.dexlib2.iface.instruction.formats.Instruction31i;
import org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import org.jf.dexlib2.iface.instruction.formats.Instruction32x;
import org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import org.jf.dexlib2.iface.instruction.formats.Instruction51l;
import org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.writer.DexDataWriter;
import org.jf.dexlib2.writer.FieldSection;
import org.jf.dexlib2.writer.MethodSection;
import org.jf.dexlib2.writer.StringSection;
import org.jf.dexlib2.writer.TypeSection;
import org.jf.util.ExceptionWithContext;

public class InstructionWriter<StringRef extends StringReference, TypeRef extends TypeReference, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference> {
    @Nonnull
    private final DexDataWriter writer;
    @Nonnull
    private final StringSection<?, StringRef> stringSection;
    @Nonnull
    private final TypeSection<?, ?, TypeRef> typeSection;
    @Nonnull
    private final FieldSection<?, ?, FieldRefKey, ?> fieldSection;
    @Nonnull
    private final MethodSection<?, ?, ?, MethodRefKey, ?> methodSection;

    @Nonnull
    static <StringRef extends StringReference, TypeRef extends TypeReference, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference> InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey> makeInstructionWriter(@Nonnull DexDataWriter writer, @Nonnull StringSection<?, StringRef> stringSection, @Nonnull TypeSection<?, ?, TypeRef> typeSection, @Nonnull FieldSection<?, ?, FieldRefKey, ?> fieldSection, @Nonnull MethodSection<?, ?, ?, MethodRefKey, ?> methodSection) {
        return new InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey>(writer, stringSection, typeSection, fieldSection, methodSection);
    }

    InstructionWriter(@Nonnull DexDataWriter writer, @Nonnull StringSection<?, StringRef> stringSection, @Nonnull TypeSection<?, ?, TypeRef> typeSection, @Nonnull FieldSection<?, ?, FieldRefKey, ?> fieldSection, @Nonnull MethodSection<?, ?, ?, MethodRefKey, ?> methodSection) {
        this.writer = writer;
        this.stringSection = stringSection;
        this.typeSection = typeSection;
        this.fieldSection = fieldSection;
        this.methodSection = methodSection;
    }

    public void write(@Nonnull Instruction10t instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction10x instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(0);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction11n instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getNarrowLiteral()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction11x instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction12x instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction20bc instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getVerificationError());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction20t instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(0);
            this.writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction21c instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction21ih instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getHatLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction21lh instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getHatLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction21s instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction21t instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction22b instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.write(instruction.getRegisterB());
            this.writer.write(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction22c instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeUshort(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction22s instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeShort(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction22t instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterA(), instruction.getRegisterB()));
            this.writer.writeShort(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction22x instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeUshort(instruction.getRegisterB());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction23x instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.write(instruction.getRegisterB());
            this.writer.write(instruction.getRegisterC());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction30t instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(0);
            this.writer.writeInt(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction31c instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeInt(this.getReferenceIndex(instruction));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction31i instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeInt(instruction.getNarrowLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction31t instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeInt(instruction.getCodeOffset());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction32x instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(0);
            this.writer.writeUshort(instruction.getRegisterA());
            this.writer.writeUshort(instruction.getRegisterB());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction35c instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterG(), instruction.getRegisterCount()));
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterC(), instruction.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction.getRegisterE(), instruction.getRegisterF()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction3rc instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterCount());
            this.writer.writeUshort(this.getReferenceIndex(instruction));
            this.writer.writeUshort(instruction.getStartRegister());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull Instruction51l instruction) {
        try {
            this.writer.write(instruction.getOpcode().value);
            this.writer.write(instruction.getRegisterA());
            this.writer.writeLong(instruction.getWideLiteral());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull ArrayPayload instruction) {
        try {
            this.writer.writeUshort(instruction.getOpcode().value);
            this.writer.writeUshort(instruction.getElementWidth());
            List<Number> elements = instruction.getArrayElements();
            this.writer.writeInt(elements.size());
            switch (instruction.getElementWidth()) {
                case 1: {
                    for (Number element : elements) {
                        this.writer.write(element.byteValue());
                    }
                    break;
                }
                case 2: {
                    for (Number element : elements) {
                        this.writer.writeShort(element.shortValue());
                    }
                    break;
                }
                case 4: {
                    for (Number element : elements) {
                        this.writer.writeInt(element.intValue());
                    }
                    break;
                }
                case 8: {
                    for (Number element : elements) {
                        this.writer.writeLong(element.longValue());
                    }
                    break;
                }
            }
            if ((this.writer.getPosition() & 1) != 0) {
                this.writer.write(0);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull SparseSwitchPayload instruction) {
        try {
            this.writer.writeUbyte(0);
            this.writer.writeUbyte(instruction.getOpcode().value >> 8);
            List<? extends SwitchElement> elements = instruction.getSwitchElements();
            this.writer.writeUshort(elements.size());
            for (SwitchElement switchElement : elements) {
                this.writer.writeInt(switchElement.getKey());
            }
            for (SwitchElement switchElement : elements) {
                this.writer.writeInt(switchElement.getOffset());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void write(@Nonnull PackedSwitchPayload instruction) {
        try {
            this.writer.writeUbyte(0);
            this.writer.writeUbyte(instruction.getOpcode().value >> 8);
            List<? extends SwitchElement> elements = instruction.getSwitchElements();
            this.writer.writeUshort(elements.size());
            if (elements.size() == 0) {
                this.writer.writeInt(0);
            } else {
                this.writer.writeInt(elements.get(0).getKey());
                for (SwitchElement switchElement : elements) {
                    this.writer.writeInt(switchElement.getOffset());
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static int packNibbles(int a, int b) {
        return b << 4 | a;
    }

    private int getReferenceIndex(ReferenceInstruction referenceInstruction) {
        switch (referenceInstruction.getOpcode().referenceType) {
            case 2: {
                return this.fieldSection.getItemIndex((FieldReference)referenceInstruction.getReference());
            }
            case 3: {
                return this.methodSection.getItemIndex((MethodReference)referenceInstruction.getReference());
            }
            case 0: {
                return this.stringSection.getItemIndex((StringReference)referenceInstruction.getReference());
            }
            case 1: {
                return this.typeSection.getItemIndex((TypeReference)referenceInstruction.getReference());
            }
        }
        throw new ExceptionWithContext("Unknown reference type: %d", new Object[]{referenceInstruction.getOpcode().referenceType});
    }
}

