/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.dexbacked.raw;

import org.jf.dexlib2.dexbacked.BaseDexBuffer;

public class OdexHeaderItem {
    public static final int ITEM_SIZE = 40;
    public static final byte[][] MAGIC_VALUES;
    public static final int MAGIC_OFFSET = 0;
    public static final int MAGIC_LENGTH = 8;
    public static final int DEX_OFFSET = 8;
    public static final int DEX_LENGTH_OFFSET = 12;
    public static final int DEPENDENCIES_OFFSET = 16;
    public static final int DEPENDENCIES_LENGTH_OFFSET = 20;
    public static final int AUX_OFFSET = 24;
    public static final int AUX_LENGTH_OFFSET = 28;
    public static final int FLAGS_OFFSET = 32;

    static {
        byte[][] byArrayArray = new byte[2][];
        byte[] byArray = new byte[8];
        byArray[0] = 100;
        byArray[1] = 101;
        byArray[2] = 121;
        byArray[3] = 10;
        byArray[4] = 48;
        byArray[5] = 51;
        byArray[6] = 53;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 100;
        byArray2[1] = 101;
        byArray2[2] = 121;
        byArray2[3] = 10;
        byArray2[4] = 48;
        byArray2[5] = 51;
        byArray2[6] = 54;
        byArrayArray[1] = byArray2;
        MAGIC_VALUES = byArrayArray;
    }

    public static int getVersion(byte[] magic) {
        if (magic.length < 8) {
            return 0;
        }
        boolean matches = true;
        int i = 0;
        while (i < MAGIC_VALUES.length) {
            byte[] expected = MAGIC_VALUES[i];
            matches = true;
            int j = 0;
            while (j < 8) {
                if (magic[j] != expected[j]) {
                    matches = false;
                    break;
                }
                ++j;
            }
            if (matches) {
                return i == 0 ? 35 : 36;
            }
            ++i;
        }
        return 0;
    }

    public static boolean verifyMagic(byte[] buf) {
        return OdexHeaderItem.getVersion(buf) != 0;
    }

    public static int getDexOffset(byte[] buf) {
        BaseDexBuffer bdb = new BaseDexBuffer(buf);
        return bdb.readSmallUint(8);
    }

    public static int getDependenciesOffset(byte[] buf) {
        BaseDexBuffer bdb = new BaseDexBuffer(buf);
        return bdb.readSmallUint(16);
    }
}

